package net.minecraft.src;

public class SlotLittleMaidArmor extends Slot
{
    protected final int armorType;
    protected final ContainerLittleMaid inventory;

    public SlotLittleMaidArmor(ContainerLittleMaid containerlittlemaid, IInventory iinventory, int i, int j, int k, int l)
    {
        super(iinventory, i, j, k);
        inventory = containerlittlemaid;
        armorType = l;
    }

    /**
     * Returns the maximum stack size for a given slot (usually the same as getInventoryStackLimit(), but 1 in the case
     * of armor slots)
     */
    public int getSlotStackLimit()
    {
        return 1;
    }

    /**
     * Check if the stack is a valid item for this slot. Always true beside for the armor slots.
     */
    public boolean isItemValid(ItemStack itemstack)
    {
        if (itemstack.getItem() instanceof ItemArmor)
        {
            return ((ItemArmor)itemstack.getItem()).armorType == armorType;
        }
        else
        {
            return false;
        }
    }

    public int getBackgroundIconIndex()
    {
    	return 15+armorType*16;
    }
}
