package net.minecraft.src;

import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class RenderLittleMaidDummy extends Render
{
    public RenderLittleMaidDummy()
    {
        shadowSize = 0.0F;
    }

    /**
     * Actually renders the given argument. This is a synthetic bridge method, always casting down its argument and then
     * handing it off to a worker function which does the actual work. In all probabilty, the class Render is generic
     * (Render<T extends Entity) and this method has signature public void doRender(T entity, double d, double d1,
     * double d2, float f, float f1). But JAD is pre 1.5 so doesn't do that.
     */
    public void doRender(Entity entity, double d, double d1, double d2, float f, float f1)
    {
        GL11.glPushMatrix();
        GL11.glDisable(GL11.GL_LIGHTING);
        GL11.glEnable(GL12.GL_RESCALE_NORMAL);
        GL11.glEnable(GL11.GL_COLOR_MATERIAL);
        GL11.glEnable(GL11.GL_BLEND);
        GL11.glDisable(GL11.GL_CULL_FACE);
        GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
        GL11.glDisable(GL11.GL_TEXTURE_2D);
        GL11.glDepthMask(false);
        GL11.glTranslatef((float)d, (float)d1, (float)d2);
        RenderHelper.enableStandardItemLighting();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        GL11.glColor3f(1.0F, 1.0F, 1.0F);
        if (entity instanceof EntityLittleMaidDummy)
        {
        	int i = ((EntityLittleMaidDummy)entity).getColor();
            int j = i >> 16 & 0xff;
            int k = i >> 8 & 0xff;
            int l = i & 0xff;
            int i1 = MathHelper.floor_float(((EntityLittleMaidDummy)entity).getAlpha(1.0F) * 256F);
            tessellator.setColorRGBA_I(i, i1);
        }

        double d3 = 0.3D;
        double d4 = 0.7D;
        double d5 = 0.015625D;
        double d6 = 0.3D;
        double d7 = 0.7D;
        tessellator.addVertex(d3, d5, d6);
        tessellator.addVertex(d3, d5, d7);
        tessellator.addVertex(d4, d5, d7);
        tessellator.addVertex(d4, d5, d6);
        tessellator.draw();
        RenderHelper.disableStandardItemLighting();
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        GL11.glEnable(GL11.GL_TEXTURE_2D);
        GL11.glDisable(GL11.GL_BLEND);
        GL11.glEnable(GL11.GL_CULL_FACE);
        GL11.glDepthMask(true);
        GL11.glEnable(GL11.GL_LIGHTING);
        GL11.glDisable(GL12.GL_RESCALE_NORMAL);
        GL11.glPopMatrix();
    }
}
