package net.minecraft.src;

import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class RenderLittleMaid extends RenderBiped
{
    protected ModelLittleMaid modelBasicOrig[];
    protected ModelLittleMaid modelMain;
    protected ModelLittleMaid modelArmorChestplate;
    protected ModelLittleMaid modelArmor;

    public RenderLittleMaid(ModelLittleMaid modellittlemaid, float f)
    {
        super(modellittlemaid, f);
        modelBasicOrig = new ModelLittleMaid[3];
        modelBasicOrig[0] = modellittlemaid;
        modelBasicOrig[1] = new ModelLittleMaid(0.5F);
        modelBasicOrig[2] = new ModelLittleMaid(0.1F);
    }

    protected int setArmorModelEx(EntityLittleMaid entitylittlemaid, int i, float f)
    {
        byte byte0 = -1;
        ItemStack itemstack = entitylittlemaid.maidInventory.armorItemInSlot(i);
        boolean flag;

        if (flag = itemstack != null && itemstack.stackSize > 0)
        {
            byte0 = ((byte)(itemstack.isItemEnchanted() ? 15 : 1));
        }

        modelArmor.bipedHead.showModel = modelArmorChestplate.bipedHead.showModel = i != 3 ? false : flag;
        modelArmor.bipedBody.showModel = modelArmor.bipedRightArm.showModel = modelArmor.bipedLeftArm.showModel = modelArmorChestplate.bipedBody.showModel = modelArmorChestplate.bipedRightArm.showModel = modelArmorChestplate.bipedLeftArm.showModel = i != 2 ? false : flag;
        modelArmor.Skirt.showModel = modelArmorChestplate.Skirt.showModel = i != 1 ? false : flag;
        modelArmor.bipedRightLeg.showModel = modelArmor.bipedLeftLeg.showModel = modelArmorChestplate.bipedRightLeg.showModel = modelArmorChestplate.bipedLeftLeg.showModel = i != 0 ? false : flag;
        return byte0;
    }

    /**
     * Queries whether should render the specified pass or not.
     */
    protected int shouldRenderPass(EntityLiving entityliving, int i, float f)
    {
        EntityLittleMaid entitylittlemaid = (EntityLittleMaid)entityliving;

        if (i < 4 && modelArmor != null)
        {
            if (entitylittlemaid.textureArmor0[i] == null)
            {
                return -1;
            }
            else
            {
                loadTexture(entitylittlemaid.textureArmor0[i]);
                setRenderPassModel(modelArmor);
                return 1;
            }
        }

        if (i < 8 && modelArmorChestplate != null)
        {
            if (entitylittlemaid.textureArmor1[i - 4] == null)
            {
                return -1;
            }
            else
            {
                loadTexture(entitylittlemaid.textureArmor1[i - 4]);
                setRenderPassModel(modelArmorChestplate);
                return 1;
            }
        }
        else
        {
            return -1;
        }
    }

    /**
     * Allows the render to do any OpenGL state modifications necessary before the model is rendered. Args:
     * entityLiving, partialTickTime
     */
    protected void preRenderCallback(EntityLiving entityliving, float f)
    {
        float f1 = 0.9375F;
        GL11.glScalef(f1, f1, f1);
    }

    public void doRenderLiving(EntityLiving entityliving, double d, double d1, double d2, float f, float f1)
    {
        GL11.glPushMatrix();
        GL11.glDisable(GL11.GL_CULL_FACE);

        try
        {
            float f2 = entityliving.prevRenderYawOffset + (entityliving.renderYawOffset - entityliving.prevRenderYawOffset) * f1;
            float f3 = entityliving.prevRotationYaw + (entityliving.rotationYaw - entityliving.prevRotationYaw) * f1;
            float f4 = entityliving.prevRotationPitch + (entityliving.rotationPitch - entityliving.prevRotationPitch) * f1;
            renderLivingAt(entityliving, d, d1, d2);
            float f5 = handleRotationFloat(entityliving, f1);
            rotateCorpse(entityliving, f5, f2, f1);
            float f6 = 0.0625F;
            GL11.glEnable(GL12.GL_RESCALE_NORMAL);
            GL11.glScalef(-1F, -1F, 1.0F);
            preRenderCallback(entityliving, f1);
            GL11.glTranslatef(0.0F, -24F * f6 - 0.0078125F, 0.0F);
            float f7 = entityliving.field_705_Q + (entityliving.field_704_R - entityliving.field_705_Q) * f1;
            float f8 = entityliving.field_703_S - entityliving.field_704_R * (1.0F - f1);

            if (entityliving.isChild())
            {
                f8 *= 3F;
            }

            if (f7 > 1.0F)
            {
                f7 = 1.0F;
            }

            GL11.glEnable(GL11.GL_ALPHA_TEST);

            if (mod_littleMaidMob.AlphaBlend)
            {
                GL11.glEnable(GL11.GL_BLEND);
                GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
            }
            else
            {
                GL11.glDisable(GL11.GL_BLEND);
            }

            modelMain.setLivingAnimations(entityliving, f8, f7, f1);
            renderModel(entityliving, f8, f7, f5, f3 - f2, f4, f6);

            for (int i = 0; i < 4; i++)
            {
                int j = setArmorModelEx((EntityLittleMaid)entityliving, i, f);

                if (j <= 0)
                {
                    continue;
                }

                for (int l = 0; l < 5; l += 4)
                {
                    if (shouldRenderPass(entityliving, i + l, f1) < 0)
                    {
                        continue;
                    }

                    renderPassModel.setLivingAnimations(entityliving, f8, f7, f1);
                    renderPassModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);

                    if (j != 15)
                    {
                        continue;
                    }

                    float f11 = (float)entityliving.ticksExisted + f1;
                    loadTexture("%blur%/misc/glint.png");
                    GL11.glEnable(GL11.GL_BLEND);
                    float f13 = 0.5F;
                    GL11.glColor4f(f13, f13, f13, 1.0F);
                    GL11.glDepthFunc(GL11.GL_EQUAL);
                    GL11.glDepthMask(false);

                    for (int j1 = 0; j1 < 2; j1++)
                    {
                        GL11.glDisable(GL11.GL_LIGHTING);
                        float f16 = 0.76F;
                        GL11.glColor4f(0.5F * f16, 0.25F * f16, 0.8F * f16, 1.0F);
                        GL11.glBlendFunc(GL11.GL_SRC_COLOR, GL11.GL_ONE);
                        GL11.glMatrixMode(GL11.GL_TEXTURE);
                        GL11.glLoadIdentity();
                        float f17 = f11 * (0.001F + (float)j1 * 0.003F) * 20F;
                        float f18 = 0.3333333F;
                        GL11.glScalef(f18, f18, f18);
                        GL11.glRotatef(30F - (float)j1 * 60F, 0.0F, 0.0F, 1.0F);
                        GL11.glTranslatef(0.0F, f17, 0.0F);
                        GL11.glMatrixMode(GL11.GL_MODELVIEW);
                        renderPassModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);
                    }

                    GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
                    GL11.glMatrixMode(GL11.GL_TEXTURE);
                    GL11.glDepthMask(true);
                    GL11.glLoadIdentity();
                    GL11.glMatrixMode(GL11.GL_MODELVIEW);
                    GL11.glEnable(GL11.GL_LIGHTING);

                    if (mod_littleMaidMob.AlphaBlend)
                    {
                        GL11.glEnable(GL11.GL_BLEND);
                        GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
                    }
                    else
                    {
                        GL11.glDisable(GL11.GL_BLEND);
                    }

                    GL11.glDepthFunc(GL11.GL_LEQUAL);
                }

                GL11.glEnable(GL11.GL_ALPHA_TEST);
            }

            GL11.glDisable(GL11.GL_BLEND);
            GL11.glEnable(GL11.GL_ALPHA_TEST);
            renderEquippedItems(entityliving, f1);
            float f9 = entityliving.getBrightness(f1);
            int k = getColorMultiplier(entityliving, f9, f1);
            OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
            GL11.glDisable(GL11.GL_TEXTURE_2D);
            OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);

            if ((k >> 24 & 0xff) > 0 || entityliving.hurtTime > 0 || entityliving.deathTime > 0)
            {
                GL11.glDisable(GL11.GL_TEXTURE_2D);
                GL11.glDisable(GL11.GL_ALPHA_TEST);
                GL11.glEnable(GL11.GL_BLEND);
                GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
                GL11.glDepthFunc(GL11.GL_EQUAL);

                if (entityliving.hurtTime > 0 || entityliving.deathTime > 0)
                {
                    GL11.glColor4f(f9, 0.0F, 0.0F, 0.4F);
                    mainModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);

                    for (int i1 = 0; i1 < 4; i1++)
                    {
                        if (inheritRenderPass(entityliving, i1, f1) >= 0)
                        {
                            GL11.glColor4f(f9, 0.0F, 0.0F, 0.4F);
                            renderPassModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);
                        }
                    }
                }

                if ((k >> 24 & 0xff) > 0)
                {
                    float f10 = (float)(k >> 16 & 0xff) / 255F;
                    float f12 = (float)(k >> 8 & 0xff) / 255F;
                    float f14 = (float)(k & 0xff) / 255F;
                    float f15 = (float)(k >> 24 & 0xff) / 255F;
                    GL11.glColor4f(f10, f12, f14, f15);
                    mainModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);

                    for (int k1 = 0; k1 < 4; k1++)
                    {
                        if (inheritRenderPass(entityliving, k1, f1) >= 0)
                        {
                            GL11.glColor4f(f10, f12, f14, f15);
                            renderPassModel.render(entityliving, f8, f7, f5, f3 - f2, f4, f6);
                        }
                    }
                }

                GL11.glDepthFunc(GL11.GL_LEQUAL);
                GL11.glDisable(GL11.GL_BLEND);
                GL11.glEnable(GL11.GL_ALPHA_TEST);
                GL11.glEnable(GL11.GL_TEXTURE_2D);
            }

            GL11.glDisable(GL12.GL_RESCALE_NORMAL);
        }
        catch (Exception exception)
        {
            exception.printStackTrace();
        }

        OpenGlHelper.setActiveTexture(OpenGlHelper.lightmapTexUnit);
        GL11.glEnable(GL11.GL_TEXTURE_2D);
        OpenGlHelper.setActiveTexture(OpenGlHelper.defaultTexUnit);
        GL11.glEnable(GL11.GL_CULL_FACE);
        GL11.glPopMatrix();
        passSpecialRender(entityliving, d, d1, d2);
    }

    public void doRenderLitlleMaid(EntityLittleMaid entitylittlemaid, double d, double d1, double d2, float f, float f1)
    {
        modelArmor.isWait = modelArmorChestplate.isWait = modelMain.isWait = entitylittlemaid.isMaidWaitEx();
        modelArmor.isSneak = modelArmorChestplate.isSneak = modelMain.isSneak = entitylittlemaid.isSneaking();
        modelArmor.isRiding = modelArmorChestplate.isRiding = modelMain.isRiding = entitylittlemaid.isRiding();
        modelArmor.aimedBow = modelArmorChestplate.aimedBow = modelMain.aimedBow = entitylittlemaid.isFixedBow();
        modelArmor.onGround = modelArmorChestplate.onGround = modelMain.onGround = renderSwingProgress(entitylittlemaid, f1);
        if (modelMain.isItemHolder()){
        	ItemStack itemstack = entitylittlemaid.maidInventory.getCurrentItem();
        	modelArmorChestplate.heldItemRight = modelArmor.heldItemRight = modelBipedMain.heldItemRight = itemstack == null ? 0 : 1;
        }
        double d3 = d1;

        if (entitylittlemaid.isSneaking())
        {
            d3 -= 0.059999999999999998D;
        }
        else if (entitylittlemaid.isRiding() && entitylittlemaid.ridingEntity == null)
        {
            d3 -= 0.25D;
        }

        doRenderLiving(entitylittlemaid, d, d3, d2, f, f1);

        if (entitylittlemaid.gotcha != null)
        {
            d1 -= 0.5D;
            Tessellator tessellator = Tessellator.instance;
            float f2 = ((entitylittlemaid.gotcha.prevRotationYaw + (entitylittlemaid.gotcha.rotationYaw - entitylittlemaid.gotcha.prevRotationYaw) * f1 * 0.5F) * (float)Math.PI) / 180F;
            float f3 = ((entitylittlemaid.gotcha.prevRotationPitch + (entitylittlemaid.gotcha.rotationPitch - entitylittlemaid.gotcha.prevRotationPitch) * f1 * 0.5F) * (float)Math.PI) / 180F;
            double d4 = MathHelper.sin(f2);
            double d5 = MathHelper.cos(f2);
            float f4 = entitylittlemaid.gotcha.getSwingProgress(f1);
            float f5 = MathHelper.sin(MathHelper.sqrt_float(f4) * (float)Math.PI);
            Vec3D vec3d = Vec3D.createVector(-0.5D, 0.029999999999999999D, 0.55000000000000004D);
            vec3d.rotateAroundX((-(entitylittlemaid.gotcha.prevRotationPitch + (entitylittlemaid.gotcha.rotationPitch - entitylittlemaid.gotcha.prevRotationPitch) * f1) * (float)Math.PI) / 180F);
            vec3d.rotateAroundY((-(entitylittlemaid.gotcha.prevRotationYaw + (entitylittlemaid.gotcha.rotationYaw - entitylittlemaid.gotcha.prevRotationYaw) * f1) * (float)Math.PI) / 180F);
            vec3d.rotateAroundY(f5 * 0.5F);
            vec3d.rotateAroundX(-f5 * 0.7F);
            double d6 = entitylittlemaid.gotcha.prevPosX + (entitylittlemaid.gotcha.posX - entitylittlemaid.gotcha.prevPosX) * (double)f1 + vec3d.xCoord;
            double d7 = entitylittlemaid.gotcha.prevPosY + (entitylittlemaid.gotcha.posY - entitylittlemaid.gotcha.prevPosY) * (double)f1 + vec3d.yCoord;
            double d8 = entitylittlemaid.gotcha.prevPosZ + (entitylittlemaid.gotcha.posZ - entitylittlemaid.gotcha.prevPosZ) * (double)f1 + vec3d.zCoord;

            if (renderManager.options.thirdPersonView > 0)
            {
                float f6 = ((entitylittlemaid.gotcha.prevRenderYawOffset + (entitylittlemaid.gotcha.renderYawOffset - entitylittlemaid.gotcha.prevRenderYawOffset) * f1) * (float)Math.PI) / 180F;
                double d10 = MathHelper.sin(f6);
                double d12 = MathHelper.cos(f6);
                d6 = (entitylittlemaid.gotcha.prevPosX + (entitylittlemaid.gotcha.posX - entitylittlemaid.gotcha.prevPosX) * (double)f1) - d12 * 0.34999999999999998D - d10 * 0.54999999999999993D;
                d7 = (entitylittlemaid.gotcha.prevPosY + (entitylittlemaid.gotcha.posY - entitylittlemaid.gotcha.prevPosY) * (double)f1) - 0.45000000000000001D;
                d8 = ((entitylittlemaid.gotcha.prevPosZ + (entitylittlemaid.gotcha.posZ - entitylittlemaid.gotcha.prevPosZ) * (double)f1) - d10 * 0.34999999999999998D) + d12 * 0.54999999999999993D;
            }

            double d9 = entitylittlemaid.prevPosX + (entitylittlemaid.posX - entitylittlemaid.prevPosX) * (double)f1;
            double d11 = (entitylittlemaid.prevPosY + (entitylittlemaid.posY - entitylittlemaid.prevPosY) * (double)f1 + 0.25D) - 0.5D;
            double d13 = entitylittlemaid.prevPosZ + (entitylittlemaid.posZ - entitylittlemaid.prevPosZ) * (double)f1;
            double d14 = (float)(d6 - d9);
            double d15 = (float)(d7 - d11);
            double d16 = (float)(d8 - d13);
            GL11.glDisable(GL11.GL_TEXTURE_2D);
            GL11.glDisable(GL11.GL_LIGHTING);
            tessellator.startDrawing(3);
            tessellator.setColorOpaque_I(0);
            int i = 16;

            for (int j = 0; j <= i; j++)
            {
                float f7 = (float)j / (float)i;
                tessellator.addVertex(d + d14 * (double)f7, d1 + d15 * (double)(f7 * f7 + f7) * 0.5D + (double)(((float)i - (float)j) / ((float)i * 0.75F) + 0.125F), d2 + d16 * (double)f7);
            }

            tessellator.draw();
            GL11.glEnable(GL11.GL_LIGHTING);
            GL11.glEnable(GL11.GL_TEXTURE_2D);
        }
    }

    /**
     * Actually renders the given argument. This is a synthetic bridge method, always casting down its argument and then
     * handing it off to a worker function which does the actual work. In all probabilty, the class Render is generic
     * (Render<T extends Entity) and this method has signature public void doRender(T entity, double d, double d1,
     * double d2, float f, float f1). But JAD is pre 1.5 so doesn't do that.
     */
    public void doRender(Entity entity, double d, double d1, double d2, float f, float f1)
    {
        EntityLittleMaid entitylittlemaid = (EntityLittleMaid)entity;
        ModelLittleMaid amodellittlemaid[] = entitylittlemaid.textureModel;
        mainModel = modelBipedMain = modelMain = amodellittlemaid[0] == null ? modelBasicOrig[0] : amodellittlemaid[0];
        modelArmorChestplate = amodellittlemaid[1] == null ? modelBasicOrig[1] : amodellittlemaid[1];
        modelArmor = amodellittlemaid[2] == null ? modelBasicOrig[2] : amodellittlemaid[2];
        doRenderLitlleMaid(entitylittlemaid, d, d1, d2, f, f1);
        mainModel = modelBasicOrig[0];
        modelBipedMain = modelBasicOrig[0];
        modelMain = modelBasicOrig[0];
        modelArmorChestplate = modelBasicOrig[1];
        modelArmor = modelBasicOrig[2];
    }

    protected void renderSpecials(EntityLittleMaid entitylittlemaid, float f)
    {
    	entitylittlemaid.maidCamouflage = false;
        ItemStack itemstack = entitylittlemaid.maidInventory.getStackInSlot(17);

        if (itemstack != null && itemstack.getItem().shiftedIndex < 256)
        {
            Item item = itemstack.getItem();
            int j = item.shiftedIndex;
            Block block = Block.blocksList[j];

            if (item instanceof ItemBlock)
            {
                if (j == Block.pumpkin.blockID || j == Block.pumpkinLantern.blockID || j == Block.leaves.blockID)
                {
                    GL11.glPushMatrix();
                    modelMain.bipedHead.postRender(0.0625F);

                    if (RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType()))
                    {
                        float f6 = 0.625F;
                        GL11.glTranslatef(0.0F, -0.25F, 0.0F);
                        GL11.glRotatef(180F, 0.0F, 1.0F, 0.0F);
                        GL11.glScalef(f6, -f6, f6);
                    }

                    renderManager.itemRenderer.renderItem(entitylittlemaid, itemstack, 0);
                    GL11.glPopMatrix();
                    entitylittlemaid.maidCamouflage = true;
                }

                if (block instanceof BlockFlower)
                {
                    loadTexture("/terrain.png");
                    GL11.glEnable(GL11.GL_CULL_FACE);
                    GL11.glPushMatrix();
                    modelMain.bipedHead.postRender(0.0625F);
                    GL11.glScalef(1.0F, -1F, 1.0F);
                    GL11.glTranslatef(0.0F, 1.0F, 0.0F);
                    GL11.glRotatef(12F, 0.0F, 1.0F, 0.0F);
                    renderBlocks.renderBlockAsItem(block, itemstack.getItemDamage(), 1.0F);
                    GL11.glPopMatrix();
                    GL11.glDisable(GL11.GL_CULL_FACE);
                    entitylittlemaid.maidCamouflage = true;
                }
            }
        }

        itemstack = entitylittlemaid.getHeldItem();

        if (itemstack != null)
        {
            GL11.glPushMatrix();
            modelMain.bipedRightArm.postRender(0.0625F);
            GL11.glTranslatef(-0.0625F, 0.4375F, 0.0625F);

            if (itemstack.itemID < 256 && RenderBlocks.renderItemIn3d(Block.blocksList[itemstack.itemID].getRenderType()))
            {
                float f1 = 0.5F;
                modelMain.equippedBlockPosition();
                f1 *= 0.75F;
                GL11.glRotatef(20F, 1.0F, 0.0F, 0.0F);
                GL11.glRotatef(45F, 0.0F, 1.0F, 0.0F);
                GL11.glScalef(f1, -f1, f1);
            }
            else if ((itemstack.getItem() instanceof ItemBow) && itemstack.getItemUseAction() != EnumAction.block)
            {
                float f2 = 0.625F;
                modelMain.equippedItemBow();
                GL11.glRotatef(-20F, 0.0F, 1.0F, 0.0F);
                GL11.glScalef(f2, -f2, f2);
                GL11.glRotatef(-100F, 1.0F, 0.0F, 0.0F);
                GL11.glRotatef(45F, 0.0F, 1.0F, 0.0F);
            }
            else if (Item.itemsList[itemstack.itemID].isFull3D())
            {
                float f3 = 0.625F;

                if (Item.itemsList[itemstack.itemID].shouldRotateAroundWhenRendering())
                {
                    GL11.glRotatef(180F, 0.0F, 0.0F, 1.0F);
                    GL11.glTranslatef(0.0F, -0.125F, 0.0F);
                }

                modelMain.equippedItemPosition3D();

                if (entitylittlemaid.maidAvatarEntity.getItemInUseCount() > 0)
                {
                    EnumAction enumaction = itemstack.getItemUseAction();

                    if (enumaction == EnumAction.block)
                    {
                        GL11.glTranslatef(0.05F, -0.05F, -0.1F);
                        GL11.glRotatef(-70F, 0.0F, 1.0F, 0.0F);
                        GL11.glRotatef(18F, 1.0F, 0.0F, 0.0F);
                        GL11.glRotatef(90F, 0.0F, 0.0F, 1.0F);
                    }
                }

                GL11.glScalef(f3, -f3, f3);
                GL11.glRotatef(-100F, 1.0F, 0.0F, 0.0F);
                GL11.glRotatef(45F, 0.0F, 1.0F, 0.0F);
            }
            else
            {
                float f4 = 0.375F;
                modelMain.equippedItemPosition();
                GL11.glScalef(f4, f4, f4);
                GL11.glRotatef(60F, 0.0F, 0.0F, 1.0F);
                GL11.glRotatef(-90F, 1.0F, 0.0F, 0.0F);
                GL11.glRotatef(20F, 0.0F, 0.0F, 1.0F);
            }

            for (int i = 0; i <= (itemstack.getItem().func_46058_c() ? 1 : 0); i++)
            {
                int k = Item.itemsList[itemstack.itemID].getColorFromDamage(itemstack.getItemDamage(), i);
                float f5 = (float)(k >> 16 & 0xff) / 255F;
                float f7 = (float)(k >> 8 & 0xff) / 255F;
                float f8 = (float)(k & 0xff) / 255F;
                GL11.glColor4f(f5, f7, f8, 1.0F);
                renderManager.itemRenderer.renderItem(entitylittlemaid, itemstack, i);
            }

            GL11.glPopMatrix();
        }
    }

    protected void renderEquippedItems(EntityLiving entityliving, float f)
    {
        renderSpecials((EntityLittleMaid)entityliving, f);
    }

    protected int updateLittleMaidColorMultiplier(EntityLittleMaid entitylittlemaid, float f, float f1)
    {
        EntityLittleMaid entitylittlemaid1 = entitylittlemaid;

        if (entitylittlemaid1.maidOverDriveTime > 0)
        {
            int i;

            if (entitylittlemaid1.maidOverDriveTime < 100)
            {
                i = entitylittlemaid1.maidOverDriveTime % 100;
            }
            else
            {
                i = 100;
            }

            return i << 24 | 0xdf0f0f;
        }

        float f2 = entitylittlemaid1.setLittleMaidFlashTime(f1);

        if ((int)(f2 * 10F) % 2 == 0)
        {
            return 0;
        }

        int j = (int)(f2 * 0.2F * 255F);

        if (j < 0)
        {
            j = 0;
        }

        if (j > 255)
        {
            j = 255;
        }

        char c = '\377';
        char c1 = '\377';
        char c2 = '\377';
        return j << 24 | c << 16 | c1 << 8 | c2;
    }

    /**
     * Returns an ARGB int color back. Args: entityLiving, lightBrightness, partialTickTime
     */
    protected int getColorMultiplier(EntityLiving entityliving, float f, float f1)
    {
        return updateLittleMaidColorMultiplier((EntityLittleMaid)entityliving, f, f1);
    }

    protected void passSpecialRender(EntityLiving entityliving, double d, double d1, double d2)
    {
        renderName((EntityLittleMaid)entityliving, d, d1, d2);
    }

    protected void renderName(EntityLittleMaid entitylittlemaid, double d, double d1, double d2)
    {
        if (Minecraft.isGuiEnabled() && entitylittlemaid != renderManager.livingPlayer)
        {
            float f = 1.6F;
            float f1 = 0.01666667F * f;
            float f2 = entitylittlemaid.getDistanceToEntity(renderManager.livingPlayer);
            float f3 = entitylittlemaid.isSneaking() ? 32F : 64F;
            float maidHeight;

            if (f2 < f3 && entitylittlemaid.getMaidName().length() > 0)
            {
                String s = entitylittlemaid.getMaidName();

                if (mod_littleMaidMob.DebugMessage)
                {
                    s = (new StringBuilder()).append(String.valueOf(entitylittlemaid.getMaidContractTime())).append("-").append(s).toString();
                }

                if (entitylittlemaid.textureModel[0] != null && entitylittlemaid.textureModel[0].getHeight() != 1.35F)
                {
                    maidHeight = entitylittlemaid.textureModel[0].getHeight() - 1.35F;
                }
                else
                {
                    maidHeight = 0F;
                }

                if (!entitylittlemaid.isSneaking())
                {
                    if (entitylittlemaid.isPlayerSleeping())
                    {
                        renderLivingLabel(entitylittlemaid, s, d, d1 - 1.5D, d2, 64);
                    }
                    else
                    {
                        renderLivingLabel(entitylittlemaid, s, d, d1 - 0.4F + maidHeight, d2, 64);
                    }
                }
                else
                {
                    FontRenderer fontrenderer = getFontRendererFromRenderManager();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)d + 0.0F, (float)d1 + 2.1F + maidHeight, (float)d2);
                    GL11.glNormal3f(0.0F, 1.0F, 0.0F);
                    GL11.glRotatef(-renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
                    GL11.glRotatef(renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
                    GL11.glScalef(-f1, -f1, f1);
                    GL11.glDisable(GL11.GL_LIGHTING);
                    GL11.glTranslatef(0.0F, 0.25F / f1, 0.0F);
                    GL11.glDepthMask(false);
                    GL11.glEnable(GL11.GL_BLEND);
                    GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
                    Tessellator tessellator = Tessellator.instance;
                    GL11.glDisable(GL11.GL_TEXTURE_2D);
                    tessellator.startDrawingQuads();
                    int i = fontrenderer.getStringWidth(s) / 2;
                    tessellator.setColorRGBA_F(0.0F, 0.0F, 0.0F, 0.25F);
                    tessellator.addVertex(-i - 1, -1D, 0.0D);
                    tessellator.addVertex(-i - 1, 8D, 0.0D);
                    tessellator.addVertex(i + 1, 8D, 0.0D);
                    tessellator.addVertex(i + 1, -1D, 0.0D);
                    tessellator.draw();
                    GL11.glEnable(GL11.GL_TEXTURE_2D);
                    GL11.glDepthMask(true);
                    fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, 0, -1);
                    GL11.glEnable(GL11.GL_LIGHTING);
                    GL11.glDisable(GL11.GL_BLEND);
                    GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
                    GL11.glPopMatrix();
                }
            }
        }
    }
}
