package net.minecraft.src;

import java.util.Random;

import org.lwjgl.opengl.GL11;

public class ModelRendererLittleMaid extends ModelRenderer
{
    private int textureOffsetX;
    private int textureOffsetY;
    private ModelBase baseModel;

    public float preRotationPointX;
    public float preRotationPointY;
    public float preRotationPointZ;
    public float preRotateAngleX;
    public float preRotateAngleY;
    public float preRotateAngleZ;
    public boolean angleFirst;
    public ModelRenderer parentModel;

    public ModelRendererLittleMaid(ModelBase modelbase, int i, int j)
    {
        super(modelbase, i, j);
        baseModel = modelbase;
        preRotationPointX = 0.0F;
        preRotationPointY = 0.0F;
        preRotationPointZ = 0.0F;
        preRotateAngleX = 0.0F;
        preRotateAngleY = 0.0F;
        preRotateAngleZ = 0.0F;
        angleFirst = false;	// ϊ𓖂Ă鏇
        parentModel = null;	// ]ɂȂe
    }

    public ModelRendererLittleMaid setTextureOffset(int i, int j)
    {
        super.setTextureOffset(i, j);
        textureOffsetX = i;
        textureOffsetY = j;
        return this;
    }

    public ModelRendererLittleMaid addPlate(String s, float f, float f1, float f2, int i, int j, int k)
    {
        s = (new StringBuilder()).append(boxName).append(".").append(s).toString();
        TextureOffset textureoffset = baseModel.getTextureOffset(s);
        setTextureOffset(textureoffset.field_40734_a, textureoffset.field_40733_b);
        cubeList.add((new ModelPlateLittleMaid(this, textureOffsetX, textureOffsetY, f, f1, f2, i, j, k, 0.0F)).func_40671_a(s));
        return this;
    }

    public ModelRendererLittleMaid addPlate(float f, float f1, float f2, int i, int j, int k)
    {
        cubeList.add(new ModelPlateLittleMaid(this, textureOffsetX, textureOffsetY, f, f1, f2, i, j, k, 0.0F));
        return this;
    }

    public ModelRendererLittleMaid addPlate(float f, float f1, float f2, int i, int j, int k, float f3)
    {
        cubeList.add(new ModelPlateLittleMaid(this, textureOffsetX, textureOffsetY, f, f1, f2, i, j, k, f3));
        return this;
    }

    public void preRotateRender(float f)
    {
        //
        if (setParentsRotate() && !parentModel.showModel)
        {
            return;
        }

        if (isHidden)
        {
            return;
        }

        if (!showModel)
        {
            return;
        }

        float rpx = rotationPointX;
        float rpy = rotationPointY;
        float rpz = rotationPointZ;
        float rax = rotateAngleX;
        float ray = rotateAngleY;
        float raz = rotateAngleZ;
        GL11.glPushMatrix();
        postRender(f);
        rotationPointX = 0F;
        rotationPointY = 0F;
        rotationPointZ = 0F;
        rotateAngleX = 0F;
        rotateAngleY = 0F;
        rotateAngleZ = 0F;

        if (!angleFirst)
        {
            GL11.glTranslatef(preRotationPointX * f, preRotationPointY * f, preRotationPointZ * f);
        }

        if (preRotateAngleZ != 0.0F)
        {
            GL11.glRotatef(preRotateAngleZ * (180F / (float)Math.PI), 0.0F, 0.0F, 1.0F);
        }

        if (preRotateAngleY != 0.0F)
        {
            GL11.glRotatef(preRotateAngleY * (180F / (float)Math.PI), 0.0F, 1.0F, 0.0F);
        }

        if (preRotateAngleX != 0.0F)
        {
            GL11.glRotatef(preRotateAngleX * (180F / (float)Math.PI), 1.0F, 0.0F, 0.0F);
        }

        if (angleFirst)
        {
            GL11.glTranslatef(preRotationPointX * f, preRotationPointY * f, preRotationPointZ * f);
        }

        render(f);
        GL11.glPopMatrix();
        rotationPointX = rpx;
        rotationPointY = rpy;
        rotationPointZ = rpz;
        rotateAngleX = rax;
        rotateAngleY = ray;
        rotateAngleZ = raz;
    }

    public void preRotateRenderDeg(float f)
    {
        // preRotationAngle̒lpxœi90Ƃj
        if (setParentsRotate() && !parentModel.showModel)
        {
            return;
        }

        if (isHidden)
        {
            return;
        }

        if (!showModel)
        {
            return;
        }

        float rpx = rotationPointX;
        float rpy = rotationPointY;
        float rpz = rotationPointZ;
        float rax = rotateAngleX;
        float ray = rotateAngleY;
        float raz = rotateAngleZ;
        GL11.glPushMatrix();
        postRender(f);
        rotationPointX = 0F;
        rotationPointY = 0F;
        rotationPointZ = 0F;
        rotateAngleX = 0F;
        rotateAngleY = 0F;
        rotateAngleZ = 0F;

        if (!angleFirst)
        {
            GL11.glTranslatef(preRotationPointX * f, preRotationPointY * f, preRotationPointZ * f);
        }

        if (preRotateAngleZ != 0.0F)
        {
            GL11.glRotatef(preRotateAngleZ, 0.0F, 0.0F, 1.0F);
        }

        if (preRotateAngleY != 0.0F)
        {
            GL11.glRotatef(preRotateAngleY, 0.0F, 1.0F, 0.0F);
        }

        if (preRotateAngleX != 0.0F)
        {
            GL11.glRotatef(preRotateAngleX, 1.0F, 0.0F, 0.0F);
        }

        if (angleFirst)
        {
            GL11.glTranslatef(preRotationPointX * f, preRotationPointY * f, preRotationPointZ * f);
        }

        render(f);
        GL11.glPopMatrix();
        rotationPointX = rpx;
        rotationPointY = rpy;
        rotationPointZ = rpz;
        rotateAngleX = rax;
        rotateAngleY = ray;
        rotateAngleZ = raz;
    }

    protected boolean setParentsRotate()
    {
        // eȂ炻̊ԐڏRs[
        if (parentModel != null)
        {
            rotationPointX = parentModel.rotationPointX;
            rotationPointY = parentModel.rotationPointY;
            rotationPointZ = parentModel.rotationPointZ;
            rotateAngleX = parentModel.rotateAngleX;
            rotateAngleY = parentModel.rotateAngleY;
            rotateAngleZ = parentModel.rotateAngleZ;
//        	showModel = parentModel.showModel;
            return true;
        }
        else
        {
            return false;
        }
    }

    public void setPreRotationPointLM(float f, float f1, float f2)
    {
        preRotationPointX = f;
        preRotationPointY = f1;
        preRotationPointZ = f2;
    }

    // o[WύXɈˑȂ߂̊֐Q
    public void addBoxLM(float f, float f1, float f2, int i, int j, int k)
    {
        addBox(f, f1, f2, i, j, k);
    }

    public void addBoxLM(float f, float f1, float f2, int i, int j, int k, float f3)
    {
        addBox(f, f1, f2, i, j, k, f3);
    }

    public void setRotationPointLM(float f, float f1, float f2)
    {
        setRotationPoint(f, f1, f2);
    }

    public void renderLM(float f)
    {
        render(f);
    }

    public void renderWithRotationLM(float f)
    {
        renderWithRotation(f);
    }

    public void postRenderLM(float f)
    {
        postRender(f);
    }

    public boolean getMirror()
    {
        return mirror;
    }

    public void setMirror(boolean flag)
    {
        mirror = flag;
    }

    public boolean getVisible()
    {
        return showModel;
    }

    public void setVisible(boolean flag)
    {
        showModel = flag;
    }

    public float getRotateAngleX()
    {
        return rotateAngleX;
    }

    public float setRotateAngleX(float value)
    {
        rotateAngleX = value;
        return rotateAngleX;
    }

    public float getRotateAngleY()
    {
        return rotateAngleY;
    }

    public float setRotateAngleY(float value)
    {
        rotateAngleY = value;
        return rotateAngleY;
    }

    public float getRotateAngleZ()
    {
        return rotateAngleZ;
    }

    public float setRotateAngleZ(float value)
    {
        rotateAngleZ = value;
        return rotateAngleZ;
    }

    public float getRotationPointX()
    {
        return rotationPointX;
    }

    public float setRotationPointX(float value)
    {
        rotationPointX = value;
        return rotationPointX;
    }

    public float getRotationPointY()
    {
        return rotationPointY;
    }

    public float setRotationPointY(float value)
    {
        rotationPointY = value;
        return rotationPointY;
    }

    public float getRotationPointZ()
    {
        return rotationPointZ;
    }

    public float setRotationPointZ(float value)
    {
        rotationPointZ = value;
        return rotationPointZ;
    }
}
