package net.minecraft.src;

public class ModelPlateLittleMaid extends ModelBox
{
    private PositionTextureVertex vertexPositions[];
    private TexturedQuad quadList[];

    /** X vertex coordinate of lower box corner */
    public final float posX1;

    /** Y vertex coordinate of lower box corner */
    public final float posY1;

    /** Z vertex coordinate of lower box corner */
    public final float posZ1;

    /** X vertex coordinate of upper box corner */
    public final float posX2;

    /** Y vertex coordinate of upper box corner */
    public final float posY2;

    /** Z vertex coordinate of upper box corner */
    public final float posZ2;

    public ModelPlateLittleMaid(ModelRenderer modelrenderer, int i, int j, float f, float f1, float f2, int k, int l, int i1, float f3)
    {
        super(modelrenderer, i, j, f, f1, f2, k, l, i1, f3);
        float f4;
        float f5;
        float f6;

        switch (i1 & 3)
        {
            case 0:
                posX1 = f;
                posY1 = f1;
                posZ1 = f2;
                posX2 = f4 = f + (float)k;
                posY2 = f5 = f1 + (float)l;
                posZ2 = f6 = f2;
                f -= f3;
                f1 -= f3;
                f4 += f3;
                f5 += f3;

                if (i1 < 4)
                {
                    f2 -= f3;
                    f6 -= f3;
                }
                else
                {
                    f2 += f3;
                    f6 += f3;
                }

                break;

            case 1:
                posX1 = f;
                posY1 = f1;
                posZ1 = f2;
                posX2 = f4 = f;
                posY2 = f5 = f1 + (float)l;
                posZ2 = f6 = f2 + (float)k;
                f1 -= f3;
                f2 -= f3;
                f5 += f3;
                f6 += f3;

                if (i1 < 4)
                {
                    f += f3;
                    f4 += f3;
                }
                else
                {
                    f -= f3;
                    f4 -= f3;
                }

                break;

            case 2:
            default:
                posX1 = f;
                posY1 = f1;
                posZ1 = f2;
                posX2 = f4 = f + (float)k;
                posY2 = f5 = f1;
                posZ2 = f6 = f2 + (float)l;
                f -= f3;
                f2 -= f3;
                f4 += f3;
                f6 += f3;

                if (i1 < 4)
                {
                    f1 -= f3;
                    f5 -= f3;
                }
                else
                {
                    f1 += f3;
                    f5 += f3;
                }

                break;
        }

        vertexPositions = new PositionTextureVertex[4];
        quadList = new TexturedQuad[1];

        if (modelrenderer.mirror)
        {
            if (i1 == 0 && i1 == 4)
            {
                float f7 = f4;
                f4 = f;
                f = f7;
            }
            else if (i1 == 1 && i1 == 5)
            {
                float f8 = f6;
                f6 = f2;
                f2 = f8;
            }
            else
            {
                float f9 = f4;
                f4 = f;
                f = f9;
            }
        }

        PositionTextureVertex positiontexturevertex = new PositionTextureVertex(f, f1, f2, 0.0F, 0.0F);
        PositionTextureVertex positiontexturevertex1 = new PositionTextureVertex(f4, f1, f6, 0.0F, 8F);
        PositionTextureVertex positiontexturevertex2 = new PositionTextureVertex(f4, f5, f6, 8F, 8F);
        PositionTextureVertex positiontexturevertex3 = new PositionTextureVertex(f, f5, f2, 8F, 0.0F);
        vertexPositions[0] = positiontexturevertex;
        vertexPositions[1] = positiontexturevertex1;
        vertexPositions[2] = positiontexturevertex2;
        vertexPositions[3] = positiontexturevertex3;

        if ((i1 & 4) > 0)
        {
            quadList[0] = new TexturedQuad(new PositionTextureVertex[]
                    {
                        positiontexturevertex, positiontexturevertex1, positiontexturevertex2, positiontexturevertex3
                    }, i, j, i + k, j + l, modelrenderer.textureWidth, modelrenderer.textureHeight);
        }
        else
        {
            quadList[0] = new TexturedQuad(new PositionTextureVertex[]
                    {
                        positiontexturevertex1, positiontexturevertex, positiontexturevertex3, positiontexturevertex2
                    }, i, j, i + k, j + l, modelrenderer.textureWidth, modelrenderer.textureHeight);
        }

        try
        {
            ModLoader.setPrivateValue(net.minecraft.src.ModelBox.class, this, 0, vertexPositions);
            ModLoader.setPrivateValue(net.minecraft.src.ModelBox.class, this, 1, quadList);
        }
        catch (Exception exception) { }
    }
}
