package net.minecraft.src;

import org.lwjgl.opengl.GL11;

public class ModelLittleMaid_SR2 extends ModelLittleMaid
{
    public ModelRendererLittleMaid eyeR;
    public ModelRendererLittleMaid eyeL;

    public ModelLittleMaid_SR2()
    {
        this(0.0F);
    }

    public ModelLittleMaid_SR2(float f)
    {
        this(f, 0.0F);
    }

    public ModelLittleMaid_SR2(float f, float f1)
    {
        super(f, f1);
        eyeR = new ModelRendererLittleMaid(this, 32, 19);
        eyeR.addPlate(-4F, -4.9F, -4.001F, 4, 4, 0, f);
        eyeR.setRotationPointLM(0.0F, 0.0F + f1, 0.0F);
        eyeL = new ModelRendererLittleMaid(this, 42, 19);
        eyeL.addPlate(0.0F, -4.9F, -4.001F, 4, 4, 0, f);
        eyeL.setRotationPointLM(0.0F, 0.0F + f1, 0.0F);
    }

    public void renderLM(Entity entity, float f, float f1, float f2, float f3, float f4, float f5)
    {
        super.renderLM(entity, f, f1, f2, f3, f4, f5);

        if (bipedHead.showModel)
        {
            GL11.glPushMatrix();
            bipedHead.postRenderLM(f5);
            eyeR.renderLM(f5);
            eyeL.renderLM(f5);
            GL11.glPopMatrix();
        }
    }

    public void setLivingAnimationsLM(EntityLiving entityliving, float f, float f1, float f2)
    {
        super.setLivingAnimationsLM(entityliving, f, f1, f2);

        if (entityliving instanceof EntityLittleMaid)
        {
            EntityLittleMaid entitylittlemaid = (EntityLittleMaid)entityliving;
            float f3 = (float)entityliving.ticksExisted + f2 + entitylittlemaid.entityIdFactor;

            if (0.0F > mh_sin(f3 * 0.05F) + mh_sin(f3 * 0.13F) + mh_sin(f3 * 0.7F) + 2.55F)
            {
                eyeR.showModel = eyeL.showModel = true;
            }
            else
            {
                eyeR.showModel = eyeL.showModel = false;
            }
        }
    }

    public void setRotationAnglesLM(float f, float f1, float f2, float f3, float f4, float f5)
    {
        super.setRotationAnglesLM(f, f1, f2, f3, f4, f5);

        if (aimedBow)
        {
            eyeL.showModel = true;
        }
    }
}
