package net.minecraft.src;

import org.lwjgl.opengl.GL11;

public class ModelLittleMaid_Aug extends ModelLittleMaid
{
    public ModelRendererLittleMaid sidetailUpperR;
    public ModelRendererLittleMaid sidetailUpperL;
    public ModelRendererLittleMaid shaggyB;
    public ModelRendererLittleMaid shaggyR;
    public ModelRendererLittleMaid shaggyL;
    public ModelRendererLittleMaid sensor1;
    public ModelRendererLittleMaid sensor2;
    public ModelRendererLittleMaid sensor3;
    public ModelRendererLittleMaid sensor4;
    public ModelRendererLittleMaid eyeR;
    public ModelRendererLittleMaid eyeL;

    public ModelLittleMaid_Aug()
    {
        this(0.0F);
    }

    public ModelLittleMaid_Aug(float f)
    {
        this(f, 0.0F);
    }

    public ModelLittleMaid_Aug(float f, float f1)
    {
        super(f, f1);
        SideTailR = new ModelRendererLittleMaid(this, 46, 20);
        SideTailR.addBoxLM(-1.5F, -0.5F, -1F, 2, 10, 2);
        SideTailR.setRotationPointLM(0.0F, 0.0F + f1, 0.0F);
        SideTailR.parentModel = bipedHead;
        SideTailR.setPreRotationPointLM(-5F, -7.8F, 1.9F);
        SideTailL = new ModelRendererLittleMaid(this, 54, 20);
        SideTailL.addBoxLM(0.5F, -0.5F, -1F, 2, 10, 2);
        SideTailL.setRotationPointLM(0.0F, 0.0F + f1, 0.0F);
        SideTailL.parentModel = bipedHead;
        SideTailL.setPreRotationPointLM(4F, -7.8F, 1.9F);
        ChignonR = new ModelRendererLittleMaid(this, 0, 18);
        ChignonR.addBox(-5F, -7F, 0.2F, 1, 3, 3, f);
        ChignonR.setRotationPointLM(0.0F, 0.0F + f1, 0.0F);
        ChignonR.parentModel = bipedHead;
        ChignonR.setPreRotationPointLM(0.0F, -1.5F, 0.0F);
        ChignonL.setPreRotationPointLM(0.0F, -1.5F, 0.0F);
        sidetailUpperR = new ModelRendererLittleMaid(this, 52, 10);
        sidetailUpperR.addBoxLM(-4F, 0.0F, -1F, 4, 3, 2);
        sidetailUpperR.setRotationPointLM(0.0F, 0.0F + f1, 0.0F);
        sidetailUpperR.parentModel = bipedHead;
        sidetailUpperR.setPreRotationPointLM(-3.5F, -9.5F, 1.9F);
        sidetailUpperL = new ModelRendererLittleMaid(this, 52, 15);
        sidetailUpperL.addBoxLM(0.0F, 0.0F, -1F, 4, 3, 2);
        sidetailUpperL.setRotationPointLM(0.0F, 0.0F + f1, 0.0F);
        sidetailUpperL.parentModel = bipedHead;
        sidetailUpperL.setPreRotationPointLM(3.5F, -9.5F, 1.9F);
        shaggyB = new ModelRendererLittleMaid(this, 24, 0);
        shaggyB.addPlate(-5F, 0.0F, 0.0F, 10, 4, 4, f);
        shaggyB.setRotationPointLM(0.0F, -1F + f1, 4F);
        shaggyB.setRotateAngleX(0.4F);
        shaggyR = new ModelRendererLittleMaid(this, 34, 4);
        shaggyR.addPlate(0.0F, 0.0F, -5F, 10, 4, 1, f);
        shaggyR.setRotationPointLM(4F, -1F + f1, 0.0F);
        shaggyR.setRotateAngleZ(-0.4F);
        shaggyL = new ModelRendererLittleMaid(this, 24, 4);
        shaggyL.addPlate(0.0F, 0.0F, -5F, 10, 4, 5, f);
        shaggyL.setRotationPointLM(-4F, -1F + f1, 0.0F);
        shaggyL.setRotateAngleZ(0.4F);
        sensor1 = new ModelRendererLittleMaid(this, 0, 0);
        sensor1.addPlate(-8F, -4F, 0.0F, 8, 4, 0);
        sensor1.setRotationPointLM(0.0F, -8F + f1, 0.0F);
        sensor2 = new ModelRendererLittleMaid(this, 0, 4);
        sensor2.addPlate(0.0F, -4F, 0.0F, 8, 4, 0);
        sensor2.setRotationPointLM(0.0F, -8F + f1, 0.0F);
        sensor3 = new ModelRendererLittleMaid(this, 44, 0);
        sensor3.addPlate(0.0F, -7F, -4F, 4, 8, 1);
        sensor3.setRotationPointLM(0.0F, -8F + f1, 0.0F);
        sensor4 = new ModelRendererLittleMaid(this, 34, 0);
        sensor4.addPlate(0.0F, -4F, -10F, 10, 4, 1);
        sensor4.setRotationPointLM(0.0F, -8F + f1, 0.0F);
        eyeR = new ModelRendererLittleMaid(this, 32, 19);
        eyeR.addPlate(-4F, -4.9F, -4.001F, 4, 4, 0, f);
        eyeR.setRotationPointLM(0.0F, 0.0F + f1, 0.0F);
        eyeL = new ModelRendererLittleMaid(this, 42, 19);
        eyeL.addPlate(0.0F, -4.9F, -4.001F, 4, 4, 0, f);
        eyeL.setRotationPointLM(0.0F, 0.0F + f1, 0.0F);
        bipedHeadwear.setVisible(false);
        Tail.setVisible(false);
        ChignonB.setVisible(false);
    }

    public void renderLM(Entity entity, float f, float f1, float f2, float f3, float f4, float f5)
    {
        super.renderLM(entity, f, f1, f2, f3, f4, f5);
        sidetailUpperR.preRotateRender(f5);
        sidetailUpperL.preRotateRender(f5);

        if (bipedHead.showModel)
        {
            GL11.glPushMatrix();
            bipedHead.postRenderLM(f5);
            shaggyB.renderLM(f5);
            shaggyR.renderLM(f5);
            shaggyL.renderLM(f5);
            sensor1.renderLM(f5);
            sensor2.renderLM(f5);
            sensor3.renderLM(f5);
            sensor4.renderLM(f5);
            eyeR.renderLM(f5);
            eyeL.renderLM(f5);
            GL11.glPopMatrix();
        }
    }

    public void setLivingAnimationsLM(EntityLiving entityliving, float f, float f1, float f2)
    {
        super.setLivingAnimationsLM(entityliving, f, f1, f2);

        if (entityliving instanceof EntityLittleMaid)
        {
            EntityLittleMaid entitylittlemaid = (EntityLittleMaid)entityliving;
            float f3 = (float)entityliving.ticksExisted + f2 + entitylittlemaid.entityIdFactor;

            if (mh_sin(f3 * 0.05F) + mh_sin(f3 * 0.13F) + mh_sin(f3 * 0.7F) + 2.55F < 0.0F)
            {
                eyeR.showModel = eyeL.showModel = true;
            }
            else
            {
                eyeR.showModel = eyeL.showModel = false;
            }

            float f4;

            if (entitylittlemaid.isLookSuger())
            {
                f3 *= 8F;
                f4 = -0.2F;
            }
            else
            {
                f4 = (1.0F - (float)entitylittlemaid.health / 20F) * 0.5F;
            }

            sensor1.rotateAngleY = -((float)Math.PI * 2F / 9F);
            sensor2.rotateAngleY = ((float)Math.PI * 2F / 9F);
            sensor1.rotateAngleX = sensor1.rotateAngleZ = mh_sin(f3 * 0.067F) * 0.05F - f4;
            sensor2.rotateAngleX = sensor2.rotateAngleZ = -(mh_sin(f3 * 0.067F) * 0.05F - f4);
            sensor3.rotateAngleX = mh_sin(f3 * 0.067F) * 0.05F - 1.2F - f4;
            sensor3.rotateAngleY = mh_sin(f3 * 0.09F) * 0.4F;
            sensor3.rotateAngleZ = mh_cos(f3 * 0.09F) * 0.2F;
            sensor4.rotateAngleX = mh_sin(f3 * 0.067F) * 0.05F + f4;
            sensor4.rotateAngleY = mh_cos(f3 * 0.09F) * 0.5F;
            sensor4.rotateAngleZ = mh_sin(f3 * 0.09F) * 0.2F;
        }
    }

    public void setRotationAnglesLM(float f, float f1, float f2, float f3, float f4, float f5)
    {
        super.setRotationAnglesLM(f, f1, f2, f3, f4, f5);
        SideTailR.preRotateAngleX = SideTailL.preRotateAngleX = -bipedHead.getRotateAngleX() / 1.5F;

        if (aimedBow)
        {
            eyeL.showModel = true;
        }
    }
}
