package net.minecraft.src;

import java.util.Random;
import org.lwjgl.opengl.GL11;

public class ModelLittleMaid extends ModelBiped
{
    public ModelRendererLittleMaid bipedHead;
    public ModelRendererLittleMaid bipedHeadwear;
    public ModelRendererLittleMaid bipedBody;
    public ModelRendererLittleMaid bipedRightArm;
    public ModelRendererLittleMaid bipedLeftArm;
    public ModelRendererLittleMaid bipedRightLeg;
    public ModelRendererLittleMaid bipedLeftLeg;
    public ModelRendererLittleMaid Skirt;
    public ModelRendererLittleMaid ChignonR;
    public ModelRendererLittleMaid ChignonL;
    public ModelRendererLittleMaid ChignonB;
    public ModelRendererLittleMaid Tail;
    public ModelRendererLittleMaid SideTailR;
    public ModelRendererLittleMaid SideTailL;
    public boolean isWait;
    protected static final float littleMaidHeight = 1.35F;
    protected static final float littleMaidWidth = 0.5F;

    public ModelLittleMaid()
    {
        this(0.0F);
    }

    public ModelLittleMaid(float f)
    {
        this(f, 0.0F);
    }

    public ModelLittleMaid(float f, float f1)
    {
        heldItemLeft = 0;
        heldItemRight = 0;
        isSneak = false;
        isWait = false;
        aimedBow = false;
        f1 += 8F;
        bipedCloak = new ModelRenderer(this, 0, 0);
        bipedCloak.addBox(-5F, 0.0F, -1F, 10, 16, 1, f);
        bipedCloak.showModel = false;
        bipedEars = new ModelRenderer(this, 0, 16);
        bipedEars.addBox(-3F, -6F, -1F, 6, 6, 1, f);
        bipedEars.showModel = false;
        bipedHead = new ModelRendererLittleMaid(this, 0, 0);
        bipedHead.addBox(-4F, -8F, -4F, 8, 8, 8, f);
        bipedHead.setRotationPoint(0.0F, 0.0F + f1, 0.0F);
        bipedHeadwear = new ModelRendererLittleMaid(this, 24, 0);
        bipedHeadwear.addBox(-4F, 0.0F, 1.0F, 8, 4, 3, f);
        bipedHeadwear.setRotationPoint(0.0F, 0.0F + f1, 0.0F);
        bipedHeadwear.parentModel = bipedHead;
        bipedBody = new ModelRendererLittleMaid(this, 32, 8);
        bipedBody.addBox(-3F, 0.0F, -2F, 6, 7, 4, f);
        bipedBody.setRotationPoint(0.0F, 0.0F + f1, 0.0F);
        bipedRightArm = new ModelRendererLittleMaid(this, 48, 0);
        bipedRightArm.addBox(-2F, -1F, -1F, 2, 8, 2, f);
        bipedRightArm.setRotationPoint(-3F, 1.5F + f1, 0.0F);
        bipedLeftArm = new ModelRendererLittleMaid(this, 56, 0);
        bipedLeftArm.addBox(0.0F, -1F, -1F, 2, 8, 2, f);
        bipedLeftArm.setRotationPoint(3F, 1.5F + f1, 0.0F);
        bipedRightLeg = new ModelRendererLittleMaid(this, 32, 19);
        bipedRightLeg.addBox(-2F, 0.0F, -2F, 3, 9, 4, f);
        bipedRightLeg.setRotationPoint(-1F, 7F + f1, 0.0F);
        bipedLeftLeg = new ModelRendererLittleMaid(this, 32, 19);
        bipedLeftLeg.mirror = true;
        bipedLeftLeg.addBox(-1F, 0.0F, -2F, 3, 9, 4, f);
        bipedLeftLeg.setRotationPoint(1.0F, 7F + f1, 0.0F);
        Skirt = new ModelRendererLittleMaid(this, 0, 16);
        Skirt.addBox(-4F, -2F, -4F, 8, 8, 8, f);
        Skirt.setRotationPoint(0.0F, 7F + f1, 0.0F);
        ChignonR = new ModelRendererLittleMaid(this, 24, 18);
        ChignonR.addBox(-5F, -7F, 0.2F, 1, 3, 3, f);
        ChignonR.setRotationPoint(0.0F, 0.0F + f1, 0.0F);
        ChignonR.parentModel = bipedHead;
        ChignonL = new ModelRendererLittleMaid(this, 24, 18);
        ChignonL.addBox(4F, -7F, 0.2F, 1, 3, 3, f);
        ChignonL.setRotationPoint(0.0F, 0.0F + f1, 0.0F);
        ChignonL.parentModel = bipedHead;
        ChignonB = new ModelRendererLittleMaid(this, 52, 10);
        ChignonB.addBox(-2F, -7.2F, 4F, 4, 4, 2, f);
        ChignonB.setRotationPoint(0.0F, 0.0F + f1, 0.0F);
        ChignonB.parentModel = bipedHead;
        Tail = new ModelRendererLittleMaid(this, 46, 20);
        Tail.addBox(-1.5F, -6.8F, 4F, 3, 9, 3, f);
        Tail.setRotationPoint(0.0F, 0.0F + f1, 0.0F);
        Tail.parentModel = bipedHead;
        SideTailR = new ModelRendererLittleMaid(this, 58, 21);
        SideTailR.addBox(-5.5F, -6.8F, 0.9F, 1, 8, 2, f);
        SideTailR.setRotationPoint(0.0F, 0.0F + f1, 0.0F);
        SideTailR.parentModel = bipedHead;
        SideTailL = new ModelRendererLittleMaid(this, 58, 21);
        SideTailL.mirror = true;
        SideTailL.addBox(4.5F, -6.8F, 0.9F, 1, 8, 2, f);
        SideTailL.setRotationPoint(0.0F, 0.0F + f1, 0.0F);
        SideTailL.parentModel = bipedHead;
    }

    /**
     * Sets the models various rotation angles then renders the model.
     */
    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5)
    {
        renderLM(entity, f, f1, f2, f3, f4, f5);
    }

    /**
     * Used for easily adding entity-dependent animations. The second and third float params here are the same second
     * and third as in the setRotationAngles method.
     */
    public void setLivingAnimations(EntityLiving entityliving, float f, float f1, float f2)
    {
        setLivingAnimationsLM(entityliving, f, f1, f2);
    }

    /**
     * Sets the models various rotation angles.
     */
    public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5)
    {
        setRotationAnglesLM(f, f1, f2, f3, f4, f5);
    }

    /**
     * renders the ears (specifically, deadmau5's)
     */
    public void renderEars(float f)
    {
    }

    /**
     * Renders the cloak of the current biped (in most cases, it's a player)
     */
    public void renderCloak(float f)
    {
    }

    public float getHeight()
    {
        return 1.35F;
    }

    public float getWidth()
    {
        return 0.5F;
    }

    public void equippedBlockPosition()
    {
        GL11.glTranslatef(0.0F, 0.1275F, -0.3125F);
    }

    public void equippedItemPosition3D()
    {
        GL11.glTranslatef(0.02F, 0.13F, 0.0F);
    }

    public void equippedItemPosition()
    {
        GL11.glTranslatef(0.2F, 0.08F, -0.0875F);
    }

    public void equippedItemBow()
    {
        equippedItemPosition3D();
        GL11.glTranslatef(-0.05F, -0.075F, 0.1F);
    }

    public boolean isItemHolder(){
    	return false;
    }

    public void renderLM(Entity entity, float f, float f1, float f2, float f3, float f4, float f5)
    {
        setRotationAngles(f, f1, f2, f3, f4, f5);
        bipedHead.preRotateRender(f5);
        bipedHeadwear.preRotateRender(f5);
        ChignonR.preRotateRender(f5);
        ChignonL.preRotateRender(f5);
        ChignonB.preRotateRender(f5);
        Tail.preRotateRender(f5);
        SideTailR.preRotateRender(f5);
        SideTailL.preRotateRender(f5);
        bipedBody.preRotateRender(f5);
        bipedRightArm.preRotateRender(f5);
        bipedLeftArm.preRotateRender(f5);
        bipedRightLeg.preRotateRender(f5);
        bipedLeftLeg.preRotateRender(f5);
        Skirt.preRotateRender(f5);
    }

    public void setLivingAnimationsLM(EntityLiving entityliving, float f, float f1, float f2)
    {
        if (entityliving instanceof EntityLittleMaid)
        {
            EntityLittleMaid entitylittlemaid = (EntityLittleMaid)entityliving;
            float f3 = entitylittlemaid.getInterestedAngle(f2);
            bipedHead.rotateAngleZ = f3;
            bipedHeadwear.rotateAngleZ = f3;
            bipedEars.rotateAngleZ = f3;
        }
    }

    public void setRotationAnglesLM(float f, float f1, float f2, float f3, float f4, float f5)
    {
        bipedHead.rotateAngleY = f3 / (180F / (float)Math.PI);
        bipedHead.rotateAngleX = f4 / (180F / (float)Math.PI);
        bipedHeadwear.rotateAngleY = bipedHead.rotateAngleY;
        bipedHeadwear.rotateAngleX = bipedHead.rotateAngleX;
        bipedRightArm.rotateAngleX = MathHelper.cos(f * 0.6662F + (float)Math.PI) * 2.0F * f1 * 0.5F;
        bipedLeftArm.rotateAngleX = MathHelper.cos(f * 0.6662F) * 2.0F * f1 * 0.5F;
        bipedRightArm.rotateAngleZ = 0.0F;
        bipedLeftArm.rotateAngleZ = 0.0F;
        bipedRightLeg.rotateAngleX = MathHelper.cos(f * 0.6662F) * 1.4F * f1;
        bipedLeftLeg.rotateAngleX = MathHelper.cos(f * 0.6662F + (float)Math.PI) * 1.4F * f1;
        bipedRightLeg.rotateAngleY = 0.0F;
        bipedLeftLeg.rotateAngleY = 0.0F;

        if (isRiding)
        {
            bipedRightArm.rotateAngleX += -((float)Math.PI / 5F);
            bipedLeftArm.rotateAngleX += -((float)Math.PI / 5F);
            bipedRightLeg.rotateAngleX = -((float)Math.PI * 2F / 5F);
            bipedLeftLeg.rotateAngleX = -((float)Math.PI * 2F / 5F);
            bipedRightLeg.rotateAngleY = ((float)Math.PI / 10F);
            bipedLeftLeg.rotateAngleY = -((float)Math.PI / 10F);
        }

        if (heldItemLeft != 0)
        {
            bipedLeftArm.rotateAngleX = bipedLeftArm.rotateAngleX * 0.5F - ((float)Math.PI / 10F) * (float)heldItemLeft;
        }

        if (heldItemRight != 0)
        {
            bipedRightArm.rotateAngleX = bipedRightArm.rotateAngleX * 0.5F - ((float)Math.PI / 10F) * (float)heldItemRight;
        }

        bipedRightArm.rotateAngleY = 0.0F;
        bipedLeftArm.rotateAngleY = 0.0F;

        if (onGround > -9990F && !aimedBow)
        {
            float f6 = onGround;
            bipedBody.rotateAngleY = MathHelper.sin(MathHelper.sqrt_float(f6) * (float)Math.PI * 2.0F) * 0.2F;
            Skirt.rotateAngleY = bipedBody.rotateAngleY;
            bipedRightArm.rotationPointZ = MathHelper.sin(bipedBody.rotateAngleY) * 4F;
            bipedRightArm.rotationPointX = -MathHelper.cos(bipedBody.rotateAngleY) * 4F + 1.0F;
            bipedLeftArm.rotationPointZ = -MathHelper.sin(bipedBody.rotateAngleY) * 4F;
            bipedLeftArm.rotationPointX = MathHelper.cos(bipedBody.rotateAngleY) * 4F - 1.0F;
            bipedRightArm.rotateAngleY += bipedBody.rotateAngleY;
            bipedLeftArm.rotateAngleY += bipedBody.rotateAngleY;
            bipedLeftArm.rotateAngleX += bipedBody.rotateAngleY;
            f6 = 1.0F - onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0F - f6;
            float f8 = MathHelper.sin(f6 * (float)Math.PI);
            float f10 = MathHelper.sin(onGround * (float)Math.PI) * -(bipedHead.rotateAngleX - 0.7F) * 0.75F;
            bipedRightArm.rotateAngleX -= (double)f8 * 1.2D + (double)f10;
            bipedRightArm.rotateAngleY += bipedBody.rotateAngleY * 2.0F;
            bipedRightArm.rotateAngleZ = MathHelper.sin(onGround * (float)Math.PI) * -0.4F;
        }

        if (isSneak)
        {
            bipedBody.rotateAngleX = 0.5F;
            bipedRightLeg.rotateAngleX -= 0.0F;
            bipedLeftLeg.rotateAngleX -= 0.0F;
            bipedRightArm.rotateAngleX += 0.4F;
            bipedLeftArm.rotateAngleX += 0.4F;
            bipedRightLeg.rotationPointZ = 3F;
            bipedLeftLeg.rotationPointZ = 3F;
            bipedRightLeg.rotationPointY = 14F;
            bipedLeftLeg.rotationPointY = 14F;
            bipedHead.rotationPointY = 9F;
            bipedHeadwear.rotationPointY = 9F;
            bipedHeadwear.rotateAngleX += 0.5F;
            Skirt.rotationPointY = 13.8F;
            Skirt.rotationPointZ = 2.7F;
            Skirt.rotateAngleX = 0.2F;
        }
        else
        {
            bipedBody.rotateAngleX = 0.0F;
            bipedRightLeg.rotationPointZ = 0.0F;
            bipedLeftLeg.rotationPointZ = 0.0F;
            bipedRightLeg.rotationPointY = 15F;
            bipedLeftLeg.rotationPointY = 15F;
            bipedHead.rotationPointY = 8F;
            bipedHeadwear.rotationPointY = 8F;
            Skirt.rotationPointY = 15F;
            Skirt.rotationPointZ = 0.0F;
            Skirt.rotateAngleX = 0.0F;
        }

        if (isWait)
        {
            bipedRightArm.rotateAngleX = MathHelper.sin(f2 * 0.067F) * 0.05F - 0.7F;
            bipedRightArm.rotateAngleY = 0.0F;
            bipedRightArm.rotateAngleZ = -0.4F;
            bipedLeftArm.rotateAngleX = MathHelper.sin(f2 * 0.067F) * 0.05F - 0.7F;
            bipedLeftArm.rotateAngleY = 0.0F;
            bipedLeftArm.rotateAngleZ = 0.4F;
        }
        else if (aimedBow)
        {
            float f7 = MathHelper.sin(onGround * (float)Math.PI);
            float f9 = MathHelper.sin((1.0F - (1.0F - onGround) * (1.0F - onGround)) * (float)Math.PI);
            bipedRightArm.rotateAngleZ = 0.0F;
            bipedLeftArm.rotateAngleZ = 0.0F;
            bipedRightArm.rotateAngleY = -(0.1F - f7 * 0.6F);
            bipedLeftArm.rotateAngleY = 0.1F - f7 * 0.6F;
            bipedRightArm.rotateAngleX = -1.470796F;
            bipedLeftArm.rotateAngleX = -1.470796F;
            bipedRightArm.rotateAngleX -= f7 * 1.2F - f9 * 0.4F;
            bipedLeftArm.rotateAngleX -= f7 * 1.2F - f9 * 0.4F;
            bipedRightArm.rotateAngleZ += MathHelper.cos(f2 * 0.09F) * 0.05F + 0.05F;
            bipedLeftArm.rotateAngleZ -= MathHelper.cos(f2 * 0.09F) * 0.05F + 0.05F;
            bipedRightArm.rotateAngleX += MathHelper.sin(f2 * 0.067F) * 0.05F;
            bipedLeftArm.rotateAngleX -= MathHelper.sin(f2 * 0.067F) * 0.05F;
            bipedRightArm.rotateAngleX += bipedHead.rotateAngleX;
            bipedLeftArm.rotateAngleX += bipedHead.rotateAngleX;
            bipedRightArm.rotateAngleY += bipedHead.rotateAngleY;
            bipedLeftArm.rotateAngleY += bipedHead.rotateAngleY;
        }
        else
        {
            bipedRightArm.rotateAngleZ += 0.5F;
            bipedLeftArm.rotateAngleZ -= 0.5F;
            bipedRightArm.rotateAngleZ += MathHelper.cos(f2 * 0.09F) * 0.05F + 0.05F;
            bipedLeftArm.rotateAngleZ -= MathHelper.cos(f2 * 0.09F) * 0.05F + 0.05F;
            bipedRightArm.rotateAngleX += MathHelper.sin(f2 * 0.067F) * 0.05F;
            bipedLeftArm.rotateAngleX -= MathHelper.sin(f2 * 0.067F) * 0.05F;
        }
    }

    public boolean getIsRiding()
    {
        return isRiding;
    }

    public float getOnGround()
    {
        return onGround;
    }

    public boolean getIsSneak()
    {
        return isSneak;
    }

    public float mh_sin(float f)
    {
        return MathHelper.sin(f);
    }

    public float mh_cos(float f)
    {
        return MathHelper.cos(f);
    }

    public float mh_sqrt_float(float f)
    {
        return MathHelper.sqrt_float(f);
    }

    public float mh_sqrt_double(double d)
    {
        return MathHelper.sqrt_double(d);
    }

    public int mh_floor_float(float f)
    {
        return MathHelper.floor_float(f);
    }

    public int mh_floor_double(double d)
    {
        return MathHelper.floor_double(d);
    }

    public long mh_floor_double_long(double d)
    {
        return MathHelper.floor_double_long(d);
    }

    public float mh_abs(float f)
    {
        return MathHelper.abs(f);
    }

    public double mh_abs_max(double d, double d1)
    {
        return MathHelper.abs_max(d, d1);
    }

    public int mh_bucketInt(int i, int j)
    {
        return MathHelper.bucketInt(i, j);
    }

    public boolean mh_stringNullOrLengthZero(String s)
    {
        return MathHelper.stringNullOrLengthZero(s);
    }

    public int mh_getRandomIntegerInRange(Random random, int i, int j)
    {
        return MathHelper.getRandomIntegerInRange(random, i, j);
    }
}
