package net.minecraft.src;

import java.lang.reflect.Method;
import java.util.*;

public class InventoryLittleMaid extends InventoryPlayer
{
    private static final int maxInventorySize = 18;
    protected EntityLittleMaid entitylittlemaid;
    private static TileEntityFurnace localFurnace = new TileEntityFurnace();

    public InventoryLittleMaid(EntityLittleMaid entitylittlemaid1)
    {
        super(null);
        mainInventory = new ItemStack[18];
        currentItem = 0;
        inventoryChanged = false;
        entitylittlemaid = entitylittlemaid1;
    }

    /**
     * returns a player armor item (as itemstack) contained in specified armor slot.
     */
    public ItemStack armorItemInSlot(int i)
    {
        return armorInventory[i];
    }

    /**
     * Based on the damage values and maximum damage values of each armor item, returns the current armor value.
     */
    public int getTotalArmorValue()
    {
        int i = 0;

        for (int j = 0; j < armorInventory.length - 1; j++)
        {
            if (armorInventory[j] != null && (armorInventory[j].getItem() instanceof ItemArmor))
            {
                int k = ((ItemArmor)armorInventory[j].getItem()).damageReduceAmount + 1;
                i += k;
            }
        }

        return i;
    }

    /**
     * Damages armor in each slot by the specified amount.
     */
    public void damageArmor(int i)
    {
        i /= 4;

        if (i < 1)
        {
            i = 1;
        }

        for (int j = 0; j < armorInventory.length - 1; j++)
        {
            if (armorInventory[j] == null || !(armorInventory[j].getItem() instanceof ItemArmor))
            {
                continue;
            }

            armorInventory[j].damageItem(i, entitylittlemaid);

            if (armorInventory[j].stackSize == 0)
            {
                armorInventory[j] = null;
            }
        }
    }

    public void dropAllItems(boolean flag)
    {
        armorInventory[3] = null;

        for (int i = 0; i < getSizeInventory(); i++)
        {
            ItemStack itemstack = getStackInSlot(i);

            if (itemstack != null)
            {
                int j = itemstack.getItem().shiftedIndex;

                if (j < 256 && Block.blocksList[j].blockMaterial == Material.tnt && flag)
                {
                    for (int k = 0; k < itemstack.stackSize; k++)
                    {
                        ((BlockTNT)Block.blocksList[j]).onBlockDestroyedByExplosion(entitylittlemaid.worldObj, (MathHelper.floor_double(entitylittlemaid.posX) + entitylittlemaid.rand.nextInt(7)) - 3, (MathHelper.floor_double(entitylittlemaid.posY) + entitylittlemaid.rand.nextInt(7)) - 3, (MathHelper.floor_double(entitylittlemaid.posZ) + entitylittlemaid.rand.nextInt(7)) - 3);
                    }
                }
                else
                {
                    entitylittlemaid.entityDropItem(itemstack, 0.0F);
                }
            }

            setInventorySlotContents(i, null);
        }
    }

    /**
     * Drop all armor and main inventory items.
     */
    public void dropAllItems()
    {
        dropAllItems(false);
    }

    /**
     * Adds the item stack to the inventory, returns false if it is impossible.
     */
    public boolean addItemStackToInventory(ItemStack itemstack)
    {
        if (!itemstack.isItemDamaged())
        {
            int i;

            do
            {
                i = itemstack.stackSize;
                itemstack.stackSize = storePartialItemStack(itemstack);
            }
            while (itemstack.stackSize > 0 && itemstack.stackSize < i);

            return itemstack.stackSize < i;
        }

        int j = getFirstEmptyStack();

        if (j >= 0)
        {
            mainInventory[j] = ItemStack.copyItemStack(itemstack);
            mainInventory[j].animationsToGo = 5;
            itemstack.stackSize = 0;
            return true;
        }
        else
        {
            return false;
        }
    }

    private int storePartialItemStack(ItemStack itemstack)
    {
        int i = itemstack.itemID;
        int j = itemstack.stackSize;

        if (itemstack.getMaxStackSize() == 1)
        {
            int k = getFirstEmptyStack();

            if (k < 0)
            {
                return j;
            }

            if (mainInventory[k] == null)
            {
                mainInventory[k] = ItemStack.copyItemStack(itemstack);
            }

            return 0;
        }

        int l = storeItemStack(itemstack);

        if (l < 0)
        {
            l = getFirstEmptyStack();
        }

        if (l < 0)
        {
            return j;
        }

        if (mainInventory[l] == null)
        {
            mainInventory[l] = new ItemStack(i, 0, itemstack.getItemDamage());
        }

        int i1 = j;

        if (i1 > mainInventory[l].getMaxStackSize() - mainInventory[l].stackSize)
        {
            i1 = mainInventory[l].getMaxStackSize() - mainInventory[l].stackSize;
        }

        if (i1 > getInventoryStackLimit() - mainInventory[l].stackSize)
        {
            i1 = getInventoryStackLimit() - mainInventory[l].stackSize;
        }

        if (i1 == 0)
        {
            return j;
        }
        else
        {
            j -= i1;
            mainInventory[l].stackSize += i1;
            mainInventory[l].animationsToGo = 5;
            return j;
        }
    }

    /**
     * Decrement the number of animations remaining. Only called on client side. This is used to handle the animation of
     * receiving a block.
     */
    public void decrementAnimations()
    {
        for (int i = 0; i < mainInventory.length; i++)
        {
            if (mainInventory[i] != null)
            {
                mainInventory[i].updateAnimation(entitylittlemaid.worldObj, entitylittlemaid, i, currentItem == i);
            }
        }
    }

    public void setItemStack(ItemStack itemstack)
    {
    }

    private int storeItemStack(ItemStack itemstack)
    {
        for (int i = 0; i < mainInventory.length; i++)
        {
            if (mainInventory[i] != null && mainInventory[i].itemID == itemstack.itemID && mainInventory[i].isStackable() && mainInventory[i].stackSize < mainInventory[i].getMaxStackSize() && mainInventory[i].stackSize < getInventoryStackLimit() && (!mainInventory[i].getHasSubtypes() || mainInventory[i].getItemDamage() == itemstack.getItemDamage()))
            {
                return i;
            }
        }

        return -1;
    }

    /**
     * Do not make give this method the name canInteractWith because it clashes with Container
     */
    public boolean isUseableByPlayer(EntityPlayer entityplayer)
    {
        if (entitylittlemaid.isDead)
        {
            return false;
        }
        else
        {
            return entityplayer.getDistanceSqToEntity(entitylittlemaid) <= 64D;
        }
    }

    public int getFirstEmptyStack()
    {
        for (int i = 0; i < mainInventory.length; i++)
        {
            if (mainInventory[i] == null)
            {
                return i;
            }
        }

        return -1;
    }

    /**
     * Returns the item stack currently held by the player.
     */
    public ItemStack getCurrentItem()
    {
        if (currentItem >= 0 && currentItem < mainInventory.length)
        {
            return mainInventory[currentItem];
        }
        else
        {
            return null;
        }
    }

    protected int getInventorySlotContainItem(int i)
    {
        for (int j = 0; j < mainInventory.length; j++)
        {
            if (mainInventory[j] != null && mainInventory[j].itemID == i)
            {
                return j;
            }
        }

        return -1;
    }

    protected ItemStack getInventorySlotContainItemStack(int i)
    {
        int j = getInventorySlotContainItem(i);

        if (j > -1)
        {
            return mainInventory[j];
        }
        else
        {
            return null;
        }
    }

    public int getInventorySlotContainItemFood()
    {
        for (int i = 0; i < mainInventory.length; i++)
        {
            if (mainInventory[i] != null && (mainInventory[i].getItem() instanceof ItemFood) && ((ItemFood)mainInventory[i].getItem()).getHealAmount() > 0)
            {
                return i;
            }
        }

        return -1;
    }

    public int getInventorySlotContainItemPotion(boolean flag, int i, boolean flag1)
    {
        label0:

        for (int j = 0; j < mainInventory.length; j++)
        {
            if (mainInventory[j] == null || !(mainInventory[j].getItem() instanceof ItemPotion))
            {
                continue;
            }

            ItemStack itemstack = mainInventory[j];
            List list = ((ItemPotion)itemstack.getItem()).getEffects(itemstack);

            if (list == null)
            {
                continue;
            }

            Iterator iterator = list.iterator();

            do
            {
                if (!iterator.hasNext())
                {
                    break;
                }

                PotionEffect potioneffect = (PotionEffect)iterator.next();

                if (potioneffect.getPotionID() == i)
                {
                    break;
                }

                if (potioneffect.getPotionID() != Potion.heal.id ? potioneffect.getPotionID() != Potion.harm.id ? Potion.potionTypes[potioneffect.getPotionID()].isBadEffect() != flag : flag && flag1 || !flag && !flag1 : !flag && flag1 || flag && !flag1)
                {
                    continue label0;
                }
            }
            while (true);

            return j;
        }

        return -1;
    }

    /**
     * Reads from the given tag list and fills the slots in the inventory with the correct items.
     */
    public void readFromNBT(NBTTagList nbttaglist)
    {
        mainInventory = new ItemStack[18];
        armorInventory = new ItemStack[4];

        for (int i = 0; i < nbttaglist.tagCount(); i++)
        {
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.tagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xff;
            ItemStack itemstack = ItemStack.loadItemStackFromNBT(nbttagcompound);

            if (itemstack == null)
            {
                continue;
            }

            if (j >= 0 && j < mainInventory.length)
            {
                mainInventory[j] = itemstack;
            }

            if (j >= 100 && j < armorInventory.length + 100)
            {
                armorInventory[j - 100] = itemstack;
            }
        }
    }

    /**
     * Returns the name of the inventory.
     */
    public String getInvName()
    {
        return "InsideSkirt";
    }

    /**
     * Return damage vs an entity done by the current held weapon, or 1 if nothing is held
     */
    public int getDamageVsEntity(Entity entity)
    {
        return getDamageVsEntity(entity, currentItem);
    }

    public int getDamageVsEntity(Entity entity, int i)
    {
        if (i < 0 || i >= getSizeInventory())
        {
            return 1;
        }

        ItemStack itemstack = getStackInSlot(i);

        if (itemstack != null)
        {
            if (itemstack.getItem() instanceof ItemAxe)
            {
                return (itemstack.getDamageVsEntity(entity) * 3) / 2 + 1;
            }
            else
            {
                return itemstack.getDamageVsEntity(entity);
            }
        }
        else
        {
            return 1;
        }
    }

    public boolean isItemExplord(int i)
    {
        ItemStack itemstack = getStackInSlot(i);

        if (itemstack == null)
        {
            return false;
        }
        else
        {
            Item item = itemstack.getItem();
            return (item instanceof ItemBlock) && Block.blocksList[item.shiftedIndex].blockMaterial == Material.tnt;
        }
    }

    private int getItemBurnTime(ItemStack itemstack)
    {
        Object obj = null;

        try
        {
            Method method;

            try
            {
                method = (net.minecraft.src.TileEntityFurnace.class).getDeclaredMethod("a", new Class[]
                        {
                            net.minecraft.src.ItemStack.class
                        });
                method.setAccessible(true);
            }
            catch (NoSuchMethodException nosuchmethodexception)
            {
                method = (net.minecraft.src.TileEntityFurnace.class).getDeclaredMethod("getItemBurnTime", new Class[]
                        {
                            net.minecraft.src.ItemStack.class
                        });
                method.setAccessible(true);
            }

            if (method != null)
            {
                return ((Integer)method.invoke(localFurnace, new Object[]
                        {
                            itemstack
                        })).intValue();
            }
        }
        catch (Exception exception)
        {
            mod_littleMaidMob.Debug("getItemBurnTime fail.");
        }

        return 0;
    }

    public boolean isItemBurned(int i)
    {
        ItemStack itemstack = getStackInSlot(i);

        if (itemstack == null)
        {
            return false;
        }

        int j = itemstack.getItem().shiftedIndex;
        return getItemBurnTime(itemstack) > 0;
    }

    public int getSmeltingItem()
    {
        for (int i = 0; i < mainInventory.length; i++)
        {
            ItemStack itemstack = mainInventory[i];

            if (itemstack != null && FurnaceRecipes.smelting().getSmeltingResult(itemstack.getItem().shiftedIndex) != null && i != currentItem && (itemstack.getMaxDamage() <= 0 || itemstack.getItemDamage() != 0))
            {
                return i;
            }
        }

        return -1;
    }

    /**
     * Called when an the contents of an Inventory change, usually
     */
    public void onInventoryChanged()
    {
        super.onInventoryChanged();
        entitylittlemaid.setClockMaid();
        entitylittlemaid.setMaskedMaid();
        entitylittlemaid.setArmorTextureValue();
    }

    public void setInventoryCurrentSlotContents(ItemStack itemstack)
    {
        setInventorySlotContents(currentItem, itemstack);
    }
}
