package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiLittleMaidTriggerSelect extends GuiContainer
{
    public static List ListSword = new ArrayList();
    public static List ListAxe = new ArrayList();
    public static List ListBow = new ArrayList();
    public static String SwordIndex = "";
    public static String AxeIndex = "";
    public static String BowIndex = "";
    protected float scrolleWeaponset;
    protected float scrolleContainer;
    private static InventoryBasic inventory1 = new InventoryBasic("tmpsel", 40);
    private static InventoryBasic inventory2 = new InventoryBasic("tmpwep", 32);
    private int lastX;
    private int lastY;
    private boolean ismousePress;
    private int isScrolled;
    public GuiLittleMaidIFF owner;
    private GuiButton guiButton[];
    private ContainerLittleMaidTriggerSelect inventoryTrigger;

    public GuiLittleMaidTriggerSelect(EntityPlayer entityplayer, GuiLittleMaidIFF guilittlemaidiff)
    {
        super(new ContainerLittleMaidTriggerSelect(entityplayer));
        guiButton = new GuiButton[3];
        ySize = 216;
        owner = guilittlemaidiff;
        inventoryTrigger = (ContainerLittleMaidTriggerSelect)inventorySlots;
    }

    /**
     * Adds the buttons (and other controls) to the screen in question.
     */
    public void initGui()
    {
        super.initGui();
        guiButton[0] = new GuiButton(100, guiLeft + 7, guiTop + 193, 46, 20, "Sword");
        guiButton[1] = new GuiButton(101, guiLeft + 61, guiTop + 193, 46, 20, "Axe");
        guiButton[2] = new GuiButton(102, guiLeft + 115, guiTop + 193, 46, 20, "Bow");
        controlList.add(guiButton[0]);
        controlList.add(guiButton[1]);
        controlList.add(guiButton[2]);
        guiButton[0].enabled = false;
    }

    /**
     * Fired when a key is typed. This is the equivalent of KeyListener.keyTyped(KeyEvent e).
     */
    protected void keyTyped(char c, int i)
    {
        if (i == 1)
        {
            mc.displayGuiScreen(owner);
        }
    }

    /**
     * Called when the screen is unloaded. Used to disable keyboard repeat events
     */
    public void onGuiClosed()
    {
        setItemList();
        super.onGuiClosed();
    }

    /**
     * Returns true if this GUI should pause the game when it is displayed in single-player
     */
    public boolean doesGuiPauseGame()
    {
        return true;
    }

    /**
     * Fired when a control is clicked. This is the equivalent of ActionListener.actionPerformed(ActionEvent e).
     */
    protected void actionPerformed(GuiButton guibutton)
    {
        setItemList();
        guiButton[0].enabled = true;
        guiButton[1].enabled = true;
        guiButton[2].enabled = true;

        if (guibutton.id == 100)
        {
            inventoryTrigger.setWeaponSelect(0);
            guiButton[0].enabled = false;
        }

        if (guibutton.id == 101)
        {
            inventoryTrigger.setWeaponSelect(1);
            guiButton[1].enabled = false;
        }

        if (guibutton.id == 102)
        {
            inventoryTrigger.setWeaponSelect(2);
            guiButton[2].enabled = false;
        }

        inventoryTrigger.setWeaponlist(0.0F);
    }

    protected void handleMouseClick(Slot slot, int i, int j, boolean flag)
    {
        if (slot != null)
        {
            if (slot.inventory == inventory1 && !flag)
            {
                InventoryPlayer inventoryplayer = mc.thePlayer.inventory;
                ItemStack itemstack1 = inventoryplayer.getItemStack();
                ItemStack itemstack2 = slot.getStack();

                if (itemstack1 != null && itemstack2 != null && itemstack1.itemID == itemstack2.itemID)
                {
                    if (j != 0)
                    {
                        inventoryplayer.setItemStack(null);
                    }
                }
                else if (itemstack1 != null)
                {
                    inventoryplayer.setItemStack(null);
                }
                else if (itemstack2 == null)
                {
                    inventoryplayer.setItemStack(null);
                }
                else
                {
                    inventoryplayer.setItemStack(ItemStack.copyItemStack(itemstack2));
                }
            }
            else
            {
                inventorySlots.slotClick(slot.slotNumber, j, flag, mc.thePlayer);
                ItemStack itemstack = inventorySlots.getSlot(slot.slotNumber).getStack();
                mc.playerController.sendSlotPacket(itemstack, (slot.slotNumber - inventorySlots.inventorySlots.size()) + 9 + 36);
            }
        }
        else
        {
            InventoryPlayer inventoryplayer1 = mc.thePlayer.inventory;
            inventoryplayer1.setItemStack(null);
        }
    }

    /**
     * Draw the foreground layer for the GuiContainer (everythin in front of the items)
     */
    protected void drawGuiContainerForegroundLayer()
    {
        fontRenderer.drawString("Item selection", 8, 6, 0x404040);
        fontRenderer.drawString("Trigger Items", 8, 110, 0x404040);
    }

    /**
     * Handles mouse input.
     */
    public void handleMouseInput()
    {
        super.handleMouseInput();
        int i = Mouse.getEventDWheel();

        if (i != 0)
        {
            if (lastY < height / 2)
            {
                int j = (inventoryTrigger.itemList.size() / 8 - 5) + 1;

                if (i > 0)
                {
                    i = 1;
                }

                if (i < 0)
                {
                    i = -1;
                }

                scrolleContainer -= (double)i / (double)j;

                if (scrolleContainer < 0.0F)
                {
                    scrolleContainer = 0.0F;
                }

                if (scrolleContainer > 1.0F)
                {
                    scrolleContainer = 1.0F;
                }

                inventoryTrigger.scrollTo(scrolleContainer);
            }
            else
            {
                int k = (inventoryTrigger.weaponSelect.size() / 8 - 4) + 1;

                if (i > 0)
                {
                    i = 1;
                }

                if (i < 0)
                {
                    i = -1;
                }

                if (k > 0)
                {
                    scrolleWeaponset -= (double)i / (double)k;
                }
                else
                {
                    scrolleWeaponset = 0.0F;
                }

                if (scrolleWeaponset < 0.0F)
                {
                    scrolleWeaponset = 0.0F;
                }

                if (scrolleWeaponset > 1.0F)
                {
                    scrolleWeaponset = 1.0F;
                }

                inventoryTrigger.setWeaponlist(scrolleWeaponset);
            }
        }
    }

    /**
     * Draws the screen and all the components in it.
     */
    public void drawScreen(int i, int j, float f)
    {
        lastX = i;
        lastY = j;
        boolean flag = Mouse.isButtonDown(0);
        int k = guiLeft;
        int l = guiTop;
        int i1 = k + 155;
        int j1 = l + 17;
        int k1 = i1 + 14;
        int l1 = j1 + 90;

        if (!flag)
        {
            isScrolled = 0;
        }

        if (!ismousePress && flag && i >= i1 && j >= j1 && i < k1 && j < l1)
        {
            isScrolled = 1;
        }

        if (isScrolled == 1)
        {
            scrolleContainer = (float)(j - (j1 + 8)) / ((float)(l1 - j1) - 16F);

            if (scrolleContainer < 0.0F)
            {
                scrolleContainer = 0.0F;
            }

            if (scrolleContainer > 1.0F)
            {
                scrolleContainer = 1.0F;
            }

            inventoryTrigger.scrollTo(scrolleContainer);
        }

        j1 = l + 120;
        l1 = j1 + 72;

        if (!ismousePress && flag && i >= i1 && j >= j1 && i < k1 && j < l1)
        {
            isScrolled = 2;
        }

        if (isScrolled == 2)
        {
            scrolleWeaponset = (float)(j - (j1 + 8)) / ((float)(l1 - j1) - 16F);

            if (scrolleWeaponset < 0.0F)
            {
                scrolleWeaponset = 0.0F;
            }

            if (scrolleWeaponset > 1.0F)
            {
                scrolleWeaponset = 1.0F;
            }

            inventoryTrigger.setWeaponlist(scrolleWeaponset);
        }

        ismousePress = flag;
        super.drawScreen(i, j, f);
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        GL11.glDisable(GL11.GL_LIGHTING);
    }

    /**
     * Draw the background layer for the GuiContainer (everything behind the items)
     */
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j)
    {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        int k = mc.renderEngine.getTexture("/gui/littlemaidtrigger.png");
        mc.renderEngine.bindTexture(k);
        int l = guiLeft;
        int i1 = guiTop;
        drawTexturedModalRect(l, i1, 0, 0, xSize, ySize);
        int j1 = l + 155;
        int k1 = i1 + 17;
        int l1 = k1 + 88 + 2;
        drawTexturedModalRect(l + 154, i1 + 17 + (int)((float)(l1 - k1 - 17) * scrolleContainer), 176, 0, 16, 16);
        drawTexturedModalRect(l + 154, i1 + 120 + (int)((float)(l1 - k1 - 35) * scrolleWeaponset), 176, 0, 16, 16);
    }

    private void setItemList()
    {
        if (mod_littleMaidMob.TriggerItemServerSetting)
        {
            return;
        }

        List list = inventoryTrigger.getItemList();
        list.clear();

        for (int i = 0; i < inventoryTrigger.weaponSelect.size(); i++)
        {
            ItemStack itemstack = (ItemStack)inventoryTrigger.weaponSelect.get(i);

            if (itemstack != null && !list.contains(Integer.valueOf(itemstack.getItem().shiftedIndex)))
            {
                list.add(Integer.valueOf(itemstack.getItem().shiftedIndex));
            }
        }

        StringBuilder stringbuilder = new StringBuilder();

        if (!list.isEmpty())
        {
            stringbuilder.append(list.get(0));

            for (int j = 1; j < list.size(); j++)
            {
                stringbuilder.append(",").append(list.get(j));
            }
        }

        switch (inventoryTrigger.weaponSelectIndex)
        {
            case 0:
                SwordIndex = stringbuilder.toString();
                break;

            case 1:
                AxeIndex = stringbuilder.toString();
                break;

            case 2:
                BowIndex = stringbuilder.toString();
                break;
        }
    }

    public static InventoryBasic getInventory1()
    {
        return inventory1;
    }

    public static InventoryBasic getInventory2()
    {
        return inventory2;
    }

    public static void initTriggerItem()
    {
        appendWeaponsIndex((String)SwordIndex, ListSword);
        appendWeaponsIndex((String)AxeIndex, ListAxe);
        appendWeaponsIndex((String)BowIndex, ListBow);
    }

    private static void appendWeaponsIndex(String s, List list)
    {
        //if (s.isEmpty() || list.contains(Integer.valueOf(s)))
    	if (s.isEmpty())
        {
            return;
        }

        String as[] = s.split(",");
        String as1[] = as;
        int i = as1.length;

        for (int j = 0; j < i; j++)
        {
            String s1 = as1[j];
            if (list.contains(Integer.valueOf(s1)))
            {
            	return;
            }
            list.add(Integer.valueOf(s1));
        }
    }
}
