package net.minecraft.src;

import java.util.*;
import net.minecraft.client.Minecraft;
import net.minecraft.src.forge.IGuiHandler;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class GuiLittleMaidInventory extends GuiContainer
{
    private Random rand;
    private IInventory upperChestInventory;
    private IInventory lowerChestInventory;
    private float xSize_lo;
    private float ySize_lo;
    private int ySizebk;
    private int updateCounter;
    public EntityLittleMaid entitylittlemaid;

    public GuiLittleMaidInventory(EntityLittleMaid entitylittlemaid1, IInventory iinventory, InventoryLittleMaid inventorylittlemaid)
    {
        super(new ContainerLittleMaid(iinventory, inventorylittlemaid));
        rand = new Random();
        upperChestInventory = iinventory;
        lowerChestInventory = inventorylittlemaid;
        allowUserInput = false;
        updateCounter = 0;
        ySizebk = ySize;
        ySize = 207;
        entitylittlemaid = entitylittlemaid1;
        entitylittlemaid.setOpenInventory(true);
    }

    /**
     * Adds the buttons (and other controls) to the screen in question.
     */
    public void initGui()
    {
        super.initGui();

        if (!entitylittlemaid.getActivePotionEffects().isEmpty())
        {
            guiLeft = 160 + (width - xSize - 200) / 2;
        }
    }

    /**
     * Draw the foreground layer for the GuiContainer (everythin in front of the items)
     */
    protected void drawGuiContainerForegroundLayer()
    {
        fontRenderer.drawString(lowerChestInventory.getInvName(), 8, 64, 0x404040);
        fontRenderer.drawString(upperChestInventory.getInvName(), 8, 114, 0x404040);
        fontRenderer.drawString("Health", 86, 8, 0x404040);
        fontRenderer.drawString("AP", 86, 32, 0x404040);
        fontRenderer.drawString(entitylittlemaid.getLittleMaidMode(), 86, 56, 0x404040);
    }

    /**
     * Draws the screen and all the components in it.
     */
    public void drawScreen(int i, int j, float f)
    {
        super.drawScreen(i, j, f);
        xSize_lo = i;
        ySize_lo = j;
        int k = i - (width - xSize) / 2;
        int l = j - (height - ySize) / 2;

        if (k > 25 && k < 78 && l > 7 && l < 60)
        {
            GL11.glPushMatrix();
            GL11.glTranslatef(i - k, j - l, 0.0F);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
            RenderHelper.disableStandardItemLighting();
            GL11.glDisable(GL11.GL_LIGHTING);
            GL11.glDisable(GL11.GL_DEPTH_TEST);

            if (entitylittlemaid.textureName != null)
            {
                int i1 = fontRenderer.getStringWidth(entitylittlemaid.textureName);
                int j1 = fontRenderer.getStringWidth(entitylittlemaid.textureArmorName);
                int k1 = i1 <= j1 ? j1 : i1;
                int l1 = 52 - k1 / 2;
                byte byte0 = 70;
                drawGradientRect(l1 - 3, byte0 - 3, l1 + k1 + 3, byte0 + 16 + 3, 0xc0000000, 0xc0000000);
                fontRenderer.drawStringWithShadow(entitylittlemaid.textureName, 52 - i1 / 2, byte0, -1);
                fontRenderer.drawStringWithShadow(entitylittlemaid.textureArmorName, 52 - j1 / 2, byte0 + 8, -1);
            }

            GL11.glPopMatrix();
            GL11.glEnable(GL11.GL_LIGHTING);
            GL11.glEnable(GL11.GL_DEPTH_TEST);
        }
    }

    public void updateTick()
    {
        updateCounter++;
    }

    /**
     * Called when the mouse is clicked.
     */
    protected void mouseClicked(int i, int j, int k)
    {
        super.mouseClicked(i, j, k);
        int l = i - (width - xSize) / 2;
        int i1 = j - (height - ySize) / 2;

        if (l > 25 && l < 78 && i1 > 7 && i1 < 60)
        {
            if (Keyboard.isKeyDown(42) || Keyboard.isKeyDown(54))
            {
                entitylittlemaid.setPrevTexturePackege(k);
            }
            else
            {
                entitylittlemaid.setNextTexturePackege(k);
            }

            entitylittlemaid.setTextureValue();
        }
    }

    /**
     * Called when the screen is unloaded. Used to disable keyboard repeat events
     */
    public void onGuiClosed()
    {
        super.onGuiClosed();
        entitylittlemaid.onGuiClosed();
    }

    /**
     * Draw the background layer for the GuiContainer (everything behind the items)
     */
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j)
    {
        String s = TextureLittleMaid.getTextureName(entitylittlemaid.textureName, 32);

        if (s == null)
        {
            s = "/gui/littlemaidinventory.png";
        }

        int k = mc.renderEngine.getTexture(s);
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        mc.renderEngine.bindTexture(k);
        int l = guiLeft;
        int i1 = guiTop;
        drawTexturedModalRect(l, i1, 0, 0, xSize, ySize);
        displayDebuffEffects();
        k = mc.renderEngine.getTexture("/gui/icons.png");
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        mc.renderEngine.bindTexture(k);
        boolean flag = (entitylittlemaid.heartsLife / 3) % 2 == 1;

        if (entitylittlemaid.heartsLife < 10)
        {
            flag = false;
        }

        //int j1 = entitylittlemaid.health;
        int j1 = entitylittlemaid.getMaidHealth();
        int k1 = entitylittlemaid.prevHealth;
        rand.setSeed(updateCounter * 0x4c627);
        int l1 = entitylittlemaid.getTotalArmorValue();

        for (int i2 = 0; i2 < 10; i2++)
        {
            int j2 = 43 + i1;

            if (l1 > 0)
            {
                int k2 = l + 86 + i2 * 8;

                if (i2 * 2 + 1 < l1)
                {
                    drawTexturedModalRect(k2, j2, 34, 9, 9, 9);
                }

                if (i2 * 2 + 1 == l1)
                {
                    drawTexturedModalRect(k2, j2, 25, 9, 9, 9);
                }

                if (i2 * 2 + 1 > l1)
                {
                    drawTexturedModalRect(k2, j2, 16, 9, 9, 9);
                }
            }

            int l2 = 0;

            if (flag)
            {
                l2 = 1;
            }

            int i3 = l + 86 + i2 * 8;
            j2 = 19 + i1;

            if (j1 <= 4)
            {
                j2 += rand.nextInt(2);
            }

            drawTexturedModalRect(i3, j2, 16 + l2 * 9, 0, 9, 9);

            if (flag)
            {
                if (i2 * 2 + 1 < k1)
                {
                    drawTexturedModalRect(i3, j2, 70, 0, 9, 9);
                }

                if (i2 * 2 + 1 == k1)
                {
                    drawTexturedModalRect(i3, j2, 79, 0, 9, 9);
                }
            }

            if (i2 * 2 + 1 < j1)
            {
                drawTexturedModalRect(i3, j2, 52, 0, 9, 9);
            }

            if (i2 * 2 + 1 == j1)
            {
                drawTexturedModalRect(i3, j2, 61, 0, 9, 9);
            }
        }

        GL11.glEnable(GL12.GL_RESCALE_NORMAL);
        GL11.glEnable(GL11.GL_COLOR_MATERIAL);
        GL11.glPushMatrix();
        GL11.glTranslatef(l + 51, i1 + 57, 50F);
        float f1 = 30F;
        GL11.glScalef(-f1, f1, f1);
        GL11.glRotatef(180F, 0.0F, 0.0F, 1.0F);
        float f2 = entitylittlemaid.renderYawOffset;
        float f3 = entitylittlemaid.rotationYaw;
        float f4 = entitylittlemaid.rotationPitch;
        float f5 = (float)(l + 51) - xSize_lo;
        float f6 = (float)((i1 + 75) - 50) - ySize_lo;
        GL11.glRotatef(135F, 0.0F, 1.0F, 0.0F);
        RenderHelper.enableStandardItemLighting();
        GL11.glRotatef(-135F, 0.0F, 1.0F, 0.0F);
        GL11.glRotatef(-(float)Math.atan(f6 / 40F) * 20F, 1.0F, 0.0F, 0.0F);
        entitylittlemaid.renderYawOffset = (float)Math.atan(f5 / 40F) * 20F;
        entitylittlemaid.rotationYaw = (float)Math.atan(f5 / 40F) * 40F;
        entitylittlemaid.rotationPitch = -(float)Math.atan(f6 / 40F) * 20F;
        GL11.glTranslatef(0.0F, entitylittlemaid.yOffset, 0.0F);
        RenderManager.instance.playerViewY = 180F;
        RenderManager.instance.renderEntityWithPosYaw(entitylittlemaid, 0.0D, 0.0D, 0.0D, 0.0F, 1.0F);
        entitylittlemaid.renderYawOffset = f2;
        entitylittlemaid.rotationYaw = f3;
        entitylittlemaid.rotationPitch = f4;
        GL11.glPopMatrix();
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable(GL12.GL_RESCALE_NORMAL);
    }

    private void displayDebuffEffects()
    {
        int i = guiLeft - 124;
        int j = guiTop;
        int k = mc.renderEngine.getTexture("/gui/inventory.png");
        Collection collection = entitylittlemaid.getActivePotionEffects();

        if (collection.isEmpty())
        {
            return;
        }

        int l = 33;

        if (collection.size() > 5)
        {
            l = 132 / (collection.size() - 1);
        }

        for (Iterator iterator = entitylittlemaid.getActivePotionEffects().iterator(); iterator.hasNext();)
        {
            PotionEffect potioneffect = (PotionEffect)iterator.next();
            Potion potion = Potion.potionTypes[potioneffect.getPotionID()];
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
            mc.renderEngine.bindTexture(k);
            drawTexturedModalRect(i, j, 0, ySizebk, 140, 32);

            if (potion.hasStatusIcon())
            {
                int i1 = potion.getStatusIconIndex();
                drawTexturedModalRect(i + 6, j + 7, 0 + (i1 % 8) * 18, ySizebk + 32 + (i1 / 8) * 18, 18, 18);
            }

            String s = StatCollector.translateToLocal(potion.getName());

            if (potioneffect.getAmplifier() > 0)
            {
                s = (new StringBuilder()).append(s).append(" ").append(StatCollector.translateToLocal((new StringBuilder()).append("potion.potency.").append(potioneffect.getAmplifier()).toString())).toString();
            }

            fontRenderer.drawStringWithShadow(s, i + 10 + 18, j + 6, 0xffffff);
            String s1 = Potion.getDurationString(potioneffect);
            fontRenderer.drawStringWithShadow(s1, i + 10 + 18, j + 6 + 10, 0x7f7f7f);
            j += l;
        }
    }
}
