package net.minecraft.src;

import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;

public class GuiLittleMaidIFFSlot extends GuiSlot
{
    protected Minecraft mc;
    public GuiLittleMaidIFF ownerGui;
    private float xSize_lo;
    private float ySize_lo;
    private int selected;

    public GuiLittleMaidIFFSlot(Minecraft minecraft, GuiLittleMaidIFF guilittlemaidiff)
    {
        super(minecraft, guilittlemaidiff.width, guilittlemaidiff.height, 32, guilittlemaidiff.height - 52, 36);
        ownerGui = guilittlemaidiff;
        mc = minecraft;
    }

    /**
     * Gets the size of the current slot list.
     */
    protected int getSize()
    {
        return ownerGui.entityMap.size();
    }

    /**
     * return the height of the content being scrolled
     */
    protected int getContentHeight()
    {
        return getSize() * 36;
    }

    /**
     * the element in the slot that was clicked, boolean for wether it was double clicked or not
     */
    protected void elementClicked(int i, boolean flag)
    {
        if (mod_littleMaidMob.IFFServerSetting)
        {
            return;
        }

        if (i == selected)
        {
            String s = ownerGui.entityMap.keySet().toArray()[i].toString();
            int j = GuiLittleMaidIFF.getIFF(s);

            if (++j > 2)
            {
                j = 0;
            }

            GuiLittleMaidIFF.IFFMap.put(s, Integer.valueOf(j));
            mc.sndManager.playSoundFX("random.click", 1.0F, 1.0F);
        }

        selected = i;
    }

    /**
     * returns true if the element passed in is currently selected
     */
    protected boolean isSelected(int i)
    {
        return selected == i;
    }

    protected void drawBackground()
    {
        ownerGui.drawDefaultBackground();
    }

    /**
     * draws the slot to the screen, pass in mouse's current x and y and partial ticks
     */
    public void drawScreen(int i, int j, float f)
    {
        super.drawScreen(i, j, f);
        xSize_lo = i;
        ySize_lo = j;
    }

    protected void drawSlot(int i, int j, int k, int l, Tessellator tessellator)
    {
        String s = ownerGui.entityMap.keySet().toArray()[i].toString();
        int i1 = GuiLittleMaidIFF.getIFF(s);
        int j1;

        switch (i1)
        {
            case 2:
                j1 = 0x3fff3f;
                break;

            case 1:
                j1 = 0xffff00;
                break;

            case 0:
                j1 = 0xff3f3f;
                break;

            default:
                j1 = 0xffffff;
                break;
        }

        ownerGui.drawString(ownerGui.fontRenderer, GuiLittleMaidIFF.IFFString[i1], j + 78, k + 18, j1);
        ownerGui.drawString(ownerGui.fontRenderer, s, j + 70, k + 6, 0xffffff);
        EntityLiving entityliving = (EntityLiving)ownerGui.entityMap.get(s);

        if (GuiLittleMaidIFF.exclusionList.contains(s))
        {
            this.ownerGui.drawString(this.ownerGui.fontRenderer, "NoImage", j + 15, k + 12, 16777215);
            return;
        }
        GL11.glEnable(GL12.GL_RESCALE_NORMAL);
        GL11.glEnable(GL11.GL_COLOR_MATERIAL);
        GL11.glPushMatrix();
        float f = 15F;

        if (entityliving.height > 2.0F)
        {
            f = (f * 2.0F) / entityliving.height;
        }

        GL11.glTranslatef(j + 30, k + 30, 50F + f);
        GL11.glScalef(-f, f, f);
        GL11.glRotatef(180F, 0.0F, 0.0F, 1.0F);
        float f1 = (float)(j + 30) - xSize_lo;
        float f2 = (float)((k + 30) - 10) - ySize_lo;
        GL11.glRotatef(135F, 0.0F, 1.0F, 0.0F);
        RenderHelper.enableStandardItemLighting();
        GL11.glRotatef(-135F, 0.0F, 1.0F, 0.0F);
        GL11.glRotatef(-(float)Math.atan(f2 / 40F) * 20F, 1.0F, 0.0F, 0.0F);
        entityliving.renderYawOffset = (float)Math.atan(f1 / 40F) * 20F;
        entityliving.rotationYaw = (float)Math.atan(f1 / 40F) * 40F;
        entityliving.rotationPitch = -(float)Math.atan(f2 / 40F) * 20F;
        entityliving.prevRotationYawHead = entityliving.rotationYawHead;
        entityliving.rotationYawHead = entityliving.rotationYaw;
        GL11.glTranslatef(0.0F, entityliving.yOffset, 0.0F);
        RenderManager.instance.playerViewY = 180F;
        try{
        RenderManager.instance.renderEntityWithPosYaw(entityliving, 0.0D, 0.0D, 0.0D, 0.0F, 1.0F);
        }
        catch(Exception e){
        	GuiLittleMaidIFF.exclusionList.add(s);
        }
        GL13.glMultiTexCoord2f(GL13.GL_TEXTURE1, 240F, 240F);
        GL11.glPopMatrix();
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable(GL12.GL_RESCALE_NORMAL);
    }
}
