package net.minecraft.src;

import java.io.*;
import java.util.*;

import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;

public class GuiLittleMaidIFF extends GuiScreen
{
    public static final String IFFString[] =
    {
        "ENEMY", "UNKNOWN", "FRIENDLY"
    };
    public static final int iff_Enemy = 0;
    public static final int iff_Unknown = 1;
    public static final int iff_Friendry = 2;
    public static final File IFFFile = new File(Minecraft.getMinecraftDir(), "/mods/littleMaidMob-IFF.iff");
    public static Map IFFMap = new TreeMap();
    private static boolean checked = false;
    protected String screenTitle = "LittleMaid IFF";
    protected GuiSlot selectPanel;
    private GuiButton localScroll;
    public Map entityMap = new TreeMap();
    public static List exclusionList = new ArrayList();
    public static String tmpIFFMap = "empty";

    public GuiLittleMaidIFF(World world)
    {
        try
        {
            Map map = (Map)ModLoader.getPrivateValue(net.minecraft.src.EntityList.class, null, 0);

            if (map != null)
            {
                Iterator iterator = map.entrySet().iterator();

                do
                {
                    if (!iterator.hasNext())
                    {
                        break;
                    }

                    java.util.Map.Entry entry = (java.util.Map.Entry)iterator.next();
                    Class class1 = (Class)entry.getValue();

                    if ((net.minecraft.src.EntityLiving.class).isAssignableFrom(class1) && !class1.isAssignableFrom(net.minecraft.src.EntityMob.class))
                    {
                        EntityLiving entityliving = (EntityLiving)EntityList.createEntityByName((String)entry.getKey(), world);

                        if (entityliving != null)
                        {
                            if (entityliving instanceof EntityTameable)
                            {
                                entityMap.put(entry.getKey(), entityliving);
                                entityliving = (EntityLiving)EntityList.createEntityByName((String)entry.getKey(), world);
                                ((EntityTameable)entityliving).setTamed(true);
                                entityMap.put((new StringBuilder()).append((String)entry.getKey()).append(":Taim").toString(), entityliving);
                            }
                            else if (entityliving instanceof EntityLittleMaid)
                            {
                                entityMap.put(entry.getKey(), entityliving);
                                entityliving = (EntityLiving)EntityList.createEntityByName((String)entry.getKey(), world);
                                ((EntityLittleMaid)entityliving).setMaidContract(true);
                                entityMap.put((new StringBuilder()).append((String)entry.getKey()).append(":Contract").toString(), entityliving);
                            }
                            else
                            {
                                entityMap.put(entry.getKey(), entityliving);
                            }
                        }
                        else
                        {
                            mod_littleMaidMob.Debug(String.format("Entity is null: %s", new Object[]
                                    {
                                        entry.getKey()
                                    }));
                        }
                    }
                }
                while (true);
            }
        }
        catch (Exception exception)
        {
            exception.printStackTrace();
        }
    }

    /**
     * Adds the buttons (and other controls) to the screen in question.
     */
    public void initGui()
    {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        selectPanel = new GuiLittleMaidIFFSlot(mc, this);
        selectPanel.registerScrollButtons(controlList, 3, 4);
        localScroll = new GuiButton(3, 0, 0, "");
        controlList.add(new GuiButton(200, width / 2 - 130, height - 40, 120, 20, stringtranslate.translateKey("gui.done")));
        controlList.add(new GuiButton(201, width / 2 + 10, height - 40, 120, 20, "Trigger Select"));
    }

    /**
     * Fired when a control is clicked. This is the equivalent of ActionListener.actionPerformed(ActionEvent e).
     */
    protected void actionPerformed(GuiButton guibutton)
    {
        if (!guibutton.enabled)
        {
            return;
        }

        if (guibutton.id == 200)
        {
            mc.displayGuiScreen(null);
        }

        if (guibutton.id == 201)
        {
            mc.displayGuiScreen(new GuiLittleMaidTriggerSelect(mc.thePlayer, this));
        }
    }

    /**
     * Draws the screen and all the components in it.
     */
    public void drawScreen(int i, int j, float f)
    {
        drawDefaultBackground();
        selectPanel.drawScreen(i, j, f);
        drawCenteredString(fontRenderer, screenTitle, width / 2, 20, 0xffffff);
        super.drawScreen(i, j, f);
    }

    /**
     * Returns true if this GUI should pause the game when it is displayed in single-player
     */
    public boolean doesGuiPauseGame()
    {
        return true;
    }

    /**
     * Called when the screen is unloaded. Used to disable keyboard repeat events
     */
    public void onGuiClosed()
    {
        saveIFF();
        super.onGuiClosed();
        String as[] = {GuiLittleMaidTriggerSelect.SwordIndex, GuiLittleMaidTriggerSelect.AxeIndex, GuiLittleMaidTriggerSelect.BowIndex, GuiLittleMaidIFF.tmpIFFMap};
        mod_littleMaidMob.SendPacketLittleMaidData(mod_littleMaidMob.packetIFFTrigger, as, null, null);
    }

    /**
     * Handles mouse input.
     */
    public void handleMouseInput()
    {
        super.handleMouseInput();
        int i = Mouse.getEventDWheel();

        if (i != 0)
        {
            localScroll.id = i <= 0 ? 4 : 3;
            selectPanel.actionPerformed(localScroll);
        }
    }

    public static int getIFF(String s)
    {
        if (s == null)
        {
            return mod_littleMaidMob.Aggressive ? 0:2;
        }

        Integer integer = (Integer)IFFMap.get(s);

        if (integer == null)
        {
            integer = Integer.valueOf(0);
            IFFMap.put(s, integer);
        }

        return integer.intValue();
    }

    public static int getIFF(Entity entity)
    {
        if (entity == null || !(entity instanceof EntityLiving))
        {
            return mod_littleMaidMob.Aggressive ? 0:2;
        }

        String s;

        if (entity instanceof EntityTameable)
        {
            s = EntityList.getEntityString(entity);

            if (((EntityTameable)entity).isTamed())
            {
                s = (new StringBuilder()).append(s).append(":Taim").toString();
            }
        }
        else if (entity instanceof EntityLittleMaid)
        {
            s = EntityList.getEntityString(entity);

            if (((EntityLittleMaid)entity).isMaidContract())
            {
                s = (new StringBuilder()).append(s).append(":Contract").toString();
            }
        }
        else
        {
            s = EntityList.getEntityString(entity);
        }

        return getIFF(s);
    }

    public static void initIFF(World world)
    {
        if (checked || !IFFMap.isEmpty() || world == null)
        {
            return;
        }

        checked = true;
        GuiLittleMaidIFF guilittlemaidiff = new GuiLittleMaidIFF(world);

        for (Iterator iterator = guilittlemaidiff.entityMap.entrySet().iterator(); iterator.hasNext();)
        {
            java.util.Map.Entry entry = (java.util.Map.Entry)iterator.next();
            EntityLiving entityliving = (EntityLiving)entry.getValue();
            String s = (String)entry.getKey();

            if ((entityliving instanceof EntityTameable) && ((EntityTameable)entityliving).isTamed())
            {
                IFFMap.put(s, Integer.valueOf(2));
            }
            else if (entityliving instanceof EntityLittleMaid)
            {
                if (((EntityLittleMaid)entityliving).isMaidContract())
                {
                    IFFMap.put(s, Integer.valueOf(2));
                }
                else
                {
                    IFFMap.put(s, Integer.valueOf(1));
                }
            }
            else if ((entityliving instanceof EntityAnimal) || (entityliving instanceof EntityMob))
            {
                IFFMap.put(s, Integer.valueOf(0));
            }
            else
            {
                IFFMap.put(s, Integer.valueOf(1));
            }
        }

        saveIFF();
    }

    public static void loadIFF()
    {
        if (!IFFFile.exists() || !IFFFile.canRead())
        {
            return;
        }

        try
        {
            FileReader filereader = new FileReader(IFFFile);
            BufferedReader bufferedreader = new BufferedReader(filereader);
            tmpIFFMap = "empty";

            do
            {
                String s;

                if ((s = bufferedreader.readLine()) == null)
                {
                    break;
                }

                String as[] = s.split("=");

                if (as.length > 1)
                {
                    if (as[0].compareTo("triggerWeaponSword") == 0)
                    {
                        GuiLittleMaidTriggerSelect.SwordIndex = as[1];
                    }
                    else if (as[0].compareTo("triggerWeaponAxe") == 0)
                    {
                        GuiLittleMaidTriggerSelect.AxeIndex = as[1];
                    }
                    else if (as[0].compareTo("triggerWeaponBow") == 0)
                    {
                        GuiLittleMaidTriggerSelect.BowIndex = as[1];
                    }
                    else if (as[0].compareTo("exclusionList") == 0)
                    {
                    	exclusionList.clear();
                    	for (String ls : as[1].split(",")){
                    		exclusionList.add(ls.trim());
                    	}
                    }
                    else
                    {
                        int i = Integer.valueOf(as[1]).intValue();

                        if (i > 2)
                        {
                            i = 1;
                        }

                        IFFMap.put(as[0], Integer.valueOf(i));

                        if (tmpIFFMap == "empty")
                        {
                            tmpIFFMap = s;
                        }
                        else
                        {
                            tmpIFFMap = (new StringBuilder()).append(tmpIFFMap).append(",").append(s).toString();
                        }
                    }
                }
            }
            while (true);

            bufferedreader.close();
            filereader.close();
        }
        catch (Exception exception) { }
    }

    public static void saveIFF()
    {
        try
        {
            if (!IFFMap.isEmpty() && (IFFFile.exists() || IFFFile.createNewFile()) && IFFFile.canWrite())
            {
                FileWriter filewriter = new FileWriter(IFFFile);
                BufferedWriter bufferedwriter = new BufferedWriter(filewriter);
                tmpIFFMap = "empty";
                bufferedwriter.write(String.format("triggerWeaponSword=%s\r\n", new Object[]
                        {
                            GuiLittleMaidTriggerSelect.SwordIndex
                        }));
                bufferedwriter.write(String.format("triggerWeaponAxe=%s\r\n", new Object[]
                        {
                            GuiLittleMaidTriggerSelect.AxeIndex
                        }));
                bufferedwriter.write(String.format("triggerWeaponBow=%s\r\n", new Object[]
                        {
                            GuiLittleMaidTriggerSelect.BowIndex
                        }));
                StringBuilder var2 = new StringBuilder();
                Iterator var3 = exclusionList.iterator();

                while (var3.hasNext())
                {
                    String var4 = (String)var3.next();

                    if (var2.length() == 0)
                    {
                        var2.append("exclusionList=").append(var4);
                    }
                    else
                    {
                        var2.append(", ").append(var4);
                    }
                }

                if (var2.length() > 0)
                {
                	bufferedwriter.write(var2.append("\r\n").toString());
                }
                java.util.Map.Entry entry;

                for (Iterator iterator = IFFMap.entrySet().iterator(); iterator.hasNext(); bufferedwriter.write(String.format("%s=%d\r\n", new Object[]
                        {
                            entry.getKey(), entry.getValue()
                        })))
                {
                    entry = (java.util.Map.Entry)iterator.next();

                    if (tmpIFFMap == "empty")
                    {
                        tmpIFFMap = (new StringBuilder()).append(entry.getKey()).append("=").append(entry.getValue()).toString();
                    }
                    else
                    {
                        tmpIFFMap = (new StringBuilder()).append(tmpIFFMap).append(",").append(entry.getKey()).append("=").append(entry.getValue()).toString();
                    }
                }
                bufferedwriter.close();
                filewriter.close();
            }
        }
        catch (Exception exception)
        {
            exception.printStackTrace();
        }
    }

    public static void setPacketIFF(String s)
    {
        if (s.isEmpty())
        {
            return;
        }

        String as[] = s.split(",");
        String as1[] = as;
        int i = as1.length;

        for (int j = 0; j < i; j++)
        {
            String s1 = as1[j];
            String as2[] = s1.split("=");

            if (as2.length > 1)
            {
                int k = Integer.valueOf(as2[1]).intValue();

                if (k > 2)
                {
                    k = 1;
                }

                IFFMap.put(as2[0], Integer.valueOf(k));
            }
        }
    }
}
