package net.minecraft.src;

import java.util.List;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

public class GuiLittleMaidEditName extends GuiScreen
{
    private String w;
    private GuiTextField nameField;
    private EntityWolf wolf;
    private EntityLittleMaid entityLittleMaid;
    protected String screenTitle;
    protected String maidText;
    private int updateCounter;
    private static final String allowedCharacters;

    public GuiLittleMaidEditName(EntityLittleMaid entitylittlemaid)
    {
        screenTitle = "Give me name:";
        entityLittleMaid = entitylittlemaid;
        maidText = entityLittleMaid.getMaidName();
    }

    public void initGui()
    {
        controlList.clear();
        Keyboard.enableRepeatEvents(true);
        controlList.add(new GuiButton(0, width / 2 - 100, height / 4 + 120, "Done"));
        nameField = new GuiTextField(fontRenderer, width / 2 - 40, 100, 80, 20);
        nameField.setFocused(true);
        nameField.setMaxStringLength(12);
        nameField.setText(entityLittleMaid.getMaidName());
    }

    public void onGuiClosed()
    {
        Keyboard.enableRepeatEvents(false);
        entityLittleMaid.setMaidName(entityLittleMaid.maidName);
        String as[] = {entityLittleMaid.maidName};
        int ai[] = {entityLittleMaid.getMaidContractTime()};
        mod_littleMaidMob.SendPacketLittleMaidData(mod_littleMaidMob.packetMaidName, as, ai, null);
    }

    public void updateScreen()
    {
        updateCounter++;
        nameField.updateCursorCounter();
    }

    protected void actionPerformed(GuiButton guibutton)
    {
        if (!guibutton.enabled)
        {
            return;
        }

        if (guibutton.id == 0)
        {
            mc.displayGuiScreen(null);
        }
    }

    protected void keyTyped(char c, int i)
    {
        if (i == 14 && maidText.length() > 0)
        {
            maidText = maidText.substring(0, maidText.length() - 1);
        }

        if (!(allowedCharacters.indexOf(c) < 0 || maidText.length() >= 12))
        {
            maidText += c;
        }

        entityLittleMaid.maidName = maidText;
        nameField.setText(maidText);
    }

    public void drawScreen(int i, int j, float f)
    {
        drawDefaultBackground();
        drawCenteredString(fontRenderer, screenTitle, width / 2, 60, 0xffffff);
        nameField.drawTextBox();

        if ((updateCounter / 6) % 2 != 0);
        super.drawScreen(i, j, f);
    }

    static
    {
        allowedCharacters = ChatAllowedCharacters.allowedCharacters;
    }
}
