package net.minecraft.src;

import java.util.Iterator;
import java.util.List;

public class EntityLittleMaidDummy extends Entity
{
    private int livecount;
    private final int maxlivecount = 16;
    private int entityColor;
    public Entity entityOwner;

    public EntityLittleMaidDummy(World world, int i, Entity entity)
    {
        super(world);
        livecount = 16;
        entityColor = i;
        entityOwner = entity;
    }

    protected void entityInit()
    {
    }

    /**
     * (abstract) Protected helper method to read subclass entity data from NBT.
     */
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound)
    {
    }

    /**
     * (abstract) Protected helper method to write subclass entity data to NBT.
     */
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound)
    {
    }

    /**
     * Called to update the entity's position/logic.
     */
    public void onUpdate()
    {
        super.onUpdate();

        if (--livecount < 0)
        {
            setDead();
        }
    }

    public float getAlpha(float f)
    {
        if (livecount >= 0)
        {
            return (f * (float)livecount) / 16F;
        }
        else
        {
            return 0.0F;
        }
    }

    public int getColor()
    {
        return entityColor;
    }

    public boolean setOwnerdEntityDead(Entity entity)
    {
        if (entityOwner == entity)
        {
            setDead();
            return true;
        }
        else
        {
            return false;
        }
    }

    public static void clearDummyEntity(World world, Entity entity)
    {
        List list = world.getLoadedEntityList();
        Iterator iterator = list.iterator();

        do
        {
            if (!iterator.hasNext())
            {
                break;
            }

            Entity entity1 = (Entity)iterator.next();

            if (entity1 instanceof EntityLittleMaidDummy)
            {
                ((EntityLittleMaidDummy)entity1).setOwnerdEntityDead(entity);
            }
        }
        while (true);
    }
}
