package net.minecraft.src;

import net.minecraft.client.Minecraft;

public class EntityLittleMaidAvatar extends EntityPlayer
{
	private static final Minecraft mcGame;
    public EntityLittleMaid avatar;
    public boolean isItemTrigger;
    public boolean isItemReload;
    private boolean isItemPreReload;
    private double appendX;
    private double appendY;
    private double appendZ;

    public EntityLittleMaidAvatar(World world, EntityLittleMaid entitylittlemaid)
    {
        super(world);
        isDead = true;
        avatar = entitylittlemaid;
        entityId = entitylittlemaid.entityId;
        inventory = entitylittlemaid.maidInventory;
        height = entitylittlemaid.height;
        width = entitylittlemaid.width;
        health = entitylittlemaid.health;
        activePotionsMap = entitylittlemaid.activePotionsMap;
        isItemTrigger = false;
        isItemReload = false;
        isItemPreReload = false;
    }

    public float getEyeHeight()
    {
        return avatar.getEyeHeight();
    }

    /**
     * Returns the sound this mob makes while it's alive.
     */
    protected String getLivingSound()
    {
        return null;
    }

    /**
     * Returns the sound this mob makes when it is hurt.
     */
    protected String getHurtSound()
    {
        return null;
    }

    /**
     * Returns the sound this mob makes on death.
     */
    protected String getDeathSound()
    {
        return null;
    }

    public void func_6420_o()
    {
    }

    /**
     * Called to update the entity's position/logic.
     */
    public void onUpdate()
    {
        if (isUsingItem())
        {
            ItemStack itemstack = inventory.getCurrentItem();

            if (itemstack != getItemInUse())
            {
                clearItemInUse();
            }
            else
            {
                int i = getItemInUseCount();

                if (i <= 25 && i % 4 == 0)
                {
                    updateItemUse(itemstack, 5);
                }

                i--;
                super.clearItemInUse();
                setItemInUse(itemstack, i);

                if (i == 0 && !worldObj.isRemote)
                {
                    onItemUseFinish();
                    isItemPreReload = true;
                }
            }
        }
    }

    /**
     * This method gets called when the entity kills another one.
     */
    public void onKillEntity(EntityLiving entityliving)
    {
    }

    public void clearItemInUse()
    {
        super.clearItemInUse();
        isItemTrigger = false;
        isItemReload = isItemPreReload = false;
    }

    public void stopUsingItem()
    {
        super.stopUsingItem();
    }

    /**
     * sets the itemInUse when the use item button is clicked. Args: itemstack, int maxItemUseDuration
     */
    public void setItemInUse(ItemStack itemstack, int i)
    {
        super.setItemInUse(itemstack, i);
        isItemTrigger = true;
        isItemReload = isItemPreReload;
    }

    public boolean isUsingItemLittleMaid()
    {
        return super.isUsingItem() | isItemTrigger;
    }

    public void getValue()
    {
        posX = avatar.posX;
        posY = avatar.posY;
        posZ = avatar.posZ;
        prevPosX = avatar.prevPosX;
        prevPosY = avatar.prevPosY;
        prevPosZ = avatar.prevPosZ;
        rotationPitch = avatar.rotationPitch;
        rotationYaw = avatar.rotationYaw;
        prevRotationPitch = avatar.prevRotationPitch;
        prevRotationYaw = avatar.prevRotationYaw;
        yOffset = avatar.yOffset;
        renderYawOffset = avatar.renderYawOffset;
        prevRenderYawOffset = avatar.prevRenderYawOffset;
    }

    public void getValueVector(double d, double d1, double d2, double d3)
    {
        double d4 = MathHelper.sqrt_double(d3);
        appendX = d / d4;
        appendY = d1 / d4;
        appendZ = d2 / d4;
        posX = avatar.posX + appendX;
        posY = avatar.posY + appendY;
        posZ = avatar.posZ + appendZ;
        prevPosX = avatar.prevPosX + appendX;
        prevPosY = avatar.prevPosY + appendY;
        prevPosZ = avatar.prevPosZ + appendZ;
        rotationPitch = avatar.rotationPitch;
        rotationYaw = avatar.rotationYaw;
        prevRotationPitch = avatar.prevRotationPitch;
        prevRotationYaw = avatar.prevRotationYaw;
        yOffset = avatar.yOffset;
        renderYawOffset = avatar.renderYawOffset;
        prevRenderYawOffset = avatar.prevRenderYawOffset;
        motionX = avatar.motionX;
        motionY = avatar.motionY;
        motionZ = avatar.motionZ;
        isSwinging = avatar.isSwinging;
    }

    public void setValue()
    {
        avatar.posX = posX;
        avatar.posY = posY;
        avatar.posZ = posZ;
        avatar.prevPosX = prevPosX;
        avatar.prevPosY = prevPosY;
        avatar.prevPosZ = prevPosZ;
        avatar.rotationPitch = rotationPitch;
        avatar.rotationYaw = rotationYaw;
        avatar.prevRotationPitch = prevRotationPitch;
        avatar.prevRotationYaw = prevRotationYaw;
        avatar.yOffset = yOffset;
        avatar.renderYawOffset = renderYawOffset;
        avatar.prevRenderYawOffset = prevRenderYawOffset;
    }

    public void setValueRotation()
    {
        avatar.rotationPitch = rotationPitch;
        avatar.rotationYaw = rotationYaw;
        avatar.prevRotationPitch = prevRotationPitch;
        avatar.prevRotationYaw = prevRotationYaw;
        avatar.renderYawOffset = renderYawOffset;
        avatar.prevRenderYawOffset = prevRenderYawOffset;
        avatar.motionX = motionX;
        avatar.motionY = motionY;
        avatar.motionZ = motionZ;
        avatar.isSwinging = isSwinging;
    }

    public void setValueVector()
    {
        avatar.posX = posX - appendX;
        avatar.posY = posY - appendY;
        avatar.posZ = posZ - appendZ;
        avatar.prevPosX = prevPosX - appendX;
        avatar.prevPosY = prevPosY - appendY;
        avatar.prevPosZ = prevPosZ - appendZ;
        avatar.rotationPitch = rotationPitch;
        avatar.rotationYaw = rotationYaw;
        avatar.prevRotationPitch = prevRotationPitch;
        avatar.prevRotationYaw = prevRotationYaw;
        avatar.renderYawOffset = renderYawOffset;
        avatar.prevRenderYawOffset = prevRenderYawOffset;
        avatar.motionX = motionX;
        avatar.motionY = motionY;
        avatar.motionZ = motionZ;
        avatar.isSwinging = isSwinging;
    }

    public void onItemPickup(Entity par1Entity, int par2)
    {
    	mcGame.effectRenderer.addEffect(new EntityPickupFX(mcGame.theWorld, par1Entity, avatar, 0.1F));
    }

    static
    {
        mcGame = mod_littleMaidMob.mcGame;
    }
}
