package net.minecraft.src;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.*;
import net.minecraft.client.Minecraft;

public class EntityLittleMaid extends EntityAnimal
{
    private static final Minecraft mcGame;
    private static final float moveSpeed_Nomal = 0.7F;
    private static final float moveSpeed_Max = 1.1F;
    private static final float moveSpeed_Overdrive = 3F;
    private boolean looksWithInterest;
    private float looksWithInterestAXIS;
    private float field_25048_b;
    private float field_25054_c;
    public boolean isSwinging;
    public int swingProgressInt;
    private int damageRemainder;
    private int homeX;
    private int homeY;
    private int homeZ;
    private int tileX;
    private int tileY;
    private int tileZ;
    public TileEntityFurnace myFurnace;
    public TileEntity myTile;
    public IInventory myChest;
    public Entity myEntity;
    protected List serchedChest;
    public String textureArmor0[];
    public String textureArmor1[];
    public String textureName;
    public String textureArmorName;
    public ModelLittleMaid textureModel[];
    public EntityLittleMaidAvatar maidAvatarEntity;
    public InventoryLittleMaid maidInventory;
    private EntityPlayer givemeEntity;
    private boolean openInventory;
    protected boolean isMaidChaseWait;
    protected EntityPlayer masterEntity;
    protected double vsMasterDistance;
    public EntityPlayer gotcha;
    //private boolean maidFreedom;
    //private boolean maidTracer;
    private int maidMode;
    private int maidColor;
    private int maidwaitcount;
    private int maidSearchCount;
    protected int maidTime;
    public long maidContractLimit;
    protected boolean isFirstLook;
    public int timeSinceIgnited;
    public int maidOverDriveTime;
    public boolean isMaskedMaid;
    public boolean isClockMaid;
    private EnumSoundLittleMaid attackSound;
    private EnumSoundLittleMaid damageSound;
    private int soundInterval;
    protected int playingRole;
    //protected boolean maidcontract;
    //private boolean maidwait;
    //private String maidmastername;
    private double lastdistance;
    private List blazingArrows;
    //private boolean doAimedBow;
    public float entityIdFactor;
    public boolean weaponFullAuto;
    public boolean weaponReload;
    public int maidContractTime;
    public boolean maidCamouflage;
    public boolean openGUIFlag;
    public String maidName;
    public int updateTexture;
    protected static final String maidModeStrings[] =
    {
        "WildMaid.", "Waiting.", "Escorter.", "Freedom.", "Fencer.", "Healer.", "Cooking.", "Bloodsucker.", "Archer.", "Blazingstar.",
        "Ripper.", "Detonator.", "TNT-D.", "Torcher", "Tracer", "Pharmacist"
    };
    private static final int mmode_WildMaid = 0;
    private static final int mmode_Waitng = 1;
    private static final int mmode_Escorter = 2;
    private static final int mmode_Freedom = 3;
    private static final int mmode_Fencer = 4;
    private static final int mmode_Healer = 5;
    private static final int mmode_Cooking = 6;
    private static final int mmode_Bloodsucker = 7;
    private static final int mmode_Archer = 8;
    private static final int mmode_Blazingstar = 9;
    private static final int mmode_Ripper = 10;
    private static final int mmode_Detonator = 11;
    private static final int mmode_TNTD = 12;
    private static final int mmode_Torcher = 13;
    private static final int mmode_Tracer = 14;
    private static final int mmode_Pharmacist = 15;
    private static final int mpr_NULL = 0;
    private static final int mpr_QuickShooter = 10;
    private static final int mpr_StockShooter = 20;

    public EntityLittleMaid(World world)
    {
        super(world);
        serchedChest = new ArrayList();
        textureArmor0 = new String[4];
        textureArmor1 = new String[4];
        textureModel = new ModelLittleMaid[3];
        blazingArrows = new ArrayList();
        moveSpeed = 0.7F;
        health = 15;
        setSize(0.5F, 1.35F);
        isSwinging = false;
        swingProgressInt = 0;
        damageRemainder = 0;
        homeX = 0;
        homeY = 0;
        homeZ = 0;
        gotcha = null;
        maidInventory = new InventoryLittleMaid(this);
        maidInventory.currentItem = 0;
        maidwaitcount = 0;
        maidColor = 12;
        //maidMode = 0;
        setMode(0);
        //maidFreedom = true;
        setFreedom(true);
        maidSearchCount = 0;
        maidTime = 6000;
        maidContractLimit = 0L;
        setMaidContractLimit(maidContractLimit);
        maidContractTime = 0;
        isFirstLook = false;
        myFurnace = null;
        myTile = null;
        myChest = null;
        myEntity = null;
        timeSinceIgnited = -1;
        maidOverDriveTime = 0;
        isClockMaid = false;
        isMaskedMaid = false;
        attackSound = EnumSoundLittleMaid.Null;
        playingRole = 0;
        //maidcontract = false;
        maidCamouflage = false;
        entityIdFactor = entityId * 70;
        openGUIFlag = false;
        maidName = "";
        updateTexture = 20;

        if (mod_littleMaidMob.defaultTexture == "")
        {
            textureName = textureArmorName = TextureLittleMaid.textures.keySet().toArray()[rand.nextInt(TextureLittleMaid.getTextureCount())].toString();
        }
        else
        {
            textureName = textureArmorName = mod_littleMaidMob.defaultTexture;
        }

        maidColor = TextureLittleMaid.getRandomWildColor(textureName, rand);
        mod_littleMaidMob.Debug(String.format("ID:%d, %s:%d", new Object[]
                {
                    Integer.valueOf(entityId), textureName, Integer.valueOf(maidColor)
                }));

        if (maidColor == -1)
        {
            textureName = textureArmorName = "default";
            maidColor = 12;
        }

        setTextureName(textureName);
        setTextureArmorName(textureArmorName);
        setColor(maidColor);
        setMaidName(maidName);
        setMaidContract(false);

        if (world != null)
        {
            maidAvatarEntity = new EntityLittleMaidAvatar(world, this);
            GuiLittleMaidIFF.initIFF(world);
        }
    }

    protected void entityInit()
    {
        super.entityInit();
        dataWatcher.addObject(16, Byte.valueOf((byte)0));
        dataWatcher.addObject(17, Byte.valueOf((byte)0));
        dataWatcher.addObject(18, new Integer(getHealth()));
        dataWatcher.addObject(19, "");
        dataWatcher.addObject(20, "");
        dataWatcher.addObject(21, "");
        dataWatcher.addObject(22, new Integer(0));
        dataWatcher.addObject(23, new Integer(0));
        dataWatcher.addObject(24, "");
        dataWatcher.addObject(25, Byte.valueOf((byte)0));
    }
    /**
     * Save the entity to NBT (calls an abstract helper method to write extra data)
     */
    public void writeToNBT(NBTTagCompound nbttagcompound)
    {
        super.writeToNBT(nbttagcompound);

        if (getMaidMaster() == null)
        {
            nbttagcompound.setString("Master", "");
        }
        else
        {
            nbttagcompound.setString("Master", getMaidMaster());
        }

        nbttagcompound.setTag("Inventory", maidInventory.writeToNBT(new NBTTagList()));
        nbttagcompound.setBoolean("Wait", isMaidWait());
        nbttagcompound.setBoolean("Freedom", isMaidFreedom());
        nbttagcompound.setBoolean("Tracer", isMaidTracer());

        //if (textureName == null)
        if (getTextureName() == null)
        {
            nbttagcompound.setString("texName", "");
        }
        else
        {
            //nbttagcompound.setString("texName", textureName);
            nbttagcompound.setString("texName", getTextureName());
        }

        //if (textureName == null)
        if (getTextureName() == null)
        {
            nbttagcompound.setString("texArmor", "");
        }
        else
        {
            //nbttagcompound.setString("texArmor", textureArmorName);
            nbttagcompound.setString("texArmor", getTextureArmorName());
        }

        byte byte0 = (byte)(getMaidMode() << 4 | getMaidColor());
        nbttagcompound.setByte("ModeColor", byte0);
        nbttagcompound.setTag("HomePosI", newIntNBTList(new int[]
                {
                    homeX, homeY, homeZ
                }));
        //nbttagcompound.setLong("Limit", maidContractLimit);
        nbttagcompound.setLong("Limit", getMaidContractLimit());
        //nbttagcompound.setLong("Anniversary", maidContractTime);
       //nbttagcompound.setInteger("Anniversary", getMaidContractTime());
        nbttagcompound.setLong("Anniversary", (long)getMaidContractTime());
        nbttagcompound.setString("MaidName", getMaidName());
    }

    /**
     * Reads the entity from NBT (calls an abstract helper method to read specialized data)
     */
    public void readFromNBT(NBTTagCompound nbttagcompound)
    {
        super.readFromNBT(nbttagcompound);
        String s = nbttagcompound.getString("Master");

        if (s.length() > 0)
        {
            setMaidMaster(s);
            setMaidContract(true);
        }

        NBTTagList nbttaglist = nbttagcompound.getTagList("Inventory");
        maidInventory.readFromNBT(nbttaglist);
        ItemStack aitemstack[] = new ItemStack[4];

        for (int i = 0; i < 4; i++)
        {
            ItemStack itemstack = maidInventory.armorItemInSlot(i);

            if (itemstack != null)
            {
                aitemstack[3 - ((ItemArmor)itemstack.getItem()).armorType] = itemstack;
            }
        }

        maidInventory.armorInventory = aitemstack;
        setMaidWait(nbttagcompound.getBoolean("Wait"));
        setMaidFreedom(nbttagcompound.getBoolean("Freedom"));
        setMaidTracer(nbttagcompound.getBoolean("Tracer"));
        textureName = nbttagcompound.getString("texName");
        setTextureName(textureName);
        textureArmorName = nbttagcompound.getString("texArmor");
        setTextureArmorName(textureArmorName);
        byte byte0 = nbttagcompound.getByte("ModeColor");
        setMaidColor(byte0 & 0xf);
        setMaidMode((byte0 & 0xf0) >> 4);
        NBTTagList nbttaglist1 = nbttagcompound.getTagList("HomePosI");

        if (nbttaglist1.tagCount() > 0)
        {
            homeX = ((NBTTagInt)nbttaglist1.tagAt(0)).data;
            homeY = ((NBTTagInt)nbttaglist1.tagAt(1)).data;
            homeZ = ((NBTTagInt)nbttaglist1.tagAt(2)).data;
        }
        else
        {
            homeX = MathHelper.floor_double(posX);
            homeY = MathHelper.floor_double(posY);
            homeZ = MathHelper.floor_double(posZ);
        }

        maidContractLimit = nbttagcompound.getLong("Limit");

        if (isMaidContract() && maidContractLimit == 0L)
        {
            maidContractLimit = worldObj.getWorldTime() + 24000L;
        }

        setMaidContractLimit(maidContractLimit);
        try{
        	maidContractTime = (int)nbttagcompound.getLong("Anniversary");
        }catch (ClassCastException e){
        	maidContractTime = nbttagcompound.getInteger("Anniversary");
        }

        if (maidContractTime == 0L && isMaidContract())
        {
            maidContractTime = (int)worldObj.getWorldTime() - entityId;
            checkMaidContractTime();
        }

        setMaidContractTime(maidContractTime);
        maidName = nbttagcompound.getString("MaidName");
        setMaidName(maidName);
        setClockMaid();
        setMaskedMaid();

        for (int i = 0; i < worldObj.loadedEntityList.size(); i++) {
        	Entity entity1 = (Entity)worldObj.loadedEntityList.get(i);
        	if (entity1 instanceof EntityLittleMaid) {
            	EntityLittleMaid elm = (EntityLittleMaid)entity1;
            	if (elm.isMaidContract() && elm.maidContractTime == maidContractTime) {
            		setDead();
            		break;
            	}
        	}
        }

        if (isDead) {
            mod_littleMaidMob.Debug(String.format("Load Doppelganger ID:%d,, %d" ,entityId, maidContractTime));
        } else {
            mod_littleMaidMob.Debug(String.format("Load ID:%d, MaidMaster:%s, x:%.1f, y:%.1f, z:%.1f, %d" ,entityId, getMaidMaster(), posX, posY, posZ, maidContractTime));
        }
    }

    /**
     * returns if this entity triggers Block.onEntityWalking on the blocks they walk on. used for spiders and wolves to
     * prevent them from trampling crops
     */
    public boolean canTriggerWalking()
    {
        return mod_littleMaidMob.trampleCrops;
    }

    /**
     * Finds the closest player within 16 blocks to attack, or null if this Entity isn't interested in attacking
     * (Animals, Spiders at day, peaceful PigZombies).
     */
    protected Entity findPlayerToAttack()
    {
        List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.expand(16D, 4D, 16D));

        if (isMaidContract() && !maidCamouflage)
        {
            for (int i = 0; i < list.size(); i++)
            {
                Entity entity = (Entity)list.get(i);

                if ((entity instanceof EntityMob))
                {

                EntityMob entitymob = (EntityMob)entity;

                if (entitymob.getEntityToAttack() == null && entitymob.getAttackTarget() == null)
                {

                double d = 4096D;
                Object obj = null;
                EntityPlayer entityplayer1 = worldObj.getClosestVulnerablePlayerToEntity(this, 16D);

                if (entityplayer1 != null && canEntityBeSeen(entityplayer1))
                {
                    d = entitymob.getDistanceSqToEntity(entityplayer1);
                    obj = entityplayer1;
                }

                List list2 = worldObj.getEntitiesWithinAABB(net.minecraft.src.EntityLittleMaid.class, AxisAlignedBB.getBoundingBoxFromPool(entitymob.posX, entitymob.posY, entitymob.posZ, entitymob.posX + 1.0D, entitymob.posY + 1.0D, entitymob.posZ + 1.0D).expand(16D, 4D, 16D));

                for (int j2 = 0; j2 < list2.size(); j2++)
                {
                    EntityLittleMaid entitylittlemaid1 = (EntityLittleMaid)list2.get(j2);

                    if (entitylittlemaid1.isMaidContract() && !entitylittlemaid1.maidCamouflage && entitymob.canEntityBeSeen(entitylittlemaid1))
                    {

                    double d1 = entitymob.getDistanceSqToEntity(entitylittlemaid1);

                    if (d > d1)
                    {
                        d = d1;
                        obj = entitylittlemaid1;
                    }
                }

                if (obj != null)
                {
                	if (entitymob.isAIEnabled())
                	{
                		entitymob.setAttackTarget((EntityLiving)obj);
                	}
                	else
                	{
                		entitymob.setTarget((Entity)(obj));
                	}
                    mod_littleMaidMob.Debug(String.format("getEntityToAttack ID:%d", new Object[]
                            {
                                Integer.valueOf(((EntityLiving)(obj)).entityId)
                            }));
                }
                }
                }
                }
            }
        }

        if (isMaidWaitEx())
        {
            return null;
        }

        if (playingRole != 0)
        {
            if (playingRole % 10 == 0 && isMaidFreedom())
            {
                Entity entity1 = null;
                Iterator iterator = list.iterator();

                do
                {
                    if (!iterator.hasNext())
                    {
                        break;
                    }

                    Entity entity5 = (Entity)iterator.next();

                    if (entity5 != null && ((entity5 instanceof EntityPlayer) || (entity5 instanceof EntityLittleMaid)))
                    {
                        entity1 = entity5;
                    }
                }
                while (!rand.nextBoolean());

                return entity1;
            }
            else
            {
                return null;
            }
        }

        masterEntity = getMaidMasterEntity();
        ItemStack itemstack = maidInventory.getCurrentItem();
        int k1 = -1;
        float f4 = 16F;
        label0:

        switch (getMaidMode())
        {
            case 4:
            case 8:
                if (masterEntity == null)
                {
                    break;
                }

                if (entityToAttack != null)
                {
                	f4 = getDistanceToEntity(entityToAttack);
                	mod_littleMaidMob.Debug("has target");
                }
                for (int j = 0; j < list.size(); j++)
                {
                    if (!(list.get(j) instanceof EntityCreature))
                    {
                        continue;
                    }

                    EntityCreature entitycreature = (EntityCreature)list.get(j);

                    if (entitycreature.health <= 0 || getIFF(entitycreature) || !canEntityBeSeen(entitycreature))
                    {
                        continue;
                    }
                    Entity entitytarget = entitycreature.isAIEnabled() ? entitycreature.getAttackTarget() : entitycreature.getEntityToAttack();
                    if (entitytarget == masterEntity || entitytarget == this)
                    {
                        float f = masterEntity.getDistanceToEntity(entitycreature);

                        if (f < f4)
                        {
                            f4 = f;
                            k1 = j;
                        }

                        continue;
                    }

                    if (!(entitytarget instanceof EntityLittleMaid) || ((EntityLittleMaid)entitytarget).getMaidMasterEntity() != masterEntity)
                    {
                        continue;
                    }

                    float f1 = getDistanceToEntity(entitycreature) * 2.0F;

                    if (f1 < f4)
                    {
                        f4 = f1;
                        k1 = j;
                    }
                }

                if (k1 > -1)
                {
                    playLittleMaidSound(EnumSoundLittleMaid.findTarget_N, false);
                    return (Entity)list.get(k1);
                }

                break;

            case 7:
            case 9:
            case 11:
                for (int k = 0; k < list.size(); k++)
                {
                    Entity entity2 = (Entity)list.get(k);

                    if (entity2 == riddenByEntity || !(entity2 instanceof EntityLiving) || getIFF(entity2) || !canEntityBeSeen(entity2))
                    {
                        continue;
                    }

                    float f2 = getDistanceToEntity(entity2);

                    if (f2 < f4)
                    {
                        f4 = f2;
                        k1 = k;
                    }
                }

                if (k1 <= -1)
                {
                    break;
                }

                if (((EntityLiving)list.get(k1)).health > 0)
                {
                    playLittleMaidSound(EnumSoundLittleMaid.findTarget_B, false);
                }

                return (Entity)list.get(k1);

            case 10:
                if (itemstack == null || !(itemstack.getItem() instanceof ItemShears))
                {
                    return null;
                }

                for (int l = 0; l < list.size(); l++)
                {
                    Entity entity3 = (Entity)list.get(l);

                    if (((entity3 instanceof EntityTNTPrimed) || (entity3 instanceof EntityCreeper)) && canEntityBeSeen(entity3))
                    {
                        setMaidMode(12);
                        return null;
                    }

                    if (entity3 instanceof EntityLittleMaid)
                    {
                        EntityLittleMaid entitylittlemaid = (EntityLittleMaid)entity3;

                        if (entitylittlemaid.getMaidMode() == 11 && entitylittlemaid.timeSinceIgnited > -1)
                        {
                            setMaidMode(12);
                            return null;
                        }
                    }

                    if (!(entity3 instanceof EntitySheep))
                    {
                        continue;
                    }

                    EntitySheep entitysheep = (EntitySheep)entity3;

                    if (entitysheep.getSheared() || !canEntityBeSeen(entity3))
                    {
                        continue;
                    }

                    float f3 = getDistanceToEntity(entity3);

                    if (f3 < f4)
                    {
                        f4 = f3;
                        k1 = l;
                    }
                }

                if (k1 > -1)
                {
                    playLittleMaidSound(EnumSoundLittleMaid.findTarget_B, false);
                    return (Entity)list.get(k1);
                }

                break;

            case 12:
                if (itemstack == null || !(itemstack.getItem() instanceof ItemShears))
                {
                    setMaidMode(2);
                    return null;
                }

                int l1 = -1;

                for (int i1 = 0; i1 < list.size(); i1++)
                {
                    int i2 = 0xfffe7961;
                    Entity entity4 = (Entity)list.get(i1);

                    if (entity4 instanceof EntityTNTPrimed)
                    {
                        i2 = 100 - ((EntityTNTPrimed)entity4).fuse;
                    }

                    if (entity4 instanceof EntityCreeper)
                    {
                        i2 = ((EntityCreeper)entity4).timeSinceIgnited;
                    }

                    if ((entity4 instanceof EntityLittleMaid) && ((EntityLittleMaid)entity4).getMaidMode() == 11)
                    {
                        i2 = ((EntityLittleMaid)entity4).timeSinceIgnited;
                    }

                    if (i2 > l1 && worldObj.getPathEntityToEntity(this, entity4, 16F, true, false, false, true) != null)
                    {
                        k1 = i1;
                        l1 = i2;
                    }
                }

                if (k1 > -1)
                {
                    maidOverDriveTime = 300;
                    return (Entity)list.get(k1);
                }

                break;

            case 13:
                if (tileX == 1)
                {
                    break;
                }

            case 6:
                if (myFurnace != null)
                {
                    break;
                }

            case 5:
            default:
                if (maidInventory.getFirstEmptyStack() <= -1 || myTile != null)
                {
                    break;
                }

                List list1 = worldObj.getEntitiesWithinAABB(net.minecraft.src.EntityItem.class, boundingBox.expand(8D, 2D, 8D));

                if (list1.size() <= 0)
                {
                    break;
                }

                int j1 = rand.nextInt(list1.size());
                EntityItem entityitem = (EntityItem)list1.get(j1);
                EntityPlayer entityplayer = masterEntity == null ? worldObj.getClosestPlayerToEntity(this, 16D) : masterEntity;

                if (entityitem.isDead || !entityitem.onGround || entityitem.delayBeforeCanPickup > 0 || entityitem.isBurning() || !canEntityItemBeSeen(entityitem) || entityplayer != null && entityplayer.getDistanceSq(entityitem.posX + (double)MathHelper.sin(entityplayer.rotationYaw * 0.01745329F) * 2D, entityitem.posY, entityitem.posZ - (double)MathHelper.cos(entityplayer.rotationYaw * 0.01745329F) * 2D) <= 7.5D)
                {
                    break;
                }

                playLittleMaidSound(EnumSoundLittleMaid.findTarget_I, false);

                switch (maidMode)
                {
                    case 5:
                        if ((entityitem.item.getItem() instanceof ItemFood) && ((ItemFood)entityitem.item.getItem()).getHealAmount() > 0)
                        {
                            return entityitem;
                        }

                        break label0;

                    case 6:
                        if (myFurnace != null && myFurnace.isBurning())
                        {
                            break label0;
                        }

                    default:
                        return entityitem;
                }
        }

        return null;
    }

    /**
     * changes pitch and yaw so that the entity calling the function is facing the entity provided as an argument
     */
    public void faceEntity(Entity entity, float f, float f1)
    {
        double d = entity.posX - posX;
        double d1 = entity.posZ - posZ;
        double d2;

        if (entity instanceof EntityLiving)
        {
            EntityLiving entityliving = (EntityLiving)entity;
            d2 = (entityliving.posY + (double)entityliving.getEyeHeight()) - (posY + (double)getEyeHeight());
        }
        else
        {
            d2 = (entity.boundingBox.minY + entity.boundingBox.maxY) / 2D - (posY + (double)getEyeHeight());
        }

        double d3 = MathHelper.sqrt_double(d * d + d1 * d1);
        float f2 = (float)((Math.atan2(d1, d) * 180D) / Math.PI) - 90F;
        float f3 = (float)(-((Math.atan2(d2, d3) * 180D) / Math.PI));
        rotationPitch = updateRotation(rotationPitch, f3, f1);
        rotationYaw = updateRotation(rotationYaw, f2, f);
    }

    protected void updateEntityActionState()
    {
    	maidMode = getMaidMode();
        if (entityToAttack == null || !entityToAttack.isEntityAlive())
        {
            if (maidMode == 5)
            {
                getNextEquipItem();
            }

            if (!weaponReload)
            {
                if (maidAvatarEntity.isUsingItem())
                {
                    if (maidAvatarEntity.isItemReload)
                    {
                        maidAvatarEntity.stopUsingItem();
                        mod_littleMaidMob.Debug(String.format("id:%d cancel reload.", new Object[]
                                {
                                    Integer.valueOf(entityId)
                                }));
                    }
                    else
                    {
                        maidAvatarEntity.clearItemInUse();
                        mod_littleMaidMob.Debug(String.format("id:%d clear.", new Object[]
                                {
                                    Integer.valueOf(entityId)
                                }));
                    }
                }
            }
            else
            {
                //doAimedBow = true;
            	setAimedBow(true);
            }
        }

        if (weaponReload && !maidAvatarEntity.isUsingItem())
        {
            maidInventory.getCurrentItem().useItemRightClick(worldObj, maidAvatarEntity);
            mod_littleMaidMob.Debug(String.format("id:%d force reload.", new Object[]
                    {
                        Integer.valueOf(entityId)
                    }));
            //doAimedBow = true;
            setAimedBow(true);
        }

        super.updateEntityActionState();

        if (maidAvatarEntity.isUsingItem() && maidAvatarEntity.getItemInUse().getItemUseAction() != EnumAction.none)
        {
            moveForward *= 0.2F;
            moveStrafing *= 0.2F;
        }

        if (isSprinting())
        {
            moveForward *= 1.3F;
            moveStrafing *= 1.3F;

            if (entityToAttack == null || !entityToAttack.isEntityAlive())
            {
                setSprinting(false);
            }
        }

        if (isSwinging)
        {
            if (swingProgressInt == 0)
            {
                playLittleMaidSound(attackSound, true);
            }

            attackSound = EnumSoundLittleMaid.Null;
            swingProgressInt++;

            if (swingProgressInt >= 8)
            {
                swingProgressInt = 0;
                isSwinging = false;
            }
        }
        else
        {
            swingProgressInt = 0;
        }

        swingProgress = (float)swingProgressInt / 8F;
        isMaidChaseWait = false;

        if (isMaidContract() && !isMaidWaitEx() && ridingEntity == null)
        {
            if (maidMode == 13 && entityToAttack == null && !hasPath())
            {
                ItemStack itemstack = maidInventory.getCurrentItem();

                if (itemstack != null && itemstack.getItem().shiftedIndex == Block.torchWood.blockID)
                {
                    moveTorcher();
                }
            }

            if (entityToAttack != null && !hasPath())
            {
                if (!isBloodsuck())
                {
                    setTarget(null);
                    mod_littleMaidMob.Debug("Retarget.");
                }
                else
                {
                    updateWanderPath();
                    mod_littleMaidMob.Debug("Reroute.");
                }
            }

            if (!isMaidFreedom())
            {
                if (maidMode == 6)
                {
                    if (myFurnace == null)
                    {
                        setPathToEntity(null);
                    }

                    isMaidChaseWait = true;
                    moveCooking();

                    if (isInWater() && myTile == null)
                    {
                        //maidMode = 2;
                        setMode(2);
                    }
                }
                else if (maidMode == 15)
                {
                    if (myTile == null)
                    {
                        setPathToEntity(null);
                    }

                    isMaidChaseWait = true;
                    movePharmacist();

                    if (isInWater() && myTile == null)
                    {
                        //maidMode = 2;
                        setMode(2);
                    }
                }
                else if (masterEntity != null)
                {
                    if (entityToAttack == null && (maidMode != 13 || tileX != 1))
                    {
                        if (vsMasterDistance < (maidMode != 5 ? 25D : 12D))
                        {
                            isMaidChaseWait = true;
                            setPathToEntity(null);
                        }
                        else
                        {
                            getPathOrWalkableBlock(masterEntity, vsMasterDistance);
                        }
                    }
                    else if (vsMasterDistance > 256D)
                    {
                        if (vsMasterDistance > 1024D)
                        {
                            setTarget(null);
                        }

                        getPathOrWalkableBlock(masterEntity, vsMasterDistance);
                    }
                }
                else if (!isInWater())
                {
                    setMaidWait(true);
                }
            }
            else
            {
                if (entityToAttack != null && !(entityToAttack instanceof EntityItem) && playingRole == 0)
                {
                    moveSpeed = 1.1F;
                }
                else
                {
                    moveSpeed = 0.7F;
                }

                if (maidMode == 6 && playingRole == 0 && entityToAttack == null)
                {
                    moveCooking();

                    if (attackTime <= 0 && (myFurnace == null || !myFurnace.isBurning() && myFurnace.getStackInSlot(1) == null && myFurnace.getStackInSlot(2) == null))
                    {
                        myFurnace = null;
                        isMaidChaseWait = false;
                    }
                    else
                    {
                        isMaidChaseWait = true;
                    }
                }

                if (myFurnace == null || !myFurnace.isBurning())
                {
                    playing();
                }

                if (maidMode == 2 && entityToAttack == null && (maidInventory.getFirstEmptyStack() == -1 || myTile != null || myEntity != null))
                {
                    moveEscorter();
                }

                //if (maidTracer && isNoTarget())
                if (isMaidTracer() && isNoTarget())
                {
                    if (!hasPath())
                    {
                        if ((isMaidChaseWait = moveTracer()))
                        {
                            setHomePosition();
                        }
                    }
                    else
                    {
                        isMaidChaseWait = true;
                    }
                }

                if (!hasPath() && !isMaidChaseWait)
                {
                    double d = (double)homeX - posX;
                    double d1 = (double)homeY - posY;
                    double d2 = (double)homeZ - posZ;
                    d *= d;
                    d1 *= d1;
                    d2 *= d2;

                    if ((d > 300D || d1 > 300D || d2 > 300D) && worldObj.getChunkFromBlockCoords(homeX, homeZ).isChunkLoaded)
                    {
                        int i = homeX;
                        int j = homeY - 1;
                        int l = homeZ;

                        if (!worldObj.getBlockMaterial(i, j, l).isSolid() || !getCanSpawnHere(i, j + 1, l))
                        {
                            mod_littleMaidMob.Debug("home lost.");
                            boolean flag = false;
                            int i1 = 1;

                            do
                            {
                                if (i1 >= 6 || flag)
                                {
                                    break;
                                }

                                if (worldObj.getBlockMaterial(i, j + i1, l).isSolid() && getCanSpawnHere(i, j + i1 + 1, l))
                                {
                                    flag = true;
                                    j += i1;
                                    break;
                                }

                                i1++;
                            }
                            while (true);

                            i1 = -1;

                            do
                            {
                                if (i1 <= -6 || flag)
                                {
                                    break;
                                }

                                if (worldObj.getBlockMaterial(i, j + i1, l).isSolid() && getCanSpawnHere(i, j + i1 + 1, l))
                                {
                                    flag = true;
                                    j += i1;
                                    break;
                                }

                                i1--;
                            }
                            while (true);

                            label0:

                            for (int j1 = 2; j1 < 18 && !flag; j1 += 2)
                            {
                                i--;
                                l--;
                                int j2 = 0;

                                do
                                {
                                    if (j2 >= 4)
                                    {
                                        continue label0;
                                    }

                                    for (int l1 = 0; l1 <= j1; l1++)
                                    {
                                        if (worldObj.getBlockMaterial(i, j, l).isSolid() && getCanSpawnHere(i, j + 1, l))
                                        {
                                            flag = true;
                                            break label0;
                                        }

                                        if (j2 == 0)
                                        {
                                            i++;
                                            continue;
                                        }

                                        if (j2 == 1)
                                        {
                                            l++;
                                            continue;
                                        }

                                        if (j2 == 2)
                                        {
                                            i--;
                                            continue;
                                        }

                                        if (j2 == 3)
                                        {
                                            l--;
                                        }
                                    }

                                    j2++;
                                }
                                while (true);
                            }

                            if (flag)
                            {
                                homeX = i;
                                homeY = j + 1;
                                homeZ = l;
                                mod_littleMaidMob.Debug(String.format("Find new position:%d, %d, %d.", new Object[]
                                        {
                                            Integer.valueOf(homeX), Integer.valueOf(homeY), Integer.valueOf(homeZ)
                                        }));
                            }
                            else
                            {
                                if (getCanSpawnHere(homeX, homeY - 6, homeZ))
                                {
                                    homeY -= 6;
                                }

                                mod_littleMaidMob.Debug(String.format("loss new position:%d, %d, %d.", new Object[]
                                        {
                                            Integer.valueOf(homeX), Integer.valueOf(homeY), Integer.valueOf(homeZ)
                                        }));
                            }
                        }
                        else
                        {
                            mod_littleMaidMob.Debug("home solid.");
                        }

                        setTarget(null);
                        setPathToEntity(null);
                        setLocationAndAngles((double)homeX + 0.5D, homeY, (double)homeZ + 0.5D, rotationYaw, rotationPitch);
                    }
                    else if (d > 100D || d1 > 100D || d2 > 100D)
                    {
                        byte byte0 = 6;
                        int k = 6;
                        byte byte1 = 6;
                        int k1 = 6;
                        byte byte2 = 6;
                        int i2 = 6;
                        int k2 = MathHelper.floor_double((double)homeX - posX);
                        int l2 = MathHelper.floor_double((double)homeY - posX);
                        int i3 = MathHelper.floor_double((double)homeZ - posZ);

                        if (k2 >= 10)
                        {
                            k = 0;
                        }

                        if (k2 <= -10)
                        {
                            byte0 = 0;
                        }

                        if (l2 >= 10)
                        {
                            k1 = 0;
                        }

                        if (l2 <= -10)
                        {
                            byte1 = 0;
                        }

                        if (i3 >= 10)
                        {
                            i2 = 0;
                        }

                        if (i3 <= -10)
                        {
                            byte2 = 0;
                        }

                        int j3 = MathHelper.floor_double((posX + (double)rand.nextInt(byte0 + k)) - (double)k);
                        int k3 = MathHelper.floor_double((posY + (double)rand.nextInt(byte1 + k1)) - (double)k1);
                        int l3 = MathHelper.floor_double((posZ + (double)rand.nextInt(byte2 + i2)) - (double)i2);
                        setPathToEntity(worldObj.getEntityPathToXYZ(this, j3, k3, l3, 10F, true, false, false, true));
                    }
                }
            }
        }

        if (!isMaidContract())
        {
            playing();
        }

        if (isInWater())
        {
            setMaidWait(false);
            setFlag(1, false);
        }
        if (!worldObj.isRemote)
        {
        	//dataWatcher.updateObject(18, Integer.valueOf(getMaidHealth()));
        	dataWatcher.updateObject(18, Integer.valueOf(getHealth()));
        }
    }

    /**
     * Called frequently so the entity can update its state every tick as required. For example, zombies and skeletons
     * use this to react to sunlight and start to burn.
     */
    public void onLivingUpdate()
    {
        weaponFullAuto = false;
        weaponReload = false;
        maidInventory.decrementAnimations();
        getWeaponStatus();
        super.onLivingUpdate();
        setLooksWithInterest(false);

        Entity entity = null;

        try
        {
            Field field = null;

            try
            {
                field = (net.minecraft.src.EntityLiving.class).getDeclaredField("ay");
            }
            catch (Exception exception1)
            {
                field = (net.minecraft.src.EntityLiving.class).getDeclaredField("currentTarget");
            }

            if (field != null)
            {
                field.setAccessible(true);
                entity = (Entity)field.get(this);
            }
        }
        catch (Exception exception) { }

        if (entity != null && (entity instanceof EntityPlayer) && givemeEntity == null)
        {
            givemeEntity = (EntityPlayer)entity;
        }

        if (givemeEntity != null)
        {
            float f = givemeEntity.getDistanceToEntity(this);
            ItemStack itemstack = givemeEntity.inventory.getCurrentItem();

            if (itemstack != null)
            {
                if (!isMaidContractEX() && itemstack.itemID == Item.cake.shiftedIndex)
                {
                    givemeSuger(f, 32F);
                }
                else if (isMaidContractEX() && itemstack.itemID == Item.sugar.shiftedIndex && maidMode != 6)
                {
                    givemeSuger(f, 16F);
                }
                else
                {
                    givemeEntity = null;
                }
            }
            else
            {
                givemeEntity = null;
            }
        }

        boolean flag = true;
        flag &= pushOutOfBlocks(posX - (double)width * 0.34999999999999998D, boundingBox.minY, posZ + (double)width * 0.34999999999999998D);
        flag &= pushOutOfBlocks(posX - (double)width * 0.34999999999999998D, boundingBox.minY, posZ + (double)width * 0.34999999999999998D);
        flag &= pushOutOfBlocks(posX + (double)width * 0.34999999999999998D, boundingBox.minY, posZ + (double)width * 0.34999999999999998D);
        flag &= pushOutOfBlocks(posX + (double)width * 0.34999999999999998D, boundingBox.minY, posZ + (double)width * 0.34999999999999998D);

        if (flag && onGround)
        {
            jump();
        }

        //if (health > 0)
        //if (getMaidHealth() > 0)
        if (getHealth() > 0)
        {
            List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.expand(1.0D, 0.0D, 1.0D));

            if (list != null)
            {
                for (int i = 0; i < list.size(); i++)
                {
                    Entity entity1 = (Entity)list.get(i);

                    if (!entity1.isDead)
                    {
                        onCollideWithLittleMaid(entity1);
                    }
                }

                if ((entityToAttack instanceof EntityItem) && maidInventory.getFirstEmptyStack() == -1)
                {
                    setTarget(null);
                }
            }

            //if (isMaidContractEX() && isClockMaid)
            if (isMaidContractEX() && isClockMaid && getMaidMasterEntity() != null)
            {
                maidTime = (int)(worldObj.getWorldTime() % 24000L);
                boolean flag1 = masterEntity.isPlayerSleeping();

                if (vsMasterDistance < 25D && canEntityBeSeen(getMaidMasterEntity()))
                {
                    EnumSoundLittleMaid enumsoundlittlemaid = EnumSoundLittleMaid.Null;

                    if (isFirstLook && (maidTime > 23500 || maidTime < 1500))
                    {
                        enumsoundlittlemaid = EnumSoundLittleMaid.goodmorning;
                        isFirstLook = false;
                    }
                    else if (!isFirstLook && flag1)
                    {
                        enumsoundlittlemaid = EnumSoundLittleMaid.goodnight;
                        isFirstLook = true;
                    }
                    else if (isFirstLook && !flag1)
                    {
                        isFirstLook = false;
                    }

                    if (enumsoundlittlemaid != EnumSoundLittleMaid.Null)
                    {
                    	playLittleMaidSound(enumsoundlittlemaid, true);
                    	setLooksWithInterest(true);
                    }
                }
                else if (!isFirstLook && (flag1 || maidTime > 18000 && maidTime < 23500))
                {
                    isFirstLook = true;
                }
            }
            else
            {
                maidTime = 6000;
            }

            if (maidMode == 11 && timeSinceIgnited > -1)
            {
                if (isMovementCeased() || timeSinceIgnited > 22)
                {
                    faceEntity(masterEntity, 40F, 40F);
                }

                if (maidInventory.isItemExplord(maidInventory.currentItem) && timeSinceIgnited++ > 30)
                {
                    maidInventory.decrStackSize(maidInventory.currentItem, 1);
                    maidInventory.dropAllItems(true);
                    timeSinceIgnited = -1;
                    setDead();
                    worldObj.createExplosion(this, posX, posY, posZ, 3F);
                }
            }

            if (maidOverDriveTime > 0)
            {
                if (--maidOverDriveTime <= 0 && maidMode == 12)
                {
                    setMaidMode(10);
                    getNextEquipItem();
                }

                //if (maidOverDriveTime > 100)
                if (maidOverDriveTime > 100 && !worldObj.isRemote)
                {
                    worldObj.spawnParticle("reddust", (posX + (double)(rand.nextFloat() * width * 2.0F)) - (double)width, posY + 0.5D + (double)(rand.nextFloat() * height), (posZ + (double)(rand.nextFloat() * width * 2.0F)) - (double)width, 1.2D, 0.40000000000000002D, 0.40000000000000002D);
                    worldObj.setEntityState(this, (byte)12);
                }

                if (entityToAttack != null)
                {
                    PathEntity pathentity = worldObj.getPathEntityToEntity(this, entityToAttack, 16F, true, false, false, true);

                    if (pathentity != null)
                    {
                        pathentity.incrementPathIndex();

                        if (!pathentity.isFinished())
                        {
                            Vec3D vec3d = pathentity.getCurrentNodeVec3d(this);
                            setPosition(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
                        }
                    }
                }
            }
            --updateTexture;
            if (updateTexture == 0)
            {
            	setTextureValue();
            	updateTexture = 20;
            }
        }
    }

    /**
     * This method gets called when the entity kills another one.
     */
    public void onKillEntity(EntityLiving entityliving)
    {
        if (isBloodsuck())
        {
            playLittleMaidSound(EnumSoundLittleMaid.laughter, false);
        }
        else
        {
            setTarget(null);
        }
    }

    /**
     * Called to update the entity's position/logic.
     */
    public void onUpdate()
    {
        label0:
        {
            label1:
            {
                int i;
                label2:
                {
                    masterEntity = getMaidMasterEntity();

                    if (masterEntity != null)
                    {
                        vsMasterDistance = masterEntity.getDistanceSqToEntity(this);
                    }

                    //doAimedBow = false;
                    if (!worldObj.isRemote)
                    {
                    	setAimedBow(isAimedBow() & attackTime > 0);
                    }
                    super.onUpdate();

                    if (maidAvatarEntity != null)
                    {
                        maidAvatarEntity.onUpdate();
                    }

                    ignoreFrustumCheck = gotcha != null;

                    if (maidwaitcount > 0)
                    {
                        if (hasPath())
                        {
                            maidwaitcount = 0;
                        }
                        else
                        {
                            maidwaitcount--;
                        }
                    }

                    if (soundInterval > 0)
                    {
                        soundInterval--;
                    }

                    if (!worldObj.isRemote)
                    {
                    	field_25054_c = field_25048_b;

                        if (looksWithInterest)
                        {
                            field_25048_b = field_25048_b + (1.0F - field_25048_b) * 0.4F;
                        }
                        else
                        {
                            field_25048_b = field_25048_b + (0.0F - field_25048_b) * 0.4F;
                        }

                        if (looksWithInterest)
                        {
                            numTicksToChaseTarget = 10;
                        }
                    }

                    if (gotcha != null)
                    {
                        double d = gotcha.getDistanceSqToEntity(this);

                        if (entityToAttack == null)
                        {
                            if (d > 4D)
                            {
                                setPathToEntity(null);
                                faceEntity(gotcha, 15F, 15F);
                            }

                            if (d > 12.25D)
                            {
                                setPathToEntity(worldObj.getPathEntityToEntity(gotcha, this, 16F, true, false, false, true));
                                faceEntity(gotcha, 15F, 15F);
                            }
                        }

                        if (d > 25D)
                        {
                            double d1 = gotcha.posX - posX;
                            double d3 = gotcha.posZ - posZ;
                            double d5 = 0.125D / (Math.sqrt(d1 * d1 + d3 * d3) + 0.0625D);
                            d1 *= d5;
                            d3 *= d5;
                            motionX += d1;
                            motionZ += d3;
                        }

                        if (d > 42.25D)
                        {
                            double d2 = gotcha.posX - posX;
                            double d4 = gotcha.posZ - posZ;
                            double d6 = 0.0625D / (Math.sqrt(d2 * d2 + d4 * d4) + 0.0625D);
                            d2 *= d6;
                            d4 *= d6;
                            gotcha.motionX -= d2;
                            gotcha.motionZ -= d4;
                        }

                        if (d > 64D)
                        {
                            gotcha = null;
                            worldObj.playSoundAtEntity(this, "random.drr", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                        }

                        if (rand.nextInt(16) == 0)
                        {
                            List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.expand(8D, 8D, 8D));

                            for (int j2 = 0; j2 < list.size(); j2++)
                            {
                                Entity entity = (Entity)list.get(j2);

                                if (!(entity instanceof EntityMob))
                                {
                                    continue;
                                }

                                EntityMob entitymob = (EntityMob)entity;

                                if (entitymob.entityToAttack == gotcha)
                                {
                                    entitymob.entityToAttack = this;
                                }
                            }
                        }
                    }

                    if (riddenByEntity != null && !(riddenByEntity instanceof EntitySquid) && height * width < riddenByEntity.height * riddenByEntity.width)
                    {
                        if (riddenByEntity instanceof EntityLiving)
                        {
                            attackEntityFrom(DamageSource.causeMobDamage((EntityLiving)riddenByEntity), 0);
                        }

                        riddenByEntity.mountEntity(null);
                        return;
                    }

                    if (attackTime > 0)
                    {
                        break label0;
                    }

                    if (!isMaidContractEX() || vsMasterDistance >= 16D || maidMode != 5 || masterEntity == null || !masterEntity.isEntityAlive() || !canEntityBeSeen(masterEntity))
                    {
                        break label1;
                    }

                    i = masterEntity.foodStats.getFoodLevel();

                    if (!isMaskedMaid)
                    {
                        break label2;
                    }

                    if (masterEntity.health < 9)
                    {
                        int k = maidInventory.getInventorySlotContainItemPotion(false, Potion.heal.id, masterEntity.isEntityUndead());

                        if (k > -1)
                        {
                            maidInventory.currentItem = k;
                            break label2;
                        }
                    }

                    if (i < 18)
                    {
                        int l = maidInventory.getInventorySlotContainItemFood();

                        if (l > -1)
                        {
                            maidInventory.currentItem = l;
                        }
                    }
                }
                boolean flag;
                label3:
                {
                    ItemStack itemstack1 = maidInventory.getCurrentItem();

                    if (itemstack1 == null)
                    {
                        break label1;
                    }

                    if (itemstack1.getItem() instanceof ItemFood)
                    {
                        if (i < 18)
                        {
                            setSwing(10, EnumSoundLittleMaid.healing);
                            itemstack1 = itemstack1.onFoodEaten(worldObj, masterEntity);
                            worldObj.playSoundAtEntity(this, masterEntity.getHurtSound(), 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);

                            if (itemstack1.stackSize <= 0)
                            {
                                itemstack1.onItemDestroyedByUse(null);
                                itemstack1 = null;
                            }

                            maidInventory.setInventoryCurrentSlotContents(itemstack1);
                            getNextEquipItem();
                        }

                        break label1;
                    }

                    if (!(itemstack1.getItem() instanceof ItemPotion))
                    {
                        break label1;
                    }

                    flag = true;
                    List list1 = ((ItemPotion)itemstack1.getItem()).getEffects(itemstack1);

                    if (list1 == null)
                    {
                        break label3;
                    }

                    Iterator iterator = list1.iterator();
                    PotionEffect potioneffect;

                    do
                    {
                        if (!iterator.hasNext())
                        {
                            break label3;
                        }

                        potioneffect = (PotionEffect)iterator.next();

                        if (potioneffect.getPotionID() == Potion.heal.id)
                        {
                            if (6 << potioneffect.getAmplifier() <= masterEntity.getMaxHealth() - masterEntity.health)
                            {
                                flag = true;
                            }
                            else
                            {
                                flag = false;
                            }

                            break label3;
                        }
                    }
                    while (!Potion.potionTypes[potioneffect.getPotionID()].isBadEffect() && !masterEntity.activePotionsMap.containsKey(Integer.valueOf(potioneffect.getPotionID())));

                    flag = false;
                }

                if (flag)
                {
                    usePotionTotarget(masterEntity);
                    worldObj.playSoundAtEntity(this, "random.hurt", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                    getNextEquipItem();
                }
            }

            //if (health < 20 && maidInventory.consumeInventoryItem(Item.sugar.shiftedIndex))
            if (getMaidHealth() < 20 && maidInventory.consumeInventoryItem(Item.sugar.shiftedIndex))
            {
                eatSugar(true, false);
            }

            if (rand.nextInt(50000) == 0 && maidInventory.consumeInventoryItem(Item.sugar.shiftedIndex))
            {
                eatSugar(true, false);
            }

            if (maidMode == 13)
            {
                ItemStack itemstack = maidInventory.getCurrentItem();

                if (itemstack != null && itemstack.getItem().shiftedIndex == Block.torchWood.blockID)
                {
                    int i1 = MathHelper.floor_double(posX);
                    int k1 = MathHelper.floor_double(posY);
                    int k2 = MathHelper.floor_double(posZ);
                    int i3 = MathHelper.floor_float(height) + 1;
                    int k3 = 8;

                    for (int i4 = -1; i4 < 2; i4++)
                    {
                        for (int j4 = -1; j4 < 2; j4++)
                        {
                            for (int k4 = 0; k4 <= i3; k4++)
                            {
                                int l4 = k1 + (k4 != i3 ? k4 : -1);
                                int i5 = worldObj.getBlockLightValue(i1 + i4, l4, k2 + j4);

                                if (k3 > i5 && worldObj.getBlockMaterial(i1 + i4, l4 - 1, k2 + j4).isSolid() && (worldObj.getBlockMaterial(i1 + i4, l4, k2 + j4) == Material.air || worldObj.getBlockId(i1 + i4, l4, k2 + j4) == Block.snow.blockID) && canBlockBeSeen(i1 + i4, l4 - 1, k2 + j4, true, false, true))
                                {
                                    k3 = i5;
                                    tileX = i1 + i4;
                                    tileY = l4 - 1;
                                    tileZ = k2 + j4;
                                    mod_littleMaidMob.Debug(String.format("torch: %d, %d, %d: %d", new Object[]
                                            {
                                                Integer.valueOf(tileX), Integer.valueOf(tileY), Integer.valueOf(tileZ), Integer.valueOf(i5)
                                            }));
                                }
                            }
                        }
                    }

                    maidAvatarEntity.getValue();

                    if (k3 < 8 && itemstack != null && itemstack.useItem(maidAvatarEntity, worldObj, tileX, tileY, tileZ, 1))
                    {
                        if (itemstack.stackSize <= 0)
                        {
                            maidInventory.setInventoryCurrentSlotContents(null);
                            getNextEquipItem();
                        }

                        setSwing(10, EnumSoundLittleMaid.installation);
                        isSwinging = true;
                        attackTime = 10;
                        tileX = 2;
                        setPathToEntity(null);
                    }
                }
            }

            //if (maidMode != 3)
            if (getMaidFreedom() && maidMode < 3 && getContractLimitDays() <= 6F)
            {
            	maidContractLimit = getMaidContractLimit();
                maidContractLimit += 24000L;

                if (maidContractLimit - worldObj.getWorldTime() > 0x29040L)
                {
                    maidContractLimit = worldObj.getWorldTime() + 0x29040L;
                }

                setMaidContractLimit(maidContractLimit);

                if (maidAvatarEntity != null)
                {
                    maidAvatarEntity.foodStats.addStats(20, 20F);
                }
            }
            else if (maidMode != 3)
            {
                float f = getContractLimitDays();

                if (f < 0.0F)
                {
                    int j1 = Math.round(-f);

                    do
                    {
                        int l1 = maidInventory.getInventorySlotContainItem(Item.sugar.shiftedIndex);

                        if (l1 == -1)
                        {
                            break;
                        }

                        ItemStack itemstack2 = maidInventory.decrStackSize(l1, j1);

                        if (itemstack2 == null)
                        {
                            break;
                        }

                        //maidContractLimit = getMaidContractLimit();
                        maidContractLimit = 24000L * (long)itemstack2.stackSize + getMaidContractLimit();
                        setMaidContractLimit(maidContractLimit);
                        f += itemstack2.stackSize;
                        j1 -= itemstack2.stackSize;
                    }
                    while (j1 > 0);
                }

                if (f <= 6F && maidInventory.consumeInventoryItem(Item.sugar.shiftedIndex))
                {
                    eatSugar(true, true);
                }
                else if (f < 0.0F)
                {
                    setHomePosition();
                    setMaidMode(3);
                    setMaidWait(false);
                }
            }
        }

        if (maidMode == 9 && blazingArrows.size() > 0)
        {
            for (int j = 0; j < blazingArrows.size(); j++)
            {
                EntityArrow entityarrow = (EntityArrow)blazingArrows.get(j);

                if (entityarrow.isDead)
                {
                    blazingArrows.remove(entityarrow);
                    continue;
                }

                try
                {
                    int i2 = ((Integer)ModLoader.getPrivateValue(net.minecraft.src.EntityArrow.class, entityarrow, 9)).intValue();

                    if (i2 > 200 && entityarrow.isBurning())
                    {
                        int l2 = MathHelper.floor_double(entityarrow.posX);
                        int j3 = MathHelper.floor_double(entityarrow.posY);
                        int l3 = MathHelper.floor_double(entityarrow.posZ);
                        worldObj.playSoundEffect((double)l2 + 0.5D, (double)j3 + 0.5D, (double)l3 + 0.5D, "fire.ignite", 1.0F, rand.nextFloat() * 0.4F + 0.8F);
                        worldObj.setBlockWithNotify(l2, j3, l3, Block.fire.blockID);
                        entityarrow.extinguish();
                    }
                }
                catch (Exception exception) { }
            }
        }
    }

    /**
     * Disables a mob's ability to move on its own while true.
     */
    protected boolean isMovementCeased()
    {
        return isMaidWaitEx() || looksWithInterest || isMaidChaseWait || timeSinceIgnited > 30;
    }

    /**
     * Called when the entity is attacked.
     */
    public boolean attackEntityFrom(DamageSource damagesource, int i)
    {
        Entity entity = damagesource.getEntity();
        damageSound = EnumSoundLittleMaid.hurt;

        if (damagesource == DamageSource.inFire || damagesource == DamageSource.onFire || damagesource == DamageSource.lava)
        {
            damageSound = EnumSoundLittleMaid.hurt_fire;
        }
        else if (damagesource instanceof EntityDamageSourceIndirect)
        {
            try
            {
                Entity entity1 = (Entity)ModLoader.getPrivateValue(net.minecraft.src.EntityDamageSource.class, damagesource, 0);
                mod_littleMaidMob.Debug(entity1.getClass().getName());

                if (entity1 instanceof EntitySnowball)
                {
                    damageSound = EnumSoundLittleMaid.hurt_snow;
                }
            }
            catch (Exception exception) { }
        }

        setMaidWait(false);
        setMaidWaitCount(0);

        if (i > 0)
        {
            playingRole = 0;
            getNextEquipItem();
        }

        if (entity != null && damageSound == EnumSoundLittleMaid.hurt_snow && (!isMaidContract() || isMaidFreedom()))
        {
            playingRole = 10;
            mod_littleMaidMob.Debug("playingMode Enable.");
        }

        if (isMaidContract() && (entity instanceof EntityLiving) || (entity instanceof EntityArrow))
        {
            if (worldObj.difficultySetting == 0)
            {
                i = 0;
            }

            if (worldObj.difficultySetting == 1 && i > 0)
            {
                i = i / 2 + 1;
            }

            if (worldObj.difficultySetting == 3)
            {
                i = (i * 3) / 2;
            }
        }

        if (i == 0 && maidMode != 11)
        {
            if (damageSound == EnumSoundLittleMaid.hurt)
            {
                damageSound = EnumSoundLittleMaid.hurt_nodamege;
            }

            playLittleMaidSound(damageSound, true);
            return false;
        }

        if (super.attackEntityFrom(damagesource, i))
        {
            if (isMaidContract() && entity != null)
            {
                if (getIFF(entity) && playingRole == 0)
                {
                    fleeingTick = 0;
                    return true;
                }
            }
            else if (maidInventory.getCurrentItem() == null)
            {
                return true;
            }

            fleeingTick = 0;
            entityToAttack = entity;
            if (entity != null){
            	setPathToEntity(worldObj.getPathEntityToEntity(this, entityToAttack, 16F, true, false, false, true));
            }
            if (maidMode == 5 && (entity instanceof EntityLiving))
            {
                maidInventory.currentItem = maidInventory.getInventorySlotContainItemPotion(true, 0, ((EntityLiving)entity).isEntityUndead() & isMaskedMaid);
            }

            return true;
        }
        else
        {
            return false;
        }
    }

    /**
     * Basic mob attack. Default to touch of death in EntityCreature. Overridden by each mob to define their attack.
     */
    protected void attackEntity(Entity entity, float f)
    {
        ItemStack itemstack = maidInventory.getCurrentItem();

        if (playingRole != 0 && (!isMaidContract() || isMaidFreedom()))
        {
            if (entity != null && f < 8F && attackTime <= 0 && getNextEquipItem())
            {
                itemstack = maidInventory.getCurrentItem();

                if (!worldObj.isRemote)
                {
                    worldObj.spawnEntityInWorld(new EntitySnowball(worldObj, this));
                }

                setSwing(30, EnumSoundLittleMaid.shoot);

                if (--itemstack.stackSize <= 0)
                {
                    maidInventory.setInventoryCurrentSlotContents(null);
                }
            }

            return;
        }

        //if (health < 10 && !isBloodsuck() && maidInventory.hasItem(Item.sugar.shiftedIndex))
        if (getMaidHealth() < 10 && !isBloodsuck() && maidInventory.hasItem(Item.sugar.shiftedIndex))
        {
            return;
        }

        masterEntity = getMaidMasterEntity();

        switch (getMaidMode())
        {
            case 8:
            case 9:
                if (f < 14F)
                {
                    double d = entity.posX - posX;
                    double d2 = entity.posY - posY;
                    double d4 = entity.posZ - posZ;
                    double d5 = d * d + d2 * d2 + d4 * d4;
                    double d6 = -1D;
                    double d7 = 10D;

                    if (masterEntity != null)
                    {
                        double d8 = masterEntity.posX - posX;
                        double d9 = masterEntity.posY - posY - 2D;
                        double d10 = masterEntity.posZ - posZ;
                        d6 = (d8 * d + d9 * d2 + d10 * d4) / d5;
                        double d11 = (posX + d6 * d) - masterEntity.posX;
                        double d12 = ((posY + d6 * d2) - masterEntity.posY) + 2D;
                        double d13 = (posZ + d6 * d4) - masterEntity.posZ;
                        d7 = d11 * d11 + d12 * d12 + d13 * d13;
                    }

                    if (itemstack != null && !(itemstack.getItem() instanceof ItemFood) && !weaponReload)
                    {
                        int j2 = worldObj.loadedEntityList.size();
                        int k2 = itemstack.stackSize;
                        //doAimedBow = true;
                        if (!worldObj.isRemote)
                        {
                        	setAimedBow(true);
                        }
                        maidAvatarEntity.getValueVector(d, d2, d4, d5);
                        boolean flag2 = true;
                        int l2 = isMaskedMaid ? maidInventory.armorInventory[3].getItem().shiftedIndex : 0;

                        if (l2 == Item.helmetDiamond.shiftedIndex || l2 == Item.helmetGold.shiftedIndex)
                        {
                            List list = worldObj.getEntitiesWithinAABBExcludingEntity(this, boundingBox.expand(16D, 16D, 16D));
                            Vec3D vec3d = Vec3D.createVector(posX, posY, posZ);
                            Vec3D vec3d1 = Vec3D.createVector(entity.posX, entity.posY, entity.posZ);

                            for (int i3 = 0; i3 < list.size(); i3++)
                            {
                                Entity entity2 = (Entity)list.get(i3);

                                if (entity2 == this || entity2 == entity || !entity2.canBeCollidedWith() || !getIFF(entity2))
                                {
                                    continue;
                                }

                                float f2 = 0.3F;
                                AxisAlignedBB axisalignedbb = entity2.boundingBox.expand(f2, f2, f2);
                                MovingObjectPosition movingobjectposition = axisalignedbb.calculateIntercept(vec3d, vec3d1);

                                if (movingobjectposition != null)
                                {
                                    flag2 = false;
                                    mod_littleMaidMob.Debug(String.format("ID:%d-friendly fire to ID:%d.", new Object[]
                                            {
                                                Integer.valueOf(entityId), Integer.valueOf(entity2.entityId)
                                            }));
                                }
                            }
                        }

                        flag2 &= d7 > 3D || d6 < 0.0D;

                        if ((weaponFullAuto && !flag2 || flag2 && attackTime <= 0) && maidAvatarEntity.isItemTrigger)
                        {
                            mod_littleMaidMob.Debug(String.format("id:%d shoot.", new Object[]
                                    {
                                        Integer.valueOf(entityId)
                                    }));
                            maidAvatarEntity.stopUsingItem();
                            k2++;
                        }
                        else if (itemstack.getMaxItemUseDuration() > 500)
                        {
                            if (!maidAvatarEntity.isUsingItemLittleMaid())
                            {
                                if (!weaponFullAuto || flag2)
                                {
                                    byte byte0 = ((byte)(l2 != Item.helmetSteel.shiftedIndex && l2 != Item.helmetDiamond.shiftedIndex ? 16 : 26));

                                    if (attackTime < byte0)
                                    {
                                        setSwing(byte0, EnumSoundLittleMaid.sighting);
                                        itemstack = itemstack.useItemRightClick(worldObj, maidAvatarEntity);
                                        mod_littleMaidMob.Debug(String.format("id:%d redygun.", new Object[]
                                                {
                                                    Integer.valueOf(entityId)
                                                }));
                                    }
                                }
                                else
                                {
                                    mod_littleMaidMob.Debug(String.format("ID:%d-friendly fire FullAuto.", new Object[]
                                            {
                                                Integer.valueOf(entityId)
                                            }));
                                }
                            }
                        }
                        else if (itemstack.getMaxItemUseDuration() == 0)
                        {
                            if (attackTime <= 0 && !maidAvatarEntity.isUsingItem())
                            {
                                if (flag2)
                                {
                                    itemstack = itemstack.useItemRightClick(worldObj, maidAvatarEntity);
                                    attackTime = 10;
                                    isSwinging = true;

                                    if (itemstack.stackSize == k2)
                                    {
                                        playLittleMaidSound(EnumSoundLittleMaid.shoot_burst, true);
                                    }

                                    mod_littleMaidMob.Debug(String.format("id:%d throw weapon.", new Object[]
                                            {
                                                Integer.valueOf(entityId)
                                            }));
                                }
                                else
                                {
                                    mod_littleMaidMob.Debug(String.format("ID:%d-friendly fire throw weapon.", new Object[]
                                            {
                                                Integer.valueOf(entityId)
                                            }));
                                }
                            }
                        }
                        else
                        {
                            if (!maidAvatarEntity.isUsingItemLittleMaid())
                            {
                                itemstack = itemstack.useItemRightClick(worldObj, maidAvatarEntity);
                                mod_littleMaidMob.Debug(String.format("%d reload.", new Object[]
                                        {
                                            Integer.valueOf(entityId)
                                        }));
                            }

                            attackTime = 5;
                        }

                        maidAvatarEntity.setValueVector();

                        if (itemstack.stackSize != k2)
                        {
                            playLittleMaidSound(EnumSoundLittleMaid.shoot, true);
                            attackTime = 30;
                        }

                        if (itemstack.stackSize <= 0)
                        {
                            destroyCurrentEquippedItem();
                            getNextEquipItem();
                        }
                        else
                        {
                            maidInventory.setInventoryCurrentSlotContents(itemstack);
                        }

                        List list1 = worldObj.loadedEntityList.subList(j2, worldObj.loadedEntityList.size());
                        boolean flag3 = false;

                        if (list1 != null && list1.size() > 0)
                        {
                            mod_littleMaidMob.Debug(String.format("new FO entity %d", new Object[]
                                    {
                                        Integer.valueOf(list1.size())
                                    }));

                            for (Iterator iterator = list1.iterator(); iterator.hasNext();)
                            {
                                Entity entity1 = (Entity)iterator.next();

                                if (entity1.isDead)
                                {
                                    flag3 = true;
                                }
                                else
                                {
                                    try
                                    {
                                        Field afield[] = entity1.getClass().getDeclaredFields();
                                        Field afield1[] = afield;
                                        int j3 = afield1.length;
                                        int k3 = 0;

                                        while (k3 < j3)
                                        {
                                            Field field = afield1[k3];
                                            field.setAccessible(true);
                                            Object obj1 = field.get(entity1);

                                            if (obj1.equals(maidAvatarEntity))
                                            {
                                                field.set(entity1, this);
                                                mod_littleMaidMob.Debug("Replace FO Owner.");

                                                if (maidMode == 9 && (entity1 instanceof EntityArrow))
                                                {
                                                    int l3 = maidInventory.getInventorySlotContainItem(Item.flintAndSteel.shiftedIndex);

                                                    if (l3 > -1)
                                                    {
                                                        ((EntityArrow)entity1).setFire(8);
                                                        ItemStack itemstack1 = maidInventory.getStackInSlot(l3);
                                                        itemstack1.damageItem(1, this);

                                                        if (itemstack1.stackSize <= 0)
                                                        {
                                                            maidInventory.setInventorySlotContents(l3, null);
                                                        }

                                                        blazingArrows.add((EntityArrow)entity1);
                                                    }
                                                }
                                            }

                                            k3++;
                                        }
                                    }
                                    catch (Exception exception) { }
                                }
                            }
                        }

                        if (flag3)
                        {
                            Iterator iterator1 = worldObj.loadedEntityList.iterator();

                            do
                            {
                                if (!iterator1.hasNext())
                                {
                                    break;
                                }

                                Object obj = iterator1.next();

                                if ((obj instanceof EntityCreature) && !(obj instanceof EntityLittleMaid))
                                {
                                    EntityCreature entitycreature = (EntityCreature)obj;

                                    if (entitycreature.entityToAttack == maidAvatarEntity)
                                    {
                                        entitycreature.entityToAttack = this;
                                    }
                                }
                            }
                            while (true);
                        }
                    }

                    if (isBloodsuck())
                    {
                        rotationYaw = (float)((Math.atan2(d4, d) * 180D) / Math.PI) + 100F;
                    }
                    else
                    {
                        rotationYaw = (float)((Math.atan2(d4, d) * 180D) / Math.PI) - 90F;
                    }

                    hasAttacked = true;
                }else{
                	mod_littleMaidMob.Debug(String.format("id:%d Target renge out.", entityId));
                	if (weaponFullAuto && maidAvatarEntity.isItemTrigger)
                	{
                		maidAvatarEntity.stopUsingItem();
                	}else{
                		maidAvatarEntity.clearItemInUse();
                	}
                }
                break;

            case 10:
                if (itemstack != null && (itemstack.getItem() instanceof ItemShears))
                {
                    if (entity instanceof EntitySheep)
                    {
                        EntitySheep entitysheep = (EntitySheep)entity;

                        if (!entitysheep.getSheared())
                        {
                            if (attackTime > 0 || (double)f >= 1.5D || entity.boundingBox.maxY <= boundingBox.minY || entity.boundingBox.minY >= boundingBox.maxY)
                            {
                                break;
                            }

                            setSwing(20, EnumSoundLittleMaid.attack);

                            if (!worldObj.isRemote)
                            {
                                entitysheep.setSheared(true);
                                int k = entitysheep.isChild() ? 1 : 2 + rand.nextInt(3);

                                for (int i1 = 0; i1 < k; i1++)
                                {
                                    EntityItem entityitem = entityDropItem(new ItemStack(Block.cloth.blockID, 1, entitysheep.getFleeceColor()), 1.0F);
                                    entityitem.motionY += rand.nextFloat() * 0.05F;
                                    entityitem.motionX += (rand.nextFloat() - rand.nextFloat()) * 0.1F;
                                    entityitem.motionZ += (rand.nextFloat() - rand.nextFloat()) * 0.1F;
                                }
                            }

                            itemstack.damageItem(1, this);

                            if (itemstack.stackSize <= 0)
                            {
                                destroyCurrentEquippedItem();
                                getNextEquipItem();
                            }

                            hasAttacked = true;
                        }
                    }
                    else
                    {
                        mod_littleMaidMob.Debug(String.format("not Sheep ID:%d", new Object[]
                                {
                                    Integer.valueOf(entityId)
                                }));
                    }
                }

                setTarget(null);
                break;

            case 12:
                if (itemstack != null && (itemstack.getItem() instanceof ItemShears) && attackTime <= 0 && (double)f < 1.5D && entity.boundingBox.maxY > boundingBox.minY && entity.boundingBox.minY < boundingBox.maxY)
                {
                    setSwing(20, EnumSoundLittleMaid.attack);
                    int i = 0;

                    if (entity instanceof EntityTNTPrimed)
                    {
                        i = 10;
                        entity.setDead();
                    }

                    if (entity instanceof EntityCreeper)
                    {
                        i = ((EntityCreeper)entity).timeSinceIgnited;
                        ((EntityCreeper)entity).timeSinceIgnited = 0;
                    }

                    if (entity instanceof EntityLittleMaid)
                    {
                        i = ((EntityLittleMaid)entity).timeSinceIgnited;
                        ((EntityLittleMaid)entity).timeSinceIgnited = -1;
                    }

                    setTarget(null);
                    itemstack.damageItem(i <= -1 ? 0 : i, this);

                    if (itemstack.stackSize <= 0)
                    {
                        destroyCurrentEquippedItem();
                        getNextEquipItem();
                    }
                }

                break;

            case 7:
                if (f > 2.0F && f < 6F && rand.nextInt(10) == 0)
                {
                    if (onGround)
                    {
                        double d1 = entity.posX - posX;
                        double d3 = entity.posZ - posZ;
                        float f1 = MathHelper.sqrt_double(d1 * d1 + d3 * d3);
                        motionX = (d1 / (double)f1) * 0.5D * 0.80000001192092896D + motionX * 0.20000000298023224D;
                        motionZ = (d3 / (double)f1) * 0.5D * 0.80000001192092896D + motionZ * 0.20000000298023224D;
                        motionY = 0.40000000596046448D;
                    }

                    break;
                }

            case 5:
                if (itemstack != null && (itemstack.getItem() instanceof ItemPotion) && (entity instanceof EntityLiving))
                {
                    EntityLiving entityliving = (EntityLiving)entity;

                    if (attackTime <= 0 && (double)f < 1.5D && entity.boundingBox.maxY > boundingBox.minY && entity.boundingBox.minY < boundingBox.maxY)
                    {
                        setSwing(20, EnumSoundLittleMaid.attack);
                        usePotionTotarget(entityliving);
                        maidInventory.currentItem = maidInventory.getInventorySlotContainItemPotion(true, 0, entityliving.isEntityUndead() & isMaskedMaid);
                        break;
                    }
                }

            case 2:
            case 13:
                //if (entity instanceof EntityItem && masterEntity != null)
            	if (entity instanceof EntityItem)
                {
                	if (masterEntity == null)
                	{
                		break;
                	}
                    if (entity.getDistanceSqToEntity(masterEntity) >= 9D);

                    break;
                }

            case 0:
            case 1:
            case 3:
            case 4:
            case 6:
            case 11:
            default:
                int j = itemstack != null ? itemstack.getItemDamage() : 0;
                int l = itemstack != null ? itemstack.stackSize : 0;
                maidAvatarEntity.getValue();

                if (entity instanceof EntityLiving)
                {
                    EntityLiving entityliving1 = (EntityLiving)entity;

                    if (attackTime <= 0 && (double)f < 2D && maidAvatarEntity.isUsingItem())
                    {
                        maidAvatarEntity.stopUsingItem();

                        if (itemstack == null || itemstack.getItemDamage() != j || itemstack.stackSize != l)
                        {
                            setSwing(20, EnumSoundLittleMaid.shoot_burst);
                            mod_littleMaidMob.Debug("throw.");
                        }
                    }

                    if (attackTime <= 0 && (double)f < 1.5D && entity.boundingBox.maxY > boundingBox.minY && entity.boundingBox.minY < boundingBox.maxY)
                    {
                        setSwing(20, EnumSoundLittleMaid.attack);
                        int j1 = maidInventory.getDamageVsEntity(entity);

                        if (isPotionActive(Potion.damageBoost))
                        {
                            j1 += 3 << getActivePotionEffect(Potion.damageBoost).getAmplifier();
                        }

                        if (isPotionActive(Potion.weakness))
                        {
                            j1 -= 2 << getActivePotionEffect(Potion.weakness).getAmplifier();
                        }

                        int k1 = 0;
                        int l1 = 0;
                        l1 = EnchantmentHelper.getEnchantmentModifierLiving(maidInventory, (EntityLiving)entity);
                        k1 += EnchantmentHelper.getKnockbackModifier(maidInventory, (EntityLiving)entity);

                        if (isSprinting())
                        {
                            k1++;
                        }

                        if (j1 > 0 || l1 > 0)
                        {
                            boolean flag = motionY < 0.0D && !onGround && !isOnLadder() && !isInWater() && !isPotionActive(Potion.blindness);

                            if (flag)
                            {
                                j1 += rand.nextInt(j1 / 2 + 2);
                            }

                            j1 += l1;
                            boolean flag1 = entity.attackEntityFrom(DamageSource.causeMobDamage(this), j1);

                            if (flag1)
                            {
                                if (k1 > 0)
                                {
                                    entity.addVelocity(-MathHelper.sin((rotationYaw * (float)Math.PI) / 180F) * (float)k1 * 0.5F, 0.10000000000000001D, MathHelper.cos((rotationYaw * (float)Math.PI) / 180F) * (float)k1 * 0.5F);
                                    motionX *= 0.59999999999999998D;
                                    motionZ *= 0.59999999999999998D;
                                }

                                if (flag)
                                {
                                    mcGame.effectRenderer.addEffect(new EntityCrit2FX(worldObj, entity));
                                }

                                if (l1 > 0)
                                {
                                    EntityCrit2FX entitycrit2fx = new EntityCrit2FX(mcGame.theWorld, entity, "magicCrit");
                                    mcGame.effectRenderer.addEffect(entitycrit2fx);
                                }
                            }

                            if (itemstack != null)
                            {
                                itemstack.getItem().hitEntity(itemstack, entityliving1, maidAvatarEntity);
                            }

                            int i2 = EnchantmentHelper.getFireAspectModifier(maidInventory, entityliving1);

                            if (i2 > 0)
                            {
                                entity.setFire(i2 * 4);
                            }

                            if (EnchantmentHelper.getSilkTouchModifier(maidInventory))
                            {
                                entityliving1.dropFewItems(true, 0);
                                mod_littleMaidMob.Debug("Add Drop.");
                            }

                            if (EnchantmentHelper.getFortuneModifier(maidInventory) > 0)
                            {
                                entityliving1.recentlyHit = 60;
                                entityliving1.attackingPlayer = maidAvatarEntity;
                            }
                        }

                        mod_littleMaidMob.Debug(String.format("ID:%d, DamageTo:%d", new Object[]
                                {
                                    Integer.valueOf(entityId), Integer.valueOf(j1)
                                }));
                        setSprinting(false);
                        maidAvatarEntity.clearItemInUse();
                    }
                    else if (isMaskedMaid)
                    {
                        ItemArmor itemarmor = (ItemArmor)maidInventory.armorInventory[3].getItem();

                        if (itemarmor.renderIndex == 2 && f < 2.0F && attackTime > 5 && (entityliving1 instanceof EntityCreature) && ((EntityCreature)entityliving1).getEntityToAttack() == this && itemstack != null && !maidAvatarEntity.isUsingItem())
                        {
                            itemstack.useItemRightClick(worldObj, maidAvatarEntity);

                            if (itemstack == null || itemstack.getItemDamage() != j || itemstack.stackSize != l)
                            {
                                setSwing(20, EnumSoundLittleMaid.shoot_burst);
                                mod_littleMaidMob.Debug("throw.");
                            }
                        }

                        if (itemarmor.renderIndex == 3 && attackTime < 9 && f < 1.9F && onGround)
                        {
                            jump();
                        }

                        if (itemarmor.renderIndex == 4 && attackTime < 5)
                        {
                            setSprinting(f < 1.7F);
                        }
                    }

                    if (itemstack != null && itemstack.stackSize <= 0)
                    {
                        destroyCurrentEquippedItem();
                        getNextEquipItem();
                    }
                }

                break;
        }

        if (maidOverDriveTime > 0)
        {
            attackTime /= 2;
        }
    }

    /**
     * Takes a coordinate in and returns a weight to determine how likely this creature will try to path to the block.
     * Args: x, y, z
     */
    public float getBlockPathWeight(int i, int j, int k)
    {
        if (worldObj.getBlockMaterial(i, j, k).getCanBurn() || worldObj.getBlockMaterial(i, j, k) == Material.lava)
        {
            return 0.0F;
        }
        else
        {
            return super.getBlockPathWeight(i, j, k);
        }
    }

    /**
     * Gets the Icon Index of the item currently held
     */
    public int getItemIcon(ItemStack itemstack, int i)
    {
        int j = super.getItemIcon(itemstack, i);

        if (itemstack.itemID == Item.potion.shiftedIndex)
        {
            if (i == 1)
            {
                return itemstack.getIconIndex();
            }
            else
            {
                return 141;
            }
        }

        if (maidAvatarEntity.getItemInUse() != null && itemstack.itemID == Item.bow.shiftedIndex)
        {
            int k = itemstack.getMaxItemUseDuration() - maidAvatarEntity.getItemInUseCount();

            if (k >= 18)
            {
                return 133;
            }

            if (k > 13)
            {
                return 117;
            }

            if (k > 0)
            {
                return 101;
            }
        }

        return j;
    }

    /**
     * Returns the item that this EntityLiving is holding, if any.
     */
    public ItemStack getHeldItem()
    {
        if (getMaidMode() >= 3 || isMaidFreedom())
        {
            return maidInventory.getCurrentItem();
        }
        else
        {
            return null;
        }
    }

    /**
     * Returns the Y offset from the entity's position for any entity riding this one.
     */
    public double getMountedYOffset()
    {
        if (riddenByEntity instanceof EntityChicken)
        {
            return (double)height + 0.029999999999999999D;
        }

        if (riddenByEntity instanceof EntitySquid)
        {
            return (double)height - 0.20000000000000001D;
        }
        else
        {
            return super.getMountedYOffset() + 0.34999999999999998D;
        }
    }

    /**
     * Returns the Y Offset of this entity.
     */
    public double getYOffset()
    {
        if (ridingEntity instanceof EntityPlayer)
        {
            return (double)(yOffset - 1.5F);
        }
        else
        {
            return (double)(yOffset - 0.25F);
        }
    }

    /**
     * Decrements the entity's air supply when underwater
     */
    protected int decreaseAirSupply(int i)
    {
        int j = EnchantmentHelper.getRespiration(maidInventory);

        if (j > 0 && rand.nextInt(j + 1) > 0)
        {
            return i;
        }
        else
        {
            return super.decreaseAirSupply(i);
        }
    }

    /**
     * Reduces damage, depending on potions
     */
    protected int applyPotionDamageCalculations(DamageSource damagesource, int i)
    {
        int j = super.applyPotionDamageCalculations(damagesource, i);

        if (j <= 0)
        {
            return 0;
        }

        int k = EnchantmentHelper.getEnchantmentModifierDamage(maidInventory, damagesource);

        if (k > 20)
        {
            k = 20;
        }

        if (k > 0 && k <= 20)
        {
            int l = 25 - k;
            int i1 = j * l + carryoverDamage;
            j = i1 / 25;
            carryoverDamage = i1 % 25;
        }

        return j;
    }

    public boolean isBlocking()
    {
        ItemStack itemstack = maidAvatarEntity.getItemInUse();
        return maidAvatarEntity.isUsingItem() && Item.itemsList[itemstack.itemID].getItemUseAction(itemstack) == EnumAction.block;
    }

    protected void damageArmor(int i)
    {
        maidInventory.damageArmor(i);
    }

    /**
     * Returns the current armor value as determined by a call to InventoryPlayer.getTotalArmorValue
     */
    public int getTotalArmorValue()
    {
        return maidInventory.getTotalArmorValue();
    }

    /**
     * Deals damage to the entity. If its a EntityPlayer then will take damage from the armor first and then health
     * second with the reduced value. Args: damageAmount
     */
    protected void damageEntity(DamageSource damagesource, int i)
    {
        int j = i;

        if (damagesource == DamageSource.fall)
        {
            damageSound = EnumSoundLittleMaid.hurt_fall;
        }

        if (!damagesource.isUnblockable() && isBlocking())
        {
            mod_littleMaidMob.Debug(String.format("Blocking success ID:%d, %d", new Object[]
                    {
                        Integer.valueOf(entityId), Integer.valueOf(i)
                    }));
            i = 1 + i >> 1;
            damageSound = EnumSoundLittleMaid.hurt_guard;
        }

        i = applyArmorCalculations(damagesource, i);
        i = applyPotionDamageCalculations(damagesource, i);
        mod_littleMaidMob.Debug(String.format("GetDamage ID:%d, %s, %d/ %d", new Object[]
                {
                    Integer.valueOf(entityId), damagesource.damageType, Integer.valueOf(i), Integer.valueOf(j)
                }));

        if (i == 0 && damageSound == EnumSoundLittleMaid.hurt)
        {
            damageSound = EnumSoundLittleMaid.hurt_nodamege;
        }

        super.damageEntity(damagesource, i);

        if (maidMode == 11 && maidInventory.isItemExplord(maidInventory.currentItem))
        {
            if (timeSinceIgnited == -1)
            {
                worldObj.playSoundAtEntity(this, "random.fuse", 1.0F, 0.5F);
                timeSinceIgnited = 0;
            }

            if (entityToAttack == null)
            {
                setMaidWait(true);
            }
        }
    }

    /**
     * Determines if an entity can be despawned, used on idle far away entities
     */
    protected boolean canDespawn()
    {
        if (isMaidContract())
        {
            return false;
        }
        else
        {
            return mod_littleMaidMob.canDespawn || super.canDespawn();
        }
    }

    /**
     * Will get destroyed next tick
     */
    public void setDead()
    {
        if (gotcha != null)
        {
            EntityItem entityitem = new EntityItem(worldObj, gotcha.posX, gotcha.posY, gotcha.posZ, new ItemStack(Item.silk));
            worldObj.spawnEntityInWorld(entityitem);
            gotcha = null;
        }

        super.setDead();
    }

    /**
     * Returns the item ID for the item the mob drops on death.
     */
    protected int getDropItemId()
    {
        return Item.sugar.shiftedIndex;
    }

    /**
     * Drop 0-2 items of this living's type
     */
    protected void dropFewItems(boolean flag, int i)
    {
        int j = rand.nextInt(3 + i);

        for (int k = 0; k <= j; k++)
        {
            if (rand.nextInt(30) == 0)
            {
                dropItem(Item.slimeBall.shiftedIndex, 1);
            }

            if (rand.nextInt(50) == 0)
            {
                entityDropItem(new ItemStack(Item.dyePowder.shiftedIndex, 1, 3), 0.0F);
            }

            dropItem(Item.sugar.shiftedIndex, 1);
        }

        maidInventory.dropAllItems(timeSinceIgnited > 30);
        timeSinceIgnited = -1;
    }

    /**
     * Will return how many at most can spawn in a chunk at once.
     */
    public int getMaxSpawnedInChunk()
    {
        return mod_littleMaidMob.maxGroupSize;
    }

    /**
     * Checks if the entity's current position is a valid location to spawn this entity.
     */
    public boolean getCanSpawnHere()
    {
        int i = MathHelper.floor_double(posX);
        int j = MathHelper.floor_double(boundingBox.minY);
        int k = MathHelper.floor_double(posZ);
        boolean flag;

        if (mod_littleMaidMob.Dominant)
        {
            int l = 0;

            if (worldObj.getBlockLightValue(i, j, k) < 7)
            {
                l = rand.nextInt(2);
            }

            flag = l == 0 && worldObj.checkIfAABBIsClear(boundingBox) && worldObj.getCollidingBoundingBoxes(this, boundingBox).size() == 0 && !worldObj.isAnyLiquid(boundingBox) && getLittleMaidCount() <= mod_littleMaidMob.spawnLimit;
        }
        else
        {
            flag = super.getCanSpawnHere() && getLittleMaidCount() <= mod_littleMaidMob.spawnLimit;
        }

        return flag;
    }

    /**
     * Called when a player interacts with a mob. e.g. gets milk from a cow, gets into the saddle on a pig.
     */
    public boolean interact(EntityPlayer entityplayer)
    {
        if (entityplayer.riddenByEntity != null)
        {
            entityplayer.riddenByEntity.mountEntity(this);
            return true;
        }

        if (gotcha == null && entityplayer.fishEntity == null)
        {
            ItemStack itemstack = entityplayer.getCurrentEquippedItem();

            if (itemstack != null && itemstack.stackSize > 0)
            {
                if (itemstack.itemID == Item.silk.shiftedIndex)
                {
                    if (isMaidContract() && !entityplayer.username.equalsIgnoreCase(getMaidMaster()))
                    {
                        if (!worldObj.isRemote)
                        {
                            showParticleFX("smoke", 0.02D, 0.02D, 0.02D);
                            worldObj.setEntityState(this, (byte)8);
                        }

                        return true;
                    }

                    gotcha = entityplayer;
                    itemstack.stackSize--;

                    if (itemstack.stackSize <= 0)
                    {
                        itemstack.onItemDestroyedByUse(gotcha);
                        gotcha.destroyCurrentEquippedItem();
                    }

                    worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                    return true;
                }

                if (isMaidContract())
                {
                    if (itemstack.itemID == Item.sugar.shiftedIndex)
                    {
                        if (--itemstack.stackSize <= 0)
                        {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                        }

                        if (!entityplayer.username.equalsIgnoreCase(getMaidMaster()))
                        {
                            eatSugar(false, false);

                            if (!worldObj.isRemote)
                            {
                                showHappyFX();
                                worldObj.setEntityState(this, (byte)11);
                            }

                            return true;
                        }

                        if (maidMode == 3)
                        {
                            eatSugar(false, false);

                            if (!worldObj.isRemote)
                            {
                                showParticleFX("smoke", 0.02D, 0.02D, 0.02D);
                                worldObj.setEntityState(this, (byte)8);
                            }

                            return true;
                        }

                        eatSugar(false, true);
                        mod_littleMaidMob.Debug(String.format("ID:%d, LestDays:%.2f", new Object[]
                                {
                                    Integer.valueOf(entityId), Float.valueOf(getContractLimitDays())
                                }));

                        if (!worldObj.isRemote)
                        {
                            showHappyFX();
                            worldObj.setEntityState(this, (byte)11);
                            setPathToEntity(null);
                            setMaidWait(!isMaidWait());
                            setMaidFreedom(isMaidFreedom());
                        }

                        setFlag(1, false);
                        isJumping = false;
                        setTarget(null);
                        myFurnace = null;
                        myEntity = null;
                        myTile = null;

                        if (myChest != null)
                        {
                            myChest.closeChest();
                            myChest = null;
                        }

                        maidSearchCount = 0;
                        serchedChest.clear();

                        if (!isMaidWait())
                        {
                            maidInventory.currentItem = 0;
                            ItemStack itemstack1 = maidInventory.getStackInSlot(0);
                            setMaidMode(2);

                            if (itemstack1 != null && itemstack1.stackSize > 0)
                            {
                                Item item = itemstack1.getItem();

                                if ((item instanceof ItemSword) || GuiLittleMaidTriggerSelect.ListSword.contains(Integer.valueOf(item.shiftedIndex)))
                                {
                                    setMaidMode(4);
                                }
                                else if ((item instanceof ItemAxe) || GuiLittleMaidTriggerSelect.ListAxe.contains(Integer.valueOf(item.shiftedIndex)))
                                {
                                    setMaidMode(7);
                                }
                                else if ((item instanceof ItemBow) || GuiLittleMaidTriggerSelect.ListBow.contains(Integer.valueOf(item.shiftedIndex)))
                                {
                                    setMaidMode(8);
                                }
                                else if ((item instanceof ItemPotion) && !itemstack1.hasEffect())
                                {
                                    setMaidMode(15);
                                }
                                else if ((item instanceof ItemFood) || (item instanceof ItemPotion))
                                {
                                    setMaidMode(5);
                                }
                                else if (item instanceof ItemShears)
                                {
                                    setMaidMode(10);
                                }
                                else if (item.shiftedIndex == Block.torchWood.blockID)
                                {
                                    setMaidMode(13);
                                }
                                else if (maidInventory.isItemBurned(0))
                                {
                                    setMaidMode(6);
                                }
                                else if (maidInventory.isItemExplord(0))
                                {
                                    setMaidMode(11);
                                    timeSinceIgnited = -1;
                                }
                            }

                            mod_littleMaidMob.Debug(String.format("ID:%d, MaidMode:%d", new Object[]
                                    {
                                        Integer.valueOf(entityId), Integer.valueOf(maidMode)
                                    }));
                        }

                        return true;
                    }

                    if (!isMaidTracer() && itemstack.itemID == Item.feather.shiftedIndex && entityplayer.username.equalsIgnoreCase(getMaidMaster()))
                    {
                        if (--itemstack.stackSize <= 0)
                        {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                        }

                        mod_littleMaidMob.Debug(String.format("ID:%d, RestDays:%.2f", new Object[]
                                {
                                    Integer.valueOf(entityId), Float.valueOf(getContractLimitDays())
                                }));

                        if (!worldObj.isRemote)
                        {
                            setPathToEntity(null);
                            setMaidWait(false);
                            setMaidFreedom(!isMaidFreedom());
                            setTarget(null);
                        }

                        maidInventory.currentItem = 0;
                        setFlag(1, false);
                        getNextEquipItem();
                        playingRole = 0;

                        if (isMaidFreedom())
                        {
                            if (!worldObj.isRemote)
                            {
                                showParticleFX("reddust", 0.5D, 0.5D, 0.5D, 1.0D, 1.0D, 1.0D);
                                worldObj.setEntityState(this, (byte)9);
                            }

                            setHomePosition();
                        }
                        else
                        {
                            if (!worldObj.isRemote)
                            {
                                showParticleFX("smoke", 0.02D, 0.02D, 0.02D);
                                worldObj.setEntityState(this, (byte)8);
                            }
                        }

                        return true;
                    }

                    if (itemstack.itemID == Item.dyePowder.shiftedIndex &&  entityplayer.username.equalsIgnoreCase(getMaidMaster()))
                    {
                        if (--itemstack.stackSize <= 0)
                        {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                        }

                        if (!worldObj.isRemote)
                        {
                            setMaidColor(15 - itemstack.getItemDamage());
                        }

                        return true;
                    }

                    if (itemstack.itemID == Item.cake.shiftedIndex && maidMode == 3)
                    {
                        if (--itemstack.stackSize <= 0)
                        {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                        }

                        if (!entityplayer.username.equalsIgnoreCase(getMaidMaster()))
                        {
                            maidContractLimit = worldObj.getWorldTime() + 0x29040L;
                            setMaidContractLimit(maidContractLimit);

                            if (!worldObj.isRemote)
                            {
                                showHappyFX();
                                worldObj.setEntityState(this, (byte)11);
                                playLittleMaidSound(EnumSoundLittleMaid.getCake, true);
                            }

                            return true;
                        }

                        if (!worldObj.isRemote)
                        {
                            setMaidFreedom(false);
                            setMaidWait(false);
                            showHappyFX();
                            worldObj.setEntityState(this, (byte)11);
                            playLittleMaidSound(EnumSoundLittleMaid.Recontract, true);
                        }

                        maidContractLimit = worldObj.getWorldTime() + 0x29040L;
                        setMaidContractLimit(maidContractLimit);
                        setMaidMode(2);
                        return true;
                    }

                    if (itemstack.itemID == Item.gunpowder.shiftedIndex && entityplayer.username.equalsIgnoreCase(getMaidMaster()))
                    {
                        maidOverDriveTime = itemstack.stackSize * 10;
                        entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                        return true;
                    }

                    if (itemstack.itemID == Item.book.shiftedIndex && entityplayer.username.equalsIgnoreCase(getMaidMaster()))
                    {
                        if (--itemstack.stackSize <= 0)
                        {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                        }

                        //ModLoader.openGUI(entityplayer, new GuiLittleMaidIFF(worldObj));
                        entityplayer.openGui(mod_littleMaidMob.instance, 1, worldObj,0, 0, 0);
                        return true;
                    }

                    if (getMaidFreedom() && itemstack.itemID == Item.redstone.shiftedIndex && entityplayer.username.equalsIgnoreCase(getMaidMaster()))
                    {
                        if (--itemstack.stackSize <= 0)
                        {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                        }

                        if (!worldObj.isRemote)
                        {
                            setPathToEntity(null);
                            setMaidWait(false);
                            setMaidTracer(!isMaidTracer());

                            if (isMaidTracer())
                            {
                                showParticleFX("explode", 0.3D, 0.3D, 0.3D, 0.0D, 0.0D, 0.0D);
                                worldObj.setEntityState(this, (byte)10);
                            }
                            else
                            {
                                showParticleFX("reddust", 0.5D, 0.5D, 0.5D, 1.0D, 1.0D, 1.0D);
                                worldObj.setEntityState(this, (byte)9);
                            }
                        }

                        myEntity = null;
                        myTile = null;

                        if (myChest != null)
                        {
                            myChest.closeChest();
                            myChest = null;
                        }

                        return true;
                    }

                    if (itemstack.getItem() instanceof ItemPotion)
                    {
                        itemstack.stackSize--;

                        if (!worldObj.isRemote)
                        {
                            List list = ((ItemPotion)itemstack.getItem()).getEffects(itemstack);

                            if (list != null)
                            {
                                PotionEffect potioneffect;

                                for (Iterator iterator = list.iterator(); iterator.hasNext(); addPotionEffect(new PotionEffect(potioneffect)))
                                {
                                    potioneffect = (PotionEffect)iterator.next();
                                }
                            }
                        }

                        if (itemstack.stackSize <= 0)
                        {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, new ItemStack(Item.glassBottle));
                        }
                        else
                        {
                            entityplayer.inventory.addItemStackToInventory(new ItemStack(Item.glassBottle));
                        }

                        return true;
                    }

                    if (itemstack.itemID == Item.paper.shiftedIndex && entityplayer.username.equalsIgnoreCase(getMaidMaster()))
                    {
                        if (--itemstack.stackSize <= 0)
                        {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                        }
                        //ModLoader.openGUI(entityplayer, new GuiLittleMaidEditName(this));
                        entityplayer.openGui(mod_littleMaidMob.instance, 2, worldObj,entityId, 0, 0);
                        return true;
                    }

                    if (itemstack.itemID == Item.netherStalkSeeds.shiftedIndex && entityplayer.username.equalsIgnoreCase(getMaidMaster()))
                    {
                        if (--itemstack.stackSize <= 0)
                        {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                        }

                        if (!worldObj.isRemote)
                        {
                            if (mod_littleMaidMob.defaultTexture == "")
                            {
                                textureName = textureArmorName = TextureLittleMaid.textures.keySet().toArray()[rand.nextInt(TextureLittleMaid.getTextureCount())].toString();
                            }
                            else
                            {
                                textureName = textureArmorName = mod_littleMaidMob.defaultTexture;
                            }

                            maidColor = TextureLittleMaid.getRandomWildColor(textureName, rand);
                            mod_littleMaidMob.Debug(String.format("ID:%d, %s:%d", new Object[]
                                    {
                                        Integer.valueOf(entityId), textureName, Integer.valueOf(maidColor)
                                    }));

                            if (maidColor == -1)
                            {
                                textureName = textureArmorName = "default";
                                maidColor = 12;
                            }

                            setTextureName(textureName);
                            setTextureArmorName(textureArmorName);
                            setColor(maidColor);
                            setMaidContract(false);
                            setMaidMaster("");
                            setPathToEntity(null);
                            setMaidWait(false);
                            setMaidFreedom(true);
                            setEntityHealth(15);
                            showParticleFX("smoke", 0.02D, 0.02D, 0.02D);
                            worldObj.setEntityState(this, (byte)8);
                            maidContractTime = 0;
                            setMaidName("");
                            playLittleMaidSound(EnumSoundLittleMaid.death, true);
                        }

                        isJumping = false;
                        maidContractLimit = 0L;
                        setMaidContractLimit(maidContractLimit);
                        return true;
                    }
                }
                else if (itemstack.itemID == Item.cake.shiftedIndex)
                {
                    if (--itemstack.stackSize <= 0)
                    {
                        entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                    }

                    if (!worldObj.isRemote)
                    {
                        entityplayer.triggerAchievement(mod_littleMaidMob.ac_Contract);
                        setMaidContract(true);
                        setMaidMaster(entityplayer.username);
                    }

                    if (isDead)
                    {
                        isDead = false;
                    }

                    if (!worldObj.isRemote)
                    {
                        setPathToEntity(null);
                        setMaidWait(false);
                        setMaidFreedom(false);
                        setEntityHealth(20);
                        showContractFX();
                        worldObj.setEntityState(this, (byte)7);
                        playLittleMaidSound(EnumSoundLittleMaid.getCake, true);
                        maidContractTime = (int)worldObj.getWorldTime();
                        checkMaidContractTime();
                    }

                    isJumping = false;
                    maidContractLimit = maidContractTime + 0x29040L;
                    setMaidContractLimit(maidContractLimit);
                    //ModLoader.openGUI(entityplayer, new GuiLittleMaidEditName(this));
                    entityplayer.openGui(mod_littleMaidMob.instance, 2, worldObj,entityId, 0, 0);
                    return true;
                }
            }
        }
        else if (gotcha != null)
        {
            EntityItem entityitem = new EntityItem(worldObj, gotcha.posX, gotcha.posY, gotcha.posZ, new ItemStack(Item.silk));

            if (!worldObj.isRemote)
            {
                worldObj.spawnEntityInWorld(entityitem);
            }

            gotcha = null;
            return true;
        }

        if ((entityplayer instanceof EntityPlayerSP) && isMaidContract() && entityplayer.username.equalsIgnoreCase(getMaidMaster()))
        {
            //openGUIFlag = true;
            isJumping = false;

            if (!worldObj.isRemote)
            {
                setPathToEntity(null);
                //ModLoader.openGUI(entityplayer, new GuiLittleMaidInventory(this, entityplayer.inventory, maidInventory));
                entityplayer.openGui(mod_littleMaidMob.instance, mod_littleMaidMob.inventoryGUI, worldObj,getMaidContractTime(), 0, 0);
            }

            //mcGame.displayGuiScreen(new GuiLittleMaidInventory(this, entityplayer.inventory, maidInventory));
            serchedChest.clear();
            return true;
        }
        else
        {
            if (!worldObj.isRemote)
            {
                showParticleFX("smoke", 0.02D, 0.02D, 0.02D);
                worldObj.setEntityState(this, (byte)8);
            }

            return true;
        }
    }

    /**
     * Returns the sound this mob makes when it is hurt.
     */
    protected String getHurtSound()
    {
        playLittleMaidSound(damageSound, true);
        return null;
    }

    /**
     * Returns the sound this mob makes on death.
     */
    protected String getDeathSound()
    {
        playLittleMaidSound(EnumSoundLittleMaid.death, true);
        return null;
    }

    /**
     * Returns the sound this mob makes while it's alive.
     */
    protected String getLivingSound()
    {
        EnumSoundLittleMaid enumsoundlittlemaid = EnumSoundLittleMaid.Null;

        if (getMaidHealth() < 10)
        {
            enumsoundlittlemaid = EnumSoundLittleMaid.living_whine;
        }
        else if (rand.nextFloat() < mod_littleMaidMob.LivingVoiceRate)
        {
            if (maidTime > 23500 || maidTime < 1500)
            {
                enumsoundlittlemaid = EnumSoundLittleMaid.living_morning;
            }
            else if (maidTime < 12500)
            {
                enumsoundlittlemaid = EnumSoundLittleMaid.living_daytime;
            }
            else
            {
                enumsoundlittlemaid = EnumSoundLittleMaid.living_night;
            }
        }

        playLittleMaidSound(enumsoundlittlemaid, false);
        return null;
    }

    /**
     * [This function is used when two same-species animals in 'love mode' breed to generate the new baby animal.]
     */
    public EntityAnimal spawnBabyAnimal(EntityAnimal entityanimal)
    {
        return null;
    }

    public int getMaxHealth()
    {
        return !isMaidContract() ? 15 : 20;
    }

    /**
     * Returns true if the newer Entity AI code should be run
     */
    protected boolean isAIEnabled()
    {
        return false;
    }

    public void setTextureValue()
    {
        textureName = getTextureName();

        if (textureName == null)
        {
            return;
        }

        int i = getMaidColor();

        if (!isMaidContract())
        {
            i += 48;
        }

        texture = TextureLittleMaid.getTextureName(textureName, i);

        if (texture == null)
        {
            setNextTexturePackege(0);
            texture = TextureLittleMaid.getTextureName(textureName, i);
        }

        setSize(0.5F, 1.35F);
        textureModel[0] = null;
        textureModel[1] = null;
        textureModel[2] = null;
        int j = textureName.lastIndexOf('_');

        if (j > -1)
        {
            String s = textureName.substring(j + 1);
            ModelLittleMaid amodellittlemaid[] = (ModelLittleMaid[])TextureLittleMaid.modelMap.get(s);

            if (amodellittlemaid != null)
            {
                textureModel[0] = amodellittlemaid[0];
            }

            if (textureModel[0] != null)
            {
                setSize(textureModel[0].getWidth(), textureModel[0].getHeight());
                mod_littleMaidMob.Debug(String.format("ID:%d, TextureModel:%s", new Object[]
                        {
                            Integer.valueOf(entityId), s
                        }));
            }
        }

        setPosition(posX, posY, posZ);
        setArmorTextureValue();
    }

    public void setArmorTextureValue()
    {
        textureArmorName = getTextureArmorName();

        if (textureArmorName == null)
        {
            return;
        }

        int i = textureArmorName.lastIndexOf('_');

        if (i > -1)
        {
            String s = textureArmorName.substring(i + 1);
            ModelLittleMaid amodellittlemaid[] = (ModelLittleMaid[])TextureLittleMaid.modelMap.get(s);

            if (amodellittlemaid != null)
            {
                textureModel[1] = amodellittlemaid[1];
                textureModel[2] = amodellittlemaid[2];
            }
        }

        for (int j = 0; j < 4; j++)
        {
            ItemStack itemstack = maidInventory.armorItemInSlot(j);
            textureArmor0[j] = TextureLittleMaid.getArmorTextureName(textureArmorName, 64, itemstack);
            textureArmor1[j] = TextureLittleMaid.getArmorTextureName(textureArmorName, 80, itemstack);
        }
    }

    public void setNextTexturePackege(int i)
    {
        if (i == 0)
        {
            if (isMaidContract())
            {
                textureName = TextureLittleMaid.getNextPackege(textureName, getMaidColor());
            }
            else
            {
                textureName = TextureLittleMaid.getNextPackege(textureName, getMaidColor() + 48);
            }

            textureArmorName = textureName;

            if (TextureLittleMaid.armors.get(textureArmorName) == null)
            {
                i = 1;
            }
        }

        if (i == 1)
        {
            textureArmorName = TextureLittleMaid.getNextArmorPackege(textureArmorName);
        }

        setTextureName(textureName);
        setTextureArmorName(textureArmorName);
    }

    public void setPrevTexturePackege(int i)
    {
        if (i == 0)
        {
            if (isMaidContract())
            {
                textureName = TextureLittleMaid.getPrevPackege(textureName, getMaidColor());
            }
            else
            {
                textureName = TextureLittleMaid.getPrevPackege(textureName, getMaidColor() + 48);
            }

            textureArmorName = textureName;

            if (TextureLittleMaid.armors.get(textureArmorName) == null)
            {
                i = 1;
            }
        }

        if (i == 1)
        {
            textureArmorName = TextureLittleMaid.getPrevArmorPackege(textureArmorName);
        }

        setTextureName(textureName);
        setTextureArmorName(textureArmorName);
    }

    protected NBTTagList newIntNBTList(int ai[])
    {
        NBTTagList nbttaglist = new NBTTagList();
        int ai1[] = ai;
        int i = ai1.length;

        for (int j = 0; j < i; j++)
        {
            int k = ai1[j];
            nbttaglist.appendTag(new NBTTagInt(null, k));
        }

        return nbttaglist;
    }

    protected boolean getIFF(Entity entity)
    {
        if (entity == getMaidMasterEntity() || entity == null)
        {
            return true;
        }

        int i = GuiLittleMaidIFF.getIFF(entity);

        switch (i)
        {
            case 0:
                return false;

            case 2:
                return true;

            case 1:
                if (isBloodsuck())
                {
                    return false;
                }

                if ((entity instanceof EntityLittleMaid) && ((EntityLittleMaid)entity).playingRole > 0)
                {
                    return true;
                }

                if (entity instanceof EntityCreature)
                {
                    Entity entity1 = ((EntityCreature)entity).getEntityToAttack();

                    if (entity1 == masterEntity)
                    {
                        return false;
                    }

                    if (entity1 == this)
                    {
                        return false;
                    }

                    if ((entity1 instanceof EntityLittleMaid) && ((EntityLittleMaid)entity1).getMaidMasterEntity() == masterEntity)
                    {
                        return false;
                    }
                }

                return true;
        }

        return false;
    }

    public boolean canEntityItemBeSeen(Entity entity)
    {
        return worldObj.rayTraceBlocks(Vec3D.createVector(posX, posY + (double)getEyeHeight(), posZ), Vec3D.createVector(entity.posX, entity.posY + (entity.boundingBox.minY - entity.boundingBox.minY) / 2D, entity.posZ)) == null;
    }

    protected float updateRotation(float f, float f1, float f2)
    {
        float f3;

        for (f3 = f1 - f; f3 < -180F; f3 += 360F) { }

        for (; f3 >= 180F; f3 -= 360F) { }

        if (f3 > f2)
        {
            f3 = f2;
        }

        if (f3 < -f2)
        {
            f3 = -f2;
        }

        return f + f3;
    }

    public void faceXYZ(int i, int j, int k, float f, float f1)
    {
        double d = ((double)i + 0.5D) - posX;
        double d1 = ((double)k + 0.5D) - posZ;
        double d2 = ((double)j + 0.5D) - (posY + (double)getEyeHeight());
        double d3 = MathHelper.sqrt_double(d * d + d1 * d1);
        float f2 = (float)((Math.atan2(d1, d) * 180D) / Math.PI) - 90F;
        float f3 = (float)(-((Math.atan2(d2, d3) * 180D) / Math.PI));
        rotationPitch = updateRotation(rotationPitch, f3, f1);
        rotationYaw = updateRotation(rotationYaw, f2, f);
    }

    public void setPathToTile(boolean flag)
    {
        byte byte0 = ((byte)(tileY != MathHelper.floor_double(posY) || !flag ? 1 : 2));
        PathEntity pathentity;

        switch (worldObj.getBlockMetadata(tileX, tileY, tileZ))
        {
            case 3:
                pathentity = worldObj.getEntityPathToXYZ(this, tileX, tileY, tileZ + byte0, 16F, true, false, false, true);
                break;

            case 2:
                pathentity = worldObj.getEntityPathToXYZ(this, tileX, tileY, tileZ - byte0, 16F, true, false, false, true);
                break;

            case 5:
                pathentity = worldObj.getEntityPathToXYZ(this, tileX + byte0, tileY, tileZ, 16F, true, false, false, true);
                break;

            case 4:
                pathentity = worldObj.getEntityPathToXYZ(this, tileX - byte0, tileY, tileZ, 16F, true, false, false, true);
                break;

            default:
                pathentity = worldObj.getEntityPathToXYZ(this, tileX, tileY, tileZ, 16F, true, false, false, true);
                break;
        }

        setPathToEntity(pathentity);
    }

    protected void moveCooking()
    {
        setFlag(1, false);

        if (myFurnace == null)
        {
            if (maidInventory.isItemBurned(maidInventory.currentItem) && maidInventory.getSmeltingItem() > -1)
            {
                tileX = MathHelper.floor_double(posX);
                tileY = MathHelper.floor_double(posY);
                tileZ = MathHelper.floor_double(posZ);
                int i = -4;
                label0:

                do
                {
                    if (i >= 5)
                    {
                        break;
                    }

                    label1:

                    for (int j = -4; j < 5; j++)
                    {
                        int k = 0;

                        do
                        {
                            if (k >= 3)
                            {
                                continue label1;
                            }

                            int i1 = k != 2 ? k : -1;
                            TileEntity tileentity = worldObj.getBlockTileEntity(tileX + j, tileY + i1, tileZ + i);

                            if (tileentity != null && (tileentity instanceof TileEntityFurnace))
                            {
                                boolean flag = false;
                                int j1 = 0;

                                do
                                {
                                    if (j1 >= worldObj.loadedEntityList.size())
                                    {
                                        break;
                                    }

                                    Entity entity = (Entity)worldObj.loadedEntityList.get(j1);

                                    if (entity != null && (entity instanceof EntityLittleMaid) && ((EntityLittleMaid)entity).myFurnace == tileentity)
                                    {
                                        flag = true;
                                        break;
                                    }

                                    j1++;
                                }
                                while (true);

                                if (!flag)
                                {
                                    Vec3D vec3d = Vec3D.createVector(posX, posY + (double)getEyeHeight(), posZ);
                                    Vec3D vec3d1 = Vec3D.createVector((double)(tileX + j) + 0.5D, (double)(tileY + i1) + 0.5D, (double)(tileZ + i) + 0.5D);
                                    MovingObjectPosition movingobjectposition = worldObj.rayTraceBlocks(vec3d, vec3d1);

                                    if (movingobjectposition != null && movingobjectposition.typeOfHit == EnumMovingObjectType.TILE && movingobjectposition.blockX == tileX + j && movingobjectposition.blockY == tileY + i1 && movingobjectposition.blockZ == tileZ + i)
                                    {
                                        tileX += j;
                                        tileY += i1;
                                        tileZ += i;
                                        myFurnace = (TileEntityFurnace)tileentity;
                                        attackTime = 1;
                                        break label0;
                                    }
                                }
                            }

                            k++;
                        }
                        while (true);
                    }

                    i++;
                }
                while (true);
            }
        }
        else
        {
            TileEntity tileentity1 = worldObj.getBlockTileEntity(tileX, tileY, tileZ);

            if (tileentity1 != null && (tileentity1 instanceof TileEntityFurnace) && tileentity1 == myFurnace)
            {
                double d = getDistanceSq((double)tileX + 0.5D, (double)tileY + 0.5D, (double)tileZ + 0.5D);

                if (!hasPath() && d < 5D)
                {
                    if (myFurnace.isBurning())
                    {
                        if ((double)tileY <= posY)
                        {
                            setFlag(1, true);
                        }

                        faceXYZ(tileX, tileY, tileZ, 30F, 40F);
                        isMaidChaseWait = true;
                    }

                    if (attackTime <= 0)
                    {
                        boolean flag1 = false;
                        ItemStack itemstack1 = myFurnace.getStackInSlot(2);

                        if (itemstack1 != null && itemstack1.stackSize > 0 && maidInventory.addItemStackToInventory(itemstack1))
                        {
                            myFurnace.setInventorySlotContents(2, null);
                            worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                            setSwing(5, EnumSoundLittleMaid.cookingOver);

                            if (!maidInventory.isItemBurned(maidInventory.currentItem))
                            {
                                getNextEquipItem();
                            }

                            flag1 = true;
                        }

                        if (!flag1 && myFurnace.getStackInSlot(0) == null)
                        {
                            int l = maidInventory.getSmeltingItem();

                            if (l > -1)
                            {
                                ItemStack itemstack = maidInventory.getStackInSlot(l);
                                myFurnace.setInventorySlotContents(0, itemstack);
                                maidInventory.setInventorySlotContents(l, null);
                                worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                                setSwing(5, EnumSoundLittleMaid.cookingStart);
                                flag1 = true;
                            }
                        }

                        if (!flag1 && myFurnace.getStackInSlot(1) == null && myFurnace.getStackInSlot(0) != null && maidInventory.isItemBurned(maidInventory.currentItem))
                        {
                            myFurnace.setInventorySlotContents(1, maidInventory.getCurrentItem());
                            maidInventory.setInventoryCurrentSlotContents(null);
                            getNextEquipItem();
                            worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                            setSwing(5, EnumSoundLittleMaid.addFuel);
                            flag1 = true;
                        }

                        if (!flag1 && !myFurnace.isBurning() && myFurnace.getStackInSlot(1) != null && maidInventory.addItemStackToInventory(myFurnace.getStackInSlot(1)))
                        {
                            myFurnace.setInventorySlotContents(1, null);
                            worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                            setSwing(5, EnumSoundLittleMaid.Null);
                            flag1 = true;
                        }

                        if (flag1)
                        {
                            isMaidChaseWait = true;
                        }
                    }
                }
                else if (d < 100D)
                {
                    if (entityToAttack == null)
                    {
                        setPathToTile(true);
                        isMaidChaseWait = true;
                    }
                }
                else
                {
                    myFurnace = null;
                }
            }
            else
            {
                myFurnace = null;
            }
        }
    }

    private boolean getChest(World world, int i, int j, int k)
    {
        Object obj = (TileEntityChest)world.getBlockTileEntity(i, j, k);
        TileEntityChest tileentitychest = null;

        if (obj == null)
        {
            return true;
        }

        serchedChest.add(obj);

        if (world.isBlockNormalCube(i, j + 1, k))
        {
            return true;
        }

        if (world.getBlockId(i - 1, j, k) == Block.chest.blockID && world.isBlockNormalCube(i - 1, j + 1, k))
        {
            return true;
        }

        if (world.getBlockId(i + 1, j, k) == Block.chest.blockID && world.isBlockNormalCube(i + 1, j + 1, k))
        {
            return true;
        }

        if (world.getBlockId(i, j, k - 1) == Block.chest.blockID && world.isBlockNormalCube(i, j + 1, k - 1))
        {
            return true;
        }

        if (world.getBlockId(i, j, k + 1) == Block.chest.blockID && world.isBlockNormalCube(i, j + 1, k + 1))
        {
            return true;
        }

        if (world.getBlockId(i - 1, j, k) == Block.chest.blockID)
        {
            tileentitychest = (TileEntityChest)world.getBlockTileEntity(i - 1, j, k);
            obj = new InventoryLargeChest("Large chest", tileentitychest, ((IInventory)(obj)));
        }

        if (world.getBlockId(i + 1, j, k) == Block.chest.blockID)
        {
            tileentitychest = (TileEntityChest)world.getBlockTileEntity(i + 1, j, k);
            obj = new InventoryLargeChest("Large chest", ((IInventory)(obj)), tileentitychest);
        }

        if (world.getBlockId(i, j, k - 1) == Block.chest.blockID)
        {
            tileentitychest = (TileEntityChest)world.getBlockTileEntity(i, j, k - 1);
            obj = new InventoryLargeChest("Large chest", tileentitychest, ((IInventory)(obj)));
        }

        if (world.getBlockId(i, j, k + 1) == Block.chest.blockID)
        {
            tileentitychest = (TileEntityChest)world.getBlockTileEntity(i, j, k + 1);
            obj = new InventoryLargeChest("Large chest", ((IInventory)(obj)), tileentitychest);
        }

        if (tileentitychest != null)
        {
            serchedChest.add(tileentitychest);
        }

        if (world.isRemote)
        {
            return false;
        }
        else
        {
            myChest = ((IInventory)(obj));
            return true;
        }
    }

    protected void putChest()
    {
        if (attackTime <= 0 && myChest != null)
        {
            mod_littleMaidMob.Debug(String.format("getChest:%d", new Object[]
                    {
                        Integer.valueOf(maidSearchCount)
                    }));
            ItemStack itemstack;

            for (; (itemstack = maidInventory.getStackInSlot(maidSearchCount)) == null && maidSearchCount < maidInventory.mainInventory.length; maidSearchCount++) { }

            if (itemstack != null && itemstack.getItem().shiftedIndex != Item.sugar.shiftedIndex && itemstack.getItem().shiftedIndex != Item.pocketSundial.shiftedIndex && itemstack != maidInventory.armorItemInSlot(3))
            {
                boolean flag = false;

                for (int i = 0; i < myChest.getSizeInventory() && itemstack.stackSize > 0; i++)
                {
                    ItemStack itemstack1 = myChest.getStackInSlot(i);

                    if (itemstack1 == null)
                    {
                        myChest.setInventorySlotContents(i, itemstack.copy());
                        itemstack.stackSize = 0;
                        flag = true;
                        break;
                    }

                    if (!itemstack1.isStackable() || !itemstack1.isItemEqual(itemstack))
                    {
                        continue;
                    }

                    flag = true;
                    itemstack1.stackSize += itemstack.stackSize;

                    if (itemstack1.stackSize > itemstack1.getMaxStackSize())
                    {
                        itemstack.stackSize = itemstack1.stackSize - itemstack1.getMaxStackSize();
                        itemstack1.stackSize = itemstack1.getMaxStackSize();
                        continue;
                    }

                    itemstack.stackSize = 0;
                    break;
                }

                if (itemstack.stackSize <= 0)
                {
                    maidInventory.setInventorySlotContents(maidSearchCount, null);
                }

                if (flag)
                {
                    worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                    setSwing(2, EnumSoundLittleMaid.Null);
                }
            }

            if (++maidSearchCount >= maidInventory.mainInventory.length)
            {
                myTile = null;
                myEntity = null;
                myChest.closeChest();
                myChest = null;
                lastdistance = 0.0D;
                mod_littleMaidMob.Debug("endChest.");

                if (maidInventory.getFirstEmptyStack() > -1)
                {
                    mod_littleMaidMob.Debug("Search clear.");
                    serchedChest.clear();
                }
            }
        }
    }

    protected void moveEscorter()
    {
        if (myTile == null && myEntity == null)
        {
            List list = worldObj.getEntitiesWithinAABB(net.minecraft.src.EntityMinecart.class, boundingBox.expand(8D, 2D, 8D));
            double d2 = 256D;
            Iterator iterator = list.iterator();

            do
            {
                if (!iterator.hasNext())
                {
                    break;
                }

                EntityMinecart entityminecart = (EntityMinecart)iterator.next();

                if (serchedChest.indexOf(entityminecart) == -1 && entityminecart.minecartType == 1)
                {
                    double d3 = entityminecart.getDistanceSqToEntity(this);

                    if (d2 > d3 && canEntityBeSeen(entityminecart))
                    {
                        myEntity = entityminecart;
                        d2 = d3;
                    }
                }
            }
            while (true);

            tileX = MathHelper.floor_double(posX + 0.5D);
            tileY = MathHelper.floor_double(posY);
            tileZ = MathHelper.floor_double(posZ + 0.5D);
            int i = MathHelper.floor_float((rotationYaw * 4F) / 360F + 2.5F) & 3;
            int j = tileX;
            int k = tileZ;
            clearDummy();
            boolean flag = false;
            label0:

            for (int l = 0; l < 4; l++)
            {
                int i1 = 0;

                do
                {
                    if (i1 >= 18)
                    {
                        break;
                    }

                    int j1 = i1 / 2;

                    if (i == 0)
                    {
                        j = tileX - j1;
                        k = tileZ - j1;
                    }
                    else if (i == 1)
                    {
                        j = tileX + j1;
                        k = tileZ - j1;
                    }
                    else if (i == 2)
                    {
                        j = tileX + j1;
                        k = tileZ + j1;
                    }
                    else if (i == 3)
                    {
                        j = tileX - j1;
                        k = tileZ + j1;
                    }

                    if (!flag)
                    {
                        setDummyEntity(0xff4f4f, j, tileY, k);
                        flag = true;
                    }

                    int k1 = 0;

                    do
                    {
                        int l1 = -1;

                        do
                        {
                            if (l1 >= 2)
                            {
                                break;
                            }

                            int i2 = tileY + l1;
                            TileEntity tileentity = worldObj.getBlockTileEntity(j, i2, k);

                            if (tileentity != null && (tileentity instanceof TileEntityChest) && serchedChest.indexOf(tileentity) == -1 && canBlockBeSeen(j, i2, k, false, true, false))
                            {
                                setDummyEntity(0x4fff4f, j, i2, k);
                                flag = true;
                                myTile = tileentity;
                                tileX = j;
                                tileY = i2;
                                tileZ = k;
                                maidSearchCount = 0;
                                isMaidChaseWait = true;
                                mod_littleMaidMob.Debug(String.format("Catch-chest:%d, %,d %d", new Object[]
                                        {
                                            Integer.valueOf(tileX), Integer.valueOf(tileY), Integer.valueOf(tileZ)
                                        }));
                                break label0;
                            }

                            l1++;
                        }
                        while (true);

                        if (!flag)
                        {
                            setDummyEntity(0xffffcf, j, tileY, k);
                            flag = true;
                        }

                        flag = false;

                        if (i == 0)
                        {
                            j++;
                        }
                        else if (i == 1)
                        {
                            k++;
                        }
                        else if (i == 2)
                        {
                            j--;
                        }
                        else if (i == 3)
                        {
                            k--;
                        }
                    }
                    while (++k1 < i1);

                    i1 += 2;
                }
                while (true);

                i = i + 1 & 3;
            }

            if (myEntity != null && myTile != null)
            {
                if (d2 < getDistanceSq((double)tileX + 0.5D, (double)tileY + 0.5D, (double)tileZ + 0.5D))
                {
                    myTile = null;
                }
                else
                {
                    myEntity = null;
                }
            }
        }
        else
        {
            isMaidChaseWait = true;

            if (myTile != null)
            {
                if (worldObj.getBlockTileEntity(tileX, tileY, tileZ) == myTile)
                {
                    if (!hasPath() && getDistanceSq((double)tileX + 0.5D, tileY, (double)tileZ + 0.5D) < 5D)
                    {
                    	if (canBlockBeSeen(tileX, tileY, tileZ, false, true, false)){
	                        if (myChest == null)
	                        {
	                            getChest(worldObj, tileX, tileY, tileZ);

	                            if (myChest != null)
	                            {
	                                myChest.openChest();
	                            }
	                            else
	                            {
	                                myTile = null;
	                            }
	                        }

	                        if (myChest != null)
	                        {
	                            faceXYZ(tileX, tileY, tileZ, 30F, 40F);
	                        }

	                        putChest();
                    	}else{
	                    	myTile = null;
	                    	if (myChest != null){
                    		myChest.closeChest();
                    		myChest = null;
                    	}
                    }
                    }
                    else if (!isMaidWaitEx())
                    {
                        double d = getDistanceSq((double)tileX + 0.5D, tileY, (double)tileZ + 0.5D);

                        if (d == lastdistance)
                        {
                            mod_littleMaidMob.Debug("Assert.");
                            updateWanderPath();
                        }
                        else
                        {
                            setPathToTile(false);
                        }

                        lastdistance = d;

                        if (myChest != null)
                        {
                            myChest.closeChest();
                            myChest = null;
                        }
                    }
                }
                else
                {
                    myTile = null;

                    if (myChest != null)
                    {
                        myChest.closeChest();
                        myChest = null;
                    }
                }
            }
            else if (myEntity != null)
            {
                if (!myEntity.isDead)
                {
                    if (getDistanceSqToEntity(myEntity) < 5D)
                    {
                        setPathToEntity(null);

                        if (myChest == null)
                        {
                            myChest = (EntityMinecart)myEntity;
                            serchedChest.add((EntityMinecart)myEntity);
                            myChest.openChest();
                        }

                        if (myChest != null)
                        {
                            faceEntity(myEntity, 30F, 40F);
                        }

                        putChest();
                    }
                    else if (!isMaidWaitEx())
                    {
                        double d1 = getDistanceSqToEntity(myEntity);

                        if (d1 == lastdistance)
                        {
                            mod_littleMaidMob.Debug("Assert.");
                            updateWanderPath();
                        }
                        else
                        {
                            setPathToEntity(worldObj.getPathEntityToEntity(this, myEntity, 16F, true, false, false, true));
                        }

                        lastdistance = d1;

                        if (myChest != null)
                        {
                            myChest.closeChest();
                            myChest = null;
                        }
                    }
                }
                else
                {
                    myEntity = null;

                    if (myChest != null)
                    {
                        myChest.closeChest();
                        myChest = null;
                    }
                }
            }
        }
    }

    protected int getBlockLighting(int i, int j, int k)
    {
        if (worldObj.getBlockMaterial(i, j - 1, k).isSolid() && worldObj.getBlockId(i, j, k) == 0)
        {
            return worldObj.getBlockLightValue(i, j, k);
        }
        else
        {
            return 32;
        }
    }

    protected boolean canBlockBeSeen(int i, int j, int k, boolean flag, boolean flag1, boolean flag2)
    {
        Vec3D vec3d = Vec3D.createVector(posX, posY + (double)getEyeHeight(), posZ);
        Vec3D vec3d1 = Vec3D.createVector((double)i + 0.5D, (double)j + (flag ? 0.90000000000000002D : 0.5D), (double)k + 0.5D);
        MovingObjectPosition movingobjectposition = worldObj.rayTraceBlocks_do_do(vec3d, vec3d1, flag1, flag2);

        if (movingobjectposition == null)
        {
            return false;
        }

        return movingobjectposition.typeOfHit == EnumMovingObjectType.TILE && movingobjectposition.blockX == MathHelper.floor_double(vec3d1.xCoord) && movingobjectposition.blockY == MathHelper.floor_double(vec3d1.yCoord) && movingobjectposition.blockZ == MathHelper.floor_double(vec3d1.zCoord);
    }

    protected void moveTorcher()
    {
        if (tileX == 2 || masterEntity == null)
        {
            tileX = 0;
            return;
        }

        int i = MathHelper.floor_double(posX);
        int j = MathHelper.floor_double(posY);
        int k = MathHelper.floor_double(posZ);
        int l = i;
        int i1 = j;
        int k1 = k;
        double d = 0.5D + (double)MathHelper.sin(masterEntity.rotationYaw * 0.01745329F) * 2D;
        double d1 = 0.5D - (double)MathHelper.cos(masterEntity.rotationYaw * 0.01745329F) * 2D;
        int l1 = MathHelper.floor_float((rotationYaw * 4F) / 360F + 2.5F) & 3;
        double d2 = 0.0D;
        byte byte0 = 15;
        PathEntity pathentity = null;
        clearDummy();
        boolean flag = false;
        setDummyEntity(0x4f4fff, masterEntity.posX - d, j, masterEntity.posZ - d1);
        int j2 = 0;
        label0:

        do
        {
            if (j2 >= 4)
            {
                break;
            }

            for (int k2 = 2; k2 < 18 && pathentity == null; k2 += 2)
            {
                int l2 = k2 / 2;

                if (l1 == 0)
                {
                    l = i - l2;
                    k1 = k - l2;
                }
                else if (l1 == 1)
                {
                    l = i + l2;
                    k1 = k - l2;
                }
                else if (l1 == 2)
                {
                    l = i + l2;
                    k1 = k + l2;
                }
                else if (l1 == 3)
                {
                    l = i - l2;
                    k1 = k + l2;
                }

                if (!flag)
                {
                    setDummyEntity(0xff4f4f, l, j, k1);
                    flag = true;
                }

                for (int i3 = 0; i3 < k2; i3++)
                {
                    for (int j3 = -1; j3 < 1; j3++)
                    {
                        int j1 = j + j3;
                        double d3 = masterEntity.getDistanceSq((double)l + d, j1, (double)k1 + d1);

                        if (d3 <= 10D)
                        {
                            continue;
                        }

                        if (!flag)
                        {
                            setDummyEntity(0xffffcf, l, j, k1);
                            flag = true;
                        }

                        int i2 = getBlockLighting(l, j1, k1);

                        if (i2 >= 8 || !canBlockBeSeen(l, j1 - 1, k1, true, true, false))
                        {
                            continue;
                        }

                        pathentity = worldObj.getEntityPathToXYZ(this, l, j1 - 1, k1, 10F, true, false, false, true);

                        if (pathentity != null)
                        {
                            break label0;
                        }
                    }

                    if (l1 == 0)
                    {
                        l++;
                    }
                    else if (l1 == 1)
                    {
                        k1++;
                    }
                    else if (l1 == 2)
                    {
                        l--;
                    }
                    else if (l1 == 3)
                    {
                        k1--;
                    }

                    flag = false;
                }
            }

            l1 = l1 + 1 & 3;
            j2++;
        }
        while (true);

        if (pathentity != null)
        {
            playLittleMaidSound(EnumSoundLittleMaid.findTarget_D, false);
            setPathToEntity(pathentity);
            tileX = 1;
        }
        else
        {
            tileX = 0;
        }
    }

    protected boolean checkSnows(int i, int j, int k)
    {
        boolean flag = true;
        flag &= worldObj.getBlockId(i, j, k) == Block.snow.blockID;
        flag &= worldObj.getBlockId(i + 1, j, k) == Block.snow.blockID;
        flag &= worldObj.getBlockId(i - 1, j, k) == Block.snow.blockID;
        flag &= worldObj.getBlockId(i, j, k + 1) == Block.snow.blockID;
        flag &= worldObj.getBlockId(i, j, k - 1) == Block.snow.blockID;
        return flag;
    }

    protected boolean movePlaying()
    {
        int i = MathHelper.floor_double(posX);
        int j = MathHelper.floor_double(posY);
        int k = MathHelper.floor_double(posZ);
        PathEntity pathentity = null;
        int l = 2;
        label0:

        do
        {
            if (l >= 18 || pathentity != null)
            {
                break;
            }

            i--;
            k--;

            for (int i1 = 0; i1 < l; i1++)
            {
                for (int j1 = 0; j1 < 4; j1++)
                {
                    if (checkSnows(i, j, k))
                    {
                        pathentity = worldObj.getEntityPathToXYZ(this, i, j - 1, k, 10F, true, false, false, true);

                        if (pathentity != null)
                        {
                            break label0;
                        }
                    }

                    if (j1 == 0)
                    {
                        i++;
                    }

                    if (j1 == 1)
                    {
                        k++;
                    }

                    if (j1 == 2)
                    {
                        i--;
                    }

                    if (j1 == 3)
                    {
                        k--;
                    }
                }
            }

            l += 2;
        }
        while (true);

        if (pathentity != null)
        {
            setPathToEntity(pathentity);
            tileX = 1;
            mod_littleMaidMob.Debug(String.format("Find Snow Area-%d:%d, %d, %d.", new Object[]
                    {
                        Integer.valueOf(entityId), Integer.valueOf(i), Integer.valueOf(j), Integer.valueOf(k)
                    }));
            return true;
        }
        else
        {
            tileX = 0;
            return false;
        }
    }

    protected void playing()
    {
        setFlag(1, false);
        setFlag(2, false);

        if (playingRole == 0)
        {
            int i = MathHelper.floor_double(posX);
            int j = MathHelper.floor_double(posY);
            int k = MathHelper.floor_double(posZ);
            boolean flag = true;

            for (int l = -1; l < 2; l++)
            {
                for (int i1 = -1; i1 < 2; i1++)
                {
                    flag &= worldObj.getBlockId(i + i1, j, k + l) == Block.snow.blockID;
                }
            }

            playingRole = rand.nextInt(100) - 97;
            playingRole = !flag || playingRole <= 0 ? 0 : playingRole * 10;

            if (!flag);
        }

        if (playingRole != 0 && !worldObj.isDaytime())
        {
            playingRole = 0;
            setTarget(null);
            getNextEquipItem();
        }

        if (playingRole != 0)
        {
            switch (playingRole)
            {
                case 10:
                case 20:
                    if (!getNextEquipItem())
                    {
                        setTarget(null);
                        setPathToEntity(null);
                        playingRole++;
                    }

                    break;

                case 11:
                case 21:
                    setTarget(null);

                    if (hasPath())
                    {
                        playingRole++;
                    }

                    break;

                case 12:
                case 22:
                    if (entityToAttack == null && !hasPath())
                    {
                        if (movePlaying())
                        {
                            playingRole++;
                        }
                        else
                        {
                            playingRole = 0;
                        }
                    }
                    else
                    {
                        setTarget(null);
                    }

                    break;

                case 13:
                case 23:
                    if (!hasPath())
                    {
                        if (checkSnows(MathHelper.floor_double(posX), MathHelper.floor_double(posY), MathHelper.floor_double(posZ)))
                        {
                            isMaidChaseWait = true;
                            attackTime = 30;
                            playingRole++;
                        }
                        else
                        {
                            playingRole--;
                        }
                    }

                    break;

                case 24:
                case 25:
                case 26:
                case 27:
                    if (attackTime <= 0)
                    {
                        if (maidInventory.addItemStackToInventory(new ItemStack(Item.snowball)))
                        {
                            worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);

                            if (playingRole == 27)
                            {
                                setSwing(5, EnumSoundLittleMaid.collect_snow);
                                playingRole = 20;
                            }
                            else
                            {
                                setSwing(30, EnumSoundLittleMaid.collect_snow);
                                playingRole++;
                            }
                        }
                        else
                        {
                            playingRole = 0;
                        }
                    }

                    isMaidChaseWait = true;
                    isJumping = false;
                    setPathToEntity(null);
                    faceXYZ(MathHelper.floor_double(posX), MathHelper.floor_double(posY - 1.0D), MathHelper.floor_double(posZ), 30F, 40F);
                    setFlag(2, true);
                    break;

                case 14:
                    if (attackTime <= 0)
                    {
                        if (maidInventory.addItemStackToInventory(new ItemStack(Item.snowball)))
                        {
                            setSwing(5, EnumSoundLittleMaid.collect_snow);
                            worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                            playingRole = 10;
                        }
                        else
                        {
                            playingRole = 0;
                        }
                    }

                    setFlag(1, true);
                    faceXYZ(MathHelper.floor_double(posX), MathHelper.floor_double(posY - 1.0D), MathHelper.floor_double(posZ), 30F, 40F);
                    break;
            }

            if (playingRole == 0)
            {
                setTarget(null);
            }
        }
    }

    protected boolean moveTracer()
    {
        int par1posx = MathHelper.floor_double(posX);
        int par2posy = MathHelper.floor_double(posY);
        int par3posz = MathHelper.floor_double(posZ);
        int par4posx = par1posx;
        int par5posy = par2posy;
        int par6posz = par3posz;
        double d = 0.0D;
        int l1 = MathHelper.floor_float((rotationYaw * 4F) / 360F + 2.5F) & 3;
        PathEntity pathentity = null;
        clearDummy();
        boolean flag = false;
        setDummyEntity(0x4f4fff, par4posx, par2posy, par6posz);
        flag = true;
        label0:

        for (int i2 = 0; i2 < 4; i2++)
        {
            int j2 = 2;

            do
            {
                if (j2 >= 14)
                {
                    break;
                }

                int k2 = j2 / 2;

                if (l1 == 0)
                {
                    par4posx = par1posx - k2;
                    par6posz = par3posz - k2;
                }
                else if (l1 == 1)
                {
                    par4posx = par1posx + k2;
                    par6posz = par3posz - k2;
                }
                else if (l1 == 2)
                {
                    par4posx = par1posx + k2;
                    par6posz = par3posz + k2;
                }
                else if (l1 == 3)
                {
                    par4posx = par1posx - k2;
                    par6posz = par3posz + k2;
                }

                if (!flag)
                {
                    setDummyEntity(0xff4f4f, par4posx, par2posy, par6posz);
                    flag = true;
                }

                for (int l2 = 0; l2 < j2; l2++)
                {
                    int i3 = -3;

                    do
                    {
                        if (i3 >= 3)
                        {
                            break;
                        }

                        int j1 = par2posy + i3;

                        if (worldObj.isBlockIndirectlyProvidingPowerTo(par4posx, j1, par6posz, 0) && (canBlockBeSeen(par4posx, j1, par6posz, true, true, false) || canBlockBeSeen(par4posx, j1 - 1, par6posz, true, true, false)))
                        {
                            if (!flag)
                            {
                                setDummyEntity(0x4fff4f, par4posx, par2posy, par6posz);
                                flag = true;
                            }

                            double d1 = getDistanceSq(par4posx, j1, par6posz);

                            if (lastdistance != d1)
                            {
                                pathentity = worldObj.getEntityPathToXYZ(this, par4posx, j1, par6posz, 10F, true, false, false, true);

                                if (pathentity != null)
                                {
                                    lastdistance = d1;
                                    break label0;
                                }
                            }
                        }

                        i3++;
                    }
                    while (true);

                    if (!flag)
                    {
                        setDummyEntity(0xffffcf, par4posx, par2posy, par6posz);
                    }

                    flag = false;

                    if (l1 == 0)
                    {
                        par4posx++;
                        continue;
                    }

                    if (l1 == 1)
                    {
                        par6posz++;
                        continue;
                    }

                    if (l1 == 2)
                    {
                        par4posx--;
                        continue;
                    }

                    if (l1 == 3)
                    {
                        par6posz--;
                    }
                }

                j2 += 2;
            }
            while (true);

            l1 = l1 + 1 & 3;
        }

        if (pathentity != null)
        {
            setPathToEntity(pathentity);
            return true;
        }
        else
        {
            return false;
        }
    }

    protected void movePharmacist()
    {
        setFlag(1, false);

        if (myTile == null)
        {
            tileX = MathHelper.floor_double(posX);
            tileY = MathHelper.floor_double(posY);
            tileZ = MathHelper.floor_double(posZ);
            int i = -4;
            label0:

            do
            {
                if (i >= 5)
                {
                    break;
                }

                label1:

                for (int j = -4; j < 5; j++)
                {
                    int k = 0;

                    do
                    {
                        if (k >= 3)
                        {
                            continue label1;
                        }

                        int l = k != 2 ? k : -1;
                        TileEntity tileentity = worldObj.getBlockTileEntity(tileX + j, tileY + l, tileZ + i);

                        if (tileentity != null && (tileentity instanceof TileEntityBrewingStand))
                        {
                            boolean flag = false;
                            int i1 = 0;

                            do
                            {
                                if (i1 >= worldObj.loadedEntityList.size())
                                {
                                    break;
                                }

                                Entity entity = (Entity)worldObj.loadedEntityList.get(i1);

                                if (entity != null && (entity instanceof EntityLittleMaid) && ((EntityLittleMaid)entity).myTile == tileentity)
                                {
                                    flag = true;
                                    break;
                                }

                                i1++;
                            }
                            while (true);

                            if (!flag)
                            {
                                Vec3D vec3d = Vec3D.createVector(posX, posY + (double)getEyeHeight(), posZ);
                                Vec3D vec3d1 = Vec3D.createVector((double)(tileX + j) + 0.5D, (double)(tileY + l) + 0.10000000000000001D, (double)(tileZ + i) + 0.5D);
                                MovingObjectPosition movingobjectposition = worldObj.rayTraceBlocks(vec3d, vec3d1);

                                if (movingobjectposition != null && movingobjectposition.typeOfHit == EnumMovingObjectType.TILE && movingobjectposition.blockX == tileX + j && movingobjectposition.blockY == tileY + l && movingobjectposition.blockZ == tileZ + i)
                                {
                                    tileX += j;
                                    tileY += l;
                                    tileZ += i;
                                    myTile = (TileEntityBrewingStand)tileentity;
                                    attackTime = 1;
                                    break label0;
                                }
                            }
                        }

                        k++;
                    }
                    while (true);
                }

                i++;
            }
            while (true);
        }
        else
        {
            TileEntity tileentity1 = worldObj.getBlockTileEntity(tileX, tileY, tileZ);

            if (tileentity1 != null && (tileentity1 instanceof TileEntityBrewingStand) && tileentity1 == myTile)
            {
                TileEntityBrewingStand tileentitybrewingstand = (TileEntityBrewingStand)myTile;
                double d = getDistanceSq((double)tileX + 0.5D, (double)tileY + 0.5D, (double)tileZ + 0.5D);

                if (!hasPath() && d < 5D)
                {
                    boolean flag1 = false;

                    if (attackTime <= 0)
                    {
                        ItemStack itemstack2 = tileentitybrewingstand.getStackInSlot(3);

                        if (itemstack2 != null && tileentitybrewingstand.getBrewTime() <= 0)
                        {
                            if ((double)tileY <= posY)
                            {
                                setFlag(1, true);
                            }

                            faceXYZ(tileX, tileY, tileZ, 30F, 40F);
                            flag1 = true;

                            if (maidInventory.addItemStackToInventory(itemstack2))
                            {
                                tileentitybrewingstand.setInventorySlotContents(3, null);
                                worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                                setSwing(5, EnumSoundLittleMaid.Null);
                            }
                        }

                        if (!flag1 && maidSearchCount > maidInventory.mainInventory.length)
                        {
                            for (int j1 = 0; j1 < 3 && !flag1; j1++)
                            {
                                ItemStack itemstack = tileentitybrewingstand.getStackInSlot(j1);

                                if (itemstack != null && maidInventory.addItemStackToInventory(itemstack))
                                {
                                    tileentitybrewingstand.setInventorySlotContents(j1, null);
                                    worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                                    setSwing(5, EnumSoundLittleMaid.Null);
                                    flag1 = true;
                                }
                            }

                            if (!flag1)
                            {
                                getNextEquipItem();
                                maidSearchCount = 0;
                                flag1 = true;
                            }
                        }

                        ItemStack itemstack1 = maidInventory.getCurrentItem();

                        if (!flag1 && itemstack1 != null && (itemstack1.getItem() instanceof ItemPotion) && !itemstack1.hasEffect())
                        {
                            int k1 = 0;

                            for (k1 = 0; k1 < 3 && !flag1; k1++)
                            {
                                if (tileentitybrewingstand.getStackInSlot(k1) == null)
                                {
                                    tileentitybrewingstand.setInventorySlotContents(k1, itemstack1);
                                    maidInventory.setInventoryCurrentSlotContents(null);
                                    worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                                    setSwing(5, EnumSoundLittleMaid.Null);
                                    getNextEquipItem();
                                    flag1 = true;
                                }
                            }

                            if (!flag1 && (tileentitybrewingstand.getStackInSlot(0) != null || tileentitybrewingstand.getStackInSlot(1) != null || tileentitybrewingstand.getStackInSlot(2) != null)
                            		&& (maidInventory.currentItem == -1 || (itemstack1 != null && itemstack1.getItem() instanceof ItemPotion && !itemstack1.hasEffect())))
                            {
                                maidSearchCount = 0;

                                do
                                {
                                    if (maidSearchCount >= maidInventory.mainInventory.length)
                                    {
                                        break;
                                    }

                                    itemstack1 = maidInventory.getStackInSlot(maidSearchCount);

                                    if (itemstack1 != null && !(itemstack1.getItem() instanceof ItemPotion))
                                    {
                                        maidInventory.currentItem = maidSearchCount;
                                        flag1 = true;
                                        break;
                                    }

                                    maidSearchCount++;
                                }
                                while (true);
                            }
                        }

                        if (!flag1 && itemstack2 == null && (tileentitybrewingstand.getStackInSlot(0) != null || tileentitybrewingstand.getStackInSlot(1) != null || tileentitybrewingstand.getStackInSlot(2) != null))
                        {
                            if (itemstack1 != null && !(itemstack1.getItem() instanceof ItemPotion) && itemstack1.getItem().isPotionIngredient())
                            {
                                tileentitybrewingstand.setInventorySlotContents(3, itemstack1);
                                maidInventory.setInventorySlotContents(maidSearchCount, null);
                                worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);
                                setSwing(15, EnumSoundLittleMaid.Null);
                                flag1 = true;
                            }
                            else if (itemstack1 == null || (itemstack1.getItem() instanceof ItemPotion) && itemstack1.hasEffect() || !itemstack1.getItem().isPotionIngredient())
                            {
                                maidSearchCount = maidInventory.mainInventory.length;
                            }

                            maidSearchCount++;
                            maidInventory.currentItem = maidSearchCount;
                        }

                        if (maidInventory.currentItem == -1 && itemstack2 == null){
                        	getNextEquipItem();
                        }
                    }

                    if (tileentitybrewingstand.getBrewTime() > 0 || attackTime > 0 || flag1)
                    {
                        if ((double)tileY <= posY)
                        {
                            setFlag(1, true);
                        }

                        faceXYZ(tileX, tileY, tileZ, 30F, 40F);
                        isMaidChaseWait = true;
                    }
                }
                else if (d < 100D)
                {
                    if (entityToAttack == null)
                    {
                        setPathToTile(true);
                        isMaidChaseWait = true;
                    }
                }
                else
                {
                    myTile = null;
                }
            }
            else
            {
                myTile = null;
            }
        }
    }

    protected void givemeSuger(float f, float f1)
    {
        if (f > f1)
        {
            givemeEntity = null;
            return;
        }

        PathEntity pathentity = worldObj.getPathEntityToEntity(this, givemeEntity, 16F, true, false, false, true);

        if (f < 3.5F)
        {
            setPathToEntity(null);
            setLooksWithInterest(true);
        }
        else if (!isMaidWait())
        {
            setPathToEntity(pathentity);
        }
    }

    protected float setLittleMaidFlashTime(float f)
    {
        if (timeSinceIgnited > -1)
        {
            return ((float)timeSinceIgnited * f) / 28F;
        }
        else
        {
            return 0.0F;
        }
    }

    private void onCollideWithLittleMaid(Entity entity)
    {
        if (worldObj.isRemote)
        {
            return;
        }

        if (entity instanceof EntityArrow)
        {
            EntityArrow entityarrow = (EntityArrow)entity;
            Boolean boolean1 = Boolean.FALSE;

            try
            {
                boolean1 = (Boolean)ModLoader.getPrivateValue(net.minecraft.src.EntityArrow.class, entityarrow, 5);
            }
            catch (Exception exception) { }

            if (!boolean1.booleanValue() || entityarrow.arrowShake > 0 || !maidInventory.addItemStackToInventory(new ItemStack(Item.arrow, 1)))
            {
                return;
            }

            worldObj.playSoundAtEntity(entity, "random.pop", 0.2F, ((rand.nextFloat() - rand.nextFloat()) * 0.7F + 1.0F) * 2.0F);
            maidAvatarEntity.onItemPickup(entity, 1);
            entityarrow.setDead();
        }
        else
        {
        	entity.onCollideWithPlayer(maidAvatarEntity);
        }
        /*if (entity instanceof EntityItem)
        {
        	EntityItem entityitem = (EntityItem)entity;
        	if (entityitem.delayBeforeCanPickup == 0 && maidInventory.addItemStackToInventory(entityitem.item))
        	{
        		maidSearchCount = 0;
        	}
        }*/
        onItemPickup(entity);
    }

    public void onItemPickup(Entity entity)
    {
        //mcGame.effectRenderer.addEffect(new EntityPickupFX(mcGame.theWorld, entity, this, 0.1F));
        setClockMaid();
        setMaskedMaid();
        getNextEquipItem();
    }

    public void destroyCurrentEquippedItem()
    {
        maidInventory.setInventoryCurrentSlotContents(null);
    }

    private void getPathOrWalkableBlock(Entity entity, double d)
    {
        PathEntity pathentity = null;

        if (entity != null)
        {
            pathentity = worldObj.getPathEntityToEntity(this, entity, 16F, true, false, false, true);
        }

        if (pathentity == null && d > 144D && !isBloodsuck())
        {
            int i = MathHelper.floor_double(entity.posX) - 2;
            int j = MathHelper.floor_double(entity.posZ) - 2;
            int k = MathHelper.floor_double(entity.boundingBox.minY);

            for (int l = 0; l <= 4; l++)
            {
                for (int i1 = 0; i1 <= 4; i1++)
                {
                    if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !worldObj.isBlockNormalCube(i + l, k - 1, j + i1) || worldObj.isBlockNormalCube(i + l, k, j + i1) || worldObj.isBlockNormalCube(i + l, k + 1, j + i1))
                    {
                        continue;
                    }

                    double d1 = masterEntity.getDistanceSq((double)(i + l) + 0.5D + (double)MathHelper.sin(masterEntity.rotationYaw * 0.01745329F) * 2D, k, (double)(j + i1) - (double)MathHelper.cos(masterEntity.rotationYaw * 0.01745329F) * 2D);

                    if (d1 > 8D)
                    {
                        setTarget(null);
                        setPathToEntity(null);
                        setLocationAndAngles((float)(i + l) + 0.5F, k, (float)(j + i1) + 0.5F, rotationYaw, rotationPitch);
                        return;
                    }
                }
            }
        }
        else
        {
            setPathToEntity(pathentity);
        }
    }

    public boolean getCanSpawnHere(double d, double d1, double d2)
    {
        AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox(d, d1, d2, d + (double)width, d1 + (double)height, d2 + (double)width);
        return worldObj.checkIfAABBIsClear(axisalignedbb) && worldObj.getCollidingBoundingBoxes(this, axisalignedbb).size() == 0 && !worldObj.isAnyLiquid(axisalignedbb);
    }

    private void showParticleFX(String s)
    {
        showParticleFX(s, 1.0D, 1.0D, 1.0D);
    }

    private void showParticleFX(String s, double d, double d1, double d2)
    {
        showParticleFX(s, d, d1, d2, 0.0D, 0.0D, 0.0D);
    }

    private void showContractFX()
    {
        for (int i = 0; i < 7; i++)
        {
            double d = rand.nextGaussian() * 1.0D;
            double d1 = rand.nextGaussian() * 1.0D;
            double d2 = rand.nextGaussian() * 1.0D;
            worldObj.spawnParticle("heart", (posX + (double)(rand.nextFloat() * width * 2.0F)) - (double)width, posY + 0.5D + (double)(rand.nextFloat() * height), (posZ + (double)(rand.nextFloat() * width * 2.0F)) - (double)width, d, d1, d2);
        }
    }

    public void showHappyFX()
    {
        double d = (double)getContractLimitDays() / 7D;
        double d1 = d * 0.29999999999999999D;
        double d2 = d;
        double d3 = d * 0.29999999999999999D;
        worldObj.spawnParticle("note", posX, posY + (double)height + 0.10000000000000001D, posZ, d1, d2, d3);
    }

    public void showParticleFX(String s, double d, double d1, double d2, double d3, double d4, double d5)
    {
        for (int i = 0; i < 7; i++)
        {
            double d6 = rand.nextGaussian() * d + d3;
            double d7 = rand.nextGaussian() * d1 + d4;
            double d8 = rand.nextGaussian() * d2 + d5;
            worldObj.spawnParticle(s, (posX + (double)(rand.nextFloat() * width * 2.0F)) - (double)width, posY + 0.5D + (double)(rand.nextFloat() * height), (posZ + (double)(rand.nextFloat() * width * 2.0F)) - (double)width, d6, d7, d8);
        }
    }

    public void setLooksWithInterest(boolean flag)
    {
    	if (!worldObj.isRemote)
    	{
    		looksWithInterest = flag;

            if (numTicksToChaseTarget <= 0)
            {
                looksWithInterestAXIS = rand.nextBoolean() ? 0.08F : -0.08F;
            }
    	}
    }

    public void setInterestedAngle(int par1,float par2,float par3,float par4)
    {
    	if (par1 == 1)looksWithInterest = true;
    	else looksWithInterest = false;

    	field_25054_c = par2;
    	field_25048_b = par3;
    	looksWithInterestAXIS = par4;

    }

    public float getInterestedAngle(float f)
    {
    	return (field_25054_c + (field_25048_b - field_25054_c) * f) * looksWithInterestAXIS * (float)Math.PI;
    }

    public int getLittleMaidCount()
    {
        return worldObj.countEntities(net.minecraft.src.EntityLittleMaid.class);
    }

    public void playLittleMaidSound(EnumSoundLittleMaid enumsoundlittlemaid, boolean flag)
    {
        if (soundInterval > 0 && !flag || enumsoundlittlemaid == EnumSoundLittleMaid.Null || worldObj.isRemote)
        {
            return;
        }

        soundInterval = 20;
        String s = SoundLittleMaid.getSoundValue(enumsoundlittlemaid, textureName, maidColor);

        if (mod_littleMaidMob.VoiceDistortion)
        {
            worldObj.playSoundAtEntity(this, s, getSoundVolume(), rand.nextFloat() * 0.2F + 0.95F);
        }
        else
        {
            worldObj.playSoundAtEntity(this, s, getSoundVolume(), 1.0F);
        }
    }

    public boolean isMaidContractEX()
    {
        //return isMaidContract() && maidContractLimit > worldObj.getWorldTime();
        return isMaidContract() && getMaidContractLimit() > worldObj.getWorldTime();
    }

    public boolean isMaidContract()
    {
        return (dataWatcher.getWatchableObjectByte(16) & 8) != 0;
    }

    public void setMaidContract(boolean flag)
    {
        byte byte0 = dataWatcher.getWatchableObjectByte(16);

        if (flag)
        {
            dataWatcher.updateObject(16, Byte.valueOf((byte)(byte0 | 8)));
            setMode(2);
            //maidMode = 2;
        }
        else
        {
            dataWatcher.updateObject(16, Byte.valueOf((byte)(byte0 & -9)));
            setMode(0);
        }

        setTextureValue();
    }

    public float getContractLimitDays()
    {
        if (getMaidContractLimit() < worldObj.getWorldTime())
        {
            return -1F;
        }
        else
        {
            return (float)(getMaidContractLimit() - worldObj.getWorldTime()) / 24000F;
        }
    }

    public String getMaidMaster()
    {
        return dataWatcher.getWatchableObjectString(19);
    }

    public void setMaidMaster(String s)
    {
        dataWatcher.updateObject(19, s);
    }

    public EntityPlayer getMaidMasterEntity()
    {
        if (isMaidContract())
        {
            Object obj;

            if (worldObj.isRemote)
            {
                obj = worldObj.getPlayerEntityByName(getMaidMaster());
            }
            else
            {
                obj = mcGame.thePlayer;
            }

            if (obj != null && maidAvatarEntity != null)
            {
                maidAvatarEntity.capabilities.isCreativeMode = ((EntityPlayer)(obj)).capabilities.isCreativeMode;
            }

            return ((EntityPlayer)(obj));
        }
        else
        {
            return null;
        }
    }

    public boolean isMaidWait()
    {
        return (dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public boolean isMaidWaitEx()
    {
        //setTextureValue();
        return isMaidWait() | (maidwaitcount > 0) | isOpenInventory();
    }

    public void setMaidWait(boolean flag)
    {
        byte byte0 = dataWatcher.getWatchableObjectByte(16);

        if (flag)
        {
            dataWatcher.updateObject(16, Byte.valueOf((byte)(byte0 | 1)));
        }
        else
        {
            dataWatcher.updateObject(16, Byte.valueOf((byte)(byte0 & -2)));
        }
    }

    public void setMaidWaitCount(int i)
    {
        maidwaitcount = i;
    }

    public void setOpenInventory(boolean flag)
    {
        openInventory = flag;
    }

    public boolean isOpenInventory()
    {
        return openInventory;
    }

    public void onGuiClosed()
    {
        setOpenInventory(false);
        setMaidWaitCount(maidMode >= 4 ? 0 : 50);

        if (maidMode != 15)
        {
            getNextEquipItem();
        }

        setClockMaid();
        setMaskedMaid();
        String as[] = {getTextureName(), getTextureArmorName()};
        int ai[] = {getMaidContractTime()};
        mod_littleMaidMob.SendPacketLittleMaidData(mod_littleMaidMob.packetCloseGUI, as, ai, null);
    }

    private boolean isBlockTranslucent(int i, int j, int k)
    {
        boolean flag = false;

        for (int l = 0; l <= (int)height; l++)
        {
            flag |= worldObj.isBlockNormalCube(i, MathHelper.floor_double(boundingBox.minY + (double)l), k);
        }

        return flag;
    }

    /**
     * Adds velocity to push the entity out of blocks at the specified x, y, z position Args: x, y, z
     */
    protected boolean pushOutOfBlocks(double d, double d1, double d2)
    {
        int i = MathHelper.floor_double(d);
        int j = MathHelper.floor_double(d1);
        int k = MathHelper.floor_double(d2);
        double d3 = d - (double)i;
        double d4 = d2 - (double)k;

        if (isBlockTranslucent(i, j, k))
        {
            boolean flag = !isBlockTranslucent(i - 1, j, k);
            boolean flag1 = !isBlockTranslucent(i + 1, j, k);
            boolean flag2 = !isBlockTranslucent(i, j, k - 1);
            boolean flag3 = !isBlockTranslucent(i, j, k + 1);
            byte byte0 = -1;
            double d5 = 9999D;

            if (flag && d3 < d5)
            {
                d5 = d3;
                byte0 = 0;
            }

            if (flag1 && 1.0D - d3 < d5)
            {
                d5 = 1.0D - d3;
                byte0 = 1;
            }

            if (flag2 && d4 < d5)
            {
                d5 = d4;
                byte0 = 4;
            }

            if (flag3 && 1.0D - d4 < d5)
            {
                double d6 = 1.0D - d4;
                byte0 = 5;
            }

            float f = 0.1F;

            if (byte0 == 0)
            {
                motionX = -f;
            }

            if (byte0 == 1)
            {
                motionX = f;
            }

            if (byte0 == 4)
            {
                motionZ = -f;
            }

            if (byte0 == 5)
            {
                motionZ = f;
            }

            return !(flag | flag1 | flag2 | flag3);
        }
        else
        {
            return false;
        }
    }

    public void setMaidFreedom(boolean flag)
    {
        setFreedom(flag);
        playingRole = 0;

        if (flag)
        {
            moveSpeed = 0.7F;
        }
        else
        {
            moveSpeed = 1.1F;
        }
    }

    public boolean isMaidFreedom()
    {
        return getMaidFreedom() || getMaidMode() == 3;
    }

    public void setMaidTracer(boolean flag)
    {
        byte byte0 = dataWatcher.getWatchableObjectByte(16);
        playingRole = 0;

        if (flag)
        {
            dataWatcher.updateObject(16, Byte.valueOf((byte)(byte0 | 4)));
        }
        else
        {
            dataWatcher.updateObject(16, Byte.valueOf((byte)(byte0 & -5)));
        }
    }

    public boolean isMaidTracer()
    {
        return (dataWatcher.getWatchableObjectByte(16) & 4) != 0;
    }

    public String getLittleMaidMode()
    {
        maidMode = getMaidMode();
        String s;

        if (isMaidWait())
        {
            s = maidModeStrings[1];
        }
        else if (maidOverDriveTime > 0)
        {
            if (maidMode == 12)
            {
                s = maidModeStrings[12];
            }
            else
            {
                s = (new StringBuilder()).append("D-").append(maidModeStrings[maidMode]).toString();
            }
        }
        else if (isMaidTracer())
        {
            if (getMaidMode() > 3)
            {
                s = (new StringBuilder()).append("T-").append(maidModeStrings[maidMode]).toString();
            }
            else
            {
                s = maidModeStrings[14];
            }
        }
        else if (isMaidFreedom())
        {
            if (getMaidMode() > 3)
            {
                s = (new StringBuilder()).append("F-").append(maidModeStrings[maidMode]).toString();
            }
            else
            {
                s = maidModeStrings[3];
            }
        }
        else
        {
            s = maidModeStrings[maidMode];
        }

        return s;
    }

    public int getMaidMode()
    {
        //return maidMode & 0xf;
        return (int)(dataWatcher.getWatchableObjectByte(17) & 0xf0) >> 4;
    }

    public void setMaidMode(int i)
    {
        setFlag(1, false);
        i &= 0xf;

        if (maidMode != i && i == 12)
        {
            playLittleMaidSound(EnumSoundLittleMaid.TNT_D, true);
        }

        //maidMode = i;
        setMode(i);

        if (maidMode == 8 && maidInventory.getInventorySlotContainItem(Item.flintAndSteel.shiftedIndex) > -1)
        {
            //maidMode = 9;
            setMode(9);
            blazingArrows.clear();
        }

        if (maidMode == 12)
        {
            maidOverDriveTime = 5;
            moveSpeed = 3F;
        }
        else
        {
            setMaidFreedom(getMaidFreedom());
        }

        getNextEquipItem();
    }

    public int getMaidColor()
    {
        return (int)(dataWatcher.getWatchableObjectByte(17) & 0xf);
    }

    public void setMaidColor(int i)
    {
        maidColor = i & 0xf;
        setColor(i);
        setTextureValue();
    }

    public boolean getNextEquipItem()
    {
        int i3 = 0;
        EntityLittleMaid entitylittlemaid = null;

        if (entitylittlemaid == null)
        {
            entitylittlemaid = this;
        }

        if (playingRole > 0)
        {
            int i = maidInventory.getInventorySlotContainItem(Item.snowball.shiftedIndex);
            maidInventory.currentItem = i;
            return i > -1;
        }

        label0:

        switch (getMaidMode())
        {
            case 14:
            default:
                break;

            case 4:
                int k2 = -1;

                for (int j = 0; j < maidInventory.getSizeInventory(); j++)
                {
                    ItemStack itemstack = maidInventory.getStackInSlot(j);

                    if (itemstack == null)
                    {
                        continue;
                    }

                    if ((itemstack.getItem() instanceof ItemSword) || GuiLittleMaidTriggerSelect.ListSword.contains(Integer.valueOf(itemstack.getItem().shiftedIndex)))
                    {
                        maidInventory.currentItem = j;
                        return true;
                    }

                    if (maidInventory.getDamageVsEntity(entitylittlemaid, j) > i3)
                    {
                        k2 = j;
                        i3 = maidInventory.getDamageVsEntity(entitylittlemaid, j);
                    }
                }

                if (k2 > -1)
                {
                    maidInventory.currentItem = k2;
                    return true;
                }

                break;

            case 15:
                byte byte0 = -1;

                for (int k = 0; k < maidInventory.getSizeInventory(); k++)
                {
                    ItemStack itemstack1 = maidInventory.getStackInSlot(k);

                    if (itemstack1 != null && (itemstack1.getItem() instanceof ItemPotion) && !itemstack1.hasEffect())
                    {
                        maidInventory.currentItem = k;
                        return true;
                    }
                }

                maidInventory.currentItem = -1;
                break;

            case 5:
                byte byte1 = -1;
                int l = 0;

                do
                {
                    if (l >= maidInventory.getSizeInventory())
                    {
                        break label0;
                    }

                    ItemStack itemstack2 = maidInventory.getStackInSlot(l);

                    if (itemstack2 != null && ((itemstack2.getItem() instanceof ItemFood) || (itemstack2.getItem() instanceof ItemPotion)))
                    {
                        maidInventory.currentItem = l;
                        return true;
                    }

                    l++;
                }
                while (true);

            case 6:
                int i1 = 0;

                do
                {
                    if (i1 >= maidInventory.getSizeInventory())
                    {
                        break label0;
                    }

                    if (maidInventory.isItemBurned(i1))
                    {
                        maidInventory.currentItem = i1;
                        return true;
                    }

                    i1++;
                }
                while (true);

            case 7:
                int l2 = -1;

                for (int j1 = 0; j1 < maidInventory.getSizeInventory(); j1++)
                {
                    ItemStack itemstack3 = maidInventory.getStackInSlot(j1);

                    if (itemstack3 == null)
                    {
                        continue;
                    }

                    if ((itemstack3.getItem() instanceof ItemAxe) || GuiLittleMaidTriggerSelect.ListAxe.contains(Integer.valueOf(itemstack3.getItem().shiftedIndex)))
                    {
                        maidInventory.currentItem = j1;
                        return true;
                    }

                    if (maidInventory.getDamageVsEntity(entitylittlemaid, j1) > i3)
                    {
                        l2 = j1;
                        i3 = maidInventory.getDamageVsEntity(entitylittlemaid, j1);
                    }
                }

                if (l2 > -1)
                {
                    maidInventory.currentItem = l2;
                    return true;
                }

                break;

            case 8:
            case 9:
                int k1 = 0;

                do
                {
                    if (k1 >= maidInventory.getSizeInventory())
                    {
                        break label0;
                    }

                    ItemStack itemstack4 = maidInventory.getStackInSlot(k1);

                    if (itemstack4 != null && ((itemstack4.getItem() instanceof ItemBow) || GuiLittleMaidTriggerSelect.ListBow.contains(Integer.valueOf(itemstack4.getItem().shiftedIndex))))
                    {
                        maidInventory.currentItem = k1;
                        return true;
                    }

                    k1++;
                }
                while (true);

            case 10:
            case 12:
                int l1 = 0;

                do
                {
                    if (l1 >= maidInventory.getSizeInventory())
                    {
                        break label0;
                    }

                    ItemStack itemstack5 = maidInventory.getStackInSlot(l1);

                    if (itemstack5 != null && (itemstack5.getItem() instanceof ItemShears))
                    {
                        maidInventory.currentItem = l1;
                        return true;
                    }

                    l1++;
                }
                while (true);

            case 11:
                for (int i2 = 0; i2 < maidInventory.getSizeInventory(); i2++)
                {
                    if (maidInventory.isItemExplord(i2))
                    {
                        maidInventory.currentItem = i2;
                        return true;
                    }
                }

                timeSinceIgnited = -1;
                break;

            case 13:
                for (int j2 = 0; j2 < maidInventory.getSizeInventory(); j2++)
                {
                    ItemStack itemstack6 = maidInventory.getStackInSlot(j2);

                    if (itemstack6 != null && itemstack6.getItem().shiftedIndex == Block.torchWood.blockID)
                    {
                        maidInventory.currentItem = j2;
                        return true;
                    }
                }

                timeSinceIgnited = -1;
                break;
        }

        return false;
    }

    public boolean isFixedBow()
    {
        return maidAvatarEntity != null && maidAvatarEntity.isUsingItemLittleMaid() || (maidMode == 8 || maidMode == 9) && isAimedBow();
    }

    public boolean isBloodsuck()
    {
        if (timeSinceIgnited > 32)
        {
            return true;
        }
        else
        {
            return (maidMode == 7 || maidMode == 9 || maidMode == 11 || timeSinceIgnited > -1) && getEntityToAttack() != null;
        }
    }

    public void setMaskedMaid()
    {
    	for (int i = maidInventory.mainInventory.length -1 ; i >=0; i--)
        {
            ItemStack itemstack = maidInventory.getStackInSlot(i);

            if (itemstack != null && (itemstack.getItem() instanceof ItemArmor) && ((ItemArmor)itemstack.getItem()).armorType == 0)
            {
                isMaskedMaid = true;
                maidInventory.armorInventory[3] = itemstack;
                setArmorTextureValue();
                return;
            }
        }

        isMaskedMaid = false;
        maidInventory.armorInventory[3] = null;
    }

    public void setClockMaid()
    {
        isClockMaid = maidInventory.getInventorySlotContainItem(Item.pocketSundial.shiftedIndex) > -1;
    }

    public void setSwing(int i, EnumSoundLittleMaid enumsoundlittlemaid)
    {
        attackTime = i;
        attackSound = enumsoundlittlemaid;

        if (!weaponFullAuto)
        {
            isSwinging = maidAvatarEntity.isSwinging = true;
        }
    }

    public void eatSugar(boolean flag, boolean flag1)
    {
        if (flag)
        {
            setSwing(2, getMaidHealth() != 19 || isBurning() ? EnumSoundLittleMaid.eatSugar : EnumSoundLittleMaid.eatSugar_MaxPower);
        }

        int i = heartsLife;
        heal(1);
        heartsLife = i;
        worldObj.playSoundAtEntity(this, "random.pop", 0.5F, (rand.nextFloat() - rand.nextFloat()) * 0.2F + 1.0F);

        if (flag1)
        {
            maidContractLimit = getMaidContractLimit();
            maidContractLimit += 24000L;

            if (maidContractLimit - worldObj.getWorldTime() > 0x29040L)
            {
                maidContractLimit = worldObj.getWorldTime() + 0x29040L;
            }

            setMaidContractLimit(maidContractLimit);
        }

        if (maidAvatarEntity != null)
        {
            maidAvatarEntity.foodStats.addStats(20, 20F);
        }
    }

    protected void setHomePosition()
    {
        homeX = MathHelper.floor_double(posX);
        homeY = MathHelper.floor_double(posY);
        homeZ = MathHelper.floor_double(posZ);
    }

    public boolean isNoTarget()
    {
        return entityToAttack == null && myTile == null && myEntity == null;
    }

    public boolean isLookSuger()
    {
        return givemeEntity != null;
    }

    public void usePotionTotarget(EntityLiving entityliving)
    {
        ItemStack itemstack = maidInventory.getCurrentItem();

        if (itemstack != null && (itemstack.getItem() instanceof ItemPotion))
        {
            itemstack.stackSize--;
            List list = ((ItemPotion)itemstack.getItem()).getEffects(itemstack);

            if (list != null)
            {
                PotionEffect potioneffect;

                for (Iterator iterator = list.iterator(); iterator.hasNext(); entityliving.addPotionEffect(new PotionEffect(potioneffect)))
                {
                    potioneffect = (PotionEffect)iterator.next();
                }
            }

            if (itemstack.stackSize <= 0)
            {
                maidInventory.setInventoryCurrentSlotContents(new ItemStack(Item.glassBottle));
            }
            else
            {
                maidInventory.addItemStackToInventory(new ItemStack(Item.glassBottle));
            }
        }
    }

    protected void getWeaponStatus()
    {
        if (maidMode != 8 && maidMode != 9)
        {
            return;
        }

        ItemStack itemstack = maidInventory.getCurrentItem();

        if (itemstack == null)
        {
            return;
        }

        try
        {
            Method method = itemstack.getItem().getClass().getMethod("isWeaponReload", new Class[]
                    {
                        net.minecraft.src.ItemStack.class, net.minecraft.src.EntityPlayer.class
                    });
            weaponReload = ((Boolean)method.invoke(itemstack.getItem(), new Object[]
                    {
                        itemstack, maidAvatarEntity
                    })).booleanValue();
        }
        catch (NoSuchMethodException nosuchmethodexception) { }
        catch (Exception exception) { }

        try
        {
            Method method1 = itemstack.getItem().getClass().getMethod("isWeaponFullAuto", new Class[]
                    {
                        net.minecraft.src.ItemStack.class
                    });
            weaponFullAuto = ((Boolean)method1.invoke(itemstack.getItem(), new Object[]
                    {
                        itemstack
                    })).booleanValue();
        }
        catch (NoSuchMethodException nosuchmethodexception1) { }
        catch (Exception exception1) { }
    }

    private void clearDummy()
    {
        if (!mod_littleMaidMob.isDebugView)
        {
            return;
        }
        else
        {
            EntityLittleMaidDummy.clearDummyEntity(worldObj, this);
            return;
        }
    }

    private void setDummyEntity(int i, double d, double d1, double d2)
    {
        if (!mod_littleMaidMob.isDebugView)
        {
            return;
        }
        else
        {
            EntityLittleMaidDummy entitylittlemaiddummy = new EntityLittleMaidDummy(worldObj, i, this);
            entitylittlemaiddummy.setPosition(d, d1, d2);
            worldObj.joinEntityInSurroundings(entitylittlemaiddummy);
            return;
        }
    }

    public void handleHealthUpdate(byte byte0)
    {
        if (byte0 == 7)
        {
            showContractFX();
        }

        if (byte0 == 8)
        {
            showParticleFX("smoke", 0.02D, 0.02D, 0.02D);
        }

        if (byte0 == 9)
        {
            showParticleFX("reddust", 0.5D, 0.5D, 0.5D, 1.0D, 1.0D, 1.0D);
        }

        if (byte0 == 10)
        {
            showParticleFX("explode", 0.3D, 0.3D, 0.3D, 0.0D, 0.0D, 0.0D);
        }

        if (byte0 == 11)
        {
            showHappyFX();
        }

        if (byte0 == 12)
        {
            worldObj.spawnParticle("reddust", (posX + (double)(rand.nextFloat() * width * 2.0F)) - (double)width, posY + 0.5D + (double)(rand.nextFloat() * height), (posZ + (double)(rand.nextFloat() * width * 2.0F)) - (double)width, 1.2D, 0.4D, 0.4D);
        }
        else
        {
            super.handleHealthUpdate(byte0);
        }
    }

    public String getTextureName()
    {
        return dataWatcher.getWatchableObjectString(20);
    }

    public void setTextureName(String s)
    {
        dataWatcher.updateObject(20, s);
    }

    public String getTextureArmorName()
    {
        return dataWatcher.getWatchableObjectString(21);
    }

    public void setTextureArmorName(String s)
    {
        dataWatcher.updateObject(21, s);
    }

    public void setFreedom(boolean flag)
    {
        byte byte0 = dataWatcher.getWatchableObjectByte(16);

        if (flag)
        {
            dataWatcher.updateObject(16, Byte.valueOf((byte)(byte0 | 2)));
        }
        else
        {
            dataWatcher.updateObject(16, Byte.valueOf((byte)(byte0 & -3)));
        }
    }

    public boolean getMaidFreedom()
    {
        return (dataWatcher.getWatchableObjectByte(16) & 2) != 0;
    }

    private void setMode(int i)
    {
        maidMode = i;
        byte byte0 = dataWatcher.getWatchableObjectByte(17);
        byte0 = (byte)(byte0 & 0xffffff0f);
        byte0 = (byte)(byte0 | i << 4);
        dataWatcher.updateObject(17, Byte.valueOf((byte)(byte0)));
    }

    private void setColor(int i)
    {
        byte byte0 = dataWatcher.getWatchableObjectByte(17);
        byte0 = (byte)(byte0 & 0xf0);
        byte0 = (byte)(byte0 | i);
        dataWatcher.updateObject(17, Byte.valueOf((byte)(byte0)));
    }

    public long getMaidContractLimit()
    {
        return (long)dataWatcher.getWatchableObjectInt(22);
    }

    public void setMaidContractLimit(long l)
    {
        dataWatcher.updateObject(22, Integer.valueOf((int)l));
    }

    public void checkMaidContractTime()
    {
        EntityLittleMaid entitylittlemaid = null;

        for (int i = 0; i < worldObj.loadedEntityList.size(); i++)
        {
            Entity entity = (Entity)worldObj.loadedEntityList.get(i);

            if (entity instanceof EntityLittleMaid)
            {
                entitylittlemaid = (EntityLittleMaid)entity;

                if (entitylittlemaid != this && entitylittlemaid.maidContractTime == maidContractTime)
                {
                    maidContractTime = (int)worldObj.getWorldTime();
                    i = 0;
                }
            }
        }

        setMaidContractTime(maidContractTime);
    }

    public void setMaidContractTime(int i)
    {
        maidContractTime = i;
        dataWatcher.updateObject(23, Integer.valueOf((int)i));
    }

    public int getMaidContractTime()
    {
        return dataWatcher.getWatchableObjectInt(23);
    }

    public String getMaidName()
    {
        return dataWatcher.getWatchableObjectString(24);
    }

    public void setMaidName(String s)
    {
        dataWatcher.updateObject(24, s);
    }

    public void setAimedBow(boolean flag)
    {
        byte byte0 = dataWatcher.getWatchableObjectByte(25);

        if (flag)
        {
            dataWatcher.updateObject(25, Byte.valueOf((byte)(byte0 | 1)));
        }
        else
        {
            dataWatcher.updateObject(25, Byte.valueOf((byte)(byte0 & -2)));
        }
    }

    public boolean isAimedBow()
    {
        return (dataWatcher.getWatchableObjectByte(25) & 1) != 0;
    }

    public int getMaidHealth()
    {
        return dataWatcher.getWatchableObjectInt(18);
    }

    public void playSound(EnumSoundLittleMaid enumsoundlittlemaid)
    {
    	soundInterval = 20;
        String s = SoundLittleMaid.getSoundValue(enumsoundlittlemaid, textureName, maidColor);

        if (mod_littleMaidMob.VoiceDistortion)
        {
            worldObj.playSoundAtEntity(this, s, getSoundVolume(), rand.nextFloat() * 0.2F + 0.95F);
        }
        else
        {
            worldObj.playSoundAtEntity(this, s, getSoundVolume(), 1.0F);
        }
    }

    static
    {
        mcGame = mod_littleMaidMob.mcGame;
    }
}
