package net.minecraft.src;

import java.util.*;

public class ContainerLittleMaidTriggerSelect extends ContainerCreative
{
    public List weaponSelect;
    public int weaponSelectIndex;
    public int weaponOffset;

    public ContainerLittleMaidTriggerSelect(EntityPlayer entityplayer)
    {
        super(entityplayer);
        weaponSelect = new ArrayList();
        inventorySlots.clear();

        for (int i = 0; i < 5; i++)
        {
            for (int k = 0; k < 8; k++)
            {
                addSlot(new Slot(GuiLittleMaidTriggerSelect.getInventory1(), k + i * 8, 8 + k * 18, 18 + i * 18));
            }
        }

        for (int j = 0; j < 4; j++)
        {
            for (int l = 0; l < 8; l++)
            {
                addSlot(new Slot(GuiLittleMaidTriggerSelect.getInventory2(), l + j * 8, 8 + l * 18, 121 + j * 18));
            }
        }

        setWeaponSelect(0);
        scrollTo(0.0F);
        setWeaponlist(0.0F);
    }

    public boolean canInteractWith(EntityPlayer entityplayer)
    {
        return true;
    }

    /**
     * Updates the gui slots ItemStack's based on scroll position.
     */
    public void scrollTo(float f)
    {
        int i = (itemList.size() / 8 - 5) + 1;
        int j = (int)((double)(f * (float)i) + 0.5D);

        if (j < 0)
        {
            j = 0;
        }

        for (int k = 0; k < 5; k++)
        {
            for (int l = 0; l < 8; l++)
            {
                int i1 = l + (k + j) * 8;

                if (i1 >= 0 && i1 < itemList.size())
                {
                    GuiLittleMaidTriggerSelect.getInventory1().setInventorySlotContents(l + k * 8, (ItemStack)itemList.get(i1));
                }
                else
                {
                    GuiLittleMaidTriggerSelect.getInventory1().setInventorySlotContents(l + k * 8, null);
                }
            }
        }
    }

    public ItemStack slotClick(int i, int j, boolean flag, EntityPlayer entityplayer)
    {
        if (i >= 40)
        {
            int k;

            for (k = (i - 40) + weaponOffset * 8; weaponSelect.size() <= k + 7; weaponSelect.add(null)) { }

            weaponSelect.set(k, entityplayer.inventory.getItemStack());
        }

        if (i == -999)
        {
            entityplayer.inventory.setItemStack(null);
        }

        ItemStack itemstack = super.slotClick(i, j, flag, entityplayer);
        return itemstack;
    }

    /**
     * Called to transfer a stack from one inventory to the other eg. when shift clicking.
     */
    public ItemStack transferStackInSlot(int i)
    {
        ItemStack itemstack = null;
        Slot slot = (Slot)inventorySlots.get(i);

        if (slot != null && slot.getHasStack())
        {
            if (i < 40)
            {
                ItemStack itemstack1 = slot.getStack();
                itemstack = itemstack1.copy();
                mergeItemStack(itemstack1, 40, 72, false);
            }
            else
            {
                slot.putStack(null);
            }
        }

        return itemstack;
    }

    /**
     * merges provided ItemStack with the first avaliable one in the container/player inventory
     */
    protected boolean mergeItemStack(ItemStack itemstack, int i, int j, boolean flag)
    {
        boolean flag1 = false;
        int k = 0;

        do
        {
            if (itemstack.stackSize <= 0 || k >= weaponSelect.size())
            {
                break;
            }

            ItemStack itemstack1 = (ItemStack)weaponSelect.get(k);

            if (itemstack1 != null)
            {
                if (itemstack1.itemID == itemstack.itemID && (!itemstack.getHasSubtypes() || itemstack.getItemDamage() == itemstack1.getItemDamage()))
                {
                    flag1 = true;
                    break;
                }
            }
            else
            {
                weaponSelect.set(k, itemstack);
                flag1 = true;
                break;
            }

            k++;
        }
        while (true);

        if (!flag1)
        {
            weaponSelect.add(itemstack);
            setWeaponlist(1.0F);
        }
        else
        {
            int l = (weaponSelect.size() / 8 - 4) + 1;
            int i1 = k / 8;
            float f = (float)i1 / (float)l;

            if (f < 0.0F)
            {
                f = 0.0F;
            }

            if (f > 1.0F)
            {
                f = 1.0F;
            }

            setWeaponlist(f);
        }

        return flag1;
    }

    public void setWeaponlist(float f)
    {
        int i = (weaponSelect.size() / 8 - 4) + 1;
        weaponOffset = (int)((double)(f * (float)i) + 0.5D);

        if (weaponOffset < 0)
        {
            weaponOffset = 0;
        }

        for (int j = 0; j < 4; j++)
        {
            for (int k = 0; k < 8; k++)
            {
                int l = k + (j + weaponOffset) * 8;

                if (l >= 0 && l < weaponSelect.size())
                {
                    GuiLittleMaidTriggerSelect.getInventory2().setInventorySlotContents(j * 8 + k, (ItemStack)weaponSelect.get(l));
                }
                else
                {
                    GuiLittleMaidTriggerSelect.getInventory2().setInventorySlotContents(j * 8 + k, null);
                }
            }
        }
    }

    public void setWeaponSelect(int i)
    {
        weaponSelect.clear();
        List list;

        switch (weaponSelectIndex = i)
        {
            case 0:
                list = GuiLittleMaidTriggerSelect.ListSword;
                break;

            case 1:
                list = GuiLittleMaidTriggerSelect.ListAxe;
                break;

            case 2:
                list = GuiLittleMaidTriggerSelect.ListBow;
                break;

            default:
                return;
        }

        Iterator iterator = list.iterator();

        do
        {
            if (!iterator.hasNext())
            {
                break;
            }

            Integer integer = (Integer)iterator.next();

            if (Item.itemsList[integer.intValue()] != null)
            {
                weaponSelect.add(new ItemStack(Item.itemsList[integer.intValue()]));
            }
        }
        while (true);
    }

    public List getItemList()
    {
        switch (weaponSelectIndex)
        {
            case 0:
                return GuiLittleMaidTriggerSelect.ListSword;

            case 1:
                return GuiLittleMaidTriggerSelect.ListAxe;

            case 2:
                return GuiLittleMaidTriggerSelect.ListBow;
        }

        return null;
    }
}
