package net.minecraft.src;

import java.util.List;

public class ContainerLittleMaid extends Container
{
    private InventoryLittleMaid littlemaidInventory;
    private int numRows;

    public ContainerLittleMaid(IInventory iinventory, InventoryLittleMaid inventorylittlemaid)
    {
        littlemaidInventory = inventorylittlemaid;
        numRows = inventorylittlemaid.getSizeInventory() / 9;

        for (int i = 0; i < numRows; i++)
        {
            for (int k = 0; k < 9; k++)
            {
                addSlot(new Slot(inventorylittlemaid, k + i * 9, 8 + k * 18, 76 + i * 18));
            }
        }

        int j = (numRows - 4) * 18 + 59;

        for (int l = 0; l < 3; l++)
        {
            for (int k1 = 0; k1 < 9; k1++)
            {
                addSlot(new Slot(iinventory, k1 + l * 9 + 9, 8 + k1 * 18, 103 + l * 18 + j));
            }
        }

        for (int i1 = 0; i1 < 9; i1++)
        {
            addSlot(new Slot(iinventory, i1, 8 + i1 * 18, 161 + j));
        }

        for (int j1 = 0; j1 < 3; j1++)
        {
            int l1 = j1 + 1;
            addSlot(new SlotLittleMaidArmor(this, inventorylittlemaid, inventorylittlemaid.getSizeInventory() - 2 - j1, 8, 8 + j1 * 18, l1));
        }
    }

    public boolean canInteractWith(EntityPlayer entityplayer)
    {
        if (littlemaidInventory.entitylittlemaid.isDead)
        {
            return false;
        }
        else
        {
            return entityplayer.getDistanceSqToEntity(littlemaidInventory.entitylittlemaid) <= 64D;
        }
    }

    /**
     * Called to transfer a stack from one inventory to the other eg. when shift clicking.
     */
    public ItemStack transferStackInSlot(int i)
    {
        ItemStack itemstack = null;
        Slot slot = (Slot)inventorySlots.get(i);

        if (slot != null && slot.getHasStack())
        {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            int j = numRows * 9;

            if (i < j)
            {
                mergeItemStack(itemstack1, j, j + 36, true);
            }
            else if (i >= j && i < j + 36)
            {
                mergeItemStack(itemstack1, 0, j, false);
            }
            else
            {
                mergeItemStack(itemstack1, 0, j + 36, false);
            }

            if (itemstack1.stackSize == 0)
            {
                slot.putStack(null);
            }
            else
            {
                slot.onSlotChanged();
            }

            if (itemstack1.stackSize != itemstack.stackSize)
            {
                slot.onPickupFromSlot(itemstack1);
            }
            else
            {
                return null;
            }
        }

        return itemstack;
    }
}
