/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import sirentropy.blocks.BlockInfo;
import sirentropy.blocks.BlockSet;
import sirentropy.blocks.MultiBlock;
import sirentropy.util.Vector3i;

public class WorldUtil {
    public static void drawCube(xd world, int x2, int y2, int z2, int x0, int y0, int z0, BlockSet immutableBlockIDs, int bid, Integer metadata) {
        WorldUtil.line(world, x2, y2, z2, x2, y0, z2, bid, metadata, immutableBlockIDs);
        WorldUtil.line(world, x0, y2, z0, x0, y0, z0, bid, metadata, immutableBlockIDs);
        WorldUtil.line(world, x2, y2, z0, x2, y0, z0, bid, metadata, immutableBlockIDs);
        WorldUtil.line(world, x0, y2, z2, x0, y0, z2, bid, metadata, immutableBlockIDs);
        WorldUtil.line(world, x2, y2, z2, x0, y2, z2, bid, metadata, immutableBlockIDs);
        WorldUtil.line(world, x2, y0, z2, x0, y0, z2, bid, metadata, immutableBlockIDs);
        WorldUtil.line(world, x2, y2, z0, x0, y2, z0, bid, metadata, immutableBlockIDs);
        WorldUtil.line(world, x2, y0, z0, x0, y0, z0, bid, metadata, immutableBlockIDs);
        WorldUtil.line(world, x2, y2, z2, x2, y2, z0, bid, metadata, immutableBlockIDs);
        WorldUtil.line(world, x0, y2, z2, x0, y2, z0, bid, metadata, immutableBlockIDs);
        WorldUtil.line(world, x2, y0, z2, x2, y0, z0, bid, metadata, immutableBlockIDs);
        WorldUtil.line(world, x0, y0, z2, x0, y0, z0, bid, metadata, immutableBlockIDs);
    }

    public static void line(xd world, int x1, int y1, int z1, int x2, int y2, int z2, int blockID, Integer metadata, BlockSet immutableBlockIDs) {
        bo step = bo.a(x2 - x1, y2 - y1, z2 - z1).c();
        double stepX = step.a;
        double stepY = step.b;
        double stepZ = step.c;
        double posX = x1;
        double posY = y1;
        double posZ = z1;
        int roundPosX = (int)Math.round(posX);
        int roundPosY = (int)Math.round(posY);
        int roundPosZ = (int)Math.round(posZ);
        while (x2 != roundPosX || y2 != roundPosY || z2 != roundPosZ) {
            BlockInfo bi2 = new BlockInfo(world.a(roundPosX, roundPosY, roundPosZ), (Integer)world.e(roundPosX, roundPosY, roundPosZ));
            if (immutableBlockIDs == null || !immutableBlockIDs.contains(bi2)) {
                if (metadata == null) {
                    world.g(roundPosX, roundPosY, roundPosZ, blockID);
                } else {
                    world.d(roundPosX, roundPosY, roundPosZ, blockID, metadata);
                }
            }
            roundPosX = (int)Math.round(posX += stepX);
            roundPosY = (int)Math.round(posY += stepY);
            roundPosZ = (int)Math.round(posZ += stepZ);
        }
    }

    public static void createCube(xd world, int x0, int y0, int z0, int length, int height, int width, int blockID, int metadata, BlockSet excludedBlocks) {
        System.out.println("Size to erase: " + length + " " + height + " " + width);
        for (int x2 = x0; x2 < x0 + length; ++x2) {
            for (int y2 = y0 + height - 1; y2 >= y0; --y2) {
                for (int z2 = z0; z2 < z0 + width; ++z2) {
                    int currentBlockID = world.a(x2, y2, z2);
                    BlockInfo bi2 = new BlockInfo(currentBlockID, (Integer)world.e(x2, y2, z2));
                    if (excludedBlocks != null && excludedBlocks.contains(bi2)) continue;
                    WorldUtil.setDataRaw(world, x2, y2, z2, blockID, metadata, 0, 0);
                }
            }
        }
        for (int i2 = x0; i2 < x0 + length; ++i2) {
            for (int j2 = y0; j2 < y0 + height; ++j2) {
                for (int k2 = z0; k2 < z0 + width; ++k2) {
                    world.k(i2, j2, k2);
                    world.j(i2, j2, k2, blockID);
                }
            }
        }
    }

    public static int findWaterLevel(xd worldObj, int i2, int j2, int k2, int lengthBlocks, int heightBlocks, int widthBlocks) {
        int y2;
        for (y2 = j2 + heightBlocks; y2 >= j2; --y2) {
            for (int x2 = i2 - 1; x2 < i2 + lengthBlocks + 1; ++x2) {
                for (int z2 = k2 - 1; z2 < k2 + widthBlocks + 1; ++z2) {
                    if (worldObj.a(x2, y2, z2) != pb.A.bO && worldObj.a(x2, y2, z2) != pb.B.bO) continue;
                    return y2;
                }
            }
        }
        return y2;
    }

    public static boolean hasBlockBelow(xd w2, wu bb2, int maxHeight) {
        int y2 = (int)bb2.b;
        for (int j2 = 0; j2 < maxHeight; ++j2) {
            int x2 = (int)Math.floor(bb2.a);
            while ((double)x2 < Math.ceil(bb2.d)) {
                int z2 = (int)Math.floor(bb2.c);
                while ((double)z2 < Math.ceil(bb2.f)) {
                    if (w2.a(x2, y2, z2) != 0) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            --y2;
        }
        return false;
    }

    public static boolean hasBlockBelow(xd w2, bo pos, int maxHeight) {
        int i2 = (int)pos.b;
        int j2 = 0;
        while (w2.a((int)Math.floor(pos.a), i2, (int)Math.floor(pos.c)) == 0) {
            --i2;
            if (++j2 <= maxHeight) continue;
            return false;
        }
        return true;
    }

    public static int copyBlocksRaw(xd world1, int x2, int y2, int z2, int l2, int h2, int w2, xd world2, int x22, int y22, int z22) {
        int numBlocks = 0;
        int i2 = x22;
        for (int i3 = x2; i3 < x2 + l2; ++i3) {
            int j2 = y22;
            for (int j3 = y2; j3 < y2 + h2; ++j3) {
                int k2 = z22;
                for (int k3 = z2; k3 < z2 + w2; ++k3) {
                    if (WorldUtil.copyBlockRaw(world1, world2, i3, j3, k3, i2, j2, k2, BlockManager.EXCLUDED_BLOCKS)) {
                        WorldUtil.moveTileEntity(world1, world2, i3, j3, k3, i2, j2, k2);
                        ++numBlocks;
                    }
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        return numBlocks;
    }

    public static void updateBox(xd world2, int x2, int y2, int z2, int length, int height, int width) {
        for (int i2 = x2 - 1; i2 < x2 + length + 2; ++i2) {
            for (int j2 = y2 - 1; j2 < y2 + height + 2; ++j2) {
                for (int k2 = z2 - 1; k2 < z2 + width + 2; ++k2) {
                    world2.u(i2, j2, k2);
                    world2.k(i2, j2, k2);
                    world2.j(i2, j2, k2, world2.a(i2, j2, k2));
                }
            }
        }
    }

    private static int discreteCos(int angle) {
        int[] cos = new int[]{1, 0, -1, 0};
        return cos[angle];
    }

    private static int discreteSin(int angle) {
        int[] sin = new int[]{0, 1, 0, -1};
        return sin[angle];
    }

    public static int copyBlocksRaw(xd world1, int x0, int y0, int z0, xd world2, int cornerX, int cornerY, int cornerZ, Set blocks2) {
        int numBlocks = 0;
        for (Vector3i pos : blocks2) {
            int x2 = pos.x - x0 + cornerX;
            int y2 = pos.y - y0 + cornerY;
            int z2 = pos.z - z0 + cornerZ;
            if (!WorldUtil.copyBlockRaw(world1, world2, pos.x, pos.y, pos.z, x2, y2, z2, BlockManager.EXCLUDED_BLOCKS)) continue;
            WorldUtil.moveTileEntity(world1, world2, pos.x, pos.y, pos.z, x2, y2, z2);
            ++numBlocks;
        }
        return numBlocks;
    }

    public static int copyBlocksRaw(xd world1, bo posWorld1, bo size, xd world2, bo posWorld2, double rotationYaw) {
        Minecraft mc2 = ModLoader.getMinecraftInstance();
        int facing = (int)(rotationYaw / 360.0 * 4.0) % 4;
        System.out.println(facing);
        int[] dir = new int[]{WorldUtil.discreteCos(facing), WorldUtil.discreteSin(facing)};
        int facingNormal = (facing + 1) % 4;
        int[] dirNormal = new int[]{WorldUtil.discreteCos(facingNormal), WorldUtil.discreteSin(facingNormal)};
        int numBlocks = 0;
        Vector3i posSrc0 = new Vector3i(posWorld1);
        Vector3i posDest0 = new Vector3i(posWorld2);
        Vector3i posSrc = new Vector3i(posWorld1);
        Vector3i posDest = new Vector3i(posWorld2);
        int i2 = 0;
        while ((double)i2 < size.a) {
            posSrc.x = posSrc0.x + i2;
            int j2 = 0;
            while ((double)j2 < size.b) {
                posSrc.y = posSrc0.y + j2;
                posDest.y = posDest0.y + j2;
                int k2 = 0;
                while ((double)k2 < size.c) {
                    posSrc.z = posSrc0.z + k2;
                    posDest.x = posDest0.x + dir[0] * i2 + dirNormal[0] * k2;
                    posDest.z = posDest0.z + dir[1] * i2 + dirNormal[1] * k2;
                    if (WorldUtil.copyBlockRaw(world1, world2, posSrc.x, posSrc.y, posSrc.z, posDest.x, posDest.y, posDest.z, BlockManager.EXCLUDED_BLOCKS)) {
                        WorldUtil.moveTileEntity(world1, world2, posSrc.x, posSrc.y, posSrc.z, posDest.x, posDest.y, posDest.z);
                    }
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        return numBlocks;
    }

    public static boolean copyBlock(xd world1, xd world2, int i2, int j2, int k2, int i22, int j22, int k22, BlockSet excludedBlocks) {
        int blockID = world1.a(i2, j2, k2);
        int metadata = world1.e(i2, j2, k2);
        int destBlockID = world2.a(i22, j22, k22);
        if (blockID == 0 && (destBlockID == pb.A.bO || destBlockID == pb.B.bO)) {
            return true;
        }
        BlockInfo bi2 = new BlockInfo(blockID, (Integer)metadata);
        if (excludedBlocks == null || !excludedBlocks.contains(bi2)) {
            world2.b(i22, j22, k22, blockID, metadata);
            WorldUtil.moveTileEntity(world1, world2, i2, j2, k2, i22, j22, k22);
            return true;
        }
        return false;
    }

    private static void moveTileEntity(xd world1, xd world2, int i2, int j2, int k2, int i22, int j22, int k22) {
        kw tileEntity = world1.b(i2, j2, k2);
        if (tileEntity != null) {
            if (tileEntity instanceof io) {
                List itemStacks = WorldUtil.removeAllItemStacks((io)((Object)tileEntity));
                world1.b(i2, j2, k2, 0, 0);
                tileEntity.m();
                world2.a(i22, j22, k22, tileEntity);
                WorldUtil.addAllItemStacks((io)((Object)tileEntity), itemStacks);
            } else {
                world1.b(i2, j2, k2, 0, 0);
                tileEntity.m();
                world2.a(i22, j22, k22, tileEntity);
            }
        }
    }

    public static boolean copyBlockRaw(xd world1, xd world2, int x2, int y2, int z2, int x22, int y22, int z22, BlockSet excludedBlocks) {
        if (x22 >= -30000000 && z22 >= -30000000 && x22 < 30000000 && z22 < 30000000) {
            BlockInfo bi2 = new BlockInfo(world1.a(x2, y2, z2), (Integer)world1.e(x2, y2, z2));
            if (excludedBlocks == null || !excludedBlocks.contains(bi2)) {
                int metadata = world1.e(x2, y2, z2);
                int lightValue = WorldUtil.getLightValueRaw(world1, x2, y2, z2);
                int skylightValue = WorldUtil.getSkylightValueRaw(world1, x2, y2, z2);
                if (y22 < 0) {
                    return false;
                }
                if (y22 >= 256) {
                    return false;
                }
                ack chunk = WorldUtil.getChunk(world2, x22, y22, z22);
                WorldUtil.setDataRaw(world2, x22, y22, z22, bi2.getBlockID(), metadata, lightValue, skylightValue);
                return true;
            }
        }
        return false;
    }

    public static ack getChunk(xd world, int x2, int y2, int z2) {
        int chunkX = x2 >> 4;
        int chunkZ = z2 >> 4;
        return world.d(chunkX, chunkZ);
    }

    public static int getSkylightValueRaw(xd world, int x2, int y2, int z2) {
        ack chunk = WorldUtil.getChunk(world, x2, y2, z2);
        zg ebs = chunk.i()[y2 >> 4];
        if (ebs == null) {
            return 0;
        }
        return ebs.c(x2 & 0xF, y2 & 0xF, z2 & 0xF);
    }

    public static int getLightValueRaw(xd world, int x2, int y2, int z2) {
        ack chunk = WorldUtil.getChunk(world, x2, y2, z2);
        zg ebs = chunk.i()[y2 >> 4];
        if (ebs == null) {
            return 0;
        }
        return ebs.d(x2 & 0xF, y2 & 0xF, z2 & 0xF);
    }

    public static void setDataRaw(xd world, int x2, int y2, int z2, int blockID, int metadata, int lightValue, int skylightValue) {
        int ebsY = y2 >> 4;
        ack chunk = WorldUtil.getChunk(world, x2, y2, z2);
        if (ebsY < chunk.i().length) {
            zg ebs = chunk.i()[ebsY];
            if (ebs == null) {
                chunk.i()[ebsY] = new zg(ebsY << 4);
                ebs = chunk.i()[ebsY];
            }
            ebs.a(x2 & 0xF, y2 & 0xF, z2 & 0xF, blockID);
            ebs.b(x2 & 0xF, y2 & 0xF, z2 & 0xF, metadata);
            ebs.d(x2 & 0xF, y2 & 0xF, z2 & 0xF, lightValue);
            ebs.c(x2 & 0xF, y2 & 0xF, z2 & 0xF, skylightValue);
        }
    }

    private static void addAllItemStacks(io inventory, List itemStacks) {
        for (int i2 = 0; i2 < inventory.a() && i2 < itemStacks.size(); ++i2) {
            inventory.a(i2, (aan)itemStacks.get(i2));
        }
    }

    private static List removeAllItemStacks(io inventory) {
        ArrayList<aan> itemStacks = new ArrayList<aan>();
        for (int i2 = 0; i2 < inventory.a(); ++i2) {
            itemStacks.add(inventory.k_(i2));
            inventory.a(i2, null);
        }
        return itemStacks;
    }

    public static Vector3i findClosestBlock(xd world, MultiBlock multiBlock, Integer blockSubtype, int x0, int y0, int z0, int dirX, int dirY, int dirZ, int maxDist) {
        int blockIDtoFind;
        Vector3i pos = new Vector3i(x0, y0, z0);
        if (multiBlock == null) {
            blockIDtoFind = 0;
        } else {
            MultiBlock block = multiBlock;
            blockIDtoFind = block.bO;
        }
        for (int numBlocks = 0; numBlocks < maxDist; ++numBlocks) {
            int blockID = world.a(pos.x, pos.y, pos.z);
            int subtype = multiBlock.getSubtype(world.e(pos.x, pos.y, pos.z));
            if (blockID == blockIDtoFind && (blockSubtype == null || blockSubtype == subtype)) {
                return pos;
            }
            pos.increment(dirX, dirY, dirZ);
        }
        return null;
    }

    public static Vector3i findLongestContiguousBlocks(xd world, BlockSet blockSet, int x0, int y0, int z0, int dirX, int dirY, int dirZ, int maxDist) {
        Vector3i pos = new Vector3i(x0, y0, z0);
        for (int numBlocks = 0; numBlocks < maxDist; ++numBlocks) {
            int metadata;
            int blockID = world.a(pos.x, pos.y, pos.z);
            if (!blockSet.contains(new BlockInfo(blockID, (Integer)(metadata = world.e(pos.x, pos.y, pos.z))))) {
                return pos;
            }
            pos.increment(dirX, dirY, dirZ);
        }
        return pos;
    }

    public static Vector3i findLongestContiguousBlocks(xd world, MultiBlock multiBlock, Integer blockSubtype, int x0, int y0, int z0, int dirX, int dirY, int dirZ, int maxDist) {
        int blockIDtoFind;
        Vector3i pos = new Vector3i(x0, y0, z0);
        if (multiBlock == null) {
            blockIDtoFind = 0;
        } else {
            MultiBlock block = multiBlock;
            blockIDtoFind = block.bO;
        }
        for (int numBlocks = 0; numBlocks < maxDist; ++numBlocks) {
            int blockID = world.a(pos.x, pos.y, pos.z);
            int subtype = 0;
            if (multiBlock != null) {
                subtype = multiBlock.getSubtype(world.e(pos.x, pos.y, pos.z));
            }
            if (blockID != blockIDtoFind || blockSubtype != null && blockSubtype != subtype) {
                return pos;
            }
            pos.increment(dirX, dirY, dirZ);
        }
        return pos;
    }

    public static List findAllBlocksOfType(xd world, MultiBlock multiBlock, Integer blockSubtype, int x0, int y0, int z0, int dirX, int dirY, int dirZ, int maxDist) {
        ArrayList<Vector3i> blocks2 = new ArrayList<Vector3i>();
        Vector3i pos = new Vector3i(x0, y0, z0);
        MultiBlock block = multiBlock;
        for (int numBlocks = 0; numBlocks < maxDist; ++numBlocks) {
            int blockID = world.a(pos.x, pos.y, pos.z);
            int subtype = multiBlock.getSubtype(world.e(pos.x, pos.y, pos.z));
            if (blockID == block.bO && (blockSubtype == null || blockSubtype == subtype)) {
                blocks2.add(new Vector3i(pos));
            }
            pos.increment(dirX, dirY, dirZ);
        }
        return blocks2;
    }

    public static bo findBoatPosition(aan itemStack, xd world, yw player) {
        float var20;
        float var17;
        double var21;
        float var16;
        float var4 = 1.0f;
        float pitch = player.x + (player.v - player.x) * var4;
        float yaw = player.w + (player.u - player.w) * var4;
        double x2 = player.l + (player.o - player.l) * (double)var4;
        double y2 = player.m + (player.p - player.m) * (double)var4 + 1.62 - (double)player.H;
        double z2 = player.n + (player.q - player.n) * (double)var4;
        bo pos = bo.b(x2, y2, z2);
        float var14 = gk.b(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float var15 = gk.a(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float var18 = var15 * (var16 = -gk.b(-pitch * ((float)Math.PI / 180)));
        bo pos2 = pos.c((double)var18 * (var21 = 5.0), (double)(var17 = gk.a(-pitch * ((float)Math.PI / 180))) * var21, (double)(var20 = var14 * var16) * var21);
        pl mop = world.a(pos, pos2, true);
        if (mop != null) {
            bo look = player.k(var4);
            boolean flag = false;
            float expand = 1.0f;
            List var28 = world.b((nn)player, player.y.a(look.a * var21, look.b * var21, look.c * var21).b(expand, expand, expand));
            for (int i2 = 0; i2 < var28.size(); ++i2) {
                float border;
                wu var32;
                nn entity = (nn)var28.get(i2);
                if (!entity.l_() || !(var32 = entity.y.b(border = entity.j_(), border, border)).a(pos)) continue;
                flag = true;
            }
            if (!flag && mop.a == aat.a) {
                int blockX = mop.b;
                int blockY = mop.c;
                int blockZ = mop.d;
                if (!world.F) {
                    if (world.a(blockX, blockY, blockZ) == pb.aS.bO) {
                        --blockY;
                    }
                    return bo.a((float)blockX + 0.5f, (float)blockY + 1.0f, (float)blockZ + 0.5f);
                }
            }
        }
        return null;
    }

    public static void fillBlocksWithValue(xd world, Set blocks2, int blockID, int metadata, BlockSet eXCLUDED_BLOCKS) {
        for (Vector3i pos : blocks2) {
            WorldUtil.setDataRaw(world, pos.x, pos.y, pos.z, blockID, metadata, 0, 0);
        }
    }
}

