/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.util;

public class Physics {
    public static final double GRAVITY_ACCELERATION = 0.025;
    public static final double WATER_DAMPING = (double)0.99f;
    public static final double MIN_VERTICAL_WATER_DAMPING = (double)0.85f;
    public static final double MAX_VERTICAL_WATER_DAMPING = (double)0.97f;
    public static final double GROUND_DAMPING = (double)0.01f;
    public static final double AIR_DAMPING = (double)0.999f;
    public static final float ANGULAR_DAMPING = 0.9f;
    public static final float WAVE_OFFSET = -0.1f;
    public static final float AVERAGE_BLOCK_DENSITY = 0.5f;
    public static float WAVE_FREQUENCY = 0.125f;
    public static float WAVE_AMPLITUDE = 1.0f;
    public static long timeForNextWaveChange;

    public static double getVerticalWaterDamping(double mass) {
        double y2 = mass;
        if (y2 > 1000.0) {
            y2 = 1000.0;
        }
        return (double)0.85f + 0.12000000476837158 * (1000.0 - y2) / 1001.0;
    }

    public static void updateWaves() {
        long currentTime = System.currentTimeMillis();
        if (currentTime > timeForNextWaveChange) {
            if ((double)(WAVE_AMPLITUDE = (float)((double)WAVE_AMPLITUDE + (Math.random() - 0.5) * 0.001)) < 0.01) {
                WAVE_AMPLITUDE = 0.01f;
            }
            if ((double)WAVE_AMPLITUDE > 0.15) {
                WAVE_AMPLITUDE = 0.15f;
            }
            if ((double)(WAVE_FREQUENCY = (float)((double)WAVE_FREQUENCY + (Math.random() - 0.5) * 0.001)) < 0.01) {
                WAVE_FREQUENCY = 0.01f;
            }
            if (WAVE_FREQUENCY > 1.0f) {
                WAVE_FREQUENCY = 1.0f;
            }
            long waitTime = (long)((Math.random() * 120.0 + 360.0) * 1000.0);
            timeForNextWaveChange = currentTime + waitTime;
            System.out.println("Wave changed. Amp: " + WAVE_AMPLITUDE + ", Freq: " + WAVE_FREQUENCY + " Wait: " + waitTime / 1000L + "s");
        }
    }
}

