/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class IOUtil {
    private static long[] lastTimeKeyPressed = new long[500];
    private static long[] lastTimeMousePressed = new long[50];
    private static boolean[] wasMouseButtonPressed = new boolean[50];
    public static final int MOUSE_LEFT_BUTTON = 0;
    public static final int MOUSE_RIGHT_BUTTON = 1;
    public static final int MOUSE_MIDDLE_BUTTON = 2;
    private static DecimalFormat formatter = new DecimalFormat("#.####");

    public static boolean isKeyPressed(int key, long interval) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastTimeKeyPressed[key] > interval && Keyboard.isKeyDown((int)key)) {
            IOUtil.lastTimeKeyPressed[key] = currentTime;
            return true;
        }
        return false;
    }

    public static boolean isMouseButtonClicked(int button, long interval) {
        long currentTime = System.currentTimeMillis();
        if (Mouse.isButtonDown((int)button)) {
            IOUtil.wasMouseButtonPressed[button] = true;
            IOUtil.lastTimeMousePressed[button] = currentTime;
        } else if (currentTime - lastTimeMousePressed[button] > interval && wasMouseButtonPressed[button]) {
            IOUtil.wasMouseButtonPressed[button] = false;
            return true;
        }
        return false;
    }

    public static boolean isMouseButtonPressed(int button) {
        return Mouse.isButtonDown((int)button);
    }

    public static void getAllFiles(File startDir, List files) {
        if (startDir.exists()) {
            File[] list;
            for (File f2 : list = startDir.listFiles()) {
                if (f2.isDirectory()) {
                    IOUtil.getAllFiles(f2, files);
                    continue;
                }
                files.add(f2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void deleteOldMCRegionFiles(File emobSaveDir) {
        ArrayList files = new ArrayList();
        IOUtil.getAllFiles(emobSaveDir, files);
        for (File f2 : files) {
            if (!f2.getName().endsWith(".mcr")) continue;
            f2.delete();
        }
    }

    public static String changeExtension(String name, String oldExtension, String newExtension) {
        return name.substring(0, name.length() - oldExtension.length()) + newExtension;
    }

    public static String formatDecimal(double num) {
        return formatter.format(num);
    }
}

