/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static void getAllFiles(File startDir, List files) {
        if (startDir.exists()) {
            File[] list;
            for (File f2 : list = startDir.listFiles()) {
                if (f2.isDirectory()) {
                    FileUtil.getAllFiles(f2, files);
                    continue;
                }
                files.add(f2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void deleteOldMCRegionFiles(File emobSaveDir) {
        ArrayList files = new ArrayList();
        FileUtil.getAllFiles(emobSaveDir, files);
        for (File f2 : files) {
            if (!f2.getName().endsWith(".mcr")) continue;
            f2.delete();
        }
    }

    public static String changeExtension(String name, String oldExtension, String newExtension) {
        return name.substring(0, name.length() - oldExtension.length()) + newExtension;
    }
}

