/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.util;

import com.jme3.math.Ray;
import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class CoordsUtil {
    public static int[][] triangles = new int[][]{{0, 1, 2}, {2, 3, 0}, {4, 5, 6}, {6, 7, 4}, {1, 5, 6}, {6, 2, 1}, {0, 4, 7}, {7, 3, 0}, {3, 2, 6}, {6, 7, 3}, {0, 1, 5}, {5, 4, 0}};
    private static double[][] dirs = new double[][]{{-1.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, -1.0}, {0.0, 0.0, 1.0}};
    private static Set excludedEntities = new HashSet();
    public static final bo UNIT_VECTOR_Z = bo.a(0.0, 0.0, 1.0);

    public static Vector4f localPosToParent(Vector4f localPos, org.lwjgl.util.vector.Vector3f pos, org.lwjgl.util.vector.Vector3f rot) {
        Matrix4f m2 = new Matrix4f();
        m2.translate(pos);
        rot.y = -rot.y;
        CoordsUtil.rotate(m2, rot);
        Vector4f result = new Vector4f();
        Matrix4f.transform((Matrix4f)m2, (Vector4f)localPos, (Vector4f)result);
        rot.y = -rot.y;
        return result;
    }

    public static Vector4f localVelToParent(Vector4f localVel, org.lwjgl.util.vector.Vector3f rot) {
        Matrix4f m2 = new Matrix4f();
        rot.y = -rot.y;
        CoordsUtil.rotate(m2, rot);
        Vector4f result = new Vector4f();
        Matrix4f.transform((Matrix4f)m2, (Vector4f)localVel, (Vector4f)result);
        rot.y = -rot.y;
        return result;
    }

    public static Vector4f parentPosToLocal(Vector4f parentPos, org.lwjgl.util.vector.Vector3f pos, org.lwjgl.util.vector.Vector3f rot) {
        Matrix4f m2 = new Matrix4f();
        rot.y = -rot.y;
        CoordsUtil.rotateInverse(m2, rot);
        m2.translate(pos.negate(pos));
        Vector4f result = new Vector4f();
        Matrix4f.transform((Matrix4f)m2, (Vector4f)parentPos, (Vector4f)result);
        rot.y = -rot.y;
        return result;
    }

    public static Vector4f parentVelToLocal(Vector4f parentVel, org.lwjgl.util.vector.Vector3f rot) {
        Matrix4f m2 = new Matrix4f();
        rot.y = -rot.y;
        CoordsUtil.rotateInverse(m2, rot);
        Vector4f result = new Vector4f();
        Matrix4f.transform((Matrix4f)m2, (Vector4f)parentVel, (Vector4f)result);
        rot.y = -rot.y;
        return result;
    }

    public static void rotate(Matrix4f m2, org.lwjgl.util.vector.Vector3f rot) {
        m2.rotate(rot.y, new org.lwjgl.util.vector.Vector3f(0.0f, 1.0f, 0.0f));
        m2.rotate(rot.z, new org.lwjgl.util.vector.Vector3f(0.0f, 0.0f, 1.0f));
        m2.rotate(rot.x, new org.lwjgl.util.vector.Vector3f(1.0f, 0.0f, 0.0f));
    }

    public static void rotateInverse(Matrix4f m2, org.lwjgl.util.vector.Vector3f rot) {
        m2.rotate(-rot.x, new org.lwjgl.util.vector.Vector3f(1.0f, 0.0f, 0.0f));
        m2.rotate(-rot.z, new org.lwjgl.util.vector.Vector3f(0.0f, 0.0f, 1.0f));
        m2.rotate(-rot.y, new org.lwjgl.util.vector.Vector3f(0.0f, 1.0f, 0.0f));
    }

    public static org.lwjgl.util.vector.Vector3f getEulerAnglesFromMatrix(Matrix4f m2) {
        org.lwjgl.util.vector.Vector3f result = new org.lwjgl.util.vector.Vector3f((float)Math.atan2(m2.m21, m2.m11), -((float)Math.atan2(m2.m02, m2.m00)), -((float)Math.asin(-m2.m01)));
        return result;
    }

    public static org.lwjgl.util.vector.Vector3f getPosVector3f(nn entity) {
        return new org.lwjgl.util.vector.Vector3f((float)entity.o, (float)entity.p, (float)entity.q);
    }

    public static Vector4f getPosVector4f(nn entity) {
        return new Vector4f((float)entity.o, (float)entity.p, (float)entity.q, 1.0f);
    }

    public static Vector4f getVelVector4f(nn entity) {
        return new Vector4f((float)entity.r, (float)entity.s, (float)entity.t, 1.0f);
    }

    public static org.lwjgl.util.vector.Vector3f getRotVector3f(nn entity) {
        return new org.lwjgl.util.vector.Vector3f(0.0f, (float)Math.toRadians(entity.u), (float)Math.toRadians(entity.v));
    }

    public static org.lwjgl.util.vector.Vector3f getLastTickPosVector3f(nn vehicle) {
        return new org.lwjgl.util.vector.Vector3f((float)vehicle.N, (float)vehicle.O, (float)vehicle.P);
    }

    public static Vector4f getLastTickPosVector4f(nn parentEntity) {
        return new Vector4f((float)parentEntity.N, (float)parentEntity.O, (float)parentEntity.P, 1.0f);
    }

    public static double returnOrigIfDifferenceTooLow(double orig, double other) {
        if (Math.abs(orig - other) < 1.0E-4) {
            return orig;
        }
        return other;
    }

    public static bo collideWithBlock(wu entityBB, bo entityV, wu bb2) {
        double[] dist = new double[]{entityBB.d - bb2.a, bb2.d - entityBB.a, entityBB.e - bb2.b, bb2.e - entityBB.b, entityBB.f - bb2.c, bb2.f - entityBB.c};
        if (Math.abs(entityV.b) > 0.4) {
            System.out.printf("%.2f, %.2f, %.2f, %.2f, %.2f, %.2f\n", dist[0], dist[1], dist[2], dist[3], dist[4], dist[5]);
        }
        if (entityV.b < 0.0 && dist[3] >= 1.0) {
            return bo.a(0.0, dist[2], 0.0);
        }
        if (entityV.b > 0.0 && dist[2] >= 1.0) {
            return bo.a(0.0, -dist[3], 0.0);
        }
        double minDist = Double.MAX_VALUE;
        int minPos = 0;
        for (int i2 = 0; i2 < dist.length; ++i2) {
            if (!(dist[i2] < minDist) || !(dist[i2] > 0.0)) continue;
            minDist = dist[i2];
            minPos = i2;
        }
        return bo.a(dist[minPos] * dirs[minPos][0], dist[minPos] * dirs[minPos][1], dist[minPos] * dirs[minPos][2]);
    }

    public static double assignIfDifferenceIsGreaterThan(double difference, double newValue, double oldValue) {
        if (Math.abs(newValue - oldValue) > difference) {
            return newValue;
        }
        return oldValue;
    }

    public static boolean equals(Vector4f v1, Vector4f v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        return v1.x == v2.x && v1.y == v2.y && v1.z == v2.z && v1.w == v2.w;
    }

    public static boolean equals(bo v1, bo v2) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        return v1.a == v2.a && v1.b == v2.b && v1.c == v2.c;
    }

    public static pl rayTrace(Emob emob, nn entity, double dist) {
        EmobWorld emobWorld = emob.emobWorld;
        bo pos = CoordsUtil.getPos(entity);
        bo look = CoordsUtil.getLook(entity);
        bo posLook = pos.c(look.a * dist, look.b * dist, look.c * dist);
        pos = emob.convertToPosInLocalCoords(pos);
        posLook = emob.convertToPosInLocalCoords(posLook);
        return emobWorld.a(pos, posLook);
    }

    public static bo getPos(nn entity) {
        bo pos = bo.a(entity.o, entity.p, entity.q);
        return pos;
    }

    public static bo getLook(nn entity) {
        double cosYaw = Math.cos((double)(-entity.u * 0.01745329f) - Math.PI);
        double sinYaw = Math.sin((double)(-entity.u * 0.01745329f) - Math.PI);
        double cosPitch = -Math.cos(-entity.v * 0.01745329f);
        double sinPitch = Math.sin(-entity.v * 0.01745329f);
        bo look = bo.a(sinYaw * cosPitch, sinPitch, cosYaw * cosPitch);
        return look;
    }

    public static float standardizeAngle(float angle) {
        if (angle < 0.0f) {
            return angle + 360.0f;
        }
        if (angle > 360.0f) {
            return angle - 360.0f;
        }
        return angle;
    }

    public static bo rotateVector(bo vec, double angleInDegrees) {
        double angle = angleInDegrees * Math.PI / 180.0;
        double cosa = Math.cos(angle);
        double sina = Math.sin(angle);
        return bo.a(vec.a * cosa - vec.c * sina, vec.b, vec.c * cosa + vec.a * sina);
    }

    public static bo rotateVector2(bo vectorInLocalCoordinates, double rotationAngle) {
        double r2 = Math.sqrt(vectorInLocalCoordinates.a * vectorInLocalCoordinates.a + vectorInLocalCoordinates.c * vectorInLocalCoordinates.c);
        double angle = Math.atan2(vectorInLocalCoordinates.c, vectorInLocalCoordinates.a) + rotationAngle * Math.PI / 180.0;
        bo rotatedVector = bo.a(r2 * Math.cos(angle), vectorInLocalCoordinates.b, r2 * Math.sin(angle));
        return rotatedVector;
    }

    public static double invertedHyperbole(double x2) {
        return -1.0 / (x2 + 1.0) + 1.0;
    }

    public static bo getPrevPos(nn entity) {
        bo pos = bo.a(entity.l, entity.m, entity.n);
        return pos;
    }

    public static bo getMotion(nn entity) {
        return bo.a(entity.r, entity.s, entity.t);
    }

    public static boolean calculateOffset(bo bb1Offset, Vector3f[] bb1Points, Vector3f[] bb2Points) {
        Triangle[] bb2Triangles = CoordsUtil.getTriangles(bb2Points);
        bo prevOffset = bo.a(bb1Offset.a, bb1Offset.b, bb1Offset.c);
        double minDist = Double.MAX_VALUE;
        Vector3f minIntersection = new Vector3f();
        Vector3f minOrigin = new Vector3f();
        Ray r2 = new Ray();
        Vector3f origin = new Vector3f();
        Vector3f direction = new Vector3f((float)(-bb1Offset.a), (float)(-bb1Offset.b), (float)(-bb1Offset.c));
        Vector3f intersection = new Vector3f();
        r2.setDirection(direction);
        for (int i2 = 0; i2 < bb1Points.length; ++i2) {
            origin.set(bb1Points[i2]);
            r2.setOrigin(origin);
            for (int j2 = 0; j2 < bb2Triangles.length; ++j2) {
                float d2;
                if (!r2.intersectWhere(bb2Triangles[j2], intersection) || !((double)(d2 = origin.distanceSquared(intersection)) < minDist)) continue;
                minDist = d2;
                minOrigin.set(origin);
                minIntersection.set(intersection);
                Triangle triangle = bb2Triangles[j2];
            }
        }
        if (minDist != Double.MAX_VALUE && minDist < bb1Offset.a * bb1Offset.a + bb1Offset.b * bb1Offset.b + bb1Offset.c * bb1Offset.c) {
            double adjustment = -0.001;
            bb1Offset.a = minOrigin.x - minIntersection.x;
            bb1Offset.b = minOrigin.y - minIntersection.y;
            bb1Offset.c = minOrigin.z - minIntersection.z;
            if (prevOffset.a != bb1Offset.a) {
                bb1Offset.a += Math.signum(bb1Offset.a) * adjustment;
            }
            if (prevOffset.b != bb1Offset.b) {
                bb1Offset.b += Math.signum(bb1Offset.b) * adjustment;
            }
            if (prevOffset.c != bb1Offset.c) {
                bb1Offset.c += Math.signum(bb1Offset.c) * adjustment;
            }
            return true;
        }
        return false;
    }

    public static Vector3f[] getEmobPointsInParentCoords(Emob emob) {
        bo c0 = emob.emobWorld.emob.emobWorld.getLowerBackLeftCorner();
        bo c6 = emob.emobWorld.emob.emobWorld.getUpperFrontRightCorner(c0);
        bo c0Parent = emob.convertToPosInParentCoords(c0);
        bo c6Parent = emob.convertToPosInParentCoords(c6);
        Vector3f[] points = CoordsUtil.getBBPoints(new double[]{c0Parent.a, c0Parent.b, c0Parent.c}, new double[]{c6Parent.a, c6Parent.b, c6Parent.c});
        return points;
    }

    public static Vector3f[] getBBPoints(double[] corner0, double[] corner1) {
        Vector3f[] points = new Vector3f[8];
        points[0] = new Vector3f((float)corner0[0], (float)corner0[1], (float)corner0[2]);
        points[6] = new Vector3f((float)corner1[0], (float)corner1[1], (float)corner1[2]);
        points[1] = new Vector3f(points[6].x, points[0].y, points[0].z);
        points[2] = new Vector3f(points[6].x, points[6].y, points[0].z);
        points[3] = new Vector3f(points[0].x, points[6].y, points[0].z);
        points[4] = new Vector3f(points[0].x, points[0].y, points[6].z);
        points[5] = new Vector3f(points[6].x, points[0].y, points[6].z);
        points[7] = new Vector3f(points[0].x, points[6].y, points[6].z);
        return points;
    }

    private static Triangle[] getTriangles(Vector3f[] entityPoints) {
        Triangle[] t2 = new Triangle[12];
        for (int i2 = 0; i2 < 12; ++i2) {
            t2[i2] = new Triangle();
            for (int p2 = 0; p2 < 3; ++p2) {
                Vector3f point = entityPoints[triangles[i2][p2]];
                t2[i2].set(p2, point);
            }
        }
        return t2;
    }

    public static void add(bo vec1, bo vec2) {
        vec1.a += vec2.a;
        vec1.b += vec2.b;
        vec1.c += vec2.c;
    }

    public static void multiply(bo vec1, double num) {
        vec1.a *= num;
        vec1.b *= num;
        vec1.c *= num;
    }

    public static bo calculateFromVector(nn entity, float ticks) {
        double x2 = entity.l + (entity.o - entity.l) * (double)ticks;
        double y2 = entity.m + (entity.p - entity.m) * (double)ticks + 1.62 - (double)entity.H;
        double z2 = entity.n + (entity.q - entity.n) * (double)ticks;
        bo from = bo.a(x2, y2, z2);
        return from;
    }

    public static bo calculateToVector(nn entity, float ticks, bo from, double maxDist) {
        float pitch = entity.x + (entity.v - entity.x) * ticks;
        float yaw = entity.w + (entity.u - entity.w) * ticks;
        float f3 = gk.b(-yaw * 0.01745329f - 3.141593f);
        float f4 = gk.a(-yaw * 0.01745329f - 3.141593f);
        float f5 = -gk.b(-pitch * 0.01745329f);
        float f6 = gk.a(-pitch * 0.01745329f);
        float dx2 = f4 * f5;
        float dy2 = f6;
        float dz2 = f3 * f5;
        bo to2 = bo.a(from.a + (double)dx2 * maxDist, from.b + (double)dy2 * maxDist, from.c + (double)dz2 * maxDist);
        return to2;
    }

    public static pl getMouseOverExcludingEntity(float ticks, nn excludedEntity) {
        excludedEntities.clear();
        excludedEntities.add(excludedEntity);
        return CoordsUtil.getMouseOverExcludingSet(ticks, excludedEntities);
    }

    public static pl getMouseOverExcludingSet(float ticks, Set excludedEntities) {
        Minecraft mc2 = ModLoader.getMinecraftInstance();
        pl objectMouseOver = null;
        if (mc2.i != null && mc2.f != null) {
            double reach = mc2.c.b();
            objectMouseOver = mc2.i.a(reach, ticks);
            double newReach = reach;
            bo from = mc2.i.j(ticks);
            if (mc2.c.i()) {
                reach = 6.0;
                newReach = 6.0;
            } else {
                if (reach > 3.0) {
                    newReach = 3.0;
                }
                reach = newReach;
            }
            if (objectMouseOver != null) {
                newReach = objectMouseOver.f.d(from);
            }
            bo look = mc2.i.k(ticks);
            bo to2 = from.c(look.a * reach, look.b * reach, look.c * reach);
            nn pointedEntity = null;
            float var9 = 1.0f;
            List entities = mc2.f.b((nn)mc2.i, mc2.i.y.a(look.a * reach, look.b * reach, look.c * reach).b(var9, var9, var9));
            double postNewReach = newReach;
            for (int i2 = 0; i2 < entities.size(); ++i2) {
                double dist;
                nn entity = (nn)entities.get(i2);
                if (!entity.l_() || excludedEntities != null && excludedEntities.contains(entity)) continue;
                float border = entity.j_();
                wu bb2 = entity.y.b(border, border, border);
                pl var17 = bb2.a(from, to2);
                if (bb2.a(from)) {
                    if (!(0.0 < postNewReach) && postNewReach != 0.0) continue;
                    pointedEntity = entity;
                    postNewReach = 0.0;
                    continue;
                }
                if (var17 == null || !((dist = from.d(var17.f)) < postNewReach) && postNewReach != 0.0) continue;
                pointedEntity = entity;
                postNewReach = dist;
            }
            if (pointedEntity != null && (postNewReach < newReach || objectMouseOver == null)) {
                objectMouseOver = new pl(pointedEntity);
            }
        }
        return objectMouseOver;
    }
}

