/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.util;

import java.util.HashSet;
import java.util.Set;

public class BlockUtil {
    public static void drawCube(xd world, int x2, int y2, int z2, int x0, int y0, int z0, Set immutableBlockIDs, int bid) {
        BlockUtil.line(world, x2, y2, z2, x2, y0, z2, bid, immutableBlockIDs);
        BlockUtil.line(world, x0, y2, z0, x0, y0, z0, bid, immutableBlockIDs);
        BlockUtil.line(world, x2, y2, z0, x2, y0, z0, bid, immutableBlockIDs);
        BlockUtil.line(world, x0, y2, z2, x0, y0, z2, bid, immutableBlockIDs);
        BlockUtil.line(world, x2, y2, z2, x0, y2, z2, bid, immutableBlockIDs);
        BlockUtil.line(world, x2, y0, z2, x0, y0, z2, bid, immutableBlockIDs);
        BlockUtil.line(world, x2, y2, z0, x0, y2, z0, bid, immutableBlockIDs);
        BlockUtil.line(world, x2, y0, z0, x0, y0, z0, bid, immutableBlockIDs);
        BlockUtil.line(world, x2, y2, z2, x2, y2, z0, bid, immutableBlockIDs);
        BlockUtil.line(world, x0, y2, z2, x0, y2, z0, bid, immutableBlockIDs);
        BlockUtil.line(world, x2, y0, z2, x2, y0, z0, bid, immutableBlockIDs);
        BlockUtil.line(world, x0, y0, z2, x0, y0, z0, bid, immutableBlockIDs);
    }

    public static void line(xd world, int x1, int y1, int z1, int x2, int y2, int z2, int blockID, Set immutableBlockIDs) {
        if (immutableBlockIDs == null) {
            immutableBlockIDs = new HashSet();
        }
        bo step = bo.a(x2 - x1, y2 - y1, z2 - z1).c();
        double stepX = step.a;
        double stepY = step.b;
        double stepZ = step.c;
        double posX = x1;
        double posY = y1;
        double posZ = z1;
        int roundPosX = (int)Math.round(posX);
        int roundPosY = (int)Math.round(posY);
        int roundPosZ = (int)Math.round(posZ);
        while (x2 != roundPosX || y2 != roundPosY || z2 != roundPosZ) {
            if (!immutableBlockIDs.contains(world.a(roundPosX, roundPosY, roundPosZ))) {
                world.g(roundPosX, roundPosY, roundPosZ, blockID);
            }
            roundPosX = (int)Math.round(posX += stepX);
            roundPosY = (int)Math.round(posY += stepY);
            roundPosZ = (int)Math.round(posZ += stepZ);
        }
    }

    public static void createCube(xd world, int x2, int y2, int z2, int length, int height, int width, int blockID) {
        int k2;
        int j2;
        int i2;
        for (i2 = x2; i2 < x2 + length; ++i2) {
            for (j2 = y2; j2 < y2 + height; ++j2) {
                for (k2 = z2; k2 < z2 + width; ++k2) {
                    world.d(i2, j2, k2, blockID);
                }
            }
        }
        for (i2 = x2; i2 < x2 + length; ++i2) {
            for (j2 = y2; j2 < y2 + height; ++j2) {
                for (k2 = z2; k2 < z2 + width; ++k2) {
                    world.k(i2, j2, k2);
                    world.j(i2, j2, k2, blockID);
                }
            }
        }
    }

    public static int findWaterLevel(xd worldObj, int i2, int j2, int k2, int lengthBlocks, int heightBlocks, int widthBlocks) {
        int y2;
        for (y2 = j2 + heightBlocks; y2 >= j2; --y2) {
            for (int x2 = i2 - 1; x2 < i2 + lengthBlocks + 1; ++x2) {
                for (int z2 = k2 - 1; z2 < k2 + widthBlocks + 1; ++z2) {
                    if (worldObj.a(x2, y2, z2) != pb.A.bO && worldObj.a(x2, y2, z2) != pb.B.bO) continue;
                    return y2;
                }
            }
        }
        return y2;
    }
}

