/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.ships;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sirentropy.anchor.Windlass;
import sirentropy.blocks.BlockInfo;
import sirentropy.blocks.BlockSet;
import sirentropy.emob.RenderEmobExperimental;
import sirentropy.ships.BlockShip;
import sirentropy.ships.Ship;
import sirentropy.util.QueueSet;
import sirentropy.util.StatusScreen;
import sirentropy.util.Vector3i;
import sirentropy.util.WorldUtil;

public class ShipCreator {
    private int length;
    private int height;
    private int width;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private xd worldObj;
    private int maxBlocks;
    private BlockSet forbiddenBlocks;
    private Set blocks;

    public ShipCreator(xd w2, int maxBlocks, BlockSet forbiddenBlocks) {
        this.worldObj = w2;
        this.maxBlocks = maxBlocks;
        this.forbiddenBlocks = forbiddenBlocks;
    }

    public Ship createShip(int x2, int y2, int z2) {
        this.blocks = new HashSet();
        Result result = this.findAllContiguousBlocks(x2, y2, z2);
        StatusScreen.INSTANCE.changeMessageLine("Found " + this.blocks.size() + " blocks", 2, 3L);
        if (result == Result.OK) {
            if (this.isShipyardBuilt() || !mod_ShipsAndBoats.requireShipyardToBuildShip || ModLoader.getMinecraftInstance().c.h() || this.isLiftingAnchor(x2, y2, z2)) {
                Ship ship = new Ship(this.worldObj, this.minX, this.minY, this.minZ, this.maxX - this.minX + 1, this.maxY - this.minY + 1, this.maxZ - this.minZ + 1, this.blocks, mod_ShipsAndBoats.defaultFlotationLine);
                this.worldObj.a(ship);
                this.initShipRendering(ship);
                int waterLevel = WorldUtil.findWaterLevel(this.worldObj, this.minX, this.minY, this.minZ, ship.getLengthBlocks(), ship.getHeightBlocks(), ship.getWidthBlocks());
                WorldUtil.fillBlocksWithValue(this.worldObj, this.blocks, 0, 0, BlockManager.EXCLUDED_BLOCKS);
                WorldUtil.createCube(this.worldObj, this.minX, this.minY, this.minZ, ship.getLengthBlocks(), waterLevel - this.minY + 1, ship.getWidthBlocks(), 9, 0, null);
                StatusScreen.INSTANCE.changeMessageLine("Ship created successfully.", 0, 3L);
                AchievementManager.addAchievementStat(AchievementManager.firstShip);
                return ship;
            }
            StatusScreen.INSTANCE.changeMessageLine("Cannot create ship. The ship is not inside a properly-build shipyard.", 0, 3L);
        } else if (result == Result.FOUND_FORBIDDEN_BLOCKS) {
            StatusScreen.INSTANCE.changeMessageLine("Cannot create ship. Found forbidden blocks.", 0, 3L);
        } else if (result == Result.TOO_MANY_BLOCKS) {
            StatusScreen.INSTANCE.changeMessageLine("Cannot create ship. There are more than " + mod_ShipsAndBoats.maxShipSizeInBlocks + " blocks", 0, 3L);
        } else if (result == Result.NOT_ENOUGH_BLOCKS) {
            StatusScreen.INSTANCE.changeMessageLine("Cannot create ship. Ships must have a minumum of " + mod_ShipsAndBoats.minShipSizeInBlocks + " blocks", 0, 3L);
        }
        return null;
    }

    private boolean isLiftingAnchor(int x2, int y2, int z2) {
        Windlass windlass;
        if (this.worldObj.a(x2, y2, z2) == mod_ShipsAndBoats.anchorBlockID && BlockManager.anchor.isWindlass(this.worldObj, x2, y2, z2) && (windlass = (Windlass)this.worldObj.b(x2, y2, z2)) != null) {
            return windlass.hasShipBeenCreated();
        }
        return false;
    }

    protected void initShipRendering(Ship ship) {
        ship.tweakEmob();
        ship.initPlayerWrapper();
        EntityPlayerWrapper player = ship.getEmobPlayerEntity();
        player.update(0.0f);
        RenderEmobExperimental.setChunkOver(ship, player.o, player.q);
        nq frustum = new nq();
        frustum.a(player.o, player.p, player.q);
        ship.emobRender.a(frustum, 0.0f);
        ship.emobRender.a(player, false);
        ship.emobRender.a(player, 0, 0.0);
    }

    private boolean isShipyardBuilt() {
        int startY;
        int j2;
        int maxDist = 100;
        BlockShip block = BlockManager.blockShip;
        int blockSubtype = 4;
        Vector3i[] wallPoints = null;
        int numWalls = 0;
        for (j2 = startY = this.minY - 5; j2 <= this.maxY && wallPoints == null; ++j2) {
            wallPoints = this.findWall(this.maxZ - this.minZ, this.minX, j2, this.minZ, new Vector3i(-1, 0, 0), maxDist, block, blockSubtype);
        }
        if (wallPoints != null) {
            ++numWalls;
        }
        wallPoints = null;
        for (j2 = startY; j2 <= this.maxY && wallPoints == null; ++j2) {
            wallPoints = this.findWall(this.maxX - this.minX, this.minX, j2, this.maxZ, new Vector3i(0, 0, 1), maxDist, block, blockSubtype);
        }
        if (wallPoints != null) {
            ++numWalls;
        }
        wallPoints = null;
        for (j2 = startY; j2 <= this.maxY && wallPoints == null; ++j2) {
            wallPoints = this.findWall(this.maxZ - this.minZ, this.maxX, j2, this.maxZ, new Vector3i(1, 0, 0), maxDist, block, blockSubtype);
        }
        if (wallPoints != null) {
            ++numWalls;
        }
        wallPoints = null;
        for (j2 = startY; j2 <= this.maxY && wallPoints == null; ++j2) {
            wallPoints = this.findWall(this.maxX - this.minX, this.maxX, j2, this.minZ, new Vector3i(0, 0, -1), maxDist, block, blockSubtype);
        }
        if (wallPoints != null) {
            ++numWalls;
        }
        return numWalls == 3;
    }

    public Vector3i[] findWall(int minWallWidth, int x0, int y0, int z0, Vector3i dir, int maxDist, BlockShip block, int blockSubtype) {
        List shipyardPlanksPositions = WorldUtil.findAllBlocksOfType(this.worldObj, block, blockSubtype, x0, y0, z0, dir.x, dir.y, dir.z, maxDist);
        Vector3i normal = dir.cross(new Vector3i(0, -1, 0));
        for (Vector3i posStartWall : shipyardPlanksPositions) {
            Vector3i posEndWall = WorldUtil.findLongestContiguousBlocks(this.worldObj, block, blockSubtype, posStartWall.x, posStartWall.y, posStartWall.z, normal.x, normal.y, normal.z, minWallWidth);
            Vector3i wallSize = posEndWall.substract(posStartWall);
            if (!(posEndWall.length() >= (double)minWallWidth)) continue;
            return new Vector3i[]{posStartWall, posEndWall};
        }
        return null;
    }

    public Result findAllContiguousBlocks(int x2, int y2, int z2) {
        this.blocks.clear();
        this.minZ = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.minX = Integer.MAX_VALUE;
        this.maxZ = -2147483647;
        this.maxY = -2147483647;
        this.maxX = -2147483647;
        QueueSet blocksToVisit = new QueueSet();
        HashSet<Vector3i> visitedPositions = new HashSet<Vector3i>();
        Vector3i current = new Vector3i(x2, y2, z2);
        blocksToVisit.add(current);
        int numBlocks = 0;
        while (!blocksToVisit.isEmpty() && numBlocks < this.maxBlocks) {
            Vector3i[] adjacent;
            current = (Vector3i)blocksToVisit.poll();
            if (visitedPositions.contains(current)) {
                System.out.println(current);
            }
            visitedPositions.add(current);
            int blockID = this.worldObj.a(current.x, current.y, current.z);
            int metadata = this.worldObj.e(current.x, current.y, current.z);
            BlockInfo bi2 = new BlockInfo(blockID, (Integer)metadata);
            if (this.forbiddenBlocks != null && this.forbiddenBlocks.contains(bi2)) {
                return Result.FOUND_FORBIDDEN_BLOCKS;
            }
            if (BlockManager.EXCLUDED_BLOCKS.contains(bi2)) continue;
            this.blocks.add(current);
            if (current.x < this.minX) {
                this.minX = current.x;
            }
            if (current.y < this.minY) {
                this.minY = current.y;
            }
            if (current.z < this.minZ) {
                this.minZ = current.z;
            }
            if (current.x > this.maxX) {
                this.maxX = current.x;
            }
            if (current.y > this.maxY) {
                this.maxY = current.y;
            }
            if (current.z > this.maxZ) {
                this.maxZ = current.z;
            }
            ++numBlocks;
            for (Vector3i adj2 : adjacent = this.getAdjacentPositions(current)) {
                if (visitedPositions.contains(adj2)) continue;
                blocksToVisit.add(adj2);
            }
        }
        if (this.minX > this.maxX || this.minY > this.maxY || this.minZ > this.maxZ || numBlocks < mod_ShipsAndBoats.minShipSizeInBlocks) {
            return Result.NOT_ENOUGH_BLOCKS;
        }
        if (numBlocks < this.maxBlocks) {
            return Result.OK;
        }
        return Result.TOO_MANY_BLOCKS;
    }

    private Vector3i[] getAdjacentPositions(Vector3i pos) {
        Vector3i[] adjacents = new Vector3i[26];
        int vecNum = 0;
        for (int i2 = -1; i2 < 2; ++i2) {
            for (int j2 = -1; j2 < 2; ++j2) {
                for (int k2 = -1; k2 < 2; ++k2) {
                    if (i2 == 0 && j2 == 0 && k2 == 0) continue;
                    adjacents[vecNum] = new Vector3i(pos.x + i2, pos.y + j2, pos.z + k2);
                    ++vecNum;
                }
            }
        }
        return adjacents;
    }

    public static enum Result {
        OK,
        TOO_MANY_BLOCKS,
        FOUND_FORBIDDEN_BLOCKS,
        NOT_ENOUGH_BLOCKS;

    }
}

