/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.ships;

import java.util.Collection;
import java.util.Set;
import sirentropy.anchor.Windlass;
import sirentropy.emob.State;
import sirentropy.event.Event;
import sirentropy.physics.AetherPump;
import sirentropy.physics.Propeller;
import sirentropy.physics.Rudder;
import sirentropy.physics.Water;
import sirentropy.physics.WaterPump;
import sirentropy.ships.ShipEvents;
import sirentropy.util.StatusScreen;

public class Ship
extends Emob {
    protected State DROPPING_ANCHOR = new State(){

        @Override
        public void onUpdate(Emob emob) {
            Ship.this.onDroppingAnchor();
        }
    };
    public static Integer[] forbiddenBlocks = new Integer[]{pb.A.bO, pb.B.bO};
    private static final double MIN_SPLASH_MOTION = 0.01;
    public double timeSinceHit;
    protected double minCollisionSpeed = 1.0E-4;
    public float damageTaken;
    public float damageRotationDirection = 1.0f;
    protected bo seatLocalCoords;
    private double seatAngle;
    private float flotationLine;
    private float fractionOfShipUnderLiquid;
    private Windlass windlass;

    public Ship(xd world) {
        super(world);
        this.h = true;
    }

    public Ship(xd world, int x0, int y0, int z0, int length, int height, int width, float flotationLine) {
        super(world, x0, y0, z0, length, height, width);
        this.setFlotationLine(flotationLine);
    }

    public Ship(xd worldObj, int x0, int y0, int z0, int length, int height, int width, Set blocks2, float defaultFlotationLine) {
        super(worldObj, x0, y0, z0, length, height, width, blocks2);
        this.setFlotationLine(defaultFlotationLine);
    }

    private void setFlotationLine(float flotationLine) {
        this.flotationLine = flotationLine;
    }

    @Override
    protected void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("flotationLine", this.getFlotationLine());
        System.out.println(this + ": " + this.o + " " + this.p + " " + this.q);
    }

    @Override
    protected void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        this.setFlotationLine((float)nbttagcompound.i("flotationLine"));
        if (this.getFlotationLine() < 0.0) {
            this.setFlotationLine(0.2f);
        }
        System.out.println(this + ": " + this.o + " " + this.p + " " + this.q);
    }

    private double getFlotationLine() {
        return this.flotationLine;
    }

    @Override
    protected void onAlive() {
        lv.a("ShipMoveEntity");
        lv.b();
        double velocity = Math.sqrt(this.r * this.r + this.s * this.s + this.t * this.t);
        this.handleCollisionDamage(velocity);
        this.updatePitch();
        if (this.i != null && this.i.G) {
            this.i = null;
        }
        super.onAlive();
    }

    @Override
    protected void onDying() {
        this.align();
        this.r *= 0.9;
        this.s = -0.07;
        this.t *= 0.9;
        if (this.B) {
            this.destroyShip();
        }
    }

    protected final void updatePitch() {
        this.v = 0.0f;
    }

    protected final void handleCollisionDamage(double speed) {
        if (this.A && speed > this.minCollisionSpeed && !this.k.F) {
            this.k.a(this, "mob.ghast.fireball", 0.5f, ((this.U.nextFloat() - this.U.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    protected final void destroyShip() {
        this.u = 0.0f;
        this.convertBackToNormalBlocks();
        this.k.a(this, "mob.ghast.fireball", 0.5f, ((this.U.nextFloat() - this.U.nextFloat()) * 0.7f + 1.0f) * 2.0f);
    }

    protected final void splashWater(double magnitudeMotionXZPlane) {
        if (magnitudeMotionXZPlane > 0.01) {
            bo splashPos = this.convertToPosInParentCoords(bo.a((double)(-this.getLengthBlocks()) / 2.0, 0.0, 0.0));
            double xYaw = Math.cos((double)this.u * Math.PI / 180.0);
            double zYaw = Math.sin((double)this.u * Math.PI / 180.0);
            int i2 = 0;
            while ((double)i2 < 60.0) {
                double randomSplashDelta1 = this.U.nextFloat() * 2.0f - 1.0f;
                double randomSplashDelta2 = (double)(this.U.nextInt(2) * 2 - 1) * 0.7;
                this.k.a("splash", splashPos.a, splashPos.b, splashPos.c, -this.r, 0.1, -this.t);
                ++i2;
            }
        }
    }

    protected final void onGroundMotionUpdate() {
        if (this.z) {
            this.r *= 0.5;
            this.s *= 0.5;
            this.t *= 0.5;
        }
    }

    public boolean isSubmarine() {
        return this.getBlockCount(BlockManager.blockShip, 2) > 0;
    }

    public boolean isAirship() {
        return this.getBlockCount(BlockManager.blockShip, 3) > 0;
    }

    public int getBlockCount(pb block, Integer metadata) {
        return this.getBlockCounter().getBlockQty(block, metadata);
    }

    public boolean canPlayerDriveShip() {
        return this.i == this.mc.h;
    }

    protected final void updatePositionMultiplayer() {
        double newPosX = this.o + this.r;
        double newPosY = this.p + this.s;
        double newPosZ = this.q + this.t;
        this.d(newPosX, newPosY, newPosZ);
        this.onGroundMotionUpdate();
    }

    public void calculateFractionOfShipUnderLiquid() {
        this.calculateFractionOfShipUnderLiquid(50, 1.0f, 0.0f);
    }

    private void calculateFractionOfShipUnderLiquid(int totalSubdivisions, float height, float offset) {
        this.fractionOfShipUnderLiquid = -1.0f;
        for (int subdivision_i = 0; subdivision_i < totalSubdivisions; ++subdivision_i) {
            float maxYSubdivision;
            float minYSubdivision = (float)(this.y.b - (double)height + (double)(height * 2.0f * (float)subdivision_i / (float)totalSubdivisions) + (double)this.getHeightBlocks() * this.getFlotationLine());
            wu subdivisionBB = wu.b(this.y.a, minYSubdivision, this.y.c, this.y.d, maxYSubdivision = (float)(this.y.b - (double)height + (double)(height * 2.0f * (float)(subdivision_i + 1) / (float)totalSubdivisions) + (double)this.getHeightBlocks() * this.getFlotationLine()), this.y.f);
            if (!Ship.isAABBInMaterial(this.k, subdivisionBB, ahd.class)) continue;
            this.fractionOfShipUnderLiquid = (float)((double)this.fractionOfShipUnderLiquid + 2.0 / (double)totalSubdivisions);
        }
        this.fractionOfShipUnderLiquid += offset;
        if (this.fractionOfShipUnderLiquid > 1.0f) {
            this.fractionOfShipUnderLiquid = 1.0f;
        } else if (this.fractionOfShipUnderLiquid < -1.0f) {
            this.fractionOfShipUnderLiquid = -1.0f;
        }
    }

    private static boolean isAABBInMaterial(xd worldObj, wu par1AxisAlignedBB, Class materialClass) {
        int minX = gk.c(par1AxisAlignedBB.a);
        int maxX = gk.c(par1AxisAlignedBB.d + 1.0);
        int minY = gk.c(par1AxisAlignedBB.b);
        int maxY = gk.c(par1AxisAlignedBB.e + 1.0);
        int minZ = gk.c(par1AxisAlignedBB.c);
        int maxZ = gk.c(par1AxisAlignedBB.f + 1.0);
        for (int var9 = minX; var9 < maxX; ++var9) {
            for (int var10 = minY; var10 < maxY; ++var10) {
                for (int var11 = minZ; var11 < maxZ; ++var11) {
                    pb var12 = pb.m[worldObj.a(var9, var10, var11)];
                    if (var12 == null || !materialClass.isAssignableFrom(var12.cd.getClass())) continue;
                    int var13 = worldObj.e(var9, var10, var11);
                    double var14 = var10 + 1;
                    if (var13 < 8) {
                        var14 = (double)(var10 + 1) - (double)var13 / 8.0;
                    }
                    if (!(var14 >= par1AxisAlignedBB.b)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean mountEntityAtSeat(EntityPlayerWrapper emobPlayer, int i2, int j2, int k2) {
        yw entity = emobPlayer.parentEntityPlayer;
        bo newSeatCoords = bo.a(i2, j2, k2);
        this.seatAngle = BlockManager.seat.getYaw(this.emobWorld.e(i2, j2, k2));
        if (this.i == null) {
            System.out.println("Mounting " + entity + " at " + newSeatCoords + " <-- " + this.seatLocalCoords + " " + this.seatAngle);
            this.seatLocalCoords = newSeatCoords;
            entity.h(this);
            return true;
        }
        if (entity == this.i) {
            System.out.println("Remounting " + entity + " at " + newSeatCoords + " <-- " + this.seatLocalCoords + " " + this.seatAngle);
            this.seatLocalCoords = newSeatCoords;
            return true;
        }
        return false;
    }

    public boolean isPlayerSeated() {
        return this.i == this.mc.h;
    }

    @Override
    public void i_() {
        if (this.i != null) {
            bo seatParentCoords = this.getEntityPosInSeatInParentCoords(this.i);
            this.i.d(seatParentCoords.a, seatParentCoords.b, seatParentCoords.c);
        }
    }

    public bo getEntityPosInSeatInParentCoords(nn entity) {
        if (this.seatLocalCoords == null) {
            return null;
        }
        return this.convertToPosInParentCoords(bo.a(this.seatLocalCoords.a + 0.5, this.seatLocalCoords.b + (double)entity.J * 0.65, this.seatLocalCoords.c + 0.5));
    }

    public boolean unmountEntityFromSeat(nn entity) {
        if (this.i != null && this.i == entity) {
            bo seatParentCoords = this.getEntityPosInSeatInParentCoords(this.i);
            entity.h(null);
            entity.d(seatParentCoords.a, seatParentCoords.b + (double)entity.J * 0.75, seatParentCoords.c);
            return true;
        }
        return false;
    }

    public boolean unmountAnyEntityFromSeat() {
        return this.unmountEntityFromSeat(this.i);
    }

    @Override
    protected void b() {
    }

    @Override
    public boolean onInteract(EntityPlayerWrapper thePlayer) {
        if (super.onInteract(thePlayer)) {
            return true;
        }
        if (this.objectMouseOver == null) {
            return this.unmountEntityFromSeat(thePlayer.parentEntityPlayer);
        }
        return false;
    }

    @Override
    protected void resetPressedKeys(EntityPlayerWrapper player) {
        this.emobPlayerController.resetBlockRemovingIfNoDamage();
    }

    @Override
    public void initActuators() {
        this.addActuator(new Propeller(this));
        this.addActuator(new Rudder(this));
        this.addActuator(new WaterPump(this));
        this.addActuator(new AetherPump(this));
        this.addActuator(new Water(this));
    }

    public double getSeatAngle() {
        return this.seatAngle;
    }

    @Override
    public boolean notify(Event event) {
        if (event == ShipEvents.keyUseItemPressed) {
            return this.onInteract(this.emobPlayerEntity);
        }
        if (event == ShipEvents.keyAttackPressed) {
            return this.onAttacked(this.emobPlayerEntity);
        }
        if (event == ShipEvents.keyUnmountPressed) {
            this.unmountEntityFromSeat(this.mc.h);
        }
        return false;
    }

    @Override
    public Collection getChildren() {
        return this.actuators;
    }

    @Override
    protected void initEvents() {
        this.eventManager.registerEventsInClass(ShipEvents.class);
    }

    @Override
    public float getMass() {
        return (float)this.getNumBlocks() * 0.5f;
    }

    public float getVolume() {
        return this.getLengthBlocks() * this.getWidthBlocks() * this.getHeightBlocks();
    }

    public float getHorizontalArea() {
        return this.getLengthBlocks() * this.getWidthBlocks();
    }

    @Override
    public boolean canInteractWith(nn entity) {
        return super.canInteractWith(entity) || this.canPlayerDriveShip();
    }

    public float getFractionOfShipUnderLiquid() {
        return this.fractionOfShipUnderLiquid;
    }

    public boolean isShipInWater() {
        return this.fractionOfShipUnderLiquid > 0.0f;
    }

    @Override
    public void updateEntityAboard(nn entity, double dx2, double dy2, double dz2) {
        super.updateEntityAboard(entity, dx2, dy2, dz2);
        if (entity instanceof acq && this.isSubmarine()) {
            ((acq)entity).g(300);
        }
    }

    @Override
    public void convertBackToNormalBlocks() {
        this.unmountAnyEntityFromSeat();
        super.convertBackToNormalBlocks();
    }

    protected void onDroppingAnchor() {
        this.align();
        if (this.isAligned()) {
            this.u = 0.0f;
            boolean couldDropAnchor = this.dropAnchor();
            if (!couldDropAnchor) {
                this.state = this.ALIVE;
            }
        }
    }

    private boolean dropAnchor() {
        if (this.windlass != null) {
            Windlass.DropAnchorResponse response = this.windlass.canDropAnchor();
            if (response == Windlass.DropAnchorResponse.CAN_DROP_ANCHOR) {
                this.convertBackToNormalBlocks();
                response = this.windlass.dropAnchor();
            }
            if (response == Windlass.DropAnchorResponse.NOT_ENOUGH_CHAINS) {
                StatusScreen.INSTANCE.changeMessageLine("Cannot deploy anchor. There are not enough chain links", 0, 4L);
                return false;
            }
            if (response == Windlass.DropAnchorResponse.NO_ANCHOR) {
                StatusScreen.INSTANCE.changeMessageLine("Cannot deploy anchor. Windlass has no anchor attached", 0, 4L);
                return false;
            }
            if (response == Windlass.DropAnchorResponse.CAN_DROP_ANCHOR) {
                return true;
            }
            if (response == Windlass.DropAnchorResponse.OTHER) {
                StatusScreen.INSTANCE.changeMessageLine("Cannot deploy anchor.", 0, 4L);
            }
        }
        return false;
    }

    public void startDroppingAnchor(Windlass windlass) {
        this.windlass = windlass;
        this.state = this.DROPPING_ANCHOR;
    }

    @Override
    protected void a(double dy2, boolean onGround) {
        if (this.isAirship()) {
            this.M = 0.0f;
        } else {
            super.a(dy2, onGround);
        }
    }
}

