/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.physics;

import java.util.Collection;
import sirentropy.event.Event;
import sirentropy.physics.Pump;
import sirentropy.ships.Ship;
import sirentropy.ships.ShipEvents;
import sirentropy.util.IOUtil;
import sirentropy.util.StatusScreen;

public class WaterPump
extends Pump {
    private static final double PUMP_FORCE = 0.01;
    private float[] cap = new float[]{-3.0f, 0.0f};

    public WaterPump(Ship ship) {
        super(ship);
    }

    public void up() {
        this.force.y = (float)((double)this.force.y + 0.01 * (double)this.getNumActuators());
        StatusScreen.INSTANCE.changeMessageLine("Water Pump power: " + IOUtil.formatDecimal(this.force.y) + " Water Buoyancy: " + IOUtil.formatDecimal(((Ship)this.emob).s), 1, 3L);
    }

    @Override
    public int getNumActuators() {
        return ((Ship)this.emob).getBlockCount(BlockManager.blockShip, 2);
    }

    public void down() {
        this.force.y = (float)((double)this.force.y - 0.01 * (double)this.getNumActuators());
        StatusScreen.INSTANCE.changeMessageLine("Water Pump power: " + IOUtil.formatDecimal(this.force.y) + " Water Buoyancy: " + IOUtil.formatDecimal(((Ship)this.emob).s), 1, 3L);
    }

    @Override
    public void capForces() {
        int numPumps = this.getNumActuators();
        if (this.force.y < this.cap[0] * (float)numPumps) {
            this.force.y = this.cap[0] * (float)numPumps;
        } else if (this.force.y > this.cap[1] * (float)numPumps) {
            this.force.y = this.cap[1] * (float)numPumps;
        }
    }

    @Override
    public boolean notify(Event event) {
        if (((Ship)this.emob).isPlayerSeated() && ((Ship)this.emob).isSubmarine() && ((Ship)this.emob).getFractionOfShipUnderLiquid() > 0.0f) {
            if (event == ShipEvents.keyJumpPressed) {
                this.up();
            } else if (event == ShipEvents.keySneakPressed) {
                this.down();
            }
        }
        return false;
    }

    @Override
    public Collection getChildren() {
        return null;
    }

    @Override
    public void afterApplyingForces() {
        if (((Ship)this.emob).H() && this.force.lengthSquared() > 0.0f) {
            ((Ship)this.emob).s *= 0.6;
        }
    }

    @Override
    protected boolean canUseActuator() {
        return ((Ship)this.emob).isSubmarine();
    }

    @Override
    public String getPluralName() {
        return "Water Pumps";
    }
}

