/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.physics;

import java.util.Collection;
import sirentropy.event.Event;
import sirentropy.physics.Actuator;
import sirentropy.ships.Ship;
import sirentropy.util.Physics;

public class Water
extends Actuator {
    public Water(Ship ship) {
        super(ship);
    }

    protected void applyDamping() {
        float fractionOfShipUnderWater = this.getRealFractionOfShipUnderWater();
        float mass = ((Ship)this.emob).getMass();
        if (((Ship)this.emob).isShipInWater()) {
            double damping = 0.99f;
            ((Ship)this.emob).r *= damping;
            ((Ship)this.emob).s *= Physics.getVerticalWaterDamping(mass);
            ((Ship)this.emob).t *= damping;
        } else {
            ((Ship)this.emob).s *= (double)0.999f;
        }
        ((Ship)this.emob).angularVelocity.y *= 0.9f;
        float inverseMass = 1.0f / mass;
        this.force.y = fractionOfShipUnderWater < 0.0f && !((Ship)this.emob).isAirship() ? (this.force.y *= -(1.0f - inverseMass) * fractionOfShipUnderWater + inverseMass) : (this.force.y *= 8.0f * inverseMass);
    }

    public void applyBuoyancy() {
        this.force.y = (float)((double)this.force.y + (double)(((Ship)this.emob).getHorizontalArea() * this.getRealFractionOfShipUnderWater() * (float)((Ship)this.emob).getHeightBlocks()) * this.getGravityAcceleration());
    }

    public float getRealFractionOfShipUnderWater() {
        float f2 = ((Ship)this.emob).getFractionOfShipUnderLiquid();
        if (f2 > -1.0f) {
            f2 += this.getWaveHeight();
        }
        return f2;
    }

    public float getWaveHeight() {
        return (float)((double)Physics.WAVE_AMPLITUDE * (Math.sin(Math.PI * 2 * (double)Physics.WAVE_FREQUENCY * (double)System.currentTimeMillis() / 1000.0 % (Math.PI * 2)) + (double)-0.1f));
    }

    protected void applyGravity() {
        this.force.y = (float)((double)this.force.y - this.getGravityAcceleration() * (double)((Ship)this.emob).getMass());
    }

    public double getGravityAcceleration() {
        return 0.025;
    }

    @Override
    public boolean notify(Event event) {
        return false;
    }

    @Override
    public Collection getChildren() {
        return null;
    }

    @Override
    public void beforeApplyingForces() {
        ((Ship)this.emob).calculateFractionOfShipUnderLiquid();
        this.applyGravity();
        this.applyBuoyancy();
        this.applyDamping();
    }

    @Override
    protected boolean canUseActuator() {
        return true;
    }

    @Override
    protected void capForces() {
    }

    @Override
    public String getPluralName() {
        return "Waters";
    }
}

