/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.physics;

import java.util.Collection;
import sirentropy.event.Event;
import sirentropy.physics.Actuator;
import sirentropy.ships.Ship;
import sirentropy.ships.ShipEvents;
import sirentropy.util.IOUtil;
import sirentropy.util.StatusScreen;

public class Rudder
extends Actuator {
    protected float torqueMagnitude = 0.1f;

    public Rudder(Ship ship) {
        super(ship);
    }

    public void turnLeft() {
        this.torque.y = -this.torqueMagnitude;
        StatusScreen.INSTANCE.changeMessageLine("Heading: " + IOUtil.formatDecimal(((Ship)this.emob).u), 0, 3L);
    }

    public void turnRight() {
        this.torque.y = this.torqueMagnitude;
        StatusScreen.INSTANCE.changeMessageLine("Heading: " + IOUtil.formatDecimal(((Ship)this.emob).u), 0, 3L);
    }

    @Override
    public boolean notify(Event event) {
        if (((Ship)this.emob).isPlayerSeated()) {
            if (event == ShipEvents.keyLeftPressed) {
                this.turnLeft();
                return true;
            }
            if (event == ShipEvents.keyRightPressed) {
                this.turnRight();
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection getChildren() {
        return null;
    }

    @Override
    public void beforeApplyingForces() {
    }

    @Override
    protected boolean canUseActuator() {
        return true;
    }

    @Override
    protected void capForces() {
    }

    @Override
    public String getPluralName() {
        return "Rudders";
    }
}

