/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.physics;

import sirentropy.physics.Actuator;
import sirentropy.ships.Ship;
import sirentropy.util.StatusScreen;

public abstract class Pump
extends Actuator {
    protected int prevNumActuators;

    public Pump(Ship emob) {
        super(emob);
    }

    protected double calculateDamping(double motionY) {
        double minD = 0.6;
        double maxD = 0.8;
        double d2 = minD + (maxD - minD) / 0.1 * motionY;
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > maxD) {
            d2 = maxD;
        }
        return d2;
    }

    @Override
    public void beforeApplyingForces() {
        ((Ship)this.emob).s *= this.calculateDamping(((Ship)this.emob).s);
    }

    public abstract int getNumActuators();

    @Override
    public void onUpdate() {
        int numActuators = this.getNumActuators();
        if (this.prevNumActuators != numActuators) {
            StatusScreen.INSTANCE.changeMessageLine("Number of active " + this.getPluralName() + " changed to " + numActuators, 0, 3L);
            this.prevNumActuators = numActuators;
        }
        super.onUpdate();
    }
}

