/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.physics;

import java.util.Collection;
import sirentropy.event.Event;
import sirentropy.physics.Actuator;
import sirentropy.ships.Ship;
import sirentropy.ships.ShipEvents;
import sirentropy.util.StatusScreen;

public class Propeller
extends Actuator {
    protected float[] speedInterval = new float[]{-10.0f, 10.0f};
    protected float propellerAcceleration = 0.1f;
    protected float propellerDeceleration = -0.1f;
    protected float engineOn = 0.0f;
    protected float propellerVelocity = 0.0f;

    public Propeller(Ship ship) {
        super(ship);
    }

    public void capVelocity() {
        if (this.propellerVelocity < this.speedInterval[0]) {
            this.propellerVelocity = this.speedInterval[0];
        } else if (this.propellerVelocity > this.speedInterval[1]) {
            this.propellerVelocity = this.speedInterval[1];
        }
    }

    public void accelerate() {
        this.propellerVelocity += this.propellerAcceleration;
        this.capVelocity();
        StatusScreen.INSTANCE.changeMessageLine("Engine power: " + (int)this.propellerVelocity, 1, 3L);
    }

    public void decelerate() {
        this.propellerVelocity += this.propellerDeceleration;
        this.capVelocity();
        StatusScreen.INSTANCE.changeMessageLine("Engine power: " + (int)this.propellerVelocity, 1, 3L);
    }

    public void switchEngine() {
        this.engineOn = (this.engineOn + 1.0f) % 2.0f;
        if (this.isEngineOn()) {
            this.accelerate();
        }
        StatusScreen.INSTANCE.changeMessageLine("Engine " + (this.isEngineOn() ? "On" : "Off"), 1, 3L);
    }

    public boolean isEngineOn() {
        return this.engineOn > 0.0f;
    }

    @Override
    public boolean notify(Event event) {
        if (((Ship)this.emob).isPlayerSeated()) {
            if (this.isEngineOn()) {
                if (event == ShipEvents.keyForwardPressed) {
                    this.accelerate();
                    return true;
                }
                if (event == ShipEvents.keyBackPressed) {
                    this.decelerate();
                    return true;
                }
            }
            if (event == ShipEvents.keySwitchEnginePressed) {
                this.switchEngine();
            }
        }
        return false;
    }

    @Override
    public Collection getChildren() {
        return null;
    }

    @Override
    public void onUpdate() {
        if (((Ship)this.emob).A) {
            this.propellerVelocity = 0.0f;
        }
        if (!this.isEngineOn()) {
            this.propellerVelocity = (float)((double)this.propellerVelocity * (double)0.99f);
        }
        double seatAngle = ((Ship)this.emob).getSeatAngle();
        double yawInRadians = ((double)((Ship)this.emob).u + seatAngle - 90.0) / 180.0 * Math.PI;
        ((Ship)this.emob).r = (float)(-0.03 * (double)this.propellerVelocity * Math.cos(yawInRadians));
        ((Ship)this.emob).t = (float)(-0.03 * (double)this.propellerVelocity * Math.sin(yawInRadians));
    }

    @Override
    protected boolean canUseActuator() {
        return this.isEngineOn();
    }

    @Override
    protected void capForces() {
    }

    @Override
    public String getPluralName() {
        return "Propellers";
    }
}

