/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.physics;

import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import sirentropy.event.EventListener;
import sirentropy.physics.Actuator;

public abstract class EntityRigidBody
implements EventListener {
    protected nn entity;
    List children = new ArrayList();
    private Vector3f force = new Vector3f();

    public EntityRigidBody(nn entity) {
        this.entity = entity;
    }

    public abstract void onUpdate();

    @Override
    public Collection getChildren() {
        return this.children;
    }

    public abstract double getMass();

    private void applyForces() {
        this.force.set(0.0f, 0.0f, 0.0f);
        for (Actuator a2 : this.children) {
            this.force.addLocal(a2.getForce());
        }
        double inverseMass = 1.0 / this.getMass();
        this.entity.r += (double)this.force.x * inverseMass;
        this.entity.s += (double)this.force.y * inverseMass;
        this.entity.t += (double)this.force.z * inverseMass;
    }

    public boolean addActuator(Actuator e2) {
        return this.children.add(e2);
    }
}

