/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.physics;

import com.jme3.math.Vector3f;
import net.minecraft.client.Minecraft;
import sirentropy.event.EventListener;

public abstract class Actuator
implements EventListener {
    protected Emob emob;
    protected Vector3f force = new Vector3f();
    protected Vector3f torque = new Vector3f();
    protected Minecraft mc = ModLoader.getMinecraftInstance();

    public Actuator(Emob emob) {
        this.emob = emob;
    }

    public Vector3f getForce() {
        return this.force;
    }

    public Vector3f getTorque() {
        return this.torque;
    }

    public void reset() {
        this.force.set(0.0f, 0.0f, 0.0f);
        this.torque.set(0.0f, 0.0f, 0.0f);
    }

    public void onUpdate() {
        if (this.canUseActuator()) {
            this.beforeApplyingForces();
            this.capForces();
            this.applyForce(this.emob, this.force);
            this.applyTorque(this.emob, this.torque);
            this.afterApplyingForces();
        } else {
            this.reset();
        }
    }

    protected abstract void capForces();

    public void beforeApplyingForces() {
    }

    public void afterApplyingForces() {
        this.reset();
    }

    public void applyForce(Emob entity, Vector3f force) {
        entity.r += (double)(force.x / entity.getMass());
        entity.s += (double)(force.y / entity.getMass());
        entity.t += (double)(force.z / entity.getMass());
    }

    public void applyTorque(Emob entity, Vector3f torque) {
        entity.angularVelocity.y += torque.y;
    }

    protected abstract boolean canUseActuator();

    public abstract String getPluralName();
}

