/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.event;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import sirentropy.event.Event;
import sirentropy.event.EventListener;

public class EventManager {
    private List events = new ArrayList();
    private List listeners = new ArrayList();

    public boolean registerEvent(Event event) {
        System.out.println("Registered event: " + event);
        return this.events.add(event);
    }

    public boolean registerEventListener(EventListener listener) {
        return this.listeners.add(listener);
    }

    public void processAllEvents() {
        for (Event event : this.events) {
            if (!event.happened()) continue;
            this.notifyListeners(event, this.listeners);
        }
    }

    private void notifyListeners(Event event, Collection listeners) {
        if (event != null && listeners != null) {
            for (EventListener listener : listeners) {
                if (listener.notify(event)) continue;
                Collection children = listener.getChildren();
                this.notifyListeners(event, children);
            }
        }
    }

    public void registerEventsInClass(Class c2) {
        for (Field f2 : c2.getDeclaredFields()) {
            if (!Event.class.isAssignableFrom(f2.getType()) || !Modifier.isStatic(f2.getModifiers())) continue;
            try {
                Event evt = (Event)f2.get(null);
                this.registerEvent(evt);
            }
            catch (IllegalArgumentException e2) {
                e2.printStackTrace();
            }
            catch (IllegalAccessException e3) {
                e3.printStackTrace();
            }
        }
    }
}

