/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.emob.world;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import sirentropy.util.FileUtil;

public class EmobSaveUtil {
    public static final String DIM_DIR_NAME = "DIM-1";
    static final String VDIM_DIR_NAME = "VDIM-1";
    private static final String REGION_DIR_NAME = "region";

    public static void convertToAnvil(String emobID, xd parentWorld) {
        fp asc = EmobSaveUtil.getAnvilSaveConverterForEmobs(parentWorld);
        File emobSaveDir = EmobSaveUtil.getEmobSaveDir(emobID, parentWorld);
        if (EmobSaveUtil.isOldMapFormat(emobSaveDir)) {
            EmobSaveUtil.convertAllChunkFilesToMCRegion(emobSaveDir);
            EmobSaveUtil.convertLevelDatToMCRegion(emobSaveDir);
            System.out.println("Converting " + emobID + " to Anvil format");
            asc.a(emobID, new rw(){

                @Override
                public void a(int i2) {
                    if (i2 % 10 == 0) {
                        System.out.print(".");
                    }
                }

                @Override
                public void b(String s2) {
                    System.out.println("\nSaving " + s2);
                }

                @Override
                public void d(String s2) {
                    System.out.println("\nLoading " + s2);
                }
            });
            System.out.println();
        } else {
            System.out.println("Emob is already " + emobID + " in Anvil Format");
        }
    }

    private static boolean isOldMapFormat(File emobSaveDir) {
        ArrayList files = new ArrayList();
        FileUtil.getAllFiles(emobSaveDir, files);
        for (File f2 : files) {
            if (!f2.getName().endsWith(".mca")) continue;
            return false;
        }
        return true;
    }

    private static void setLevelVersion(File emobSaveDir, int version) {
        File file1 = new File(emobSaveDir, "level.dat");
        if (file1.exists()) {
            try {
                ady nbttagcompound = at.a(new FileInputStream(file1));
                ady nbttagcompound1 = nbttagcompound.m("Data");
                nbttagcompound1.a("version", version);
                at.a(nbttagcompound, new FileOutputStream(file1));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void convertLevelDatToMCRegion(File emobSaveDir) {
        File file1 = new File(emobSaveDir, "level.dat");
        if (file1.exists()) {
            try {
                ady nbttagcompound = at.a(new FileInputStream(file1));
                ady nbttagcompound1 = nbttagcompound.m("Data");
                nbttagcompound1.a("LevelName", emobSaveDir.getName());
                nbttagcompound1.a("version", 19132);
                at.a(nbttagcompound, new FileOutputStream(file1));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static fp getAnvilSaveConverterForEmobs(xd parentWorld) {
        File emobAllSavesDir = EmobSaveUtil.getEmobAllSavesDir(parentWorld);
        fp asc = new fp(emobAllSavesDir);
        return asc;
    }

    public static fp getAnvilSaveConverterForEmobs(String parentWorldName) {
        File emobAllSavesDir = EmobSaveUtil.getEmobAllSavesDir(parentWorldName);
        fp asc = new fp(emobAllSavesDir);
        return asc;
    }

    private static boolean convertAllChunkFilesToMCRegion(File emobSaveDir) {
        File chunksDir = new File(emobSaveDir, VDIM_DIR_NAME);
        ArrayList files = new ArrayList();
        FileUtil.getAllFiles(chunksDir, files);
        for (File chunkFile : files) {
            EmobSaveUtil.convertToMCRegion(emobSaveDir, chunkFile);
        }
        return true;
    }

    private static void convertToMCRegion(File baseFolder, File chunkFile) {
        String[] tokens = chunkFile.getName().split("\\.");
        int x2 = Integer.valueOf(tokens[1]);
        int z2 = Integer.valueOf(tokens[2]);
        byte[] buffer = new byte[4096];
        lz region = EmobSaveUtil.createRegionFile(baseFolder, x2, z2);
        try {
            DataInputStream istream = new DataInputStream(new GZIPInputStream(new FileInputStream(chunkFile)));
            DataOutputStream out = region.b(x2 & 0x1F, z2 & 0x1F);
            int length = 0;
            while ((length = istream.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            out.close();
            istream.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static boolean fillToSize(File file, long targetSize) {
        try {
            RandomAccessFile f2 = new RandomAccessFile(file, "rw");
            long length = f2.length();
            System.out.println(file + " before size: " + length);
            f2.seek(length);
            for (long i2 = length; i2 < targetSize; ++i2) {
                f2.write(0);
            }
            System.out.println(file + " after size: " + f2.length());
            f2.close();
            return true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private static File getEmobSaveDir(String emobID, xd parentWorld) {
        return new File(EmobSaveUtil.getEmobAllSavesDir(parentWorld), emobID);
    }

    private static File getEmobAllSavesDir(xd parentWorld) {
        String worldName = parentWorld.B().j();
        return EmobSaveUtil.getEmobAllSavesDir(worldName);
    }

    public static File getEmobAllSavesDir(String worldName) {
        return new File(EmobSaveUtil.getSavesDirectory(), worldName);
    }

    public static File getSavesDirectory() {
        return new File(ModLoader.getMinecraftInstance().F, "saves");
    }

    private static lz createRegionFile(File baseFolder, int x2, int z2) {
        File file = new File(baseFolder, REGION_DIR_NAME);
        File file1 = new File(file, "r." + (x2 >> 5) + "." + (z2 >> 5) + ".mcr");
        if (!file.exists()) {
            file.mkdirs();
        }
        return new lz(file1);
    }
}

