/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.emob;

import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sirentropy.emob.EmobBB;
import sirentropy.util.CoordsUtil;

public class EmobQuickBB
extends EmobBB {
    private int pointsPerChunkSide = 0;
    List collisionPoints = new ArrayList();
    private int minPointsPerSide = 0;

    public EmobQuickBB(Emob emob, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(emob, minX, minY, minZ, maxX, maxY, maxZ);
    }

    private void createCollisionPoints() {
        int pointsPerLength = this.getPointsPerLength();
        int pointsPerWidth = this.getPointsPerWidth();
        int totalPoints = 2 * (pointsPerLength + pointsPerWidth) + 8;
        for (int i2 = 0; i2 < totalPoints; ++i2) {
            this.collisionPoints.add(new Vector3f());
        }
    }

    private int getPointsPerWidth() {
        return Math.max(this.emob.getWidthBlocks() / 16, this.minPointsPerSide) * this.pointsPerChunkSide;
    }

    private int getPointsPerLength() {
        return Math.max(this.emob.getLengthBlocks() / 16, this.minPointsPerSide) * this.pointsPerChunkSide;
    }

    private void updateCollisionPoints() {
        int pointsPerWidth;
        if (this.collisionPoints.isEmpty()) {
            this.createCollisionPoints();
        }
        bo corner1 = this.emob.emobWorld.emob.emobWorld.getLowerBackLeftCorner();
        bo corner2 = this.emob.emobWorld.emob.emobWorld.getUpperFrontRightCorner(corner1);
        Iterator it2 = this.collisionPoints.iterator();
        bo cornerParent1 = this.emob.convertToPosInParentCoords(corner1);
        bo cornerParent2 = this.emob.convertToPosInParentCoords(corner2);
        ((Vector3f)it2.next()).set(cornerParent1);
        ((Vector3f)it2.next()).set((float)cornerParent1.a, (float)cornerParent1.b, (float)cornerParent2.c);
        ((Vector3f)it2.next()).set((float)cornerParent1.a, (float)cornerParent2.b, (float)cornerParent1.c);
        ((Vector3f)it2.next()).set((float)cornerParent1.a, (float)cornerParent2.b, (float)cornerParent2.c);
        ((Vector3f)it2.next()).set((float)cornerParent2.a, (float)cornerParent1.b, (float)cornerParent1.c);
        ((Vector3f)it2.next()).set((float)cornerParent2.a, (float)cornerParent1.b, (float)cornerParent2.c);
        ((Vector3f)it2.next()).set((float)cornerParent2.a, (float)cornerParent2.b, (float)cornerParent1.c);
        ((Vector3f)it2.next()).set(cornerParent2);
        float y2 = (float)((cornerParent2.b + cornerParent1.b) / 2.0);
        int pointsPerLength = this.getPointsPerLength();
        if (pointsPerLength > 1) {
            float stepX = (float)((corner2.a - corner1.a) / (double)(pointsPerLength - 1));
            for (int i2 = 0; i2 < pointsPerLength; ++i2) {
                ((Vector3f)it2.next()).set((float)i2 * stepX, y2, (float)corner1.c);
                ((Vector3f)it2.next()).set((float)i2 * stepX, y2, (float)corner2.c);
            }
        }
        if ((pointsPerWidth = this.getPointsPerWidth()) > 1) {
            float stepZ = (float)((corner2.c - corner1.c) / (double)(pointsPerLength - 1));
            for (int i3 = 0; i3 < pointsPerWidth; ++i3) {
                ((Vector3f)it2.next()).set((float)corner1.a, y2, (float)i3 * stepZ);
                ((Vector3f)it2.next()).set((float)corner2.a, y2, (float)i3 * stepZ);
            }
        }
    }

    public boolean calculateOffset(bo offset) {
        boolean result = false;
        this.updateCollisionPoints();
        for (Vector3f point : this.collisionPoints) {
            wu collisionPointBB = this.createBB(point);
            List bbs = this.emob.k.a((nn)this.emob, collisionPointBB.a(offset.a, offset.b, offset.c));
            for (wu bb2 : bbs) {
                result |= CoordsUtil.calculateOffset(offset, new Vector3f[]{point}, CoordsUtil.getBBPoints(new double[]{bb2.a, bb2.b, bb2.c}, new double[]{bb2.d, bb2.e, bb2.f}));
            }
        }
        return result;
    }

    private wu createBB(Vector3f point) {
        return wu.a((double)point.x - 0.5, (double)point.y - 0.5, (double)point.z - 0.5, (double)point.x + 0.5, (double)point.y + 0.5, (double)point.z + 0.5);
    }

    private wu createBB2(Vector3f point, bo offset) {
        double minX = Math.min((double)point.x - offset.a, (double)point.x + offset.a);
        double minY = point.y - 8.0f;
        double minZ = Math.min((double)point.z - offset.c, (double)point.z + offset.c);
        double maxX = Math.max((double)point.x - offset.a, (double)point.x + offset.a);
        double maxY = point.y + 8.0f;
        double maxZ = Math.max((double)point.z - offset.c, (double)point.z + offset.c);
        if (maxX <= minX) {
            maxX = minX + 1.0;
        }
        if (maxZ <= minZ) {
            maxZ = minZ + 1.0;
        }
        return wu.a(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

