/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.cannon;

import sirentropy.blocks.MultiBlockTileEntity;
import sirentropy.cannon.CannonFlameFX;
import sirentropy.cannon.Cannonball;
import sirentropy.cannon.ContainerCannon;

public class Cannon
extends MultiBlockTileEntity {
    private static final int INITIAL_IMPULSE = 4;
    private State state = State.IDLE;
    public int timeToFire = 0;

    @Override
    public String c() {
        return "Cannon";
    }

    @Override
    public void a(ady par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        this.timeToFire = par1NBTTagCompound.f("cannonTimeToFire");
    }

    @Override
    public void b(ady par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("cannonTimeToFire", this.timeToFire);
    }

    public boolean isGoingToFire() {
        return this.timeToFire > 0;
    }

    public void startFiring() {
        if (this.state == State.IDLE) {
            this.timeToFire = 40;
            this.state = State.FIRING;
            this.i.a((double)this.j + 0.5, (double)this.k + 0.5, (double)this.l + 0.5, "random.fuse", 1.0f, this.i.r.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean canBeFiredByPlayer(yw player) {
        return this.isPlayerUsingCorrectItem(player) && this.itemStacks[0] != null && this.itemStacks[1] != null && this.itemStacks[1].a > 0 && this.itemStacks[0].c == yr.M.bQ && this.itemStacks[1].a > 0 && this.itemStacks[1].c == ItemManager.cannonball.bQ;
    }

    public boolean isPlayerUsingCorrectItem(yw player) {
        return player.ap.b() != null && player.ap.b().c == yr.i.bQ;
    }

    private void fire() {
        this.a(ContainerCannon.CHAMBER_SLOT, 1);
        this.a(ContainerCannon.CANNONBALL_SLOT, 1);
        this.state = State.IDLE;
        int metadata = this.i.e(this.j, this.k, this.l);
        int[] dir = BlockManager.cannon.getBlockDirection(metadata);
        float yaw = (float)BlockManager.cannon.getYaw(metadata);
        this.createCannonball(dir, yaw);
        this.spawnParticleEffects(dir);
        this.i.a((double)this.j + 0.5, (double)this.k + 0.5, (double)this.l + 0.5, "random.explode", 1.0f, this.i.r.nextFloat() * 0.1f + 0.9f);
        this.j();
    }

    private void spawnParticleEffects(int[] dir) {
        this.i.a("explode", (double)this.j + (double)dir[0] * 1.8 + 0.5, (double)this.k + 0.5, (double)this.l + (double)dir[1] * 1.8 + 0.5, 0.0, 0.0, 0.0);
        this.i.a("smoke", (double)this.j + 0.5, (double)this.k + 1.1, (double)this.l + 0.5, 0.0, 0.0, 0.0);
        this.i.a("flame", (double)this.j + 0.5, (double)this.k + 0.7, (double)this.l + 0.5, 0.0, 0.0, 0.0);
        CannonFlameFX flame = new CannonFlameFX(this.i, (double)this.j + (double)dir[0] * 1.6 + 0.5, (double)this.k + 0.35, (double)this.l + (double)dir[1] * 1.6 + 0.5, 0.0, 0.0, 0.0);
        ModLoader.getMinecraftInstance().j.a(flame);
    }

    private void createCannonball(int[] dir, float yaw) {
        Cannonball cannonball = new Cannonball(this.i, (double)(this.j + dir[0] * 2) + 0.5, (double)this.k + 0.25, (double)(this.l + dir[1] * 2) + 0.5, 180.0f - yaw, -1.0f, 4.0);
        this.i.a(cannonball);
    }

    @Override
    public void n_() {
        boolean fired = false;
        if (this.timeToFire > 0) {
            --this.timeToFire;
        }
        if (!this.i.F && this.state == State.FIRING && this.timeToFire == 0) {
            this.fire();
        }
    }

    @Override
    public int d() {
        return 16;
    }

    private static enum State {
        IDLE,
        FIRING;

    }
}

