/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.cannon;

import java.util.Random;
import net.minecraft.client.Minecraft;
import sirentropy.blocks.RotatedBlock;
import sirentropy.cannon.Cannon;
import sirentropy.cannon.GuiCannon;

public class BlockCannon
extends RotatedBlock {
    public static final int BLOCK_CANNON_TUBE = 0;
    public static final int BLOCK_CANNON_TRIGGER = 1;
    public static final int BLOCK_CANNON_CHAMBER = 2;
    private static int[][] directions = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};
    private Minecraft mc = ModLoader.getMinecraftInstance();

    public BlockCannon(int par1) {
        super(par1, 0, acn.f);
        this.a("Cannon");
        this.setBounds();
    }

    @Override
    public boolean b(xd world, int x2, int y2, int z2, yw player) {
        int metadata = world.e(x2, y2, z2);
        if (this.isCannonTube(metadata) || this.isCannonChamber(metadata)) {
            Cannon cannon;
            if (this.isCannonChamber(metadata)) {
                cannon = (Cannon)world.b(x2, y2, z2);
            } else {
                int[] dir = this.getBlockDirection(metadata);
                cannon = (Cannon)world.b(x2 - dir[0], y2, z2 - dir[1]);
            }
            if (cannon.canBeFiredByPlayer(player)) {
                cannon.startFiring();
                player.ap.b().a(1, (acq)player);
            } else {
                this.mc.a(new GuiCannon(player.ap, cannon));
            }
            return true;
        }
        return false;
    }

    @Override
    public void a(xd par1World, int x2, int y2, int z2, int neighborBlockID) {
        int metadata = par1World.e(x2, y2, z2);
        int[] dir = this.getBlockDirection(metadata);
        if (this.isCannonChamber(metadata)) {
            if (par1World.a(x2 + dir[0], y2, z2 + dir[1]) != this.bO) {
                par1World.g(x2, y2, z2, 0);
            }
        } else if (this.isCannonTube(metadata) && par1World.a(x2 - dir[0], y2, z2 - dir[1]) != this.bO) {
            par1World.g(x2, y2, z2, 0);
            if (!par1World.F) {
                this.a(par1World, x2, y2, z2, metadata, 0);
            }
        } else if (this.isCannonTrigger(metadata)) {
            // empty if block
        }
    }

    public boolean isCannonTrigger(int metadata) {
        return this.getSubtype(metadata) == 1;
    }

    public boolean isCannonTube(int metadata) {
        return this.getSubtype(metadata) == 0;
    }

    @Override
    public int a(int par1, Random par2Random, int par3) {
        return this.isCannonChamber(par1) ? 0 : ItemManager.cannon.bQ;
    }

    private void setBounds() {
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean isCannonChamber(int metadata) {
        return this.getSubtype(metadata) == 2;
    }

    @Override
    public int f() {
        return 1;
    }

    @Override
    public kw u_() {
        return new Cannon();
    }

    public int[] getBlockDirection(int metadata) {
        return directions[metadata & this.BLOCK_DIRECTION_MASK];
    }

    @Override
    public double getYaw(int metadata) {
        return 180.0 - (double)(metadata & this.BLOCK_DIRECTION_MASK) * 90.0;
    }

    @Override
    public int getMetadataForYaw(double yaw) {
        return gk.c(yaw * 4.0 / 360.0 + 0.5) & 3;
    }

    @Override
    public String getName(int subtype) {
        return "cannon";
    }
}

