/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.blocks;

import sirentropy.blocks.MultiBlock;

public class BlockInfo {
    private pb block;
    private Integer blockID;
    private Integer subtype;
    private Class materialClass;

    public BlockInfo(pb block, Integer metadata) {
        this.init(block, BlockManager.getBlockID(block), metadata);
    }

    public BlockInfo(int blockID, Integer metadata) {
        this.init(BlockManager.getBlock(blockID), blockID, metadata);
    }

    public BlockInfo(Class material) {
        this.materialClass = material;
    }

    public void init(pb block, int blockID, Integer metadata) {
        this.block = block;
        this.blockID = blockID;
        if (block instanceof MultiBlock && metadata != null) {
            this.subtype = ((MultiBlock)block).getSubtype(metadata);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.blockID == null ? 0 : this.blockID.hashCode());
        result = 31 * result + (this.materialClass == null ? 0 : this.materialClass.hashCode());
        result = 31 * result + (this.subtype == null ? 0 : this.subtype.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockInfo other = (BlockInfo)obj;
        if (this.blockID == null ? other.blockID != null : !this.blockID.equals(other.blockID)) {
            return false;
        }
        if (this.materialClass == null ? other.materialClass != null : !this.materialClass.equals(other.materialClass)) {
            return false;
        }
        return !(this.subtype == null ? other.subtype != null : !this.subtype.equals(other.subtype));
    }

    public pb getBlock() {
        return this.block;
    }

    public void setBlock(pb block) {
        this.block = block;
    }

    public Integer getBlockID() {
        return this.blockID;
    }

    public Integer getSubtype() {
        return this.subtype;
    }

    public Class getMaterialClass() {
        return this.materialClass;
    }
}

