/*
 * Decompiled with CFR 0.152.
 */
package sirentropy.anchor;

import sirentropy.anchor.BlockAnchor;
import sirentropy.anchor.ContainerWindlass;
import sirentropy.blocks.BlockInfo;
import sirentropy.blocks.BlockSet;
import sirentropy.blocks.MultiBlockTileEntity;
import sirentropy.ships.Ship;
import sirentropy.ships.ShipCreator;
import sirentropy.util.StatusScreen;
import sirentropy.util.Vector3i;
import sirentropy.util.WorldUtil;

public class Windlass
extends MultiBlockTileEntity {
    public static final int MAX_CHAIN_LENGTH = 64;
    private boolean hasShipBeenCreated = false;
    private static BlockSet chains = new BlockSet();

    @Override
    public String c() {
        return "Windlass";
    }

    @Override
    public void e() {
    }

    @Override
    public void f() {
    }

    @Override
    public void a(ady nbt) {
        super.a(nbt);
        this.hasShipBeenCreated = nbt.o("hasShipBeenCreated");
    }

    @Override
    public void b(ady nbt) {
        super.b(nbt);
        nbt.a("hasShipBeenCreated", this.hasShipBeenCreated);
    }

    public boolean hasShipBeenCreated() {
        return this.hasShipBeenCreated;
    }

    public void liftAnchor() {
        if (!(this.i instanceof EmobWorld)) {
            Vector3i chainEnd = WorldUtil.findLongestContiguousBlocks(this.i, chains, this.j, this.k - 1, this.l, 0, -1, 0, 64);
            int numChains = Math.abs(chainEnd.y - this.k) - 1;
            if (numChains > 64) {
                StatusScreen.INSTANCE.changeMessageLine("Cannot lift anchor. Chain is longer than 64 blocks", 0, 4L);
                return;
            }
            int numAnchor = 0;
            if (this.i.a(chainEnd.x, chainEnd.y, chainEnd.z) == BlockManager.anchor.bO && BlockManager.anchor.isAnchor(this.i, this.j, this.k - numChains - 1, this.l)) {
                numAnchor = 1;
            }
            WorldUtil.line(this.i, this.j, this.k - 1, this.l, this.j, this.k - numChains - numAnchor - 1, this.l, 0, null, null);
            this.incrStackSize(ContainerWindlass.ANCHOR_SLOT, numAnchor);
            this.incrStackSize(ContainerWindlass.CHAIN_SLOT, numChains);
            this.j();
            ShipCreator creator = new ShipCreator(this.i, mod_ShipsAndBoats.maxShipSizeInBlocks, null);
            Ship ship = creator.createShip(this.j, this.k, this.l);
        }
    }

    public DropAnchorResponse dropAnchor() {
        if (!(this.i instanceof EmobWorld)) {
            aan anchorStack = this.k_(ContainerWindlass.ANCHOR_SLOT);
            if (anchorStack != null && anchorStack.a > 0) {
                aan chainStack = this.k_(ContainerWindlass.CHAIN_SLOT);
                int numChainsAvailable = chainStack == null ? 0 : chainStack.a;
                Vector3i closestBlock = WorldUtil.findLongestContiguousBlocks(this.i, BlockManager.EXCLUDED_BLOCKS, this.j, this.k - 1, this.l, 0, -1, 0, numChainsAvailable + 2);
                int numChainsRequired = Math.abs(closestBlock.y - this.k) - 2;
                if (numChainsRequired <= numChainsAvailable) {
                    if (closestBlock != null) {
                        WorldUtil.line(this.i, this.j, this.k - 1, this.l, closestBlock.x, closestBlock.y + 1, closestBlock.z, BlockManager.anchor.bO, BlockManager.anchor.getMetadataForSubtype(BlockAnchor.CHAIN), null);
                    }
                    this.a(ContainerWindlass.CHAIN_SLOT, numChainsRequired);
                    this.i.d(closestBlock.x, closestBlock.y + 1, closestBlock.z, BlockManager.anchor.bO, BlockAnchor.CHAIN);
                    this.a(ContainerWindlass.ANCHOR_SLOT, 1);
                    this.j();
                    this.hasShipBeenCreated = true;
                    return DropAnchorResponse.CAN_DROP_ANCHOR;
                }
                return DropAnchorResponse.NOT_ENOUGH_CHAINS;
            }
            return DropAnchorResponse.NO_ANCHOR;
        }
        return DropAnchorResponse.OTHER;
    }

    @Override
    public void n_() {
        super.n_();
        if (this.hasJustActivated()) {
            if (this.isAnchored()) {
                this.liftAnchor();
            } else {
                Emob emob = this.getEmob();
                if (emob != null && emob instanceof Ship) {
                    Ship ship = (Ship)emob;
                    ship.startDroppingAnchor(this);
                }
            }
        }
    }

    private boolean isAnchored() {
        return this.hasShipBeenCreated() && this.getEmob() == null;
    }

    public DropAnchorResponse canDropAnchor() {
        Emob emob = this.getEmob();
        if (emob != null && emob instanceof Ship) {
            xd worldObj = emob.k;
            aan anchorStack = this.k_(ContainerWindlass.ANCHOR_SLOT);
            if (anchorStack != null && anchorStack.a > 0) {
                aan chainStack = this.k_(ContainerWindlass.CHAIN_SLOT);
                int numChainsAvailable = chainStack == null ? 0 : chainStack.a;
                Vector3i wlPos = emob.convertToPosInParentCoords(new Vector3i(this.j, this.k, this.l));
                Vector3i closestBlock = WorldUtil.findLongestContiguousBlocks(worldObj, BlockManager.EXCLUDED_BLOCKS, wlPos.x, wlPos.y - 1, wlPos.z, 0, -1, 0, numChainsAvailable + 2);
                int numChainsRequired = Math.abs(closestBlock.y - wlPos.y) - 2;
                if (numChainsRequired <= numChainsAvailable) {
                    return DropAnchorResponse.CAN_DROP_ANCHOR;
                }
                return DropAnchorResponse.NOT_ENOUGH_CHAINS;
            }
            return DropAnchorResponse.NO_ANCHOR;
        }
        return DropAnchorResponse.NOT_ATTACHED_TO_A_SHIP;
    }

    static {
        chains.add(new BlockInfo(BlockManager.anchor, (Integer)BlockManager.anchor.getMetadataForSubtype(BlockAnchor.CHAIN)));
    }

    public static enum DropAnchorResponse {
        CAN_DROP_ANCHOR,
        NOT_ENOUGH_CHAINS,
        NO_ANCHOR,
        NOT_ATTACHED_TO_A_SHIP,
        OTHER;

    }
}

