/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.math.FastMath;
import java.io.Serializable;
import java.util.logging.Logger;

public final class Vector3f
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Vector3f.class.getName());
    public static final Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f NAN = new Vector3f(Float.NaN, Float.NaN, Float.NaN);
    public static final Vector3f UNIT_X = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_Y = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f UNIT_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3f UNIT_XYZ = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Vector3f POSITIVE_INFINITY = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
    public static final Vector3f NEGATIVE_INFINITY = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
    public float x;
    public float y;
    public float z;

    public Vector3f() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector3f(float x2, float y2, float z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    public Vector3f(Vector3f copy) {
        this.set(copy);
    }

    public Vector3f set(float x2, float y2, float z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        return this;
    }

    public Vector3f set(Vector3f vect) {
        this.x = vect.x;
        this.y = vect.y;
        this.z = vect.z;
        return this;
    }

    public Vector3f add(Vector3f vec) {
        if (null == vec) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        return new Vector3f(this.x + vec.x, this.y + vec.y, this.z + vec.z);
    }

    public Vector3f add(Vector3f vec, Vector3f result) {
        result.x = this.x + vec.x;
        result.y = this.y + vec.y;
        result.z = this.z + vec.z;
        return result;
    }

    public Vector3f addLocal(Vector3f vec) {
        if (null == vec) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    public Vector3f add(float addX, float addY, float addZ) {
        return new Vector3f(this.x + addX, this.y + addY, this.z + addZ);
    }

    public Vector3f addLocal(float addX, float addY, float addZ) {
        this.x += addX;
        this.y += addY;
        this.z += addZ;
        return this;
    }

    public Vector3f scaleAdd(float scalar, Vector3f add2) {
        this.x = this.x * scalar + add2.x;
        this.y = this.y * scalar + add2.y;
        this.z = this.z * scalar + add2.z;
        return this;
    }

    public Vector3f scaleAdd(float scalar, Vector3f mult, Vector3f add2) {
        this.x = mult.x * scalar + add2.x;
        this.y = mult.y * scalar + add2.y;
        this.z = mult.z * scalar + add2.z;
        return this;
    }

    public float dot(Vector3f vec) {
        if (null == vec) {
            logger.warning("Provided vector is null, 0 returned.");
            return 0.0f;
        }
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public Vector3f cross(Vector3f v2) {
        return this.cross(v2, null);
    }

    public Vector3f cross(Vector3f v2, Vector3f result) {
        return this.cross(v2.x, v2.y, v2.z, result);
    }

    public Vector3f cross(float otherX, float otherY, float otherZ, Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        float resX = this.y * otherZ - this.z * otherY;
        float resY = this.z * otherX - this.x * otherZ;
        float resZ = this.x * otherY - this.y * otherX;
        result.set(resX, resY, resZ);
        return result;
    }

    public Vector3f crossLocal(Vector3f v2) {
        return this.crossLocal(v2.x, v2.y, v2.z);
    }

    public Vector3f crossLocal(float otherX, float otherY, float otherZ) {
        float tempx = this.y * otherZ - this.z * otherY;
        float tempy = this.z * otherX - this.x * otherZ;
        this.z = this.x * otherY - this.y * otherX;
        this.x = tempx;
        this.y = tempy;
        return this;
    }

    public Vector3f project(Vector3f other) {
        float n2 = this.dot(other);
        float d2 = other.lengthSquared();
        return new Vector3f(other).normalizeLocal().multLocal(n2 / d2);
    }

    public boolean isUnitVector() {
        float len = this.length();
        return 0.99f < len && len < 1.01f;
    }

    public float length() {
        return FastMath.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distanceSquared(Vector3f v2) {
        double dx2 = this.x - v2.x;
        double dy2 = this.y - v2.y;
        double dz2 = this.z - v2.z;
        return (float)(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
    }

    public float distance(Vector3f v2) {
        return FastMath.sqrt(this.distanceSquared(v2));
    }

    public Vector3f mult(float scalar) {
        return new Vector3f(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public Vector3f mult(float scalar, Vector3f product) {
        if (null == product) {
            product = new Vector3f();
        }
        product.x = this.x * scalar;
        product.y = this.y * scalar;
        product.z = this.z * scalar;
        return product;
    }

    public Vector3f multLocal(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3f multLocal(Vector3f vec) {
        if (null == vec) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x *= vec.x;
        this.y *= vec.y;
        this.z *= vec.z;
        return this;
    }

    public Vector3f multLocal(float x2, float y2, float z2) {
        this.x *= x2;
        this.y *= y2;
        this.z *= z2;
        return this;
    }

    public Vector3f mult(Vector3f vec) {
        if (null == vec) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        return this.mult(vec, null);
    }

    public Vector3f mult(Vector3f vec, Vector3f store) {
        if (null == vec) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        if (store == null) {
            store = new Vector3f();
        }
        return store.set(this.x * vec.x, this.y * vec.y, this.z * vec.z);
    }

    public Vector3f divide(float scalar) {
        scalar = 1.0f / scalar;
        return new Vector3f(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public Vector3f divideLocal(float scalar) {
        scalar = 1.0f / scalar;
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3f divide(Vector3f scalar) {
        return new Vector3f(this.x / scalar.x, this.y / scalar.y, this.z / scalar.z);
    }

    public Vector3f divideLocal(Vector3f scalar) {
        this.x /= scalar.x;
        this.y /= scalar.y;
        this.z /= scalar.z;
        return this;
    }

    public Vector3f negate() {
        return new Vector3f(-this.x, -this.y, -this.z);
    }

    public Vector3f negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f subtract(Vector3f vec) {
        return new Vector3f(this.x - vec.x, this.y - vec.y, this.z - vec.z);
    }

    public Vector3f subtractLocal(Vector3f vec) {
        if (null == vec) {
            logger.warning("Provided vector is null, null returned.");
            return null;
        }
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    public Vector3f subtract(Vector3f vec, Vector3f result) {
        if (result == null) {
            result = new Vector3f();
        }
        result.x = this.x - vec.x;
        result.y = this.y - vec.y;
        result.z = this.z - vec.z;
        return result;
    }

    public Vector3f subtract(float subtractX, float subtractY, float subtractZ) {
        return new Vector3f(this.x - subtractX, this.y - subtractY, this.z - subtractZ);
    }

    public Vector3f subtractLocal(float subtractX, float subtractY, float subtractZ) {
        this.x -= subtractX;
        this.y -= subtractY;
        this.z -= subtractZ;
        return this;
    }

    public Vector3f normalize() {
        float length = this.x * this.x + this.y * this.y + this.z * this.z;
        if (length != 1.0f && length != 0.0f) {
            length = 1.0f / FastMath.sqrt(length);
            return new Vector3f(this.x * length, this.y * length, this.z * length);
        }
        return this.clone();
    }

    public Vector3f normalizeLocal() {
        float length = this.x * this.x + this.y * this.y + this.z * this.z;
        if (length != 1.0f && length != 0.0f) {
            length = 1.0f / FastMath.sqrt(length);
            this.x *= length;
            this.y *= length;
            this.z *= length;
        }
        return this;
    }

    public void maxLocal(Vector3f other) {
        this.x = other.x > this.x ? other.x : this.x;
        this.y = other.y > this.y ? other.y : this.y;
        this.z = other.z > this.z ? other.z : this.z;
    }

    public void minLocal(Vector3f other) {
        this.x = other.x < this.x ? other.x : this.x;
        this.y = other.y < this.y ? other.y : this.y;
        this.z = other.z < this.z ? other.z : this.z;
    }

    public Vector3f zero() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        return this;
    }

    public float angleBetween(Vector3f otherVector) {
        float dotProduct = this.dot(otherVector);
        float angle = FastMath.acos(dotProduct);
        return angle;
    }

    public Vector3f interpolate(Vector3f finalVec, float changeAmnt) {
        this.x = (1.0f - changeAmnt) * this.x + changeAmnt * finalVec.x;
        this.y = (1.0f - changeAmnt) * this.y + changeAmnt * finalVec.y;
        this.z = (1.0f - changeAmnt) * this.z + changeAmnt * finalVec.z;
        return this;
    }

    public Vector3f interpolate(Vector3f beginVec, Vector3f finalVec, float changeAmnt) {
        this.x = (1.0f - changeAmnt) * beginVec.x + changeAmnt * finalVec.x;
        this.y = (1.0f - changeAmnt) * beginVec.y + changeAmnt * finalVec.y;
        this.z = (1.0f - changeAmnt) * beginVec.z + changeAmnt * finalVec.z;
        return this;
    }

    public static boolean isValidVector(Vector3f vector) {
        if (vector == null) {
            return false;
        }
        if (Float.isNaN(vector.x) || Float.isNaN(vector.y) || Float.isNaN(vector.z)) {
            return false;
        }
        return !Float.isInfinite(vector.x) && !Float.isInfinite(vector.y) && !Float.isInfinite(vector.z);
    }

    public static void generateOrthonormalBasis(Vector3f u2, Vector3f v2, Vector3f w2) {
        w2.normalizeLocal();
        Vector3f.generateComplementBasis(u2, v2, w2);
    }

    public static void generateComplementBasis(Vector3f u2, Vector3f v2, Vector3f w2) {
        if (FastMath.abs(w2.x) >= FastMath.abs(w2.y)) {
            float fInvLength = FastMath.invSqrt(w2.x * w2.x + w2.z * w2.z);
            u2.x = -w2.z * fInvLength;
            u2.y = 0.0f;
            u2.z = w2.x * fInvLength;
            v2.x = w2.y * u2.z;
            v2.y = w2.z * u2.x - w2.x * u2.z;
            v2.z = -w2.y * u2.x;
        } else {
            float fInvLength = FastMath.invSqrt(w2.y * w2.y + w2.z * w2.z);
            u2.x = 0.0f;
            u2.y = w2.z * fInvLength;
            u2.z = -w2.y * fInvLength;
            v2.x = w2.y * u2.z - w2.z * u2.y;
            v2.y = -w2.x * u2.z;
            v2.z = w2.x * u2.y;
        }
    }

    public Vector3f clone() {
        try {
            return (Vector3f)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new AssertionError();
        }
    }

    public float[] toArray(float[] floats) {
        if (floats == null) {
            floats = new float[]{this.x, this.y, this.z};
        }
        return floats;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3f other = (Vector3f)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public float getX() {
        return this.x;
    }

    public Vector3f setX(float x2) {
        this.x = x2;
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Vector3f setY(float y2) {
        this.y = y2;
        return this;
    }

    public float getZ() {
        return this.z;
    }

    public Vector3f setZ(float z2) {
        this.z = z2;
        return this;
    }

    public float get(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("index must be either 0, 1 or 2");
    }

    public void set(int index, float value) {
        switch (index) {
            case 0: {
                this.x = value;
                return;
            }
            case 1: {
                this.y = value;
                return;
            }
            case 2: {
                this.z = value;
                return;
            }
        }
        throw new IllegalArgumentException("index must be either 0, 1 or 2");
    }

    public void set(bo vec) {
        this.x = (float)vec.a;
        this.y = (float)vec.b;
        this.z = (float)vec.c;
    }
}

