/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.math;

import com.jme3.math.AbstractTriangle;
import com.jme3.math.Vector3f;
import java.io.Serializable;

public class Triangle
extends AbstractTriangle
implements Serializable {
    static final long serialVersionUID = 1L;
    private Vector3f pointa = new Vector3f();
    private Vector3f pointb = new Vector3f();
    private Vector3f pointc = new Vector3f();
    private transient Vector3f center;
    private transient Vector3f normal;
    private float projection;
    private int index;

    public Triangle() {
    }

    public Triangle(Vector3f p1, Vector3f p2, Vector3f p3) {
        this.pointa.set(p1);
        this.pointb.set(p2);
        this.pointc.set(p3);
    }

    public Vector3f get(int i2) {
        switch (i2) {
            case 0: {
                return this.pointa;
            }
            case 1: {
                return this.pointb;
            }
            case 2: {
                return this.pointc;
            }
        }
        return null;
    }

    @Override
    public Vector3f get1() {
        return this.pointa;
    }

    @Override
    public Vector3f get2() {
        return this.pointb;
    }

    @Override
    public Vector3f get3() {
        return this.pointc;
    }

    public void set(int i2, Vector3f point) {
        switch (i2) {
            case 0: {
                this.pointa.set(point);
                break;
            }
            case 1: {
                this.pointb.set(point);
                break;
            }
            case 2: {
                this.pointc.set(point);
            }
        }
    }

    public void set(int i2, float x2, float y2, float z2) {
        switch (i2) {
            case 0: {
                this.pointa.set(x2, y2, z2);
                break;
            }
            case 1: {
                this.pointb.set(x2, y2, z2);
                break;
            }
            case 2: {
                this.pointc.set(x2, y2, z2);
            }
        }
    }

    public void set1(Vector3f v2) {
        this.pointa.set(v2);
    }

    public void set2(Vector3f v2) {
        this.pointb.set(v2);
    }

    public void set3(Vector3f v2) {
        this.pointc.set(v2);
    }

    @Override
    public void set(Vector3f v1, Vector3f v2, Vector3f v3) {
        this.pointa.set(v1);
        this.pointb.set(v2);
        this.pointc.set(v3);
    }

    public void calculateCenter() {
        if (this.center == null) {
            this.center = new Vector3f(this.pointa);
        } else {
            this.center.set(this.pointa);
        }
        this.center.addLocal(this.pointb).addLocal(this.pointc).multLocal(0.33333334f);
    }

    public void calculateNormal() {
        if (this.normal == null) {
            this.normal = new Vector3f(this.pointb);
        } else {
            this.normal.set(this.pointb);
        }
        this.normal.subtractLocal(this.pointa).crossLocal(this.pointc.x - this.pointa.x, this.pointc.y - this.pointa.y, this.pointc.z - this.pointa.z);
        this.normal.normalizeLocal();
    }

    public Vector3f getCenter() {
        if (this.center == null) {
            this.calculateCenter();
        }
        return this.center;
    }

    public void setCenter(Vector3f center) {
        this.center = center;
    }

    public Vector3f getNormal() {
        if (this.normal == null) {
            this.calculateNormal();
        }
        return this.normal;
    }

    public void setNormal(Vector3f normal) {
        this.normal = normal;
    }

    public float getProjection() {
        return this.projection;
    }

    public void setProjection(float projection) {
        this.projection = projection;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static Vector3f computeTriangleNormal(Vector3f v1, Vector3f v2, Vector3f v3, Vector3f store) {
        if (store == null) {
            store = new Vector3f(v2);
        } else {
            store.set(v2);
        }
        store.subtractLocal(v1).crossLocal(v3.x - v1.x, v3.y - v1.y, v3.z - v1.z);
        return store.normalizeLocal();
    }

    public Triangle clone() {
        try {
            Triangle t2 = (Triangle)super.clone();
            t2.pointa = this.pointa.clone();
            t2.pointb = this.pointb.clone();
            t2.pointc = this.pointc.clone();
            return t2;
        }
        catch (CloneNotSupportedException e2) {
            throw new AssertionError();
        }
    }
}

