/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

public class TMIView
implements _tmi_MgTooltipHandler {
    public static final String COPYRIGHT = "All of TooManyItems except for thesmall portion excerpted from the original Minecraft game is copyright 2011Marglyph. TooManyItems is free for personal use only. Do not redistributeTooManyItems, including in mod packs, and do not use TooManyItems' sourcecode or graphics in your own mods.";
    private _tmi_MgCanvas canvas;
    private TMIConfig config;
    private TMIController controller;
    private boolean widgetsCreated = false;
    private String activeTooltip = null;
    private _tmi_MgButton prevButton;
    private _tmi_MgButton nextButton;
    private _tmi_MgButton trashButton;
    private _tmi_MgButton[] stateButtons;
    private _tmi_MgButton[] deleteButtons;
    public _tmi_MgItemPanel itemPanel;
    public _tmi_MgButton rain;
    public _tmi_MgButton creative;
    public _tmi_MgButton delete;
    public _tmi_MgButton noon;
    public _tmi_MgButton dawn;
    public _tmi_MgButton dusk;
    public _tmi_MgButton midnight;

    public TMIView(_tmi_MgCanvas _tmi_MgCanvas2, TMIConfig tMIConfig, TMIController tMIController) {
        this.canvas = _tmi_MgCanvas2;
        this.config = tMIConfig;
        this.controller = tMIController;
        this.stateButtons = new _tmi_MgButton[this.config.getNumSaves()];
        this.deleteButtons = new _tmi_MgButton[this.config.getNumSaves()];
        this.createWidgets();
    }

    public void createWidgets() {
        this.prevButton = new _tmi_MgButton("", this.controller, "prev");
        this.prevButton.icon = new _tmi_MgImage(48, 12, 12, 12);
        this.prevButton.setOwnWidth(this.canvas);
        this.prevButton.height = 12;
        this.canvas.widgets.add(this.prevButton);
        this.nextButton = new _tmi_MgButton("", this.controller, "next");
        this.nextButton.icon = new _tmi_MgImage(36, 12, 12, 12);
        this.nextButton.setOwnWidth(this.canvas);
        this.nextButton.height = 12;
        this.canvas.widgets.add(this.nextButton);
        this.itemPanel = new _tmi_MgItemPanel(0, 0, 0, 0, 0, this.config.getItems(), this.controller);
        this.canvas.widgets.add(this.itemPanel);
        this.rain = new _tmi_MgButton("", this.controller, "rain");
        this.rain.showState = true;
        this.rain.icon = new _tmi_MgImage(0, 12, 12, 12);
        this.rain.setOwnWidth(this.canvas);
        this.rain.height = 14;
        this.canvas.widgets.add(this.rain);
        this.creative = new _tmi_MgButton("", this.controller, "creative");
        this.creative.showState = true;
        this.creative.icon = new _tmi_MgImage(12, 12, 12, 12);
        this.creative.setOwnWidth(this.canvas);
        this.creative.height = 14;
        this.canvas.widgets.add(this.creative);
        this.delete = new _tmi_MgButton("", this.controller, "deleteMode");
        this.delete.icon = new _tmi_MgImage(24, 12, 12, 12);
        this.delete.showState = true;
        this.delete.setOwnWidth(this.canvas);
        this.delete.height = 14;
        this.canvas.widgets.add(this.delete);
        this.noon = new _tmi_MgButton("", this.controller, "noon");
        this.noon.icon = new _tmi_MgImage(0, 24, 12, 12);
        this.noon.setOwnWidth(this.canvas);
        this.noon.height = 14;
        this.canvas.widgets.add(this.noon);
        this.dawn = new _tmi_MgButton("", this.controller, "dawn");
        this.dawn.icon = new _tmi_MgImage(12, 24, 12, 12);
        this.dawn.setOwnWidth(this.canvas);
        this.dawn.height = 14;
        this.canvas.widgets.add(this.dawn);
        this.dusk = new _tmi_MgButton("", this.controller, "dusk");
        this.dusk.icon = new _tmi_MgImage(24, 24, 12, 12);
        this.dusk.setOwnWidth(this.canvas);
        this.dusk.height = 14;
        this.canvas.widgets.add(this.dusk);
        this.midnight = new _tmi_MgButton("", this.controller, "midnight");
        this.midnight.icon = new _tmi_MgImage(36, 24, 12, 12);
        this.midnight.setOwnWidth(this.canvas);
        this.midnight.height = 14;
        this.canvas.widgets.add(this.midnight);
        this.delete.x = 2;
        this.delete.y = 2;
        this.canvas.arrangeHorizontally(1, 1001, this.delete, this.creative, this.rain, this.dawn, this.noon, this.dusk, this.midnight);
        this.stateButtons = new _tmi_MgButton[this.config.getNumSaves()];
        for (int i2 = 0; i2 < this.config.getNumSaves(); ++i2) {
            this.stateButtons[i2] = new _tmi_MgButton("Save " + (i2 + 1), this.controller, new TMIStateButtonData(i2, 0));
            this.canvas.widgets.add(this.stateButtons[i2]);
            this.deleteButtons[i2] = new _tmi_MgButton("x", this.controller, new TMIStateButtonData(i2, 1));
            this.canvas.widgets.add(this.deleteButtons[i2]);
        }
        this.widgetsCreated = true;
    }

    public void layout(int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = (n2 - n4) / 2;
        if (!this.widgetsCreated) {
            this.createWidgets();
        }
        this.itemPanel.x = (n2 + n4) / 2 + 5;
        this.itemPanel.y = 20;
        this.itemPanel.width = n2 - this.itemPanel.x - 2;
        this.itemPanel.height = n3 - this.itemPanel.y;
        this.itemPanel.resize();
        this.rain.state = TMIUtils.isRaining();
        this.creative.state = TMIUtils.isCreativeMode();
        this.delete.state = this.controller.deleteMode;
        this.prevButton.y = 2;
        this.nextButton.y = 2;
        this.nextButton.x = n2 - this.nextButton.width - 2;
        this.prevButton.x = this.nextButton.x - this.prevButton.width - 2;
        this.canvas.drawRect(0, 0, n2, 18, -301989888);
        String string = "" + (_tmi_MgItemPanel.page + 1) + "/" + this.itemPanel.numPages;
        int n8 = this.prevButton.x - 4 - this.canvas.getTextWidth(string);
        this.canvas.drawText(2, n3 - 13, "TooManyItems 1.2.5pre 2012-03-30   ModLoader " + (TMIConfig.isModloaderEnabled ? "ON" : "OFF"), -1);
        this.canvas.drawText(n8, 4, string, -1);
        this.rain.show = TMIConfig.canChangeWeather();
        this.creative.show = TMIConfig.canChangeCreativeMode();
        this.delete.show = TMIConfig.canDelete();
        this.dusk.show = this.midnight.show = TMIConfig.canChangeTime();
        this.noon.show = this.midnight.show;
        this.dawn.show = this.midnight.show;
        boolean bl2 = TMIConfig.canRestoreSaves();
        int n9 = 0;
        for (n6 = 0; n6 < this.config.getNumSaves(); ++n6) {
            this.deleteButtons[n6].x = -1000;
            this.stateButtons[n6].y = 30 + n6 * 22;
            this.stateButtons[n6].height = 20;
            String string2 = this.config.getSettings().get("save-name" + (n6 + 1));
            if (string2 == null) {
                string2 = "" + (n6 + 1);
            }
            this.stateButtons[n6].label = this.config.isStateSaved(n6) ? "Load " + string2 : "Save " + string2;
            int n10 = this.canvas.getTextWidth(this.stateButtons[n6].label) + 26;
            if (n10 + 2 + 20 > n7) {
                n10 = n7 - 20 - 2;
            }
            if (n10 <= n9) continue;
            n9 = n10;
        }
        for (n6 = 0; n6 < this.config.getNumSaves(); ++n6) {
            this.stateButtons[n6].width = n9;
            this.stateButtons[n6].show = bl2;
            this.deleteButtons[n6].show = bl2;
            if (!this.config.isStateSaved(n6)) continue;
            this.deleteButtons[n6].x = this.stateButtons[n6].width + 2;
            this.deleteButtons[n6].y = this.stateButtons[n6].y;
            this.deleteButtons[n6].width = 20;
            this.deleteButtons[n6].height = 20;
        }
    }

    public void determineTooltip(int n2, int n3) {
        this.setTooltip(null);
        if (this.rain != null && this.rain.contains(n2, n3)) {
            this.setTooltip("Rain/snow is " + (this.rain.state ? "ON" : "OFF"));
        } else if (this.creative != null && this.creative.contains(n2, n3)) {
            this.setTooltip("Creative mode is " + (this.creative.state ? "ON" : "OFF"));
        } else if (this.noon != null && this.noon.contains(n2, n3)) {
            this.setTooltip("Set time to noon");
        } else if (this.dawn != null && this.dawn.contains(n2, n3)) {
            this.setTooltip("Set time to sunrise");
        } else if (this.dusk != null && this.dusk.contains(n2, n3)) {
            this.setTooltip("Set time to sunset");
        } else if (this.midnight != null && this.midnight.contains(n2, n3)) {
            this.setTooltip("Set time to midnight");
        } else if (this.delete != null && this.delete.contains(n2, n3)) {
            aan aan2 = TMIUtils.getHeldItem();
            if (aan2 == null) {
                if (TMIUtils.shiftKey()) {
                    this.setTooltip("DELETE ALL ITEMS from current inventory screen");
                } else {
                    this.setTooltip("Delete mode is " + (this.delete.state ? "ON" : "OFF"));
                }
            } else if (TMIUtils.shiftKey()) {
                this.setTooltip("DELETE ALL " + TMIUtils.itemDisplayName(aan2));
            } else {
                this.setTooltip("DELETE " + TMIUtils.itemDisplayName(aan2));
            }
        } else if (this.itemPanel.contains(n2, n3)) {
            aan aan3 = TMIUtils.getHeldItem();
            if (aan3 == null) {
                aan aan4 = this.itemPanel.getHoverItem();
                if (aan4 != null) {
                    List<String> list = TMIUtils.itemDisplayNameMultiline(aan4, true);
                    this.canvas.drawMultilineTip(n2, n3, list);
                }
            } else {
                this.setTooltip("DELETE " + TMIUtils.itemDisplayName(aan3));
            }
        }
    }

    public boolean isInitialized() {
        return this.widgetsCreated;
    }

    public void setTooltip(String string) {
        this.activeTooltip = string;
    }

    public String getTooltip(String string) {
        return this.activeTooltip;
    }

    public boolean hasTooltip() {
        return this.activeTooltip != null;
    }

    public void showToolTip(int n2, int n3) {
        if (this.activeTooltip != null) {
            this.canvas.drawTip(n2, n3, this.activeTooltip);
        }
    }
}

