/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModLoader {
    private static final List<tt> animList = new LinkedList<tt>();
    private static final Map<Integer, BaseMod> blockModels = new HashMap<Integer, BaseMod>();
    private static final Map<Integer, Boolean> blockSpecialInv = new HashMap<Integer, Boolean>();
    private static final File cfgdir = new File(Minecraft.b(), "/config/");
    private static final File cfgfile = new File(cfgdir, "ModLoader.cfg");
    public static Level cfgLoggingLevel = Level.FINER;
    private static Map<String, Class<? extends nn>> classMap = null;
    private static long clock = 0L;
    public static final boolean DEBUG = false;
    private static Field field_animList = null;
    private static Field field_armorList = null;
    private static Field field_modifiers = null;
    private static Field field_TileEntityRenderers = null;
    private static boolean hasInit = false;
    private static int highestEntityId = 3000;
    private static final Map<BaseMod, Boolean> inGameHooks = new HashMap<BaseMod, Boolean>();
    private static final Map<BaseMod, Boolean> inGUIHooks = new HashMap<BaseMod, Boolean>();
    private static Minecraft instance = null;
    private static int itemSpriteIndex = 0;
    private static int itemSpritesLeft = 0;
    private static final Map<BaseMod, Map<afu, boolean[]>> keyList = new HashMap<BaseMod, Map<afu, boolean[]>>();
    private static String langPack = null;
    private static Map<String, Map<String, String>> localizedStrings = new HashMap<String, Map<String, String>>();
    private static final File logfile = new File(Minecraft.b(), "ModLoader.txt");
    private static final Logger logger = Logger.getLogger("ModLoader");
    private static FileHandler logHandler = null;
    private static Method method_RegisterEntityID = null;
    private static Method method_RegisterTileEntity = null;
    private static final File modDir = new File(Minecraft.b(), "/mods/");
    private static final LinkedList<BaseMod> modList = new LinkedList();
    private static int nextBlockModelID = 1000;
    private static final Map<Integer, Map<String, Integer>> overrides = new HashMap<Integer, Map<String, Integer>>();
    private static final Map<String, BaseMod> packetChannels = new HashMap<String, BaseMod>();
    public static final Properties props = new Properties();
    private static abn[] standardBiomes;
    private static int terrainSpriteIndex;
    private static int terrainSpritesLeft;
    private static String texPack;
    private static boolean texturesAdded;
    private static final boolean[] usedItemSprites;
    private static final boolean[] usedTerrainSprites;
    public static final String VERSION = "ModLoader 1.2.5";
    private static adl netHandler;

    static {
        terrainSpriteIndex = 0;
        terrainSpritesLeft = 0;
        texPack = null;
        texturesAdded = false;
        usedItemSprites = new boolean[256];
        usedTerrainSprites = new boolean[256];
        netHandler = null;
    }

    public static void addAchievementDesc(aeb achievement, String name, String description) {
        try {
            if (achievement.i().contains(".")) {
                String[] split = achievement.i().split("\\.");
                if (split.length == 2) {
                    String key = split[1];
                    ModLoader.addLocalization("achievement." + key, name);
                    ModLoader.addLocalization("achievement." + key + ".desc", description);
                    ModLoader.setPrivateValue(ajw.class, achievement, 1, cy.a("achievement." + key));
                    ModLoader.setPrivateValue(aeb.class, achievement, 3, cy.a("achievement." + key + ".desc"));
                } else {
                    ModLoader.setPrivateValue(ajw.class, achievement, 1, name);
                    ModLoader.setPrivateValue(aeb.class, achievement, 3, description);
                }
            } else {
                ModLoader.setPrivateValue(ajw.class, achievement, 1, name);
                ModLoader.setPrivateValue(aeb.class, achievement, 3, description);
            }
        }
        catch (IllegalArgumentException e2) {
            logger.throwing("ModLoader", "AddAchievementDesc", e2);
            ModLoader.throwException(e2);
        }
        catch (SecurityException e3) {
            logger.throwing("ModLoader", "AddAchievementDesc", e3);
            ModLoader.throwException(e3);
        }
        catch (NoSuchFieldException e4) {
            logger.throwing("ModLoader", "AddAchievementDesc", e4);
            ModLoader.throwException(e4);
        }
    }

    public static int addAllFuel(int id2, int metadata) {
        logger.finest("Finding fuel for " + id2);
        int result = 0;
        Iterator iter = modList.iterator();
        while (iter.hasNext() && result == 0) {
            result = ((BaseMod)iter.next()).addFuel(id2, metadata);
        }
        if (result != 0) {
            logger.finest("Returned " + result);
        }
        return result;
    }

    public static void addAllRenderers(Map<Class<? extends nn>, um> renderers) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        for (BaseMod mod : modList) {
            mod.addRenderer(renderers);
        }
    }

    public static void addAnimation(tt anim) {
        logger.finest("Adding animation " + anim.toString());
        for (tt oldAnim : animList) {
            if (oldAnim.g != anim.g || oldAnim.k != anim.k) continue;
            animList.remove(anim);
            break;
        }
        animList.add(anim);
    }

    public static int addArmor(String armor) {
        try {
            String[] existingArmor = (String[])field_armorList.get(null);
            List<String> existingArmorList = Arrays.asList(existingArmor);
            ArrayList<String> combinedList = new ArrayList<String>();
            combinedList.addAll(existingArmorList);
            if (!combinedList.contains(armor)) {
                combinedList.add(armor);
            }
            int index = combinedList.indexOf(armor);
            field_armorList.set(null, combinedList.toArray(new String[0]));
            return index;
        }
        catch (IllegalArgumentException e2) {
            logger.throwing("ModLoader", "AddArmor", e2);
            ModLoader.throwException("An impossible error has occured!", e2);
        }
        catch (IllegalAccessException e3) {
            logger.throwing("ModLoader", "AddArmor", e3);
            ModLoader.throwException("An impossible error has occured!", e3);
        }
        return -1;
    }

    public static void addBiome(abn biome) {
        abn[] existingBiomes = ahy.biomeArray;
        List<abn> existingBiomeList = Arrays.asList(existingBiomes);
        ArrayList<abn> combinedList = new ArrayList<abn>();
        combinedList.addAll(existingBiomeList);
        if (!combinedList.contains(biome)) {
            combinedList.add(biome);
        }
        ahy.biomeArray = combinedList.toArray(new abn[0]);
    }

    public static void addLocalization(String key, String value) {
        ModLoader.addLocalization(key, "en_US", value);
    }

    public static void addLocalization(String key, String lang, String value) {
        Map<Object, Object> langMap;
        if (localizedStrings.containsKey(lang)) {
            langMap = localizedStrings.get(lang);
        } else {
            langMap = new HashMap();
            localizedStrings.put(lang, langMap);
        }
        langMap.put(key, value);
    }

    private static void addMod(ClassLoader loader, String filename) {
        try {
            Class<?> instclass;
            String name = filename.split("\\.")[0];
            if (name.contains("$")) {
                return;
            }
            if (props.containsKey(name) && (props.getProperty(name).equalsIgnoreCase("no") || props.getProperty(name).equalsIgnoreCase("off"))) {
                return;
            }
            Package pack = ModLoader.class.getPackage();
            if (pack != null) {
                name = String.valueOf(pack.getName()) + "." + name;
            }
            if (!BaseMod.class.isAssignableFrom(instclass = loader.loadClass(name))) {
                return;
            }
            ModLoader.setupProperties(instclass);
            BaseMod mod = (BaseMod)instclass.newInstance();
            if (mod != null) {
                modList.add(mod);
                logger.fine("Mod Initialized: \"" + mod.toString() + "\" from " + filename);
                System.out.println("Mod Initialized: " + mod.toString());
            }
        }
        catch (Throwable e2) {
            logger.fine("Failed to load mod from \"" + filename + "\"");
            System.out.println("Failed to load mod from \"" + filename + "\"");
            logger.throwing("ModLoader", "addMod", e2);
            ModLoader.throwException(e2);
        }
    }

    public static void addName(Object instance, String name) {
        ModLoader.addName(instance, "en_US", name);
    }

    public static void addName(Object instance, String lang, String name) {
        Exception e2;
        String tag = null;
        if (instance instanceof yr) {
            yr item = (yr)instance;
            if (item.e() != null) {
                tag = String.valueOf(item.e()) + ".name";
            }
        } else if (instance instanceof pb) {
            pb block = (pb)instance;
            if (block.s() != null) {
                tag = String.valueOf(block.s()) + ".name";
            }
        } else if (instance instanceof aan) {
            aan stack = (aan)instance;
            String stackTag = yr.e[stack.c].a(stack);
            if (stackTag != null) {
                tag = String.valueOf(stackTag) + ".name";
            }
        } else {
            e2 = new Exception(String.valueOf(instance.getClass().getName()) + " cannot have name attached to it!");
            logger.throwing("ModLoader", "AddName", e2);
            ModLoader.throwException(e2);
        }
        if (tag != null) {
            ModLoader.addLocalization(tag, lang, name);
        } else {
            e2 = new Exception(instance + " is missing name tag!");
            logger.throwing("ModLoader", "AddName", e2);
            ModLoader.throwException(e2);
        }
    }

    public static int addOverride(String fileToOverride, String fileToAdd) {
        try {
            int i2 = ModLoader.getUniqueSpriteIndex(fileToOverride);
            ModLoader.addOverride(fileToOverride, fileToAdd, i2);
            return i2;
        }
        catch (Throwable e2) {
            logger.throwing("ModLoader", "addOverride", e2);
            ModLoader.throwException(e2);
            throw new RuntimeException(e2);
        }
    }

    public static void addOverride(String path, String overlayPath, int index) {
        int dst = -1;
        int left = 0;
        if (path.equals("/terrain.png")) {
            dst = 0;
            left = terrainSpritesLeft;
        } else if (path.equals("/gui/items.png")) {
            dst = 1;
            left = itemSpritesLeft;
        } else {
            return;
        }
        System.out.println("Overriding " + path + " with " + overlayPath + " @ " + index + ". " + left + " left.");
        logger.finer("addOverride(" + path + "," + overlayPath + "," + index + "). " + left + " left.");
        Map<String, Integer> overlays = overrides.get(dst);
        if (overlays == null) {
            overlays = new HashMap<String, Integer>();
            overrides.put(dst, overlays);
        }
        overlays.put(overlayPath, index);
    }

    public static void addRecipe(aan output, Object ... params) {
        fr.a().a(output, params);
    }

    public static void addShapelessRecipe(aan output, Object ... params) {
        fr.a().b(output, params);
    }

    public static void addSmelting(int input, aan output) {
        dy.a().a(input, output);
    }

    public static void addSpawn(Class<? extends acq> entityClass, int weightedProb, int min, int max, acf spawnList) {
        ModLoader.addSpawn(entityClass, weightedProb, min, max, spawnList, null);
    }

    public static void addSpawn(Class<? extends acq> entityClass, int weightedProb, int min, int max, acf spawnList, abn ... biomes) {
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass cannot be null");
        }
        if (spawnList == null) {
            throw new IllegalArgumentException("spawnList cannot be null");
        }
        if (biomes == null) {
            biomes = standardBiomes;
        }
        int i2 = 0;
        while (i2 < biomes.length) {
            List list = biomes[i2].a(spawnList);
            if (list != null) {
                boolean exists = false;
                for (bg entry : list) {
                    if (entry.a != entityClass) continue;
                    entry.d = weightedProb;
                    entry.b = min;
                    entry.c = max;
                    exists = true;
                    break;
                }
                if (!exists) {
                    list.add(new bg(entityClass, weightedProb, min, max));
                }
            }
            ++i2;
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, acf spawnList) {
        ModLoader.addSpawn(entityName, weightedProb, min, max, spawnList, null);
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, acf spawnList, abn ... biomes) {
        Class<? extends nn> entityClass = classMap.get(entityName);
        if (entityClass != null && acq.class.isAssignableFrom(entityClass)) {
            ModLoader.addSpawn(entityClass, weightedProb, min, max, spawnList, biomes);
        }
    }

    public static boolean dispenseEntity(xd world, double x2, double y2, double z2, int xVel, int zVel, aan item) {
        boolean result = false;
        Iterator iter = modList.iterator();
        while (iter.hasNext() && !result) {
            result = ((BaseMod)iter.next()).dispenseEntity(world, x2, y2, z2, xVel, zVel, item);
        }
        return result;
    }

    public static void genericContainerRemoval(xd world, int x2, int y2, int z2) {
        io container = (io)((Object)world.b(x2, y2, z2));
        if (container != null) {
            int i2 = 0;
            while (i2 < container.a()) {
                aan item = container.k_(i2);
                if (item != null) {
                    double xOffset = world.r.nextDouble() * 0.8 + 0.1;
                    double yOffset = world.r.nextDouble() * 0.8 + 0.1;
                    double zOffset = world.r.nextDouble() * 0.8 + 0.1;
                    while (item.a > 0) {
                        int amt = world.r.nextInt(21) + 10;
                        if (amt > item.a) {
                            amt = item.a;
                        }
                        item.a -= amt;
                        fq entity = new fq(world, (double)x2 + xOffset, (double)y2 + yOffset, (double)z2 + zOffset, new aan(item.c, amt, item.i()));
                        double speed = 0.05;
                        entity.r = world.r.nextGaussian() * speed;
                        entity.s = world.r.nextGaussian() * speed + 0.2;
                        entity.t = world.r.nextGaussian() * speed;
                        if (item.n()) {
                            entity.a.d((ady)item.o().b());
                        }
                        world.a(entity);
                    }
                    container.a(i2, null);
                }
                ++i2;
            }
        }
    }

    public static List<BaseMod> getLoadedMods() {
        return Collections.unmodifiableList(modList);
    }

    public static Logger getLogger() {
        return logger;
    }

    public static Minecraft getMinecraftInstance() {
        if (instance == null) {
            try {
                ThreadGroup group = Thread.currentThread().getThreadGroup();
                int count = group.activeCount();
                Thread[] threads = new Thread[count];
                group.enumerate(threads);
                int i2 = 0;
                while (i2 < threads.length) {
                    System.out.println(threads[i2].getName());
                    ++i2;
                }
                i2 = 0;
                while (i2 < threads.length) {
                    if (threads[i2].getName().equals("Minecraft main thread")) {
                        instance = (Minecraft)ModLoader.getPrivateValue(Thread.class, threads[i2], "target");
                        break;
                    }
                    ++i2;
                }
            }
            catch (SecurityException e2) {
                logger.throwing("ModLoader", "getMinecraftInstance", e2);
                throw new RuntimeException(e2);
            }
            catch (NoSuchFieldException e3) {
                logger.throwing("ModLoader", "getMinecraftInstance", e3);
                throw new RuntimeException(e3);
            }
        }
        return instance;
    }

    public static <T, E> T getPrivateValue(Class<? super E> instanceclass, E instance, int fieldindex) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field f2 = instanceclass.getDeclaredFields()[fieldindex];
            f2.setAccessible(true);
            return (T)f2.get(instance);
        }
        catch (IllegalAccessException e2) {
            logger.throwing("ModLoader", "getPrivateValue", e2);
            ModLoader.throwException("An impossible error has occured!", e2);
            return null;
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> instanceclass, E instance, String field) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field f2 = instanceclass.getDeclaredField(field);
            f2.setAccessible(true);
            return (T)f2.get(instance);
        }
        catch (IllegalAccessException e2) {
            logger.throwing("ModLoader", "getPrivateValue", e2);
            ModLoader.throwException("An impossible error has occured!", e2);
            return null;
        }
    }

    public static int getUniqueBlockModelID(BaseMod mod, boolean full3DItem) {
        int id2 = nextBlockModelID++;
        blockModels.put(id2, mod);
        blockSpecialInv.put(id2, full3DItem);
        return id2;
    }

    public static int getUniqueEntityId() {
        return highestEntityId++;
    }

    private static int getUniqueItemSpriteIndex() {
        while (itemSpriteIndex < usedItemSprites.length) {
            if (!usedItemSprites[itemSpriteIndex]) {
                ModLoader.usedItemSprites[ModLoader.itemSpriteIndex] = true;
                --itemSpritesLeft;
                return itemSpriteIndex++;
            }
            ++itemSpriteIndex;
        }
        Exception e2 = new Exception("No more empty item sprite indices left!");
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", e2);
        ModLoader.throwException(e2);
        return 0;
    }

    public static int getUniqueSpriteIndex(String path) {
        if (path.equals("/gui/items.png")) {
            return ModLoader.getUniqueItemSpriteIndex();
        }
        if (path.equals("/terrain.png")) {
            return ModLoader.getUniqueTerrainSpriteIndex();
        }
        Exception e2 = new Exception("No registry for this texture: " + path);
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", e2);
        ModLoader.throwException(e2);
        return 0;
    }

    private static int getUniqueTerrainSpriteIndex() {
        while (terrainSpriteIndex < usedTerrainSprites.length) {
            if (!usedTerrainSprites[terrainSpriteIndex]) {
                ModLoader.usedTerrainSprites[ModLoader.terrainSpriteIndex] = true;
                --terrainSpritesLeft;
                return terrainSpriteIndex++;
            }
            ++terrainSpriteIndex;
        }
        Exception e2 = new Exception("No more empty terrain sprite indices left!");
        logger.throwing("ModLoader", "getUniqueItemSpriteIndex", e2);
        ModLoader.throwException(e2);
        return 0;
    }

    private static void init() {
        hasInit = true;
        String usedItemSpritesString = "1111111111111111111111111111111111111101111111111111111111111111111111111111111111111111111111111111110111111111111111000111111111111101111111110000000101111111000000010101111100000000000000110000000000000000000000000000000000000000000000001111111111111111";
        String usedTerrainSpritesString = "1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000001111111111000000001111111100000111111111100000001111111110000001111111111111111111";
        int i2 = 0;
        while (i2 < 256) {
            boolean bl2 = ModLoader.usedItemSprites[i2] = usedItemSpritesString.charAt(i2) == '1';
            if (!usedItemSprites[i2]) {
                ++itemSpritesLeft;
            }
            boolean bl3 = ModLoader.usedTerrainSprites[i2] = usedTerrainSpritesString.charAt(i2) == '1';
            if (!usedTerrainSprites[i2]) {
                ++terrainSpritesLeft;
            }
            ++i2;
        }
        try {
            instance = (Minecraft)ModLoader.getPrivateValue(Minecraft.class, null, 1);
            ModLoader.instance.u = new EntityRendererProxy(instance);
            classMap = (Map)ModLoader.getPrivateValue(aao.class, null, 0);
            field_modifiers = Field.class.getDeclaredField("modifiers");
            field_modifiers.setAccessible(true);
            field_TileEntityRenderers = ach.class.getDeclaredFields()[0];
            field_TileEntityRenderers.setAccessible(true);
            field_armorList = we.class.getDeclaredFields()[3];
            field_modifiers.setInt(field_armorList, field_armorList.getModifiers() & 0xFFFFFFEF);
            field_armorList.setAccessible(true);
            field_animList = aaw.class.getDeclaredFields()[6];
            field_animList.setAccessible(true);
            Field[] fieldArray = abn.class.getDeclaredFields();
            LinkedList<abn> biomes = new LinkedList<abn>();
            int i3 = 0;
            while (i3 < fieldArray.length) {
                abn biome;
                Class<abn> fieldType = fieldArray[i3].getType();
                if ((fieldArray[i3].getModifiers() & 8) != 0 && fieldType.isAssignableFrom(abn.class) && !((biome = (abn)fieldArray[i3].get(null)) instanceof td) && !(biome instanceof fz)) {
                    biomes.add(biome);
                }
                ++i3;
            }
            standardBiomes = biomes.toArray(new abn[0]);
            try {
                method_RegisterTileEntity = kw.class.getDeclaredMethod("a", Class.class, String.class);
            }
            catch (NoSuchMethodException e2) {
                method_RegisterTileEntity = kw.class.getDeclaredMethod("addMapping", Class.class, String.class);
            }
            method_RegisterTileEntity.setAccessible(true);
            try {
                method_RegisterEntityID = aao.class.getDeclaredMethod("a", Class.class, String.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e3) {
                method_RegisterEntityID = aao.class.getDeclaredMethod("addMapping", Class.class, String.class, Integer.TYPE);
            }
            method_RegisterEntityID.setAccessible(true);
        }
        catch (SecurityException e4) {
            logger.throwing("ModLoader", "init", e4);
            ModLoader.throwException(e4);
            throw new RuntimeException(e4);
        }
        catch (NoSuchFieldException e5) {
            logger.throwing("ModLoader", "init", e5);
            ModLoader.throwException(e5);
            throw new RuntimeException(e5);
        }
        catch (NoSuchMethodException e6) {
            logger.throwing("ModLoader", "init", e6);
            ModLoader.throwException(e6);
            throw new RuntimeException(e6);
        }
        catch (IllegalArgumentException e7) {
            logger.throwing("ModLoader", "init", e7);
            ModLoader.throwException(e7);
            throw new RuntimeException(e7);
        }
        catch (IllegalAccessException e8) {
            logger.throwing("ModLoader", "init", e8);
            ModLoader.throwException(e8);
            throw new RuntimeException(e8);
        }
        try {
            ModLoader.loadConfig();
            if (props.containsKey("loggingLevel")) {
                cfgLoggingLevel = Level.parse(props.getProperty("loggingLevel"));
            }
            if (props.containsKey("grassFix")) {
                vl.cfgGrassFix = Boolean.parseBoolean(props.getProperty("grassFix"));
            }
            logger.setLevel(cfgLoggingLevel);
            if ((logfile.exists() || logfile.createNewFile()) && logfile.canWrite() && logHandler == null) {
                logHandler = new FileHandler(logfile.getPath());
                logHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(logHandler);
            }
            logger.fine("ModLoader 1.2.5 Initializing...");
            System.out.println("ModLoader 1.2.5 Initializing...");
            File source = new File(ModLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            modDir.mkdirs();
            ModLoader.readFromClassPath(source);
            ModLoader.readFromModFolder(modDir);
            ModLoader.sortModList();
            for (BaseMod mod : modList) {
                mod.load();
                logger.fine("Mod Loaded: \"" + mod.toString() + "\"");
                System.out.println("Mod Loaded: " + mod.toString());
                if (props.containsKey(mod.getClass().getSimpleName())) continue;
                props.setProperty(mod.getClass().getSimpleName(), "on");
            }
            for (BaseMod mod : modList) {
                mod.modsLoaded();
            }
            System.out.println("Done.");
            props.setProperty("loggingLevel", cfgLoggingLevel.getName());
            props.setProperty("grassFix", Boolean.toString(vl.cfgGrassFix));
            ModLoader.instance.A.A = ModLoader.registerAllKeys(ModLoader.instance.A.A);
            ModLoader.instance.A.a();
            ModLoader.initStats();
            ModLoader.saveConfig();
        }
        catch (Throwable e9) {
            logger.throwing("ModLoader", "init", e9);
            ModLoader.throwException("ModLoader has failed to initialize.", e9);
            if (logHandler != null) {
                logHandler.close();
            }
            throw new RuntimeException(e9);
        }
    }

    private static void initStats() {
        String str;
        int id2 = 0;
        while (id2 < pb.m.length) {
            if (!gv.a.containsKey(0x1000000 + id2) && pb.m[id2] != null && pb.m[id2].t()) {
                str = cy.a("stat.mineBlock", pb.m[id2].r());
                gv.C[id2] = new aii(0x1000000 + id2, str, id2).a();
                gv.e.add(gv.C[id2]);
            }
            ++id2;
        }
        id2 = 0;
        while (id2 < yr.e.length) {
            if (!gv.a.containsKey(0x1020000 + id2) && yr.e[id2] != null) {
                str = cy.a("stat.useItem", yr.e[id2].n());
                gv.E[id2] = new aii(0x1020000 + id2, str, id2).a();
                if (id2 >= pb.m.length) {
                    gv.d.add(gv.E[id2]);
                }
            }
            if (!gv.a.containsKey(0x1030000 + id2) && yr.e[id2] != null && yr.e[id2].i()) {
                str = cy.a("stat.breakItem", yr.e[id2].n());
                gv.F[id2] = new aii(0x1030000 + id2, str, id2).a();
            }
            ++id2;
        }
        HashSet<Integer> idHashSet = new HashSet<Integer>();
        for (Object result : fr.a().b()) {
            idHashSet.add(((wf)result).b().c);
        }
        for (Object result : dy.a().b().values()) {
            idHashSet.add(((aan)result).c);
        }
        Iterator<Object> iterator = idHashSet.iterator();
        while (iterator.hasNext()) {
            int id3 = (Integer)iterator.next();
            if (gv.a.containsKey(0x1010000 + id3) || yr.e[id3] == null) continue;
            String str2 = cy.a("stat.craftItem", yr.e[id3].n());
            gv.D[id3] = new aii(0x1010000 + id3, str2, id3).a();
        }
    }

    public static boolean isGUIOpen(Class<? extends vp> gui2) {
        Minecraft game = ModLoader.getMinecraftInstance();
        if (gui2 == null) {
            return game.s == null;
        }
        if (game.s == null && gui2 != null) {
            return false;
        }
        return gui2.isInstance(game.s);
    }

    public static boolean isModLoaded(String modname) {
        for (BaseMod mod : modList) {
            if (!modname.contentEquals(mod.getName())) continue;
            return true;
        }
        return false;
    }

    public static void loadConfig() throws IOException {
        cfgdir.mkdir();
        if (!cfgfile.exists() && !cfgfile.createNewFile()) {
            return;
        }
        if (cfgfile.canRead()) {
            FileInputStream in2 = new FileInputStream(cfgfile);
            props.load(in2);
            ((InputStream)in2).close();
        }
    }

    public static BufferedImage loadImage(aaw texCache, String path) throws Exception {
        gi pack = (gi)ModLoader.getPrivateValue(aaw.class, texCache, 11);
        InputStream input = pack.a.a(path);
        if (input == null) {
            throw new Exception("Image not found: " + path);
        }
        BufferedImage image = ImageIO.read(input);
        if (image == null) {
            throw new Exception("Image corrupted: " + path);
        }
        return image;
    }

    public static void onItemPickup(yw player, aan item) {
        for (BaseMod mod : modList) {
            mod.onItemPickup(player, item);
        }
    }

    public static void onTick(float tick, Minecraft game) {
        Map.Entry<BaseMod, Boolean> modSet;
        Iterator<Map.Entry<BaseMod, Boolean>> iter;
        lv.b();
        lv.b();
        lv.a("modtick");
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        if (texPack == null || game.A.m != texPack) {
            texturesAdded = false;
            texPack = game.A.m;
        }
        if (langPack == null || adn.a().c() != langPack) {
            Properties localized = null;
            try {
                localized = (Properties)ModLoader.getPrivateValue(adn.class, adn.a(), 1);
            }
            catch (SecurityException e2) {
                logger.throwing("ModLoader", "AddLocalization", e2);
                ModLoader.throwException(e2);
            }
            catch (NoSuchFieldException e3) {
                logger.throwing("ModLoader", "AddLocalization", e3);
                ModLoader.throwException(e3);
            }
            langPack = adn.a().c();
            if (localized != null) {
                if (localizedStrings.containsKey("en_US")) {
                    localized.putAll(localizedStrings.get("en_US"));
                }
                if (!langPack.contentEquals("en_US") && localizedStrings.containsKey(langPack)) {
                    localized.putAll(localizedStrings.get(langPack));
                }
            }
        }
        if (!texturesAdded && game.p != null) {
            ModLoader.registerAllTextureOverrides(game.p);
            texturesAdded = true;
        }
        long newclock = 0L;
        if (game.f != null) {
            newclock = game.f.w();
            iter = inGameHooks.entrySet().iterator();
            while (iter.hasNext()) {
                modSet = iter.next();
                if (clock == newclock && modSet.getValue().booleanValue() || modSet.getKey().onTickInGame(tick, game)) continue;
                iter.remove();
            }
        }
        if (game.r != null) {
            iter = inGUIHooks.entrySet().iterator();
            while (iter.hasNext()) {
                modSet = iter.next();
                if (clock == newclock && modSet.getValue() & game.f != null || modSet.getKey().onTickInGUI(tick, game, game.s)) continue;
                iter.remove();
            }
        }
        if (clock != newclock) {
            for (Map.Entry<BaseMod, Map<afu, boolean[]>> modSet2 : keyList.entrySet()) {
                for (Map.Entry<afu, boolean[]> keySet : modSet2.getValue().entrySet()) {
                    int key = keySet.getKey().d;
                    boolean state = key < 0 ? Mouse.isButtonDown((int)(key += 100)) : Keyboard.isKeyDown((int)key);
                    boolean[] keyInfo = keySet.getValue();
                    boolean oldState = keyInfo[1];
                    keyInfo[1] = state;
                    if (!state || oldState && !keyInfo[0]) continue;
                    modSet2.getKey().keyboardEvent(keySet.getKey());
                }
            }
        }
        clock = newclock;
        lv.b();
        lv.a("render");
        lv.a("gameRenderer");
    }

    public static void openGUI(yw player, vp gui2) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        Minecraft game = ModLoader.getMinecraftInstance();
        if (game.i != player) {
            return;
        }
        if (gui2 != null) {
            game.a(gui2);
        }
    }

    public static void populateChunk(ca generator, int chunkX, int chunkZ, xd world) {
        if (!hasInit) {
            ModLoader.init();
            logger.fine("Initialized");
        }
        Random rnd = new Random(world.v());
        long xSeed = rnd.nextLong() / 2L * 2L + 1L;
        long zSeed = rnd.nextLong() / 2L * 2L + 1L;
        rnd.setSeed((long)chunkX * xSeed + (long)chunkZ * zSeed ^ world.v());
        for (BaseMod mod : modList) {
            if (generator.c().equals("RandomLevelSource")) {
                mod.generateSurface(world, rnd, chunkX << 4, chunkZ << 4);
                continue;
            }
            if (!generator.c().equals("HellRandomLevelSource")) continue;
            mod.generateNether(world, rnd, chunkX << 4, chunkZ << 4);
        }
    }

    private static void readFromClassPath(File source) throws FileNotFoundException, IOException {
        logger.finer("Adding mods from " + source.getCanonicalPath());
        ClassLoader loader = ModLoader.class.getClassLoader();
        if (source.isFile() && (source.getName().endsWith(".jar") || source.getName().endsWith(".zip"))) {
            logger.finer("Zip found.");
            FileInputStream input = new FileInputStream(source);
            ZipInputStream zip = new ZipInputStream(input);
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith("mod_") || !name.endsWith(".class")) continue;
                ModLoader.addMod(loader, name);
            }
            ((InputStream)input).close();
        } else if (source.isDirectory()) {
            Package pkg = ModLoader.class.getPackage();
            if (pkg != null) {
                String pkgdir = pkg.getName().replace('.', File.separatorChar);
                source = new File(source, pkgdir);
            }
            logger.finer("Directory found.");
            File[] files = source.listFiles();
            if (files != null) {
                int i2 = 0;
                while (i2 < files.length) {
                    String name = files[i2].getName();
                    if (files[i2].isFile() && name.startsWith("mod_") && name.endsWith(".class")) {
                        ModLoader.addMod(loader, name);
                    }
                    ++i2;
                }
            }
        }
    }

    private static void readFromModFolder(File folder) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Object source;
        int file;
        ClassLoader loader = Minecraft.class.getClassLoader();
        Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURL.setAccessible(true);
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("folder must be a Directory.");
        }
        Object[] sourcefiles = folder.listFiles();
        Arrays.sort(sourcefiles);
        if (loader instanceof URLClassLoader) {
            file = 0;
            while (file < sourcefiles.length) {
                source = sourcefiles[file];
                if (((File)source).isDirectory() || ((File)source).isFile() && (((File)source).getName().endsWith(".jar") || ((File)source).getName().endsWith(".zip"))) {
                    addURL.invoke((Object)loader, ((File)source).toURI().toURL());
                }
                ++file;
            }
        }
        file = 0;
        while (file < sourcefiles.length) {
            source = sourcefiles[file];
            if (((File)source).isDirectory() || ((File)source).isFile() && (((File)source).getName().endsWith(".jar") || ((File)source).getName().endsWith(".zip"))) {
                String name;
                logger.finer("Adding mods from " + ((File)source).getCanonicalPath());
                if (((File)source).isFile()) {
                    logger.finer("Zip found.");
                    FileInputStream input = new FileInputStream((File)source);
                    ZipInputStream zip = new ZipInputStream(input);
                    ZipEntry entry = null;
                    while ((entry = zip.getNextEntry()) != null) {
                        name = entry.getName();
                        if (entry.isDirectory() || !name.startsWith("mod_") || !name.endsWith(".class")) continue;
                        ModLoader.addMod(loader, name);
                    }
                    zip.close();
                    ((InputStream)input).close();
                } else if (((File)source).isDirectory()) {
                    Package pkg = ModLoader.class.getPackage();
                    if (pkg != null) {
                        String pkgdir = pkg.getName().replace('.', File.separatorChar);
                        source = new File((File)source, pkgdir);
                    }
                    logger.finer("Directory found.");
                    File[] dirfiles = ((File)source).listFiles();
                    if (dirfiles != null) {
                        int j2 = 0;
                        while (j2 < dirfiles.length) {
                            name = dirfiles[j2].getName();
                            if (dirfiles[j2].isFile() && name.startsWith("mod_") && name.endsWith(".class")) {
                                ModLoader.addMod(loader, name);
                            }
                            ++j2;
                        }
                    }
                }
            }
            ++file;
        }
    }

    public static void receivePacket(ee packet) {
        BaseMod mod;
        if (packetChannels.containsKey(packet.a) && (mod = packetChannels.get(packet.a)) != null) {
            mod.receiveCustomPacket(packet);
        }
    }

    public static afu[] registerAllKeys(afu[] keys) {
        LinkedList<afu> combinedList = new LinkedList<afu>();
        combinedList.addAll(Arrays.asList(keys));
        for (Map<afu, boolean[]> keyMap : keyList.values()) {
            combinedList.addAll(keyMap.keySet());
        }
        return combinedList.toArray(new afu[0]);
    }

    public static void registerAllTextureOverrides(aaw cache) {
        animList.clear();
        Minecraft game = ModLoader.getMinecraftInstance();
        for (BaseMod baseMod : modList) {
            baseMod.registerAnimation(game);
        }
        for (tt tt2 : animList) {
            cache.a(tt2);
        }
        for (Map.Entry entry : overrides.entrySet()) {
            for (Map.Entry overlayEntry : ((Map)entry.getValue()).entrySet()) {
                String overlayPath = (String)overlayEntry.getKey();
                int index = (Integer)overlayEntry.getValue();
                int dst = (Integer)entry.getKey();
                try {
                    BufferedImage im2 = ModLoader.loadImage(cache, overlayPath);
                    ModTextureStatic anim = new ModTextureStatic(index, dst, im2);
                    cache.a(anim);
                }
                catch (Exception e2) {
                    logger.throwing("ModLoader", "RegisterAllTextureOverrides", e2);
                    ModLoader.throwException(e2);
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    public static void registerBlock(pb block) {
        ModLoader.registerBlock(block, null);
    }

    public static void registerBlock(pb block, Class<? extends vd> itemclass) {
        try {
            if (block == null) {
                throw new IllegalArgumentException("block parameter cannot be null.");
            }
            int id2 = block.bO;
            vd item = null;
            item = itemclass != null ? itemclass.getConstructor(Integer.TYPE).newInstance(id2 - 256) : new vd(id2 - 256);
            if (pb.m[id2] != null && yr.e[id2] == null) {
                yr.e[id2] = item;
            }
        }
        catch (IllegalArgumentException e2) {
            logger.throwing("ModLoader", "RegisterBlock", e2);
            ModLoader.throwException(e2);
        }
        catch (IllegalAccessException e3) {
            logger.throwing("ModLoader", "RegisterBlock", e3);
            ModLoader.throwException(e3);
        }
        catch (SecurityException e4) {
            logger.throwing("ModLoader", "RegisterBlock", e4);
            ModLoader.throwException(e4);
        }
        catch (InstantiationException e5) {
            logger.throwing("ModLoader", "RegisterBlock", e5);
            ModLoader.throwException(e5);
        }
        catch (InvocationTargetException e6) {
            logger.throwing("ModLoader", "RegisterBlock", e6);
            ModLoader.throwException(e6);
        }
        catch (NoSuchMethodException e7) {
            logger.throwing("ModLoader", "RegisterBlock", e7);
            ModLoader.throwException(e7);
        }
    }

    public static void registerEntityID(Class<? extends nn> entityClass, String entityName, int id2) {
        try {
            method_RegisterEntityID.invoke(null, entityClass, entityName, id2);
        }
        catch (IllegalArgumentException e2) {
            logger.throwing("ModLoader", "RegisterEntityID", e2);
            ModLoader.throwException(e2);
        }
        catch (IllegalAccessException e3) {
            logger.throwing("ModLoader", "RegisterEntityID", e3);
            ModLoader.throwException(e3);
        }
        catch (InvocationTargetException e4) {
            logger.throwing("ModLoader", "RegisterEntityID", e4);
            ModLoader.throwException(e4);
        }
    }

    public static void registerEntityID(Class<? extends nn> entityClass, String entityName, int id2, int background, int foreground) {
        ModLoader.registerEntityID(entityClass, entityName, id2);
        aao.a.put(id2, new hr(id2, background, foreground));
    }

    public static void registerKey(BaseMod mod, afu keyHandler, boolean allowRepeat) {
        Map<afu, boolean[]> keyMap = keyList.get(mod);
        if (keyMap == null) {
            keyMap = new HashMap<afu, boolean[]>();
        }
        boolean[] blArray = new boolean[2];
        blArray[0] = allowRepeat;
        keyMap.put(keyHandler, blArray);
        keyList.put(mod, keyMap);
    }

    public static void registerPacketChannel(BaseMod mod, String channel) {
        if (channel.length() >= 16) {
            throw new RuntimeException(String.format("Invalid channel name: %s. Must be less than 16 characters.", channel));
        }
        packetChannels.put(channel, mod);
    }

    public static void registerTileEntity(Class<? extends kw> tileEntityClass, String id2) {
        ModLoader.registerTileEntity(tileEntityClass, id2, null);
    }

    public static void registerTileEntity(Class<? extends kw> tileEntityClass, String id2, aar renderer) {
        try {
            method_RegisterTileEntity.invoke(null, tileEntityClass, id2);
            if (renderer != null) {
                ach ref = ach.a;
                Map renderers = (Map)field_TileEntityRenderers.get(ref);
                renderers.put(tileEntityClass, renderer);
                renderer.a(ref);
            }
        }
        catch (IllegalArgumentException e2) {
            logger.throwing("ModLoader", "RegisterTileEntity", e2);
            ModLoader.throwException(e2);
        }
        catch (IllegalAccessException e3) {
            logger.throwing("ModLoader", "RegisterTileEntity", e3);
            ModLoader.throwException(e3);
        }
        catch (InvocationTargetException e4) {
            logger.throwing("ModLoader", "RegisterTileEntity", e4);
            ModLoader.throwException(e4);
        }
    }

    public static void removeBiome(abn biome) {
        abn[] existingBiomes = ahy.biomeArray;
        List<abn> existingBiomeList = Arrays.asList(existingBiomes);
        ArrayList<abn> combinedList = new ArrayList<abn>();
        combinedList.addAll(existingBiomeList);
        if (combinedList.contains(biome)) {
            combinedList.remove(biome);
        }
        ahy.biomeArray = combinedList.toArray(new abn[0]);
    }

    public static void removeSpawn(Class<? extends acq> entityClass, acf spawnList) {
        ModLoader.removeSpawn(entityClass, spawnList, null);
    }

    public static void removeSpawn(Class<? extends acq> entityClass, acf spawnList, abn ... biomes) {
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass cannot be null");
        }
        if (spawnList == null) {
            throw new IllegalArgumentException("spawnList cannot be null");
        }
        if (biomes == null) {
            biomes = standardBiomes;
        }
        int i2 = 0;
        while (i2 < biomes.length) {
            List list = biomes[i2].a(spawnList);
            if (list != null) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    bg entry = (bg)iter.next();
                    if (entry.a != entityClass) continue;
                    iter.remove();
                }
            }
            ++i2;
        }
    }

    public static void removeSpawn(String entityName, acf spawnList) {
        ModLoader.removeSpawn(entityName, spawnList, null);
    }

    public static void removeSpawn(String entityName, acf spawnList, abn ... biomes) {
        Class<? extends nn> entityClass = classMap.get(entityName);
        if (entityClass != null && acq.class.isAssignableFrom(entityClass)) {
            ModLoader.removeSpawn(entityClass, spawnList, biomes);
        }
    }

    public static boolean renderBlockIsItemFull3D(int modelID) {
        if (!blockSpecialInv.containsKey(modelID)) {
            return modelID == 16;
        }
        return blockSpecialInv.get(modelID);
    }

    public static void renderInvBlock(vl renderer, pb block, int metadata, int modelID) {
        BaseMod mod = blockModels.get(modelID);
        if (mod == null) {
            return;
        }
        mod.renderInvBlock(renderer, block, metadata, modelID);
    }

    public static boolean renderWorldBlock(vl renderer, ali world, int x2, int y2, int z2, pb block, int modelID) {
        BaseMod mod = blockModels.get(modelID);
        if (mod == null) {
            return false;
        }
        return mod.renderWorldBlock(renderer, world, x2, y2, z2, block, modelID);
    }

    public static void saveConfig() throws IOException {
        cfgdir.mkdir();
        if (!cfgfile.exists() && !cfgfile.createNewFile()) {
            return;
        }
        if (cfgfile.canWrite()) {
            FileOutputStream out = new FileOutputStream(cfgfile);
            props.store(out, "ModLoader Config");
            ((OutputStream)out).close();
        }
    }

    public static void serverChat(String text) {
        for (BaseMod mod : modList) {
            mod.receiveChatPacket(text);
        }
    }

    public static void serverConnect(adl handler, aec loginPacket) {
        netHandler = handler;
        if (packetChannels.size() > 0) {
            ee packet = new ee();
            packet.a = "REGISTER";
            StringBuilder channels = new StringBuilder();
            Iterator<String> iter = packetChannels.keySet().iterator();
            channels.append(iter.next());
            while (iter.hasNext()) {
                channels.append("\u0000");
                channels.append(iter.next());
            }
            packet.c = channels.toString().getBytes(Charset.forName("UTF8"));
            packet.b = packet.c.length;
            ModLoader.sendPacket(packet);
        }
        for (BaseMod mod : modList) {
            mod.serverConnect(netHandler);
        }
    }

    public static void serverDisconnect() {
        for (BaseMod mod : modList) {
            mod.serverDisconnect();
        }
        netHandler = null;
    }

    public static void sendPacket(abs packet) {
        if (netHandler != null) {
            netHandler.c(packet);
        }
    }

    public static void setInGameHook(BaseMod mod, boolean enable, boolean useClock) {
        if (enable) {
            inGameHooks.put(mod, useClock);
        } else {
            inGameHooks.remove(mod);
        }
    }

    public static void setInGUIHook(BaseMod mod, boolean enable, boolean useClock) {
        if (enable) {
            inGUIHooks.put(mod, useClock);
        } else {
            inGUIHooks.remove(mod);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> instanceclass, T instance, int fieldindex, E value) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field f2 = instanceclass.getDeclaredFields()[fieldindex];
            f2.setAccessible(true);
            int modifiers = field_modifiers.getInt(f2);
            if ((modifiers & 0x10) != 0) {
                field_modifiers.setInt(f2, modifiers & 0xFFFFFFEF);
            }
            f2.set(instance, value);
        }
        catch (IllegalAccessException e2) {
            logger.throwing("ModLoader", "setPrivateValue", e2);
            ModLoader.throwException("An impossible error has occured!", e2);
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> instanceclass, T instance, String field, E value) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        try {
            Field f2 = instanceclass.getDeclaredField(field);
            int modifiers = field_modifiers.getInt(f2);
            if ((modifiers & 0x10) != 0) {
                field_modifiers.setInt(f2, modifiers & 0xFFFFFFEF);
            }
            f2.setAccessible(true);
            f2.set(instance, value);
        }
        catch (IllegalAccessException e2) {
            logger.throwing("ModLoader", "setPrivateValue", e2);
            ModLoader.throwException("An impossible error has occured!", e2);
        }
    }

    private static void setupProperties(Class<? extends BaseMod> mod) throws IllegalArgumentException, IllegalAccessException, IOException, SecurityException, NoSuchFieldException, NoSuchAlgorithmException, DigestException {
        LinkedList<Field> fieldList = new LinkedList<Field>();
        Properties modprops = new Properties();
        int currentHash = 0;
        int cfgHash = 0;
        File modcfgfile = new File(cfgdir, String.valueOf(mod.getSimpleName()) + ".cfg");
        if (modcfgfile.exists() && modcfgfile.canRead()) {
            modprops.load(new FileInputStream(modcfgfile));
        }
        if (modprops.containsKey("checksum")) {
            cfgHash = Integer.parseInt(modprops.getProperty("checksum"), 36);
        }
        Field[] fieldArray = mod.getDeclaredFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            if ((field.getModifiers() & 8) != 0 && field.isAnnotationPresent(MLProp.class)) {
                fieldList.add(field);
                Object currentvalue = field.get(null);
                currentHash += currentvalue.hashCode();
            }
            ++n3;
        }
        StringBuilder helptext = new StringBuilder();
        for (Field field : fieldList) {
            if ((field.getModifiers() & 8) == 0 || !field.isAnnotationPresent(MLProp.class)) continue;
            Class<Object> type = field.getType();
            MLProp annotation = field.getAnnotation(MLProp.class);
            String key = annotation.name().length() == 0 ? field.getName() : annotation.name();
            Object currentvalue = field.get(null);
            StringBuilder range = new StringBuilder();
            if (annotation.min() != Double.NEGATIVE_INFINITY) {
                range.append(String.format(",>=%.1f", annotation.min()));
            }
            if (annotation.max() != Double.POSITIVE_INFINITY) {
                range.append(String.format(",<=%.1f", annotation.max()));
            }
            StringBuilder info = new StringBuilder();
            if (annotation.info().length() > 0) {
                info.append(" -- ");
                info.append(annotation.info());
            }
            helptext.append(String.format("%s (%s:%s%s)%s\n", key, type.getName(), currentvalue, range, info));
            if (cfgHash == currentHash && modprops.containsKey(key)) {
                String strvalue = modprops.getProperty(key);
                Object value = null;
                if (type.isAssignableFrom(String.class)) {
                    value = strvalue;
                } else if (type.isAssignableFrom(Integer.TYPE)) {
                    value = Integer.parseInt(strvalue);
                } else if (type.isAssignableFrom(Short.TYPE)) {
                    value = Short.parseShort(strvalue);
                } else if (type.isAssignableFrom(Byte.TYPE)) {
                    value = Byte.parseByte(strvalue);
                } else if (type.isAssignableFrom(Boolean.TYPE)) {
                    value = Boolean.parseBoolean(strvalue);
                } else if (type.isAssignableFrom(Float.TYPE)) {
                    value = Float.valueOf(Float.parseFloat(strvalue));
                } else if (type.isAssignableFrom(Double.TYPE)) {
                    value = Double.parseDouble(strvalue);
                }
                if (value == null) continue;
                if (value instanceof Number) {
                    double num = ((Number)value).doubleValue();
                    if (annotation.min() != Double.NEGATIVE_INFINITY && num < annotation.min() || annotation.max() != Double.POSITIVE_INFINITY && num > annotation.max()) continue;
                }
                logger.finer(String.valueOf(key) + " set to " + value);
                if (value.equals(currentvalue)) continue;
                field.set(null, value);
                continue;
            }
            logger.finer(String.valueOf(key) + " not in config, using default: " + currentvalue);
            modprops.setProperty(key, currentvalue.toString());
        }
        modprops.put("checksum", Integer.toString(currentHash, 36));
        if (!modprops.isEmpty() && (modcfgfile.exists() || modcfgfile.createNewFile()) && modcfgfile.canWrite()) {
            modprops.store(new FileOutputStream(modcfgfile), helptext.toString());
        }
    }

    private static void sortModList() throws Exception {
        HashMap<String, BaseMod> loadedMods = new HashMap<String, BaseMod>();
        for (BaseMod mod : ModLoader.getLoadedMods()) {
            loadedMods.put(mod.getClass().getSimpleName(), mod);
        }
        LinkedList<BaseMod> newList = new LinkedList<BaseMod>();
        int pass = 0;
        while (newList.size() != modList.size()) {
            if (pass > 10) break;
            block2: for (BaseMod mod : modList) {
                if (newList.contains(mod)) continue;
                String priority = mod.getPriorities();
                if (priority == null || priority.length() == 0 || priority.indexOf(58) == -1) {
                    newList.add(mod);
                    continue;
                }
                if (pass <= 0) continue;
                int newIndex = -1;
                int max = Integer.MIN_VALUE;
                int min = Integer.MAX_VALUE;
                String[] rules = priority.indexOf(59) > 0 ? priority.split(";") : new String[]{priority};
                int i2 = 0;
                while (i2 < rules.length) {
                    String rule = rules[i2];
                    if (rule.indexOf(58) != -1) {
                        String[] keyValuePair = rule.split(":");
                        String key = keyValuePair[0];
                        String value = keyValuePair[1];
                        if (key.contentEquals("required-before") || key.contentEquals("before") || key.contentEquals("after") || key.contentEquals("required-after")) {
                            if (value.contentEquals("*")) {
                                if (key.contentEquals("required-before") || key.contentEquals("before")) {
                                    newIndex = 0;
                                    break;
                                }
                                if (!key.contentEquals("required-after") && !key.contentEquals("after")) break;
                                newIndex = newList.size();
                                break;
                            }
                            if ((key.contentEquals("required-before") || key.contentEquals("required-after")) && !loadedMods.containsKey(value)) {
                                throw new Exception(String.format("%s is missing dependency: %s", mod, value));
                            }
                            BaseMod mod2 = (BaseMod)loadedMods.get(value);
                            if (!newList.contains(mod2)) continue block2;
                            int index = newList.indexOf(mod2);
                            if (key.contentEquals("required-before") || key.contentEquals("before")) {
                                newIndex = index;
                                if (newIndex < min) {
                                    min = newIndex;
                                } else {
                                    newIndex = min;
                                }
                            } else if (key.contentEquals("required-after") || key.contentEquals("after")) {
                                newIndex = index + 1;
                                if (newIndex > max) {
                                    max = newIndex;
                                } else {
                                    newIndex = max;
                                }
                            }
                        }
                    }
                    ++i2;
                }
                if (newIndex == -1) continue;
                newList.add(newIndex, mod);
            }
            ++pass;
        }
        modList.clear();
        modList.addAll(newList);
    }

    public static void takenFromCrafting(yw player, aan item, io matrix) {
        for (BaseMod mod : modList) {
            mod.takenFromCrafting(player, item, matrix);
        }
    }

    public static void takenFromFurnace(yw player, aan item) {
        for (BaseMod mod : modList) {
            mod.takenFromFurnace(player, item);
        }
    }

    public static void throwException(String message, Throwable e2) {
        Minecraft game = ModLoader.getMinecraftInstance();
        if (game == null) {
            throw new RuntimeException(e2);
        }
        game.a(new ja(message, e2));
    }

    private static void throwException(Throwable e2) {
        ModLoader.throwException("Exception occured in ModLoader", e2);
    }

    private ModLoader() {
    }
}

