/*
 * Decompiled with CFR 0.152.
 */
package ee;

import ee.EEBase;
import forge.Configuration;
import forge.Property;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;

public class EEConfigurationManager {
    public static final String GUI_ID = "guiId";
    public static final String ITEM_ID = "itemId";
    public static final String BLOCK_ID = "blockId";
    public static final String MACHINE_SPEED = "machineSpeed";
    public static final String ENABLED = "enabled";
    public static final String OP_ONLY = "opOnly";
    public static final String OWNER_LOCKED = "ownerLocked";
    public static final String GENERAL_SETTING = "general";
    public static final String AUTO_RESOLVE_IDS = "autoResolveIds";
    public static final String USE_ADV_PERMISSIONS = "advancedPermissions";
    private String configFilename;
    private static HashMap configMap;
    private static HashMap keybindMap;

    public EEConfigurationManager(String configFilename) {
        this.configFilename = "config/ee2/" + configFilename;
        configMap = new HashMap();
        keybindMap = new HashMap();
    }

    public void initialize() {
        Configuration config;
        try {
            File configFile = new File(Minecraft.b(), this.configFilename);
            config = new Configuration(configFile);
            config.load();
        }
        catch (Exception e) {
            config = null;
        }
        if (config != null) {
            Boolean autoResolveIds = false;
            Property prop = config.getOrCreateBooleanProperty("general.blockIds.autoResolve", GENERAL_SETTING, false);
            prop.comment = "Determines whether or not to auto resolve block id conflicts affecting EE block ids";
            EEConfigurationManager.getOrSetBooleanConfigProperty(GENERAL_SETTING, AUTO_RESOLVE_IDS, Boolean.parseBoolean(prop.value));
            if (Boolean.parseBoolean(prop.value)) {
                prop.value = "false";
            }
            prop = config.getOrCreateBooleanProperty("general.configuration.useAdvancedPermissions", GENERAL_SETTING, false);
            prop.comment = "Whether or not to use advanced item permissions (per item/function permission)";
            EEConfigurationManager.getOrSetBooleanConfigProperty(GENERAL_SETTING, USE_ADV_PERMISSIONS, Boolean.parseBoolean(prop.value));
            prop = config.getOrCreateBlockIdProperty("BlockEEStone", 175);
            EEConfigurationManager.getOrSetIntConfigProperty("BlockEEStone", BLOCK_ID, Integer.parseInt(prop.value));
            prop = config.getOrCreateBlockIdProperty("BlockEEPedestal", 176);
            EEConfigurationManager.getOrSetIntConfigProperty("BlockEEPedestal", BLOCK_ID, Integer.parseInt(prop.value));
            prop = config.getOrCreateBlockIdProperty("BlockEEChest", 177);
            EEConfigurationManager.getOrSetIntConfigProperty("BlockEEChest", BLOCK_ID, Integer.parseInt(prop.value));
            prop = config.getOrCreateBlockIdProperty("BlockEETorch", 178);
            EEConfigurationManager.getOrSetIntConfigProperty("BlockEETorch", BLOCK_ID, Integer.parseInt(prop.value));
            prop = config.getOrCreateBlockIdProperty("BlockEEDevice", 179);
            EEConfigurationManager.getOrSetIntConfigProperty("BlockEEDevice", BLOCK_ID, Integer.parseInt(prop.value));
            prop = config.getOrCreateBooleanProperty("machine.collector.mk1.enabled", GENERAL_SETTING, true);
            prop.comment = "Determines if Collector Mk1's are enabled";
            EEConfigurationManager.getOrSetBooleanConfigProperty("collector1", ENABLED, Boolean.parseBoolean(prop.value));
            prop = config.getOrCreateIntProperty("machine.collector.mk1.guiId", GENERAL_SETTING, 47);
            prop.comment = "GUI ID for Collector Mk1's";
            EEConfigurationManager.getOrSetIntConfigProperty("collector1", GUI_ID, Integer.parseInt(prop.value));
            prop = config.getOrCreateIntProperty("machine.collector.mk1.machineSpeed", GENERAL_SETTING, 16);
            prop.comment = "Determines the speed, as a percentage, of Collector Mk1's";
            EEConfigurationManager.getOrSetIntConfigProperty("collector1", MACHINE_SPEED, Integer.parseInt(prop.value));
            prop = config.getOrCreateBooleanProperty("machine.collector.mk1.opOnly", GENERAL_SETTING, false);
            prop.comment = "Determines if Collector Mk1's are only usable by OPs";
            EEConfigurationManager.getOrSetBooleanConfigProperty("collector1", OP_ONLY, Boolean.parseBoolean(prop.value));
            prop = config.getOrCreateBooleanProperty("machine.collector.mk1.ownerLocked", GENERAL_SETTING, false);
            prop.comment = "Determines if Collector Mk1's are locked to their owner only";
            EEConfigurationManager.getOrSetBooleanConfigProperty("collector1", OWNER_LOCKED, Boolean.parseBoolean(prop.value));
            prop = config.getOrCreateBooleanProperty("machine.collector.mk2.enabled", GENERAL_SETTING, true);
            prop.comment = "Determines if Collector Mk2's are enabled";
            prop = config.getOrCreateIntProperty("machine.collector.mk2.guiId", GENERAL_SETTING, 48);
            prop.comment = "GUI ID for Collector Mk2's";
            prop = config.getOrCreateIntProperty("machine.collector.mk2.machineSpeed", GENERAL_SETTING, 1);
            prop.comment = "Determines the speed, as a percentage, of Collector Mk2's";
            prop = config.getOrCreateBooleanProperty("machine.collector.mk2.opOnly", GENERAL_SETTING, false);
            prop.comment = "Determines if Collector Mk2's are only usable by OPs";
            prop = config.getOrCreateBooleanProperty("machine.collector.mk2.ownerLocked", GENERAL_SETTING, false);
            prop.comment = "Determines if Collector Mk2's are locked to their owner only";
            prop = config.getOrCreateBooleanProperty("machine.collector.mk3.enabled", GENERAL_SETTING, true);
            prop.comment = "Determines if Collector Mk3's are enabled";
            prop = config.getOrCreateIntProperty("machine.collector.mk3.guiId", GENERAL_SETTING, 49);
            prop.comment = "GUI ID for Collector Mk3's";
            prop = config.getOrCreateIntProperty("machine.collector.mk3.machineSpeed", GENERAL_SETTING, 1);
            prop.comment = "Determines the speed, as a percentage, of Collector Mk3's";
            prop = config.getOrCreateBooleanProperty("machine.collector.mk3.opOnly", GENERAL_SETTING, false);
            prop.comment = "Determines if Collector Mk3's are only usable by OPs";
            prop = config.getOrCreateBooleanProperty("machine.collector.mk3.ownerLocked", GENERAL_SETTING, false);
            prop.comment = "Determines if Collector Mk3's are locked to their owner only";
            config.save();
        }
    }

    public void printConfigMap() {
        Set keySet = configMap.entrySet();
        Iterator iter1 = keySet.iterator();
        System.out.println();
        System.out.println("EE Configuration Manager Mappings");
        while (iter1.hasNext()) {
            Map.Entry keyMap = iter1.next();
            String key = (String)keyMap.getKey();
            HashMap propMap = (HashMap)configMap.get(key);
            Set propSet = propMap.entrySet();
            for (Map.Entry propMapSet : propSet) {
                String property = (String)propMapSet.getKey();
                String value = (String)propMapSet.getValue();
                System.out.println("[" + key + "," + property + "," + value + "]");
            }
        }
        System.out.println();
    }

    public void printPropertyMapForKey(String key) {
        HashMap propMap = (HashMap)configMap.get(key);
        if (propMap == null) {
            return;
        }
        Set propSet = propMap.entrySet();
        Iterator iter1 = propSet.iterator();
        System.out.println();
        System.out.println("EE Configuration Property Mappings For: " + key);
        while (iter1.hasNext()) {
            Map.Entry propMapSet = iter1.next();
            String property = (String)propMapSet.getKey();
            String value = (String)propMapSet.getValue();
            System.out.println("[" + key + "," + property + "," + value + "]");
        }
        System.out.println();
    }

    public void printValueMapForProperty(String propertyKey) {
        Set keySet = configMap.entrySet();
        Iterator iter1 = keySet.iterator();
        HashMap<Integer, String> hm = new HashMap<Integer, String>();
        int count = 0;
        while (iter1.hasNext()) {
            Map.Entry keyMap = iter1.next();
            String key = (String)keyMap.getKey();
            HashMap propMap = (HashMap)configMap.get(key);
            Set propSet = propMap.entrySet();
            for (Map.Entry propMapSet : propSet) {
                String property = (String)propMapSet.getKey();
                String value = (String)propMapSet.getValue();
                if (!propertyKey.equals(property)) continue;
                hm.put(count, "[" + key + "," + property + "," + value + "]");
                ++count;
            }
        }
        System.out.println();
        System.out.println("EE Configuration Value Mappings For: " + propertyKey);
        for (int i = 0; i < count; ++i) {
            System.out.println(hm.get(i));
        }
        System.out.println();
    }

    private static boolean getOrSetBooleanConfigProperty(String key, String property, boolean value) {
        return Boolean.parseBoolean(EEConfigurationManager.getOrSetConfigProperty(key, property, Boolean.toString(value)));
    }

    private static int getOrSetIntConfigProperty(String key, String property, int value) {
        return Integer.parseInt(EEConfigurationManager.getOrSetConfigProperty(key, property, Integer.toString(value)));
    }

    private static int generateNewBlockId(int id) {
        if (pb.m[id] != null) {
            for (int i = 130; i < pb.m.length; ++i) {
                if (pb.m[i] != null) continue;
                return i;
            }
        }
        return id;
    }

    public static int getBlockId(String blockName) {
        return Integer.parseInt(EEConfigurationManager.getConfigPropertyValue(blockName, BLOCK_ID));
    }

    public static Float getMachineSpeed(String machineName) {
        return Float.valueOf((float)EEBase.getMachineFactor() / 16.0f);
    }

    public static String getConfigPropertyValue(String key, String property) {
        HashMap propMap;
        if (configMap.containsKey(key) && (propMap = (HashMap)configMap.get(key)).containsKey(property)) {
            return (String)propMap.get(property);
        }
        return null;
    }

    public static String getOrSetConfigProperty(String key, String property, String value) {
        if (configMap.containsKey(key)) {
            HashMap propMap = (HashMap)configMap.get(key);
            if (propMap.containsKey(property)) {
                return (String)propMap.get(property);
            }
            propMap.put(property, value);
            configMap.put(key, propMap);
            return value;
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put(property, value);
        configMap.put(key, propMap);
        return value;
    }
}

