#README:
#   **Currently takes REALLY REALLY long, working on optimizations
#   1. Install python compiler 'pypy' for fastest execution
#   2. Run 'pypy scheduler.py' in the /game directory in terminal
#   3. Creates dead_end0 file in ladykiller game (root) dir w/ dead end routes (Overwrites EACH time scheduler is run)


#Multiprocessing:   split into 6 pools, 1 does all routes starting w/ n1a1->sw1ph1, 2 does all starting w/ n1a1->by1, etc etc etc                   
#   Estimates: 185949421056 upper bound possible total permutations (based on maxing out # of avail scenes)
#           / ~680000 routes per second w/ pypy (~145000 w/ python)
#           = 3.16 days per full execution (w/o any multiprocessing)
#               multiprocessing w/ 6 processes = bit over half a day for full execution

#Routes calculated per second before using actual scene data: 783611
import os
import sys
import math
import time
import copy
import multiprocessing
from multiprocessing import Pool, Value
from multiprocessing.dummy import Pool as ThreadPool

class Finished(Exception): pass

class store:
    all_scenes = []
    day = 0
    period = ""
    characters = {}

class Person:
    def __init__(self):
        self.named = False

i = [0, 0, 0, 0, 0, 0]

started = False

scenes = []

scene_unlocks = {
            'n1a1': 'a2 pr3n2',
            'a2': 'a3',
            'a3': 'a4',
            'a4': 'a5',
            'a5': '',
            'pr3n2': ['pr4 n3', ''],
            'pr4': '',
            'n3': 'n4',
            'n4': ['n5', ''],
            'n5': '',
            'be1': 'pr1 be2',
            'be2': 'be3',
            'be3': 'be4',
            'be4': 'be5',
            'be5': 'be6',
            'be6': '',
            'pr1': ['pr2', ''],
            'pr2': ['pr3n2', ''],
            'sw1ph1': ['sw2', 'ph2', 'sw2 ph2'],
            'sw2': ['sw3', ''],
            'sw3': 'sw4',
            'sw4': ['sw5', ''],
            'sw5': '',
            'ph2': 'ph3',
            'ph3': 'ph4',
            'ph4': 'ph5',
            'ph5': '',
            'st1': 'st2',
            'st2': 'st3',
            'st3': 'st4',
            'st4': 'st5',
            'st5': 'st6',
            'st6': '',
            'by1': 'by2',
            'by2': 'by3',
            'by3': 'by4',
            'by4': 'by5',
            'by5': ''
}

scene_names = {
            'Nerd1': 'n1',
            'Athlete1': 'a2',
            'Athlete2': 'a3',
            'Athlete3': 'a4',
            'Athlete4': 'a5',
            'Athlete5': '',
            'President3': 'pr4',
            'Nerd2': 'n3',  
            'President4': 'pr5',
            'Nerd3': 'n4',
            'Nerd4': 'n5',
            'Nerd5': '',
            'Beauty1': 'be2',
            'Beauty2': 'be3',
            'Beauty3': 'be4',
            'Beauty4': 'be5',
            'Beauty5': 'be6',
            'Beauty6': '',
            'President1': 'pr2',
            'President2': 'pr3n2',
            'Swimmer1': 'sw2',
            'Photographer1': 'ph2' ,
            'Swimmer2': 'sw3',
            'Swimmer3': 'sw4',
            'Swimmer4': 'sw5',
            'Swimmer5': '',
            'Photographer2': 'ph3',
            'Photographer3': 'ph4',
            'Photographer4': 'ph5',
            'Photographer5': '',
            'Stalker1': 'st2',
            'Stalker2': 'st3',
            'Stalker3': 'st4',
            'Stalker4': 'st5',
            'Stalker5': 'st6',
            'Stalker6': '',
            'Boy1': 'by2',
            'Boy2': 'by3',
            'Boy3': 'by4',
            'Boy4': 'by5', 
            'Boy5': '' 
}

scene_objects = {}

dead_ends = [0,0,0,0,0,0]

outcomes = []

path = []

mark = 0.0

#FAKED FOR NOW
sw4_seduced = True
be4_climaxed = True
be4_molesther = True

def seen(scene_id):
    #REWORK
    if scene_id == 'XPhotographer1' or 'XStalker1' or 'XBoy1':
        return False
    return scene_names[scene_id] in path

def cleared(scene_id):
    #REWORK
    if scene_id == 'XPhotographer1' or 'XStalker1' or 'XBoy1':
        return False
    outcome_scene = scene_names[scene_id]
    if outcome_scene == '': #Should never happen
        return
    return outcome_scene in outcomes

def char(index):
    return store.characters[index]

def night_route():
    stalker = 0
    beauty = 0

    for i in store.finished_scenes:
        if "Stalker" in i:
            stalker += 1
        elif "Beauty" in i:
            beauty += 1

    if beauty >= 2:
        if stalker >= 2:
            return "ladykiller"
        else:
            return "beauty"
    else:
        if beauty > stalker:
            return "beauty"
        elif beauty == stalker:
            return "ladykiller"
        else:
            return "stalker"

def import_scenes():
    global scenes
    chunk = ""
    classes = ""
    init = ""

    #Read scenes.rpy
    with open('{0}/{1}'.format(os.path.dirname(os.path.abspath(sys.argv[0])), "scenes.rpy"), "r") as scenefile:
        scene_raw = scenefile.readlines()
        
    for line in scene_raw:
        if "init python:" in line:
            chunk = "classes"
            classes = "def class_init():\n"
        elif "label init_scenes:" in line:
            chunk = "init"
            #init = "def init_scenes():\n"
        elif chunk == "classes":
            if "im." in line or "renpy." in line:
                line = "            pass\n"
            classes += line
        elif chunk == "init":
            if "return" not in line:
                init += "    " + line.translate(None, '$ ')
    scene_raw = classes + "\n" + init
    exec scene_raw
    class_init()

    chars = store.characters
    chars["Swimmer"] = Person()
    chars["Photographer"] = Person()
    chars["Nerd"] = Person()
    chars["Athlete"] = Person()
    chars["Boy"] = Person()
    chars["Stalker"] = Person()

    build_objects()

def build_objects():
    for scene in scene_unlocks:
        lookup = scene
        if scene == 'n1a1': lookup = 'n1'
        elif scene == 'sw1ph1': lookup = 'sw1'
        elif scene == 'pr3n2': lookup = 'pr3'
        scene_object = filter(lambda s: s.identifier.lower() + str(s.scene_number) == lookup, store.all_scenes)[0]
        scene_objects[scene] = scene_object

def PlayGame(instance = 0, target = [], pool = ['n1a1', 'be1', 'st1', 'sw1ph1', 'by1'], choice = "start", t = 1, path_so_far = [], named = []):
    global i
    global store
    global outcomes
    global path
    global mark
    #old_store = copy.deepcopy(store) 
    #store = copy.deepcopy(new_store) 

    #if time.time() - mark >= 10 and time.time() - mark < 10.01:
    #    raise Finished

    #Multiprocessing stuff
    if path_so_far == target:
        raise Finished
 
    if t > 17:
        #Week over, game ends (selection was possible for last choice point 17)
        i[instance - 1] += 1
        #i[instance] += 1
        #print(i[instance])
        return
    
    #Determine day & ToD
    tod = ""
    day = 1.0
    day = math.ceil(float(t) / 3)
    remainder = (t) % 3
    if remainder is 1:
        tod = "AFTERNOON"
    elif remainder is 2:
        tod = "EVENING"
    elif remainder is 0:
        tod = "NIGHT"

    #populate named characters
    if choice is not 'start' and choice is not 'pm':
        choice_named = scene_objects[choice].named_chars
        for name in choice_named:
            if name not in named:
                named.append(name)

    #Set store variables
    store.day = day
    store.period = tod
    for c in store.characters:
        store.characters[c].named = False
    for n in named: store.characters[n].named = True
    
    #Fork selection path
    forks = []
    if choice == "start":
        #Initial possibility space is just the starting pool 
        forks.append(pool)
    elif choice == "pm": 
        path_so_far = path_so_far + ["pm"]
        forks.append(pool)
            #print(choice, instance, tod, pool)
    else:
       #Append path w/ choice & get possible outcomes from choice 
        path_so_far = path_so_far + [choice]
        new_choices = OptionsForChoice(choice)
        for permutation in new_choices:
            valid_permutations = []
            for option in permutation:
                if option is '':
                    forks.append(pool)
                elif option not in path_so_far and option not in pool:
                    valid_permutations.append(option)
            if valid_permutations:
                forks.append(valid_permutations + pool)
    #Set scenes in choice pool & prev path as unlocked (this is shit)
    for s in scene_objects:
        scene_objects[s].unlocked = False
    for s in pool:
        scene_objects[s].unlocked = True
    for s in path_so_far:
        if s is not 'pm':
            scene_objects[s].unlocked = True
    
    for fork in forks:
        invalid_choices = []
        if tod == "NIGHT" and "be1" in path_so_far:
            new_pool = [] + fork
            #print('->'.join(path_so_far),instance, t, store.day, store.period, 'st1', new_pool)
            PlayGame(instance, target, new_pool, 'pm', t + 1, path_so_far, named)
        else:
            for select in fork:
                #Set global info for func calls inside prerequisites() [seen, cleared, etc]
                path = path_so_far
                outcomes = []
                outcomes.extend(path_so_far)
                outcomes.extend(pool)
                store.day = day
                store.period = tod
                #Get the scene.all_files instance of selection
                scene_object = scene_objects[select]
                scene_object.unlocked = True
                if tod == 'NIGHT' and 'be' not in select and 'st' not in select:
                    invalid_choices.append(select)
                elif scene_object.prerequisites():
                    new_pool = [] + fork
                    #print('->'.join(path_so_far),instance, t, store.day, store.period, select, new_pool)
                    new_pool.pop(new_pool.index(select))
                    PlayGame(instance, target, new_pool, select, t + 1, path_so_far, named)
                else: invalid_choices.append(select)
                #If all scenes in fork are invalid, it's a dead end
                if len(invalid_choices) == len(fork) and t < 18:
                    global dead_ends
                    dead_ends[instance - 1] = dead_ends[instance - 1] + 1
                    dead_end = 'Path: {0} |Time: {1} |Day: {2} |Period: {3} |Unlocked: {4}\n'.format('->'.join(path_so_far), t, store.day, store.period, fork)
                    print(dead_end)
                    with open('{0}/../{1}'.format(os.path.dirname(os.path.abspath(sys.argv[0])), "dead_ends{}.txt".format(instance)), "a") as logfile:
                        logfile.write(dead_end)
            #store = old_store

#Returns list of possible outcomes from playing scene_name
def OptionsForChoice(scene_name):
    #Returns list of strings contained in the choice_string
    def ParseNewChoices(choice_string):
        permutation = choice_string.split(' ')
        return permutation 
    permutations = []
    new_scenes = scene_unlocks[scene_name]
    if type(new_scenes) is list:
        permutations = map(ParseNewChoices, new_scenes)
    else:
        permutations = [ParseNewChoices(new_scenes)]
    return permutations


#Multiprocessing handler
def MultiGame(instance):
    global i
    global mark
    global dead_ends
    #Clear dead end log file 
    with open('{0}/../{1}'.format(os.path.dirname(os.path.abspath(sys.argv[0])), "dead_ends{0}.txt".format(instance)), "a") as logfile:
        logfile.truncate(0)

    pool = ['n1a1', 'be1', 'st1', 'sw1ph1', 'by1']
    target = []
    t = 0
    if instance == 1:
        pool = ['n1a1', 'sw1ph1', 'by1', 'be1', 'st1']
        target = ['sw1ph1']
        #target = ['n1a1', 'sw1ph1']
    #if instance == 2:
    #    pool = ['n1a1', 'by1', 'sw1ph1', 'be1', 'st1']  
    #    target = ['n1a1', 'by1']    #Currently just dupes instance 1 results, needs to start at n1a1->sw1ph1?
    if instance == 2:
        pool = ['sw1ph1', 'by1', 'n1a1', 'be1', 'st1']
        target = ['by1']
        #target = ['sw1ph1', 'n1a1']
    #if instance == 4:
    #    pool = ['sw1ph1', 'by1', 'n1a1', 'be1', 'st1']
    #    target = ['sw1ph1', 'by1']  #Dupes instance 3 results
    if instance == 3:#5:
        pool = ['by1', 'n1a1', 'sw1ph1', 'be1', 'st1']
        target = ['n1a1']
        #target = ['by1', 'na1']
    #if instance == 6:
    #    pool = ['by1', 'sw1ph1', 'n1a1', 'be1', 'st1']
    #    target = ['by1', 'sw1ph1']  #Dupes instance 5 results
    try:
        PlayGame(instance, target, pool)
    except Finished:
        print("Thread {0} complete: {1} paths ({2}/s)".format(instance, i[instance - 1], i[instance - 1] / (time.time() - mark)))
        with open('{0}/../{1}'.format(os.path.dirname(os.path.abspath(sys.argv[0])), "dead_ends{0}.txt".format(instance)), "a") as logfile:
            logfile.write('Finished in {0} seconds ({1} /s) w/ {2} dead ends out of {3} paths'.format(time.time() - mark, i[instance - 1] / (time.time() - mark), dead_ends[instance - 1], i[instance - 1]))
        return

#pool = ThreadPool(6)
#results = pool.map(MultiGame, [1,2,3,4,5,6])
#pool.close()
#pool.join()


try:
    mark = time.time()
    import_scenes()
    p = multiprocessing.Pool()
    p.map(MultiGame,[1,2,3])
    #PlayGame()#new_store = copy.deepcopy(store))
except KeyboardInterrupt:
    p.terminate()
    p.join()
    delta = time.time() - mark
    print('')
    print(i[0] / delta) #Prints complete routes calculated per second on ctrl+c