;BEGIN FRAGMENT CODE - Do not edit anything between this and the end comment
;NEXT FRAGMENT INDEX 4
Scriptname zaddradiantmasterscript Extends Quest Hidden

;BEGIN FRAGMENT Fragment_3
Function Fragment_3()
;BEGIN CODE
SetObjectiveDisplayed(100)
BeginSummonCountdown()
;END CODE
EndFunction
;END FRAGMENT

;BEGIN FRAGMENT Fragment_2
Function Fragment_2()
;BEGIN CODE
StartupTrapCapture()
;END CODE
EndFunction
;END FRAGMENT

;BEGIN FRAGMENT Fragment_1
Function Fragment_1()
;BEGIN CODE
StartupSleepCapture()
;END CODE
EndFunction
;END FRAGMENT

;END FRAGMENT CODE - Do not edit anything between this and the begin comment

;===============================================================================
;                             Radiant Master
;===============================================================================

; Libs
zadLibs Property libs Auto
zadConfig Property Config Auto
SexLabFramework property SexLab auto
slaUtilScr Property Aroused Auto
zadBQ00 Property BeltQuest Auto
zaddRadiantMasterTasks Property Tasks Auto

; Quest Setting Variables
LocationAlias Property MasterHome Auto
ReferenceAlias Property Master Auto
ReferenceAlias Property KeyContainer Auto
Bool Property IsWealthy Auto
Bool Property IsMerchant Auto

; Scenes
;Scene Property MasterGreetSummonedSlave Auto

; Quest Flow Variables
float Property Compliance Auto
float Property Disposition Auto
float Property NextSummonTime Auto
float Property TimeSummonIssued Auto
int Property SummonType Auto   ; The summon we're using for this cycle

zaddRadiantMasterBaseTask Property CurrentTask Auto
zaddRadiantMasterBaseTask[] Property TaskPool Auto

; Etc
LocationRefType Property TGRWealthyHomeChest Auto
LocationRefType Property TGRSLStrongbox Auto

; Quest Objective ID's
int qoAwaitSummons = 100
int qoMasterSummons = 300
int qoPerformTask = 500
int qoReturnPostTask = 699
int qoEscapeBelt = 700


int NumSummonTypes = 2 ; Number of available summons

;==================================================
; 
;==================================================
Function Maintenance()
	libs.Log("Radiant Master is performing maintenance.")
	if SummonType
		libs.Log("Resuming summon sequence.")
		QueueHeartbeat(config.rmSummonHeartbeatInterval)
	else
		QueueHeartbeat(config.rmHeartbeatInterval)
	EndIf
EndFunction

;==================================================
; Quest Setup Functions
;==================================================
bool Function SanityCheck()
	libs.Log("Radiant Master SanityCheck()")
	if MasterHome == none
		libs.Error("Master home not set.")
		Stop()
		return false
	EndIf
	if Master == none
		libs.Error("Master not set.")
		Stop()
		return false
	EndIf
	if KeyContainer == none
		libs.Error("Key Container not set.")
		Stop()
		return false
	EndIf
	return true
EndFunction


Function SetupQuest()
	; Initialize variables
	SummonType = -1
	TaskPool = new zaddRadiantMasterBaseTask[1]
	TaskPool[0] = Tasks.Task001
	; Setup personality
	if MasterHome.GetLocation().HasRefType(TGRWealthyHomeChest)
		libs.Log("Master is wealthy.")
		IsWealthy = true
	EndIf
	if MasterHome.GetLocation().HasRefType(TGRSLStrongbox)
		libs.Log("Master is a merchant.")
		IsMerchant = true
	EndIf
EndFunction

;==================================================
; Capture Functions
;==================================================
Function StartupSleepCapture()
	libs.Log("StartupSleepCapture")
	if !SanityCheck()
		return
	EndIf
	SetupQuest()
	libs.NotifyPlayer("Captured by sleeping in an unsafe location placeholder.",1)
	SetStage(100)
EndFunction


Function StartupTrapCapture()
	libs.Log("StartupTrapCapture")
	if !SanityCheck()
		return
	EndIf
	SetupQuest()
	libs.NotifyPlayer("Captured by a trap Placeholder.",1)
	SetStage(100)
EndFunction


;==================================================
; Summon Functions
;==================================================
Function QueueHeartbeat(float offset)
	RegisterForSingleUpdateGameTime(offset)
EndFunction


Function IssueSummon()
	SetObjectiveCompleted(qoAwaitSummons, true)
	SetObjectiveCompleted(qoMasterSummons, false)
	SetObjectiveDisplayed(qoMasterSummons, true)
	NextSummonTime = 0.0
	TimeSummonIssued = Utility.GetCurrentGameTime()
	if SummonType < 0
		SummonType = Utility.RandomInt(0, NumSummonTypes - 1)
	EndIf
EndFunction


Function BeginSummonCountdown()
	libs.Log("BeginSummonCountdown("+Utility.GameTimeToString(TimeSummonIssued)+")")
	SetObjectiveCompleted(qoAwaitSummons, false)
	SetObjectiveDisplayed(qoAwaitSummons, true)
	NextSummonTime = Utility.GetCurrentGameTime()
	QueueHeartbeat(config.rmHeartbeatInterval)
EndFunction


Function SummonPlayerEvent()
	if SummonType == 0
		libs.Log("Playing Shock Summon")
		libs.NotifyPlayer("Shock Summon")
	ElseIf SummonType == 1
		; Vibrator Summon
		libs.Log("Playing Vibrator Summon")
		libs.NotifyPlayer("Vibrator Summon")
	EndIf
	QueueHeartbeat(config.rmSummonHeartbeatInterval)
EndFunction


Event OnUpdateGameTime()
	libs.Log("RM OnUpdateGameTime()")
	If NextSummonTime > 0.0 && Utility.GetCurrentGameTime() >= NextSummonTime
		IssueSummon()
	EndIf
	if TimeSummonIssued > 0.0 ; Is there currently an active summon
		SummonPlayerEvent()
		QueueHeartbeat(config.rmSummonHeartbeatInterval)
		return
	EndIf
	QueueHeartbeat(config.rmHeartbeatInterval)
EndEvent


;==================================================
; Arrival
;==================================================
Function PlayerRespondedToSummon()
	; Player arrived at master, stop summon events.
	NextSummonTime = 0.0
	TimeSummonIssued = 0.0
	libs.NotifyPlayer("Arrived at master, stopping summon timer.", 1)
	; Took too long, etc.
EndFunction


;==================================================
; Tasks
;==================================================
zaddRadiantMasterBaseTask Function GetTask()
	int i = TaskPool.Length
	int[] elligibilities = new int[128]
	int bestMatch = 1
	int bestTask = -1
	while i > 0
		i -= 1
		elligibilities[i] = Utility.RandomInt() + TaskPool[i].DetermineElligibility()
		if elligibilities[i] >= bestMatch
			libs.Log("Found new best canidate: Task #"+i)
			bestMatch = elligibilities[i]
			bestTask = i
		EndIf
	EndWhile
	if bestTask <0
		libs.Error("No tasks available for assignment.")
		return TaskPool[0]
	EndIf
	return TaskPool[bestTask]
EndFunction


Function GiveRandomTask()
	libs.Log("GiveRandomTask")
	libs.SetObjectiveCompleted(qoMasterSummons)
	CurrentTask = GetTask()
	CurrentTask.Start()
EndFunction


Function TaskCompleted()
	libs.Log("TaskCompleted()")
	libs.NotifyPlayer("Task Completed.",1)
	CurrentTask.CompleteQuest()
	CurrentTask = none

EndFunction


Function TaskFailed()
	libs.Log("TaskFailed()")
	libs.NotifyPlayer("Task Failed.",1)
	CurrentTask.Stop()
	CurrentTask = none
EndFunction


