Scriptname zaddSurreptitiousScript Extends Quest Hidden

; Libs
zadLibs Property libs Auto
SexLabFramework property SexLab auto
slaUtilScr Property Aroused Auto
zaddQuestMonitorScript Property QuestMonitor Auto

LocationAlias Property DefaultLocation Auto
ReferenceAlias Property DefaultContainer Auto
ReferenceAlias Property DefaultMaster Auto
ReferenceAlias Property Player Auto

FormList Property SafeLocations Auto

Event OnInit()
	libs.Log("SS is initializing.")
	Maintenance()
EndEvent

Function Maintenance()
	UnregisterForSleep()
	RegisterForSleep()
	libs.Log("SS is now tracking player.")
EndFunction


Function StartRadiantMaster(LocationAlias myLocation, ReferenceAlias myContainer, ReferenceAlias myMaster, int stage)
	if !questMonitor.RadiantMaster.Start()
		libs.Error("RadiantMaster failed to start.")
		return
	EndIf
	questMonitor.RadiantMaster.MasterHome = myLocation
	questMonitor.RadiantMaster.KeyContainer = myContainer
	questMonitor.RadiantMaster.Master = myMaster
	questMonitor.RadiantMaster.SetStage(stage)
EndFunction


Event OnSleepStop(bool abInterrupted)
	if !libs.Config.SurreptitiousStreets
		return
	EndIf
	libs.Log("SS OnSleepStop("+abInterrupted+")")
	if !abInterrupted
		; Determine if player is sleeping in a "safe" location.
		bool safe = false
		Location loc = Player.GetActorRef().GetCurrentLocation()
		if loc == none
			libs.Warn("Player location is none. Assuming unsafe location.")
		else
			int i = SafeLocations.GetSize()
			while i > 0 && !safe
				i -= 1
				Keyword tmp = SafeLocations.GetAt(i) as Keyword
				; libs.Log("Checking " + tmp)
				if loc.HasKeyword(tmp)
					safe = true
				EndIf
			EndWhile
		EndIf
		libs.Log("Safe:"+safe)
		if !safe
			libs.NotifyPlayer("Unsafe location.",1)
			if Utility.RandomInt() <= libs.Config.ssSleepChance
				StartRadiantMaster(DefaultLocation, DefaultContainer, DefaultMaster, stage=10)
			EndIf
		EndIf
	EndIf
EndEvent
