Scriptname zaddQuestMonitorScript Extends Quest Hidden


; libs 
zadLibs Property libs Auto

; All quests that we're monitoring.
Quest Property zaddForbiddenTomeQuest  Auto
Quest Property zaddSSQuest Auto
zaddRadiantMasterScript Property RadiantMaster Auto

; All actors that we're monitoring.
ReferenceAlias Property Urag Auto


Event OnInit()
	Maintenance()
EndEvent


Function Maintenance()
	UnregisterForAllModEvents()
	RegisterForModEvent("DeviceRemovedBelt", "OnBeltRemoved")
	libs.Log("QuestMonitor is now watching for device events.")
EndFunction


Function TerminateQuestIfRunning(Quest tmp)
	if tmp.IsRunning() && tmp.GetStage() < 890
		tmp.SetStage(900)
		; Don't terminate here, quests may have special termination scenes/events.
		; Ex: Attempt to recapture player, etc.
	EndIf
EndFunction


Event OnBeltRemoved(string eventName, string argString, float argNum, form sender)
	libs.Log("QuestMonitor OnDeviceRemoved("+argString+": "+argNum+")")
	if argNum == 1 ; Chastity belt, PC removed.
		TerminateQuestIfRunning(zaddForbiddenTomeQuest)
	EndIf
EndEvent


bool Function ShouldStartNewQuest()
	actor akActor = libs.PlayerRef
	if akActor.WornHasKeyword(libs.zad_DeviousBelt)
		libs.Log("ShouldStartNewQuest() Already belted")
		return false
	EndIf
	if zaddForbiddenTomeQuest.IsRunning() || RadiantMaster.IsRunning()
		libs.Log("ShouldStartNewQuest() Already in a quest")
		return false
	EndIf
	libs.Log("ShouldStartNewQuest(): "+true)
	return true
EndFunction
